/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.fusion.entity.model;

import com.supermartijn642.fusion.entity.EntityRenderTypeHelper;
import com.supermartijn642.fusion.entity.VanillaModelLayerProperties;
import com.supermartijn642.fusion.entity.model.EntityLayerProperties;
import com.supermartijn642.fusion.entity.model.SubModelPart;
import com.supermartijn642.fusion.extensions.BufferSourceExtension;
import com.supermartijn642.fusion.extensions.EntityExtension;
import com.supermartijn642.fusion.util.Triple;
import net.minecraft.class_1297;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4668;
import net.minecraft.class_630;

public class FusionModelPart
extends SubModelPart {
    private final int layerIndex;
    private final class_630 original;
    private VanillaModelLayerProperties vanillaProperties;
    private EntityLayerProperties properties;
    private boolean ready;
    private class_4597 bufferSource;
    private class_2960 currentTexture;
    private Float currentScaling;
    private class_1921 adjustedRenderType;

    public FusionModelPart(int layerIndex, class_630 original) {
        super(null);
        this.mainPart = this;
        this.layerIndex = layerIndex;
        this.original = original;
    }

    public void setProperties(EntityLayerProperties properties, VanillaModelLayerProperties vanillaProperties) {
        this.properties = properties;
        this.vanillaProperties = vanillaProperties;
        if (properties == null) {
            this.mirror(this.original);
        }
    }

    public void setup(class_1297 entity, class_4597 bufferSource) {
        if (this.properties == null) {
            return;
        }
        this.bufferSource = bufferSource;
        if (((EntityExtension)entity).shouldFusionRecomputeModel(this.layerIndex)) {
            Triple<class_630, class_2960, Float> model = this.properties.chooseModel(entity);
            ((EntityExtension)entity).setFusionModel(this.layerIndex, model);
        }
        Triple<class_630, class_2960, Float> modelChoice = ((EntityExtension)entity).getFusionModel(this.layerIndex);
        class_630 currentModel = modelChoice.left();
        this.currentTexture = modelChoice.middle();
        this.currentScaling = modelChoice.right();
        FusionModelPart.resetPose(currentModel);
        this.mirror(currentModel);
        this.ready = true;
    }

    public void clear() {
        if (this.properties == null) {
            return;
        }
        this.bufferSource = null;
        this.currentTexture = null;
        this.currentScaling = null;
        this.adjustedRenderType = null;
    }

    @Override
    public void method_22699(class_4587 poseStack, class_4588 vertexConsumer, int i, int j, float f, float g, float h, float k) {
        this.renderPart(this, poseStack, vertexConsumer, i, j, f, g, h, k);
    }

    public void renderPart(SubModelPart part, class_4587 poseStack, class_4588 vertexConsumer, int i, int j, float f, float g, float h, float k) {
        if (!this.field_3665) {
            return;
        }
        if (!this.ready) {
            if (part == this) {
                this.original.method_22699(poseStack, vertexConsumer, i, j, f, g, h, k);
            }
            return;
        }
        if (this.bufferSource != null && this.currentTexture != null) {
            vertexConsumer = this.adjustTexture(vertexConsumer, this.bufferSource);
        }
        poseStack.method_22903();
        this.vanillaProperties.transform(poseStack);
        if (this.currentScaling != null) {
            poseStack.method_22905(this.currentScaling.floatValue(), this.currentScaling.floatValue(), this.currentScaling.floatValue());
        }
        part.renderInternal(poseStack, vertexConsumer, i, j, f, g, h, k);
        poseStack.method_22909();
    }

    private static void resetPose(class_630 part) {
        part.method_41923();
        part.field_3661.values().forEach(FusionModelPart::resetPose);
    }

    private class_4588 adjustTexture(class_4588 buffer, class_4597 bufferSource) {
        if (!(bufferSource instanceof BufferSourceExtension)) {
            return buffer;
        }
        class_1921 renderType = ((BufferSourceExtension)bufferSource).fusionGetLastRenderType();
        if (this.adjustedRenderType != null && this.adjustedRenderType == renderType) {
            return bufferSource.getBuffer(renderType);
        }
        if (!(renderType instanceof class_1921.class_4687)) {
            return buffer;
        }
        class_4668.class_5939 textureState = ((class_1921.class_4687)renderType).field_21403.field_21406;
        if (!(textureState instanceof class_4668.class_4683)) {
            return buffer;
        }
        class_2960 texture = ((class_4668.class_4683)textureState).field_21397.orElse(null);
        if (this.currentTexture.equals((Object)texture)) {
            return buffer;
        }
        if ((renderType = EntityRenderTypeHelper.getRenderTypeWithTexture(renderType, this.currentTexture)) == null) {
            return buffer;
        }
        this.adjustedRenderType = renderType;
        return bufferSource.getBuffer(renderType);
    }
}

