/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.fusion.mixin;

import com.supermartijn642.fusion.FusionClient;
import com.supermartijn642.fusion.api.texture.TextureErrorException;
import com.supermartijn642.fusion.api.texture.TextureType;
import com.supermartijn642.fusion.api.util.Pair;
import com.supermartijn642.fusion.extensions.SpriteContentsExtension;
import com.supermartijn642.fusion.extensions.TextureAtlasSpriteExtension;
import com.supermartijn642.fusion.texture.FusionTextureMetadataSection;
import com.supermartijn642.fusion.texture.SpriteCreationContextImpl;
import com.supermartijn642.fusion.texture.SpritePreparationContextImpl;
import com.supermartijn642.fusion.texture.TextureTypeRegistryImpl;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.minecraft.class_1011;
import net.minecraft.class_1058;
import net.minecraft.class_1079;
import net.minecraft.class_2960;
import net.minecraft.class_3270;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_7764;
import net.minecraft.class_7766;
import net.minecraft.class_7771;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={class_7766.class}, priority=900)
public class SpriteLoaderMixin {
    @Inject(method={"loadSprite"}, at={@At(value="INVOKE_ASSIGN", target="Lnet/minecraft/client/resources/metadata/animation/AnimationMetadataSection;calculateFrameSize(II)Lnet/minecraft/client/resources/metadata/animation/FrameSize;", shift=At.Shift.AFTER)}, cancellable=true, locals=LocalCapture.CAPTURE_FAILHARD)
    private static void gatherMetadata(class_2960 identifier, class_3298 resource, CallbackInfoReturnable<class_7764> ci, class_1079 animationMetadata, class_1011 image, class_7771 originalSize) {
        Pair metadata = null;
        try {
            metadata = resource.method_14481().method_43041((class_3270)FusionTextureMetadataSection.INSTANCE).orElse(null);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (metadata != null) {
            Pair<Integer, Integer> newSize;
            try {
                newSize = ((TextureType)metadata.left()).getFrameSize(new SpritePreparationContextImpl(originalSize.comp_1049(), originalSize.comp_1050(), image.method_4307(), image.method_4323(), identifier, animationMetadata), metadata.right());
            }
            catch (TextureErrorException e) {
                FusionClient.LOGGER.error("Error for texture '{}': {}", (Object)identifier, (Object)e.getMessage());
                image.close();
                ci.setReturnValue(null);
                return;
            }
            catch (Exception e) {
                throw new RuntimeException("Encountered an exception whilst getting frame size from texture type '" + String.valueOf(TextureTypeRegistryImpl.getIdentifier((TextureType)metadata.left())) + "' for texture '" + String.valueOf(identifier) + "'!", e);
            }
            if (newSize == null) {
                throw new RuntimeException("Received null frame size from texture type '" + String.valueOf(TextureTypeRegistryImpl.getIdentifier((TextureType)metadata.left())) + "' for texture '" + String.valueOf(identifier) + "'!");
            }
            class_7764 contents = new class_7764(identifier, new class_7771(newSize.left().intValue(), newSize.right().intValue()), image, animationMetadata);
            ((SpriteContentsExtension)contents).setFusionMetadata(metadata);
            ci.setReturnValue((Object)contents);
        }
    }

    @Inject(method={"loadAndStitch"}, at={@At(value="RETURN")})
    private void initializeTextures(class_3300 resourceManager, class_2960 atlas, int i, Executor executor, CallbackInfoReturnable<CompletableFuture<class_7766.class_7767>> ci) {
        ((CompletableFuture)ci.getReturnValue()).thenApply(preparations -> {
            Map textures = preparations.comp_1044();
            for (Map.Entry entry : textures.entrySet()) {
                class_1058 newTexture;
                class_2960 identifier = (class_2960)entry.getKey();
                class_1058 texture = (class_1058)entry.getValue();
                Pair<TextureType<Object>, Object> textureData = ((SpriteContentsExtension)texture.method_45851()).getFusionMetadata();
                if (textureData == null) continue;
                try (SpriteCreationContextImpl context = new SpriteCreationContextImpl((class_7766.class_7767)preparations, atlas, texture);){
                    newTexture = textureData.left().createSprite(context, textureData.right());
                }
                catch (Exception e) {
                    throw new RuntimeException("Encountered an exception whilst initialising texture '" + String.valueOf(identifier) + "' for texture type '" + String.valueOf(TextureTypeRegistryImpl.getIdentifier(textureData.left())) + "'!", e);
                }
                if (newTexture == null) {
                    throw new RuntimeException("Received null texture from texture type '" + String.valueOf(TextureTypeRegistryImpl.getIdentifier(textureData.left())) + "' for texture '" + String.valueOf(identifier) + "'!");
                }
                ((TextureAtlasSpriteExtension)newTexture).setFusionTextureType(textureData.left());
                textures.put(identifier, newTexture);
            }
            return preparations;
        });
    }
}

