/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.fusion.model.modifiers.item.predicates;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.supermartijn642.fusion.api.model.modifier.item.ItemPredicate;
import com.supermartijn642.fusion.api.util.Serializer;
import com.supermartijn642.fusion.util.IdentifierUtil;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_2960;

public class ItemPredicateRegistry {
    private static final Map<class_2960, Serializer<? extends ItemPredicate>> IDENTIFIER_TO_SERIALIZER = new HashMap<class_2960, Serializer<? extends ItemPredicate>>();
    private static final Map<Serializer<? extends ItemPredicate>, class_2960> SERIALIZER_TO_IDENTIFIER = new HashMap<Serializer<? extends ItemPredicate>, class_2960>();
    private static boolean finalized = false;

    public static synchronized void registerItemPredicate(class_2960 identifier, Serializer<? extends ItemPredicate> serializer) {
        if (finalized) {
            throw new RuntimeException("Item predicates must be registered before models get loaded!");
        }
        if (IDENTIFIER_TO_SERIALIZER.containsKey(identifier)) {
            throw new RuntimeException("Duplicate item predicate registration for identifier '" + String.valueOf(identifier) + "'!");
        }
        if (SERIALIZER_TO_IDENTIFIER.containsKey(serializer)) {
            throw new RuntimeException("Item predicate has already been registered!");
        }
        IDENTIFIER_TO_SERIALIZER.put(identifier, serializer);
        SERIALIZER_TO_IDENTIFIER.put(serializer, identifier);
    }

    public static JsonObject serializeItemPredicate(ItemPredicate predicate) {
        JsonObject json;
        if (!finalized) {
            throw new RuntimeException("Can only serialize item predicates after registration has completed!");
        }
        class_2960 identifier = SERIALIZER_TO_IDENTIFIER.get(predicate.getSerializer());
        if (identifier == null) {
            throw new RuntimeException("Cannot use unregistered item predicate serializer '" + String.valueOf(predicate.getSerializer()) + "'!");
        }
        try {
            json = predicate.getSerializer().serialize(predicate);
            if (json == null) {
                json = new JsonObject();
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Encountered an exception whilst serializing data for item predicate type '" + String.valueOf(identifier) + "'!", e);
        }
        json.addProperty("type", identifier.toString());
        return json;
    }

    public static ItemPredicate deserializeItemPredicate(JsonObject json) {
        ItemPredicate predicate;
        if (!finalized) {
            throw new RuntimeException("Can only deserialize item predicates after registration has completed!");
        }
        JsonElement typeJson = json.getAsJsonObject().get("type");
        if (typeJson == null || !typeJson.isJsonPrimitive() || !typeJson.getAsJsonPrimitive().isString()) {
            throw new JsonParseException("Item predicate must have string property 'type'!");
        }
        if (!IdentifierUtil.isValidIdentifier(typeJson.getAsString())) {
            throw new JsonParseException("Property 'type' must be a valid identifier!");
        }
        class_2960 identifier = IdentifierUtil.withFusionNamespace(typeJson.getAsString());
        Serializer<? extends ItemPredicate> serializer = IDENTIFIER_TO_SERIALIZER.get(identifier);
        if (serializer == null) {
            throw new JsonParseException("Unknown item predicate type '" + String.valueOf(identifier) + "'!");
        }
        try {
            predicate = serializer.deserialize(json);
        }
        catch (JsonParseException e) {
            throw new JsonParseException("Invalid json for predicate type '" + String.valueOf(identifier) + "'!", (Throwable)e);
        }
        catch (Exception e) {
            throw new RuntimeException("Encountered an exception whilst deserializing data for predicate type '" + String.valueOf(identifier) + "'!", e);
        }
        return predicate;
    }

    public static void finalizeRegistration() {
        finalized = true;
    }
}

