/*
 * Decompiled with CFR 0.152.
 */
package com.basicallymods.signs.api;

import com.basicallymods.signs.api.SignsRegisterer;
import com.google.common.collect.Iterables;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.data.loot.BlockLootSubProvider;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.data.tags.IntrinsicHolderTagsProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.StandingSignBlock;
import net.minecraft.world.level.block.WallSignBlock;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraftforge.client.model.generators.BlockModelProvider;
import net.minecraftforge.client.model.generators.BlockStateProvider;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ItemModelProvider;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;
import org.jetbrains.annotations.NotNull;

public class DataGenerators {
    public static LootTableProvider.SubProviderEntry getLootProvider(SignsRegisterer registerer) {
        return new LootTableProvider.SubProviderEntry(() -> new BlockLootProvider(registerer), LootContextParamSets.f_81421_);
    }

    public static void registerBlockModels(BlockModelProvider provider, SignsRegisterer registerer) {
        ResourceLocation planks_particles = new ResourceLocation("minecraft", "block/spruce_planks");
        registerer.SIGN_BLOCKS_BY_COLOR.values().forEach(block -> {
            provider.sign(ForgeRegistries.BLOCKS.getKey((Object)((Block)block.standing().get())).m_135815_(), planks_particles);
            provider.sign(ForgeRegistries.BLOCKS.getKey((Object)((Block)block.wall().get())).m_135815_(), planks_particles);
        });
    }

    public static void registerBlockStates(BlockStateProvider provider, SignsRegisterer registerer) {
        registerer.SIGN_BLOCKS_BY_COLOR.values().forEach(e -> {
            provider.simpleBlock((Block)e.standing().get(), DataGenerators.existingModel((Block)e.standing().get(), provider, registerer));
            provider.simpleBlock((Block)e.wall().get(), DataGenerators.existingModel((Block)e.wall().get(), provider, registerer));
        });
    }

    public static void registerBlockTags(Function<TagKey<Block>, IntrinsicHolderTagsProvider.IntrinsicTagAppender<Block>> tag, SignsRegisterer registerer) {
        tag.apply((TagKey<Block>)BlockTags.f_13066_).m_255179_((Object[])((Block[])registerer.SIGN_BLOCKS_BY_COLOR.values().stream().map(e -> (StandingSignBlock)e.standing().get()).toArray(StandingSignBlock[]::new)));
        tag.apply((TagKey<Block>)BlockTags.f_13067_).m_255179_((Object[])((Block[])registerer.SIGN_BLOCKS_BY_COLOR.values().stream().map(e -> (WallSignBlock)e.wall().get()).toArray(WallSignBlock[]::new)));
    }

    public static void registerItemTags(Function<TagKey<Item>, IntrinsicHolderTagsProvider.IntrinsicTagAppender<Item>> tag, SignsRegisterer registerer) {
        tag.apply((TagKey<Item>)ItemTags.f_13157_).m_255179_((Object[])((Item[])registerer.SIGN_ITEMS_BY_SIGN_COLOR.values().stream().map(RegistryObject::get).toArray(Item[]::new)));
    }

    public static void registerItemModels(ItemModelProvider provider, SignsRegisterer registerer) {
        registerer.SIGN_ITEMS_BY_SIGN_COLOR.forEach((key, value) -> ((ItemModelBuilder)provider.withExistingParent(ForgeRegistries.ITEMS.getKey((Object)((Item)value.get())).m_135815_(), "minecraft:item/generated")).texture("layer0", key.getItemTexture()));
    }

    private static String blockName(Block block, SignsRegisterer registerer) {
        return registerer.blocksRegistry.getEntries().stream().filter(e -> e.get() == block).findFirst().get().getId().m_135815_();
    }

    private static ResourceLocation resourceBlock(String path, SignsRegisterer registerer) {
        return new ResourceLocation(registerer.MOD_ID, "block/" + path);
    }

    private static ModelFile existingModel(Block block, BlockStateProvider provider, SignsRegisterer registerer) {
        return new ModelFile.ExistingModelFile(DataGenerators.resourceBlock(DataGenerators.blockName(block, registerer), registerer), provider.models().existingFileHelper);
    }

    public static class BlockLootProvider
    extends BlockLootSubProvider {
        public final SignsRegisterer registerer;

        public BlockLootProvider(SignsRegisterer registerer) {
            super(Set.of(), FeatureFlags.f_244280_.m_247355_());
            this.registerer = registerer;
        }

        protected void m_245660_() {
            this.registerer.SIGN_BLOCKS_BY_COLOR.values().forEach(e -> {
                this.m_245724_((Block)e.standing().get());
                this.m_245724_((Block)e.wall().get());
            });
        }

        @NotNull
        protected Iterable<Block> getKnownBlocks() {
            Iterable[] iterableArray = new Iterable[1];
            iterableArray[0] = this.registerer.SIGN_BLOCKS_BY_COLOR.values().stream().flatMap(e -> Set.of((Block)e.wall().get(), (Block)e.standing().get()).stream())::iterator;
            return Iterables.concat((Iterable[])iterableArray);
        }
    }
}

