/*
 * Decompiled with CFR 0.152.
 */
package com.basicallymods.signs.api;

import com.basicallymods.signs.client.renderer.ColoredSignRenderer;
import com.basicallymods.signs.common.block.StandingSignBlock;
import com.basicallymods.signs.common.block.WallSignBlock;
import com.basicallymods.signs.common.data.ISignColor;
import com.basicallymods.signs.common.entity.SignBlockEntity;
import com.basicallymods.signs.common.registry.ModBlocks;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderers;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.SignItem;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SignBlock;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public class SignsRegisterer {
    public final DeferredRegister<Block> blocksRegistry;
    public final DeferredRegister<Item> itemsRegistry;
    public final DeferredRegister<BlockEntityType<?>> blockEntityRegister;
    public final Map<ISignColor, ModBlocks.SignBlock> SIGN_BLOCKS_BY_COLOR = new HashMap<ISignColor, ModBlocks.SignBlock>();
    public final Map<ISignColor, RegistryObject<? extends Item>> SIGN_ITEMS_BY_SIGN_COLOR = new HashMap<ISignColor, RegistryObject<? extends Item>>();
    private RegistryObject<BlockEntityType<SignBlockEntity>> signBlockEntity;
    public final String MOD_ID;

    public SignsRegisterer(String MOD_ID) {
        this(MOD_ID, (DeferredRegister<Block>)DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)MOD_ID), (DeferredRegister<Item>)DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)MOD_ID), DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCK_ENTITY_TYPES, (String)MOD_ID));
    }

    public SignsRegisterer(String MOD_ID, DeferredRegister<Block> blocksRegistry, DeferredRegister<Item> itemsRegistry, DeferredRegister<BlockEntityType<?>> blockEntityRegister) {
        this.blocksRegistry = blocksRegistry;
        this.itemsRegistry = itemsRegistry;
        this.blockEntityRegister = blockEntityRegister;
        this.MOD_ID = MOD_ID;
        this.signBlockEntity = null;
        this.signBlockEntity = blockEntityRegister.register("sign_block_entity", () -> BlockEntityType.Builder.m_155273_(SignBlockEntity.make(this.signBlockEntity), (Block[])((Block[])this.SIGN_BLOCKS_BY_COLOR.values().stream().map(e -> List.of((SignBlock)e.standing().get(), (SignBlock)e.wall().get())).reduce(new ArrayList(), (a, b) -> {
            a.addAll(b);
            return a;
        }).toArray(Block[]::new))).m_58966_(null));
    }

    public void registerBasic(ISignColor sign) {
        RegistryObject standingBlock = this.blocksRegistry.register(sign.standingSignName(), () -> new StandingSignBlock(sign, (Supplier<BlockEntityType<SignBlockEntity>>)this.signBlockEntity));
        RegistryObject wallSignBlock = this.blocksRegistry.register(sign.wallSignName(), () -> new WallSignBlock(sign, (Supplier<BlockEntityType<SignBlockEntity>>)this.signBlockEntity));
        ModBlocks.SignBlock block = new ModBlocks.SignBlock((RegistryObject<? extends net.minecraft.world.level.block.StandingSignBlock>)standingBlock, (RegistryObject<? extends net.minecraft.world.level.block.WallSignBlock>)wallSignBlock);
        this.SIGN_BLOCKS_BY_COLOR.put(sign, block);
        RegistryObject item = this.itemsRegistry.register(sign.itemName(), () -> new SignItem(new Item.Properties().m_41487_(64), (Block)standingBlock.get(), (Block)wallSignBlock.get()));
        this.SIGN_ITEMS_BY_SIGN_COLOR.put(sign, (RegistryObject<? extends Item>)item);
    }

    public void setupClient() {
        BlockEntityRenderers.m_173590_((BlockEntityType)((BlockEntityType)this.signBlockEntity.get()), ColoredSignRenderer::new);
    }

    public RegistryObject<BlockEntityType<SignBlockEntity>> getSignBlockEntity() {
        return this.signBlockEntity;
    }
}

