/*
 * Decompiled with CFR 0.152.
 */
package com.basicallymods.signs.client.renderer;

import com.basicallymods.signs.common.block.state.ColoredSign;
import com.basicallymods.signs.common.data.ISignColor;
import com.basicallymods.signs.common.registry.ModAtlases;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.model.Model;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.blockentity.SignRenderer;
import net.minecraft.client.resources.model.Material;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.FastColor;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SignBlock;
import net.minecraft.world.level.block.StandingSignBlock;
import net.minecraft.world.level.block.entity.SignBlockEntity;
import net.minecraft.world.level.block.entity.SignText;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ColoredSignRenderer
extends SignRenderer {
    private static final int OUTLINE_RENDER_DISTANCE = Mth.m_144944_((int)16);
    private static final Vec3 TEXT_OFFSET = new Vec3(0.0, 0.3333333432674408, 0.046666666865348816);
    private final SignRenderer.SignModel signModel;
    private final Font font;

    public ColoredSignRenderer(BlockEntityRendererProvider.Context context) {
        super(context);
        this.signModel = new SignRenderer.SignModel(context.m_173582_(ModelLayers.m_171291_((WoodType)WoodType.f_61831_)));
        this.font = context.m_173586_();
    }

    public void m_6922_(SignBlockEntity pBlockEntity, float pPartialTick, PoseStack pPoseStack, MultiBufferSource pBuffer, int pPackedLight, int pPackedOverlay) {
        BlockState blockstate = pBlockEntity.m_58900_();
        SignBlock signblock = (SignBlock)blockstate.m_60734_();
        WoodType woodtype = SignBlock.m_247329_((Block)signblock);
        SignRenderer.SignModel signrenderer$signmodel = this.signModel;
        signrenderer$signmodel.f_112507_.f_104207_ = blockstate.m_60734_() instanceof StandingSignBlock;
        this.m_278756_(pBlockEntity, pPoseStack, pBuffer, pPackedLight, pPackedOverlay, blockstate, signblock, woodtype, (Model)signrenderer$signmodel);
    }

    void m_278756_(SignBlockEntity pSignEntity, PoseStack pPoseStack, MultiBufferSource pBuffer, int pPackedLight, int pPackedOverlay, BlockState pState, SignBlock pSignBlock, WoodType pWoodType, Model pModel) {
        pPoseStack.m_85836_();
        this.m_276777_(pPoseStack, -pSignBlock.m_276903_(pState), pState);
        this.renderSign(pPoseStack, pBuffer, pPackedLight, pPackedOverlay, pWoodType, pModel, pSignEntity);
        this.renderSignText(pSignEntity.m_58899_(), pSignEntity.m_277142_(), pPoseStack, pBuffer, pPackedLight, pSignEntity.m_245065_(), pSignEntity.m_245123_(), true, this.getCustomOffset(pSignEntity));
        this.renderSignText(pSignEntity.m_58899_(), pSignEntity.m_277159_(), pPoseStack, pBuffer, pPackedLight, pSignEntity.m_245065_(), pSignEntity.m_245123_(), false, this.getCustomOffset(pSignEntity));
        pPoseStack.m_85849_();
    }

    public int getCustomOffset(SignBlockEntity entity) {
        Block block = entity.m_58900_().m_60734_();
        if (block instanceof ColoredSign) {
            ColoredSign sign = (ColoredSign)block;
            return sign.getColorSign().getYOffset();
        }
        return 0;
    }

    void m_276777_(PoseStack pPoseStack, float pYRot, BlockState pState) {
        pPoseStack.m_252880_(0.5f, 0.75f * this.m_278770_(), 0.5f);
        pPoseStack.m_252781_(Axis.f_252436_.m_252977_(pYRot));
        if (!(pState.m_60734_() instanceof StandingSignBlock)) {
            pPoseStack.m_252880_(0.0f, -0.3125f, -0.4375f);
        }
    }

    void renderSign(PoseStack pPoseStack, MultiBufferSource pBuffer, int pPackedLight, int pPackedOverlay, WoodType pWoodType, Model pModel, SignBlockEntity pSignEntity) {
        pPoseStack.m_85836_();
        float f = this.m_278770_();
        pPoseStack.m_85841_(f, -f, -f);
        Material material = this.getSignMaterial(pWoodType, pSignEntity);
        VertexConsumer vertexconsumer = material.m_119194_(pBuffer, arg_0 -> ((Model)pModel).m_103119_(arg_0));
        this.m_245885_(pPoseStack, pPackedLight, pPackedOverlay, pModel, vertexconsumer);
        pPoseStack.m_85849_();
    }

    void m_245885_(PoseStack pPoseStack, int pPackedLight, int pPackedOverlay, Model pModel, VertexConsumer pVertexConsumer) {
        SignRenderer.SignModel signrenderer$signmodel = (SignRenderer.SignModel)pModel;
        signrenderer$signmodel.f_173655_.m_104301_(pPoseStack, pVertexConsumer, pPackedLight, pPackedOverlay);
    }

    Material getSignMaterial(WoodType pWoodType, SignBlockEntity pSignEntity) {
        Block block = pSignEntity.m_58900_().m_60734_();
        if (block instanceof ColoredSign) {
            ColoredSign sign = (ColoredSign)block;
            return ColoredSignRenderer.getMaterial(sign.getColorSign());
        }
        return Sheets.m_173381_((WoodType)pWoodType);
    }

    void renderSignText(BlockPos pPos, SignText pText, PoseStack pPoseStack, MultiBufferSource pBuffer, int pPackedLight, int pLineHeight, int pMaxWidth, boolean pIsFrontText, int yOffset) {
        int l;
        boolean flag;
        int k;
        pPoseStack.m_85836_();
        this.m_278823_(pPoseStack, pIsFrontText, this.m_278725_());
        int i = ColoredSignRenderer.m_173639_(pText);
        int j = 2 * pLineHeight + yOffset;
        FormattedCharSequence[] aformattedcharsequence = pText.m_277130_(Minecraft.m_91087_().m_167974_(), p_277227_ -> {
            List list = this.font.m_92923_((FormattedText)p_277227_, pMaxWidth);
            return list.isEmpty() ? FormattedCharSequence.f_13691_ : (FormattedCharSequence)list.get(0);
        });
        if (pText.m_276843_()) {
            k = pText.m_276773_().m_41071_();
            flag = ColoredSignRenderer.m_277119_(pPos, k);
            l = 0xF000F0;
        } else {
            k = i;
            flag = false;
            l = pPackedLight;
        }
        for (int i1 = 0; i1 < 4; ++i1) {
            FormattedCharSequence formattedcharsequence = aformattedcharsequence[i1];
            float f = -this.font.m_92724_(formattedcharsequence) / 2;
            float y = i1 * pLineHeight - j;
            if (flag) {
                this.font.m_168645_(formattedcharsequence, f, y, k, i, pPoseStack.m_85850_().m_252922_(), pBuffer, l);
                continue;
            }
            this.font.m_272191_(formattedcharsequence, f, y, k, false, pPoseStack.m_85850_().m_252922_(), pBuffer, Font.DisplayMode.POLYGON_OFFSET, 0, l);
        }
        pPoseStack.m_85849_();
    }

    private void m_278823_(PoseStack pPoseStack, boolean pIsFrontText, Vec3 pOffset) {
        if (!pIsFrontText) {
            pPoseStack.m_252781_(Axis.f_252436_.m_252977_(180.0f));
        }
        float f = 0.015625f * this.m_278631_();
        pPoseStack.m_85837_(pOffset.f_82479_, pOffset.f_82480_, pOffset.f_82481_);
        pPoseStack.m_85841_(f, -f, f);
    }

    Vec3 m_278725_() {
        return TEXT_OFFSET;
    }

    static boolean m_277119_(BlockPos pPos, int pTextColor) {
        if (pTextColor == DyeColor.BLACK.m_41071_()) {
            return true;
        }
        Minecraft minecraft = Minecraft.m_91087_();
        LocalPlayer localplayer = minecraft.f_91074_;
        if (localplayer != null && minecraft.f_91066_.m_92176_().m_90612_() && localplayer.m_150108_()) {
            return true;
        }
        Entity entity = minecraft.m_91288_();
        return entity != null && entity.m_20238_(Vec3.m_82512_((Vec3i)pPos)) < (double)OUTLINE_RENDER_DISTANCE;
    }

    static int m_173639_(SignText pSignText) {
        int i = pSignText.m_276773_().m_41071_();
        if (i == DyeColor.BLACK.m_41071_() && pSignText.m_276843_()) {
            return -988212;
        }
        if (i == DyeColor.WHITE.m_41071_() && !pSignText.m_276843_()) {
            return i;
        }
        double d0 = 0.4;
        int j = (int)((double)FastColor.ARGB32.m_13665_((int)i) * d0);
        int k = (int)((double)FastColor.ARGB32.m_13667_((int)i) * d0);
        int l = (int)((double)FastColor.ARGB32.m_13669_((int)i) * d0);
        return FastColor.ARGB32.m_13660_((int)0, (int)j, (int)k, (int)l);
    }

    public static Material getMaterial(ISignColor signColor) {
        return ModAtlases.COLORED_SIGN_MATERIALS.get(signColor);
    }
}

