/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.client.freecam.mixins;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArraySet;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.ParticleStatus;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderBuffers;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix3fc;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import ydmsama.hundred_years_war.client.freecam.Freecam;
import ydmsama.hundred_years_war.client.freecam.config.ClientModConfig;
import ydmsama.hundred_years_war.client.freecam.selection.SelectionHandler;
import ydmsama.hundred_years_war.client.freecam.selection.TargetInfo;
import ydmsama.hundred_years_war.main.entity.entities.BaseCombatEntity;
import ydmsama.hundred_years_war.main.entity.utils.MultiSeatVehicle;

@Mixin(value={LevelRenderer.class})
public abstract class LevelRendererMixin {
    @Shadow
    @Final
    private RenderBuffers f_109464_;
    @Unique
    private static final int TARGET_REMOVAL_CHECK_INTERVAL = 5;
    @Unique
    private int frameCounter = 0;
    @Unique
    private final Map<Entity, Map<TargetInfo, Long>> pendingRemovals = new HashMap<Entity, Map<TargetInfo, Long>>();

    @Shadow
    private void m_109517_(Entity entity, double cameraX, double cameraY, double cameraZ, float tickDelta, PoseStack matrices, MultiBufferSource vertexConsumers) {
    }

    @Shadow
    protected abstract ParticleStatus m_109767_(boolean var1);

    @Inject(method={"renderLevel"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/renderer/LevelRenderer;checkPoseStack(Lcom/mojang/blaze3d/vertex/PoseStack;)V", ordinal=0)})
    private void onRender(PoseStack matrices, float tickDelta, long limitTime, boolean renderBlockOutline, Camera camera, GameRenderer gameRenderer, LightTexture lightmapTextureManager, Matrix4f positionMatrix, CallbackInfo ci) {
        double minDistance;
        double thresholdSquared;
        Vec3 playerPos;
        Vec3 cameraPos;
        double distanceSquared;
        if (Freecam.isEnabled() && Freecam.MC.f_91072_.m_105295_() != GameType.SURVIVAL && ClientModConfig.INSTANCE.visual.showPlayer && (distanceSquared = (cameraPos = camera.m_90583_()).m_82557_(playerPos = Freecam.MC.f_91074_.m_146892_())) > (thresholdSquared = (minDistance = ClientModConfig.INSTANCE.visual.playerRenderMinDistance) * minDistance)) {
            PoseStack safeStack = new PoseStack();
            PoseStack.Pose safePose = safeStack.m_85850_();
            safePose.m_252922_().set((Matrix4fc)matrices.m_85850_().m_252922_());
            safePose.m_252943_().set((Matrix3fc)matrices.m_85850_().m_252943_());
            this.m_109517_((Entity)Freecam.MC.f_91074_, cameraPos.f_82479_, cameraPos.f_82480_, cameraPos.f_82481_, tickDelta, safeStack, (MultiBufferSource)this.f_109464_.m_110104_());
        }
    }

    @Inject(method={"renderEntity"}, at={@At(value="HEAD")}, cancellable=true)
    private void onRenderEntity(Entity entity, double cameraX, double cameraY, double cameraZ, float tickDelta, PoseStack matrices, MultiBufferSource bufferSource, CallbackInfo ci) {
        Vec3 entityPos;
        double minDistance;
        double thresholdSquared;
        double distanceSquared;
        Vec3 cameraPos;
        BaseCombatEntity baseCombatEntity;
        if (entity instanceof BaseCombatEntity && !(baseCombatEntity = (BaseCombatEntity)entity).getShouldRender()) {
            ci.cancel();
            return;
        }
        if (this.isEntityInInternalSeat(entity)) {
            ci.cancel();
            return;
        }
        if (!Freecam.isEnabled()) {
            return;
        }
        if (entity == Freecam.MC.f_91074_) {
            if (Freecam.MC.f_91072_.m_105295_() == GameType.SURVIVAL) {
                ci.cancel();
                return;
            }
            if (ClientModConfig.INSTANCE.visual.showPlayer) {
                Vec3 playerPos;
                cameraPos = Freecam.MC.f_91063_.m_109153_().m_90583_();
                distanceSquared = cameraPos.m_82557_(playerPos = Freecam.MC.f_91074_.m_146892_());
                if (distanceSquared <= (thresholdSquared = (minDistance = ClientModConfig.INSTANCE.visual.playerRenderMinDistance) * minDistance)) {
                    ci.cancel();
                }
            } else {
                ci.cancel();
            }
        }
        if (entity instanceof BaseCombatEntity && (distanceSquared = (cameraPos = Freecam.MC.f_91063_.m_109153_().m_90583_()).m_82557_(entityPos = entity.m_146892_())) <= (thresholdSquared = (minDistance = ClientModConfig.INSTANCE.visual.playerRenderMinDistance) * minDistance)) {
            ci.cancel();
        }
    }

    @Unique
    private boolean isEntityInInternalSeat(Entity entity) {
        Entity vehicle = entity.m_20202_();
        if (vehicle instanceof MultiSeatVehicle) {
            MultiSeatVehicle multiSeatVehicle = (MultiSeatVehicle)vehicle;
            return multiSeatVehicle.getSeatForEntity(entity).map(seat -> seat.getType() == MultiSeatVehicle.SeatType.INTERNAL).orElse(false);
        }
        return false;
    }

    @Inject(method={"renderLevel"}, at={@At(value="HEAD")})
    private void onRenderLevel(PoseStack poseStack, float f, long l, boolean bl, Camera camera, GameRenderer gameRenderer, LightTexture lightTexture, Matrix4f matrix4f, CallbackInfo ci) {
        ++this.frameCounter;
        if (this.frameCounter >= 5) {
            this.frameCounter = 0;
            this.processTargetRemoval();
        }
    }

    @Unique
    private void processTargetRemoval() {
        CopyOnWriteArraySet<TargetInfo> targets;
        Entity entity;
        Minecraft mc = Minecraft.m_91087_();
        ClientLevel level = mc.f_91073_;
        if (level == null) {
            return;
        }
        Map<Entity, CopyOnWriteArraySet<TargetInfo>> targetMap = SelectionHandler.getInstance().getCombinedTargetMap();
        if (targetMap.isEmpty()) {
            return;
        }
        HashMap<String, List> formationMap = new HashMap<String, List>();
        for (Map.Entry<Entity, CopyOnWriteArraySet<TargetInfo>> entry : targetMap.entrySet()) {
            entity = entry.getKey();
            if (!(entity instanceof BaseCombatEntity) || (targets = entry.getValue()) == null) continue;
            for (TargetInfo target : targets) {
                String type = target.getType();
                if (!"formTarget".equals(type) && !"formAttackTarget".equals(type)) continue;
                BlockPos targetPos = target.getPosition();
                String formationKey = type + "_" + targetPos.m_123344_();
                formationMap.computeIfAbsent(formationKey, k -> new ArrayList()).add(entity);
            }
        }
        for (Map.Entry<Entity, CopyOnWriteArraySet<TargetInfo>> entry : targetMap.entrySet()) {
            entity = entry.getKey();
            if (!(entity instanceof BaseCombatEntity) || (targets = entry.getValue()) == null || targets.isEmpty()) continue;
            Vec3 formationCenter = entity.m_20182_();
            List formationEntities = Collections.singletonList(entity);
            for (Map.Entry formationEntry : formationMap.entrySet()) {
                if (!((List)formationEntry.getValue()).contains(entity)) continue;
                formationEntities = (List)formationEntry.getValue();
                formationCenter = this.calculateCenterPosition(formationEntities);
                break;
            }
            this.processTargetRemovalForEntity(entity, targets, formationCenter, formationEntities);
        }
    }

    @Unique
    private void processTargetRemovalForEntity(Entity entity, CopyOnWriteArraySet<TargetInfo> targets, Vec3 formationCenter, List<Entity> formationEntities) {
        Iterator<TargetInfo> iterator;
        if (this.pendingRemovals.containsKey(entity)) {
            Map<TargetInfo, Long> removalMap = this.pendingRemovals.get(entity);
            long currentTime = System.currentTimeMillis();
            Iterator<Map.Entry<TargetInfo, Long>> entryIterator = removalMap.entrySet().iterator();
            while (entryIterator.hasNext()) {
                long timeout;
                Map.Entry<TargetInfo, Long> entry = entryIterator.next();
                String type = entry.getKey().getType();
                long l = timeout = (Objects.equals(type, "formTarget") || Objects.equals(type, "formAttackTarget")) && formationEntities.size() > 1 ? 1500L : 500L;
                if (currentTime - entry.getValue() <= timeout) continue;
                targets.remove(entry.getKey());
                entryIterator.remove();
            }
            if (removalMap.isEmpty()) {
                this.pendingRemovals.remove(entity);
            }
        }
        if (!targets.isEmpty() && (iterator = targets.iterator()).hasNext()) {
            TargetInfo firstTarget = iterator.next();
            BlockPos pos = firstTarget.getPosition();
            String type = firstTarget.getType();
            if (!Objects.equals(type, "entityTarget") && !Objects.equals(type, "followTarget")) {
                if (!Objects.equals(type, "formTarget") && !Objects.equals(type, "formAttackTarget")) {
                    double threshold = Math.max(((BaseCombatEntity)entity).getArrivalThreshold() * 1.2, 1.0);
                    if (!(!this.hasArrivedAtTarget(entity, pos, threshold) || this.pendingRemovals.containsKey(entity) && this.pendingRemovals.get(entity).containsKey(firstTarget))) {
                        this.pendingRemovals.computeIfAbsent(entity, k -> new HashMap()).put(firstTarget, System.currentTimeMillis());
                    }
                } else {
                    double threshold;
                    Vec3 targetPos = new Vec3((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 1.1, (double)pos.m_123343_() + 0.5);
                    double distance = this.calculateHorizontalDistance(formationCenter, targetPos);
                    if (!(!(distance < (threshold = this.calculateFormationThreshold(formationEntities))) || this.pendingRemovals.containsKey(entity) && this.pendingRemovals.get(entity).containsKey(firstTarget))) {
                        this.pendingRemovals.computeIfAbsent(entity, k -> new HashMap()).put(firstTarget, System.currentTimeMillis());
                    }
                }
            }
        }
        targets.removeIf(target -> {
            String type = target.getType();
            if (Objects.equals(type, "entityTarget") || Objects.equals(type, "followTarget")) {
                Entity targetEntity = target.getHywTarget();
                return !targetEntity.m_6084_();
            }
            return false;
        });
    }

    @Unique
    public double calculateHorizontalDistance(Vec3 pos1, Vec3 pos2) {
        return Math.sqrt(Math.pow(pos1.m_7096_() - pos2.m_7096_(), 2.0) + Math.pow(pos1.m_7094_() - pos2.m_7094_(), 2.0));
    }

    @Unique
    private boolean hasArrivedAtTarget(Entity entity, BlockPos targetPos, double threshold) {
        Minecraft mc = Minecraft.m_91087_();
        ClientLevel level = mc.f_91073_;
        if (level == null) {
            return false;
        }
        Vec3 entityPos = entity.m_20182_();
        Vec3 targetPosVec = new Vec3((double)targetPos.m_123341_() + 0.5, (double)targetPos.m_123342_() + 1.1, (double)targetPos.m_123343_() + 0.5);
        BlockState targetBlockState = level.m_8055_(targetPos);
        boolean isTargetAir = targetBlockState.m_60795_();
        double horizontalDistance = this.calculateHorizontalDistance(entityPos, targetPosVec);
        if (isTargetAir) {
            return horizontalDistance < threshold;
        }
        double verticalDistance = Math.abs(entityPos.m_7098_() - targetPosVec.m_7098_());
        return horizontalDistance < threshold && verticalDistance < threshold;
    }

    @Unique
    private Vec3 calculateCenterPosition(List<Entity> selectedEntities) {
        if (selectedEntities.isEmpty()) {
            return Vec3.f_82478_;
        }
        double sumX = 0.0;
        double sumY = 0.0;
        double sumZ = 0.0;
        for (Entity entity : selectedEntities) {
            Vec3 entityPos = entity.m_20182_();
            sumX += entityPos.f_82479_;
            sumY += entityPos.f_82480_;
            sumZ += entityPos.f_82481_;
        }
        double centerX = sumX / (double)selectedEntities.size();
        double centerY = sumY / (double)selectedEntities.size();
        double centerZ = sumZ / (double)selectedEntities.size();
        return new Vec3(centerX, centerY, centerZ);
    }

    @Unique
    private double calculateFormationThreshold(List<Entity> formationEntities) {
        if (formationEntities.size() == 1) {
            Entity entity = formationEntities.get(0);
            if (entity instanceof BaseCombatEntity) {
                return Math.max(((BaseCombatEntity)entity).getArrivalThreshold() * 1.2, 1.0);
            }
            return 1.0;
        }
        return 8.0;
    }
}

