/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.client.freecam.ui;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import ydmsama.hundred_years_war.client.freecam.ui.CustomButton;
import ydmsama.hundred_years_war.client.freecam.ui.CustomConfirmScreen;
import ydmsama.hundred_years_war.client.freecam.ui.CustomUI;
import ydmsama.hundred_years_war.client.freecam.ui.PlayerRelationListEntry;
import ydmsama.hundred_years_war.client.freecam.ui.PlayerRelationListWidget;
import ydmsama.hundred_years_war.client.network.ClientPacketHandler;
import ydmsama.hundred_years_war.main.network.packets.RelationResponsePacket;
import ydmsama.hundred_years_war.main.network.packets.RelationUpdatePacket;
import ydmsama.hundred_years_war.main.utils.RelationSystem;

public class RelationUI
extends Screen {
    private static final int WINDOW_WIDTH = 240;
    private static final int WINDOW_HEIGHT = 250;
    private static final int SEARCH_BOX_HEIGHT = 20;
    private static final int PLAYER_ITEM_HEIGHT = 24;
    private static final int PLAYER_LIST_HEIGHT = 150;
    private int leftPos;
    private int topPos;
    private EditBox searchBox;
    private PlayerRelationListWidget playerListWidget;
    private String searchText = "";
    private List<PlayerRelationInfo> playerInfoList = new ArrayList<PlayerRelationInfo>();
    private List<PlayerRelationInfo> filteredPlayerInfoList = new ArrayList<PlayerRelationInfo>();
    private CustomButton applyButton;
    private boolean hasChanges = false;

    public RelationUI() {
        super((Component)Component.m_237115_((String)"ui.hundred_years_war.relation_ui"));
        ClientPacketHandler.requestRelationData();
    }

    public void onRelationDataUpdate(RelationResponsePacket packet) {
        this.playerInfoList.clear();
        String currentPlayerName = Minecraft.m_91087_().f_91074_.m_7755_().getString();
        UUID currentPlayerUUID = Minecraft.m_91087_().f_91074_.m_20148_();
        for (Map.Entry<UUID, RelationResponsePacket.RelationInfo> entry : packet.getRelationInfoMap().entrySet()) {
            RelationResponsePacket.RelationInfo relationInfo = entry.getValue();
            PlayerRelationInfo playerInfo = new PlayerRelationInfo(entry.getKey(), relationInfo.getPlayerName(), relationInfo.getMyRelation(), relationInfo.getTheirRelation(), PlayerRelationListEntry.EntryType.PERSONAL);
            playerInfo.resetChanged();
            this.playerInfoList.add(playerInfo);
        }
        for (Map.Entry<UUID, Object> entry : packet.getTeamInfoMap().entrySet()) {
            RelationResponsePacket.TeamInfo teamInfo = (RelationResponsePacket.TeamInfo)entry.getValue();
            RelationSystem.RelationType theirRelation = teamInfo.getTheirRelation();
            PlayerRelationInfo teamInfo2 = new PlayerRelationInfo(entry.getKey(), teamInfo.getTeamName(), teamInfo.getMyRelation(), theirRelation, PlayerRelationListEntry.EntryType.TEAM);
            teamInfo2.resetChanged();
            this.playerInfoList.add(teamInfo2);
        }
        boolean selfExists = false;
        for (PlayerRelationInfo playerRelationInfo : this.playerInfoList) {
            if (playerRelationInfo.getEntryType() != PlayerRelationListEntry.EntryType.PERSONAL || !playerRelationInfo.getPlayerName().equals(currentPlayerName)) continue;
            selfExists = true;
            break;
        }
        if (!selfExists) {
            PlayerRelationInfo playerRelationInfo = new PlayerRelationInfo(currentPlayerUUID, currentPlayerName, RelationSystem.RelationType.CONTROL, RelationSystem.RelationType.CONTROL, PlayerRelationListEntry.EntryType.PERSONAL);
            playerRelationInfo.resetChanged();
            this.playerInfoList.add(playerRelationInfo);
        }
        this.updateFilteredPlayerList();
        if (this.playerListWidget != null) {
            this.updatePlayerList();
        }
        this.hasChanges = false;
        this.updateApplyButton();
        this.f_96541_.f_91065_.m_93076_().m_93785_((Component)Component.m_237115_((String)"message.hundred_years_war.relation_settings_updated"));
    }

    protected void m_7856_() {
        super.m_7856_();
        this.leftPos = (this.f_96543_ - 240) / 2;
        this.topPos = (this.f_96544_ - 250) / 2;
        this.searchBox = new EditBox(this.f_96547_, this.leftPos + 10, this.topPos + 20 + 15, 220, 20, (Component)Component.m_237115_((String)"ui.hundred_years_war.search"));
        this.searchBox.m_94199_(50);
        this.searchBox.m_94182_(true);
        this.searchBox.m_94194_(true);
        this.searchBox.m_94202_(0xFFFFFF);
        this.searchBox.m_94144_(this.searchText);
        this.searchBox.m_94151_(this::onSearchTextChanged);
        this.m_142416_((GuiEventListener)this.searchBox);
        int playerListTop = this.topPos + 20 + 15 + 20 + 5;
        this.playerListWidget = new PlayerRelationListWidget(this.f_96541_, 220, 150, playerListTop, playerListTop + 150, 24);
        this.playerListWidget.m_93507_(this.leftPos + 10);
        this.updateFilteredPlayerList();
        this.updatePlayerList();
        this.m_7787_((GuiEventListener)this.playerListWidget);
        this.applyButton = new CustomButton(this.leftPos + 10, this.topPos + 250 - 20 - 10, 60, 20, (Component)Component.m_237115_((String)"ui.hundred_years_war.apply"), button -> this.applyChanges());
        this.applyButton.f_93623_ = true;
        this.m_142416_(this.applyButton);
        this.m_142416_(new CustomButton(this.leftPos + 240 - 60 - 10, this.topPos + 250 - 20 - 10, 60, 20, (Component)Component.m_237115_((String)"ui.hundred_years_war.back"), button -> this.m_7379_()));
    }

    private void updateApplyButton() {
        if (this.applyButton != null) {
            this.applyButton.f_93623_ = true;
        }
    }

    private void applyChanges() {
        RelationUpdatePacket updatePacket = new RelationUpdatePacket();
        for (PlayerRelationInfo info : this.playerInfoList) {
            if (!info.hasChanged()) continue;
            updatePacket.addRelationUpdate(info.getPlayerUUID(), info.getMyRelation());
        }
        ClientPacketHandler.sendRelationUpdate(updatePacket);
        this.f_96541_.f_91065_.m_93076_().m_93785_((Component)Component.m_237115_((String)"message.hundred_years_war.applying_relation_settings"));
        this.f_96541_.m_91152_((Screen)new CustomUI());
    }

    private void updateFilteredPlayerList() {
        Map<UUID, PlayerRelationInfo> teamInfoMap = new HashMap<UUID, PlayerRelationInfo>();
        HashMap<UUID, List> teamMembersMap = new HashMap<UUID, List>();
        List<PlayerRelationInfo> soloPlayers = new ArrayList<PlayerRelationInfo>();
        RelationResponsePacket relationData = ClientPacketHandler.getLatestRelationData();
        String currentPlayerName = Minecraft.m_91087_().f_91074_.m_7755_().getString();
        for (PlayerRelationInfo playerRelationInfo : this.playerInfoList) {
            if (playerRelationInfo.getEntryType() == PlayerRelationListEntry.EntryType.TEAM) {
                teamInfoMap.put(playerRelationInfo.getPlayerUUID(), playerRelationInfo);
                teamMembersMap.computeIfAbsent(playerRelationInfo.getPlayerUUID(), k -> new ArrayList());
                continue;
            }
            boolean belongsToTeam = false;
            if (relationData != null) {
                for (Map.Entry<UUID, RelationResponsePacket.TeamInfo> entry2 : relationData.getTeamInfoMap().entrySet()) {
                    UUID uUID = entry2.getKey();
                    RelationResponsePacket.TeamInfo teamInfo = entry2.getValue();
                    if (!teamInfo.getMembers().containsKey(playerRelationInfo.getPlayerUUID())) continue;
                    teamMembersMap.computeIfAbsent(uUID, k -> new ArrayList()).add(playerRelationInfo);
                    belongsToTeam = true;
                    break;
                }
            }
            if (belongsToTeam) continue;
            soloPlayers.add(playerRelationInfo);
        }
        if (!this.searchText.isEmpty()) {
            String searchLower = this.searchText.toLowerCase(Locale.ROOT);
            List list = soloPlayers.stream().filter(info -> info.getPlayerName().toLowerCase(Locale.ROOT).contains(searchLower)).collect(Collectors.toList());
            HashSet<UUID> teamsWithMatchingMembers = new HashSet<UUID>();
            HashMap filteredTeamMembersMap = new HashMap();
            for (Map.Entry entry3 : teamMembersMap.entrySet()) {
                UUID teamUUID = (UUID)entry3.getKey();
                List members = (List)entry3.getValue();
                List filteredMembers = members.stream().filter(info -> info.getPlayerName().toLowerCase(Locale.ROOT).contains(searchLower)).collect(Collectors.toList());
                if (filteredMembers.isEmpty()) continue;
                filteredTeamMembersMap.put(teamUUID, filteredMembers);
                teamsWithMatchingMembers.add(teamUUID);
            }
            Map<UUID, PlayerRelationInfo> map = teamInfoMap.entrySet().stream().filter(entry -> ((PlayerRelationInfo)entry.getValue()).getPlayerName().toLowerCase(Locale.ROOT).contains(searchLower) || teamsWithMatchingMembers.contains(entry.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            soloPlayers = list;
            teamInfoMap = map;
            teamMembersMap = filteredTeamMembersMap;
        }
        this.filteredPlayerInfoList = new ArrayList<PlayerRelationInfo>();
        this.filteredPlayerInfoList.addAll(soloPlayers);
        for (Map.Entry entry4 : teamInfoMap.entrySet()) {
            UUID teamUUID = (UUID)entry4.getKey();
            PlayerRelationInfo teamInfo = (PlayerRelationInfo)entry4.getValue();
            this.filteredPlayerInfoList.add(teamInfo);
            if (!teamMembersMap.containsKey(teamUUID)) continue;
            this.filteredPlayerInfoList.addAll((Collection)teamMembersMap.get(teamUUID));
        }
    }

    private void updatePlayerList() {
        if (this.playerListWidget != null) {
            this.playerListWidget.m_93516_();
            String currentPlayerName = Minecraft.m_91087_().f_91074_.m_7755_().getString();
            ClientPacketHandler.requestTeamData();
            UUID currentPlayerTeamUUID = null;
            if (ClientPacketHandler.getLatestTeamData() != null) {
                currentPlayerTeamUUID = ClientPacketHandler.getLatestTeamData().getTeamUUID();
            }
            HashMap<UUID, Integer> teamIndexMap = new HashMap<UUID, Integer>();
            HashMap teamMembersMap = new HashMap();
            for (int i = 0; i < this.filteredPlayerInfoList.size(); ++i) {
                PlayerRelationInfo info = this.filteredPlayerInfoList.get(i);
                boolean isSelf = info.getEntryType() == PlayerRelationListEntry.EntryType.PERSONAL && info.getPlayerName().equals(currentPlayerName);
                boolean isOwnTeam = info.getEntryType() == PlayerRelationListEntry.EntryType.TEAM && currentPlayerTeamUUID != null && info.getPlayerUUID().equals(currentPlayerTeamUUID);
                PlayerRelationListEntry entry = PlayerRelationListEntry.createForRelationUI(info.getPlayerName(), info.getPlayerUUID(), info.getMyRelation(), info.getTheirRelation(), this.playerListWidget, this::onRelationChanged, info.getEntryType());
                if (isSelf || isOwnTeam) {
                    entry.hideRelationButton();
                }
                int entryIndex = this.playerListWidget.addEntry(entry);
                if (info.getEntryType() != PlayerRelationListEntry.EntryType.TEAM) continue;
                teamIndexMap.put(info.getPlayerUUID(), entryIndex);
                teamMembersMap.put(info.getPlayerUUID(), new ArrayList());
            }
            RelationResponsePacket relationData = ClientPacketHandler.getLatestRelationData();
            if (relationData != null) {
                block1: for (int i = 0; i < this.filteredPlayerInfoList.size(); ++i) {
                    PlayerRelationInfo info = this.filteredPlayerInfoList.get(i);
                    if (info.getEntryType() != PlayerRelationListEntry.EntryType.PERSONAL) continue;
                    for (Map.Entry<UUID, RelationResponsePacket.TeamInfo> teamEntry : relationData.getTeamInfoMap().entrySet()) {
                        UUID teamUUID = teamEntry.getKey();
                        RelationResponsePacket.TeamInfo teamInfo = teamEntry.getValue();
                        if (!teamInfo.getMembers().containsKey(info.getPlayerUUID())) continue;
                        if (!teamIndexMap.containsKey(teamUUID)) continue block1;
                        ((List)teamMembersMap.get(teamUUID)).add(i);
                        continue block1;
                    }
                }
                for (Map.Entry entry : teamMembersMap.entrySet()) {
                    UUID teamUUID = (UUID)entry.getKey();
                    List memberIndices = (List)entry.getValue();
                    this.playerListWidget.setTeamMembers(teamUUID, memberIndices);
                }
            }
        }
    }

    private void onRelationChanged(UUID playerUUID, RelationSystem.RelationType newRelation) {
        for (PlayerRelationInfo info : this.playerInfoList) {
            RelationResponsePacket relationData;
            if (!info.getPlayerUUID().equals(playerUUID)) continue;
            info.setMyRelation(newRelation);
            if (info.getEntryType() != PlayerRelationListEntry.EntryType.TEAM || (relationData = ClientPacketHandler.getLatestRelationData()) == null || !relationData.getTeamInfoMap().containsKey(playerUUID)) break;
            RelationResponsePacket.TeamInfo teamInfo = relationData.getTeamInfoMap().get(playerUUID);
            block1: for (UUID memberUUID : teamInfo.getMembers().keySet()) {
                for (PlayerRelationInfo memberInfo : this.playerInfoList) {
                    if (!memberInfo.getPlayerUUID().equals(memberUUID)) continue;
                    memberInfo.setMyRelation(newRelation);
                    this.updateMemberEntryRelation(memberUUID, newRelation);
                    continue block1;
                }
            }
        }
        this.hasChanges = true;
        this.updateApplyButton();
    }

    private void updateMemberEntryRelation(UUID memberUUID, RelationSystem.RelationType newRelation) {
        for (PlayerRelationListEntry entry : this.playerListWidget.m_6702_()) {
            if (!entry.getPlayerUUID().equals(memberUUID)) continue;
            entry.setRelation(PlayerRelationListEntry.convertFromSystemRelation(newRelation));
            break;
        }
    }

    private void onSearchTextChanged(String text) {
        this.searchText = text;
        this.updateFilteredPlayerList();
        this.updatePlayerList();
        if (this.playerListWidget != null) {
            this.playerListWidget.m_93410_(0.0);
        }
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        guiGraphics.m_280509_(this.leftPos, this.topPos, this.leftPos + 240, this.topPos + 250, -1073741824);
        guiGraphics.m_280509_(this.leftPos, this.topPos, this.leftPos + 240, this.topPos + 1, -1);
        guiGraphics.m_280509_(this.leftPos, this.topPos + 250 - 1, this.leftPos + 240, this.topPos + 250, -1);
        guiGraphics.m_280509_(this.leftPos, this.topPos, this.leftPos + 1, this.topPos + 250, -1);
        guiGraphics.m_280509_(this.leftPos + 240 - 1, this.topPos, this.leftPos + 240, this.topPos + 250, -1);
        guiGraphics.m_280653_(this.f_96547_, this.f_96539_, this.leftPos + 120, this.topPos + 10, 0xFFFFFF);
        guiGraphics.m_280488_(this.f_96547_, Component.m_237115_((String)"ui.hundred_years_war.search").getString().split("\\.\\.\\.")[0], this.leftPos + 10, this.topPos + 20 + 5, 0xFFFFFF);
        if (this.playerListWidget != null) {
            this.playerListWidget.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
        }
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        return super.m_6375_(mouseX, mouseY, button);
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 256) {
            this.m_7379_();
            return true;
        }
        if (this.searchBox.m_93696_()) {
            return this.searchBox.m_7933_(keyCode, scanCode, modifiers);
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    public boolean m_5534_(char codePoint, int modifiers) {
        if (this.searchBox.m_93696_()) {
            return this.searchBox.m_5534_(codePoint, modifiers);
        }
        return super.m_5534_(codePoint, modifiers);
    }

    public void m_7379_() {
        if (this.hasChanges) {
            this.f_96541_.m_91152_((Screen)new CustomConfirmScreen(this, (Component)Component.m_237115_((String)"ui.hundred_years_war.confirm"), (Component)Component.m_237115_((String)"ui.hundred_years_war.unsaved_changes_confirm"), confirmed -> {
                if (confirmed) {
                    Minecraft.m_91087_().m_91152_((Screen)new CustomUI());
                } else {
                    Minecraft.m_91087_().m_91152_((Screen)this);
                }
            }));
            return;
        }
        Minecraft.m_91087_().m_91152_((Screen)new CustomUI());
    }

    public static class PlayerRelationInfo {
        private final UUID playerUUID;
        private final String playerName;
        private RelationSystem.RelationType myRelation;
        private final RelationSystem.RelationType theirRelation;
        private boolean hasChanged = false;
        private final PlayerRelationListEntry.EntryType entryType;

        public PlayerRelationInfo(UUID playerUUID, String playerName, RelationSystem.RelationType myRelation, RelationSystem.RelationType theirRelation) {
            this(playerUUID, playerName, myRelation, theirRelation, PlayerRelationListEntry.EntryType.PERSONAL);
        }

        public PlayerRelationInfo(UUID playerUUID, String playerName, RelationSystem.RelationType myRelation, RelationSystem.RelationType theirRelation, PlayerRelationListEntry.EntryType entryType) {
            this.playerUUID = playerUUID;
            this.playerName = playerName;
            this.myRelation = myRelation;
            this.theirRelation = theirRelation;
            this.entryType = entryType;
        }

        public UUID getPlayerUUID() {
            return this.playerUUID;
        }

        public String getPlayerName() {
            return this.playerName;
        }

        public RelationSystem.RelationType getMyRelation() {
            return this.myRelation;
        }

        public void setMyRelation(RelationSystem.RelationType relation) {
            if (this.myRelation != relation) {
                this.myRelation = relation;
                this.hasChanged = true;
            }
        }

        public RelationSystem.RelationType getTheirRelation() {
            return this.theirRelation;
        }

        public boolean hasChanged() {
            return this.hasChanged;
        }

        public void resetChanged() {
            this.hasChanged = false;
        }

        public PlayerRelationListEntry.EntryType getEntryType() {
            return this.entryType;
        }
    }
}

