/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.client.freecam.ui;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import ydmsama.hundred_years_war.client.freecam.ui.CustomButton;
import ydmsama.hundred_years_war.client.freecam.ui.TeamApplicationEntry;
import ydmsama.hundred_years_war.client.freecam.ui.TeamApplicationsWidget;
import ydmsama.hundred_years_war.client.network.ClientPacketHandler;
import ydmsama.hundred_years_war.main.network.packets.TeamApplicationsResponsePacket;

public class TeamApplicationsUI
extends Screen {
    private static final int WINDOW_WIDTH = 240;
    private static final int WINDOW_HEIGHT = 250;
    private final Screen parentScreen;
    private int leftPos;
    private int topPos;
    private EditBox searchBox;
    private TeamApplicationsWidget applicationsListWidget;
    private CustomButton backButton;
    private String searchText = "";
    private List<TeamApplicationsResponsePacket.Application> allApplications = new ArrayList<TeamApplicationsResponsePacket.Application>();
    private List<TeamApplicationsResponsePacket.Application> filteredApplications = new ArrayList<TeamApplicationsResponsePacket.Application>();

    public TeamApplicationsUI(Screen parentScreen) {
        super((Component)Component.m_237115_((String)"ui.hundred_years_war.team_applications_ui"));
        this.parentScreen = parentScreen;
        ClientPacketHandler.requestTeamApplications();
    }

    public void onApplicationsDataUpdate(TeamApplicationsResponsePacket packet) {
        System.out.println("\u6536\u5230\u56e2\u961f\u7533\u8bf7\u6570\u636e\u66f4\u65b0: " + packet.getApplications().size() + " \u4e2a\u7533\u8bf7");
        this.allApplications.clear();
        this.allApplications.addAll(packet.getApplications());
        for (TeamApplicationsResponsePacket.Application app : this.allApplications) {
            System.out.println("  \u7533\u8bf7\u8005: " + app.getPlayerName() + ", UUID: " + app.getPlayerUUID() + ", \u65f6\u95f4: " + app.getApplyTime());
        }
        if (this.searchBox != null && this.applicationsListWidget != null) {
            this.updateFilteredApplications();
            this.applicationsListWidget.m_93410_(0.0);
        }
    }

    private void updateFilteredApplications() {
        if (this.searchBox == null) {
            return;
        }
        String searchText = this.searchBox.m_94155_().toLowerCase();
        this.filteredApplications.clear();
        if (searchText.isEmpty()) {
            this.filteredApplications.addAll(this.allApplications);
        } else {
            for (TeamApplicationsResponsePacket.Application app : this.allApplications) {
                if (!app.getPlayerName().toLowerCase().contains(searchText)) continue;
                this.filteredApplications.add(app);
            }
        }
        System.out.println("\u8fc7\u6ee4\u540e\u7684\u7533\u8bf7\u6570\u91cf: " + this.filteredApplications.size());
        this.updateApplicationsList();
    }

    private void updateApplicationsList() {
        if (this.applicationsListWidget == null) {
            return;
        }
        this.applicationsListWidget.m_93516_();
        for (TeamApplicationsResponsePacket.Application app : this.filteredApplications) {
            TeamApplicationEntry entry = new TeamApplicationEntry(app.getPlayerName(), app.getPlayerUUID(), app.getApplyTime(), this.applicationsListWidget);
            entry.setAcceptClickHandler(() -> this.acceptApplication(app.getPlayerUUID()));
            entry.setRejectClickHandler(() -> this.rejectApplication(app.getPlayerUUID()));
            this.applicationsListWidget.addEntry(entry);
        }
        this.applicationsListWidget.m_93410_(0.0);
    }

    private void acceptApplication(UUID playerUUID) {
        ClientPacketHandler.requestTeamManage(ClientPacketHandler.getLatestTeamData().getTeamUUID(), "accept", playerUUID);
        for (int i = this.allApplications.size() - 1; i >= 0; --i) {
            if (!this.allApplications.get(i).getPlayerUUID().equals(playerUUID)) continue;
            this.allApplications.remove(i);
            break;
        }
        this.updateFilteredApplications();
    }

    private void rejectApplication(UUID playerUUID) {
        ClientPacketHandler.requestTeamManage(ClientPacketHandler.getLatestTeamData().getTeamUUID(), "reject", playerUUID);
        for (int i = this.allApplications.size() - 1; i >= 0; --i) {
            if (!this.allApplications.get(i).getPlayerUUID().equals(playerUUID)) continue;
            this.allApplications.remove(i);
            break;
        }
        this.updateFilteredApplications();
    }

    public boolean m_5534_(char codePoint, int modifiers) {
        if (this.searchBox.m_5534_(codePoint, modifiers)) {
            this.updateFilteredApplications();
            return true;
        }
        return super.m_5534_(codePoint, modifiers);
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (this.searchBox.m_7933_(keyCode, scanCode, modifiers)) {
            this.updateFilteredApplications();
            return true;
        }
        if (keyCode == 256) {
            this.m_7379_();
            return true;
        }
        if (this.searchBox.m_93696_()) {
            return this.searchBox.m_7933_(keyCode, scanCode, modifiers);
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    protected void m_7856_() {
        super.m_7856_();
        this.leftPos = (this.f_96543_ - 240) / 2;
        this.topPos = (this.f_96544_ - 250) / 2;
        this.searchBox = new EditBox(this.f_96547_, this.leftPos + 20, this.topPos + 20 + 25, 200, 20, (Component)Component.m_237115_((String)"ui.hundred_years_war.search"));
        this.searchBox.m_94199_(32);
        this.searchBox.m_94182_(true);
        this.searchBox.m_94190_(true);
        this.searchBox.m_94202_(0xFFFFFF);
        this.searchBox.m_94144_(this.searchText);
        this.searchBox.m_94151_(s -> {
            this.searchText = s;
            this.updateFilteredApplications();
        });
        this.m_142416_((GuiEventListener)this.searchBox);
        this.applicationsListWidget = new TeamApplicationsWidget(this.f_96541_, 200, 140, this.topPos + 20 + 50, this.topPos + 250 - 20 - 20 - 5, 24);
        this.applicationsListWidget.m_93507_(this.leftPos + 20);
        this.m_142416_((GuiEventListener)this.applicationsListWidget);
        this.backButton = new CustomButton(this.leftPos + 240 - 60 - 10, this.topPos + 250 - 20 - 10, 60, 20, (Component)Component.m_237115_((String)"ui.hundred_years_war.back"), button -> this.m_7379_());
        this.m_142416_(this.backButton);
        this.allApplications.clear();
        this.filteredApplications.clear();
        ClientPacketHandler.requestTeamApplications();
        TeamApplicationsResponsePacket cachedData = ClientPacketHandler.getLatestTeamApplicationsData();
        if (cachedData != null) {
            System.out.println("\u7f13\u5b58\u7684\u7533\u8bf7\u6570\u636e: " + cachedData.getApplications().size() + " \u4e2a\u7533\u8bf7");
            for (TeamApplicationsResponsePacket.Application app : cachedData.getApplications()) {
                System.out.println("  \u7533\u8bf7\u8005: " + app.getPlayerName() + ", UUID: " + app.getPlayerUUID());
            }
            if (!cachedData.getApplications().isEmpty()) {
                this.onApplicationsDataUpdate(cachedData);
            }
        } else {
            System.out.println("\u6ca1\u6709\u7f13\u5b58\u7684\u7533\u8bf7\u6570\u636e");
        }
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        guiGraphics.m_280509_(this.leftPos, this.topPos, this.leftPos + 240, this.topPos + 250, -1073741824);
        guiGraphics.m_280509_(this.leftPos, this.topPos, this.leftPos + 240, this.topPos + 1, -1);
        guiGraphics.m_280509_(this.leftPos, this.topPos + 250 - 1, this.leftPos + 240, this.topPos + 250, -1);
        guiGraphics.m_280509_(this.leftPos, this.topPos, this.leftPos + 1, this.topPos + 250, -1);
        guiGraphics.m_280509_(this.leftPos + 240 - 1, this.topPos, this.leftPos + 240, this.topPos + 250, -1);
        guiGraphics.m_280653_(this.f_96547_, this.f_96539_, this.leftPos + 120, this.topPos + 10, 0xFFFFFF);
        if (this.allApplications.isEmpty()) {
            guiGraphics.m_280653_(this.f_96547_, (Component)Component.m_237115_((String)"ui.hundred_years_war.no_applications"), this.leftPos + 120, this.topPos + 125, 0xFFFFFF);
        } else {
            this.applicationsListWidget.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
        }
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
    }

    public void m_7379_() {
        Minecraft.m_91087_().m_91152_(this.parentScreen);
    }
}

