/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.client.freecam.ui;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.function.BiConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.ContainerObjectSelectionList;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import ydmsama.hundred_years_war.client.freecam.ui.CustomButton;
import ydmsama.hundred_years_war.main.utils.RelationSystem;

public class TeamRelationListEntry
extends ContainerObjectSelectionList.Entry<TeamRelationListEntry> {
    private final String playerName;
    private final ContainerObjectSelectionList<?> parent;
    private final List<GuiEventListener> children = new ArrayList<GuiEventListener>();
    private final Minecraft minecraft;
    private CustomButton relationButton;
    private static final ResourceLocation PERSONAL_ICON = new ResourceLocation("hundred_years_war", "textures/gui/personal.png");
    private static final ResourceLocation TEAM_ICON = new ResourceLocation("hundred_years_war", "textures/gui/team.png");
    private static final int ICON_SIZE = 16;
    protected RelationType currentRelation = RelationType.NEUTRAL;
    private UUID playerUUID;
    private BiConsumer<UUID, RelationSystem.RelationType> relationChangeCallback;
    private int nameColor = 0xFFFFFF;
    private EntryType entryType = EntryType.PERSONAL;

    public TeamRelationListEntry(String playerName, ContainerObjectSelectionList<?> parent) {
        this.playerName = playerName;
        this.parent = parent;
        this.minecraft = Minecraft.m_91087_();
        this.updateRelationButton();
    }

    public static TeamRelationListEntry createForRelationUI(String playerName, UUID playerUUID, RelationSystem.RelationType myRelation, RelationSystem.RelationType theirRelation, ContainerObjectSelectionList<?> parent, BiConsumer<UUID, RelationSystem.RelationType> callback) {
        return TeamRelationListEntry.createForRelationUI(playerName, playerUUID, myRelation, theirRelation, parent, callback, EntryType.PERSONAL);
    }

    public static TeamRelationListEntry createForRelationUI(String playerName, UUID playerUUID, RelationSystem.RelationType myRelation, RelationSystem.RelationType theirRelation, ContainerObjectSelectionList<?> parent, BiConsumer<UUID, RelationSystem.RelationType> callback, EntryType entryType) {
        TeamRelationListEntry entry = new TeamRelationListEntry(playerName, parent);
        entry.playerUUID = playerUUID;
        entry.relationChangeCallback = callback;
        entry.entryType = entryType;
        entry.nameColor = TeamRelationListEntry.getColorForRelationType(theirRelation);
        entry.setRelation(TeamRelationListEntry.convertFromSystemRelation(myRelation));
        return entry;
    }

    public void setRelation(RelationType relation) {
        this.currentRelation = relation;
        this.updateRelationButton();
    }

    public void setEntryType(EntryType entryType) {
        this.entryType = entryType;
    }

    public EntryType getEntryType() {
        return this.entryType;
    }

    public UUID getPlayerUUID() {
        return this.playerUUID;
    }

    public static RelationType convertFromSystemRelation(RelationSystem.RelationType systemRelation) {
        return switch (systemRelation) {
            case RelationSystem.RelationType.HOSTILE -> RelationType.HOSTILE;
            case RelationSystem.RelationType.NEUTRAL -> RelationType.NEUTRAL;
            case RelationSystem.RelationType.FRIENDLY -> RelationType.FRIENDLY;
            case RelationSystem.RelationType.CONTROL -> RelationType.SHARED_CONTROL;
            default -> RelationType.NEUTRAL;
        };
    }

    public static RelationSystem.RelationType convertToSystemRelation(RelationType uiRelation) {
        return switch (uiRelation) {
            case RelationType.HOSTILE -> RelationSystem.RelationType.HOSTILE;
            case RelationType.NEUTRAL -> RelationSystem.RelationType.NEUTRAL;
            case RelationType.FRIENDLY -> RelationSystem.RelationType.FRIENDLY;
            case RelationType.SHARED_CONTROL -> RelationSystem.RelationType.CONTROL;
            default -> RelationSystem.RelationType.NEUTRAL;
        };
    }

    public static int getColorForRelationType(RelationSystem.RelationType relationType) {
        return switch (relationType) {
            case RelationSystem.RelationType.HOSTILE -> 0xFF5555;
            case RelationSystem.RelationType.NEUTRAL, RelationSystem.RelationType.FRIENDLY -> 0xFFFF55;
            case RelationSystem.RelationType.CONTROL -> 0x55FF55;
            default -> 0xFFFFFF;
        };
    }

    private void updateRelationButton() {
        if (this.relationButton == null) {
            this.relationButton = new CustomButton(0, 0, 100, 18, (Component)Component.m_237115_((String)this.currentRelation.getTranslationKey()).m_130938_(style -> style.m_178520_(this.currentRelation.getColor())), button -> this.onRelationToggle());
            this.children.add(this.relationButton);
        } else {
            this.relationButton.m_93666_((Component)Component.m_237115_((String)this.currentRelation.getTranslationKey()).m_130938_(style -> style.m_178520_(this.currentRelation.getColor())));
        }
    }

    protected void onRelationToggle() {
        this.currentRelation = this.currentRelation.next();
        this.updateRelationButton();
        if (this.relationChangeCallback != null && this.playerUUID != null) {
            RelationSystem.RelationType systemRelation = TeamRelationListEntry.convertToSystemRelation(this.currentRelation);
            this.relationChangeCallback.accept(this.playerUUID, systemRelation);
        } else {
            this.minecraft.f_91065_.m_93076_().m_93785_((Component)Component.m_237113_((String)("\u8bbe\u7f6e\u4e0e " + this.playerName + " \u7684\u5173\u7cfb\u4e3a: " + Component.m_237115_((String)this.currentRelation.getTranslationKey()).getString())));
        }
    }

    public void m_6311_(GuiGraphics guiGraphics, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean isHovered, float partialTick) {
        ResourceLocation iconResource = this.entryType == EntryType.TEAM ? TEAM_ICON : PERSONAL_ICON;
        guiGraphics.m_280163_(iconResource, left + 5, top + 4, 0.0f, 0.0f, 16, 16, 16, 16);
        guiGraphics.m_280488_(this.minecraft.f_91062_, this.playerName, left + 6 + 16, top + 8, this.nameColor);
        int buttonY = top + 3;
        int buttonWidth = 60;
        int buttonsLeft = left + width - buttonWidth - 10;
        this.relationButton.m_252865_(buttonsLeft);
        this.relationButton.m_253211_(buttonY);
        this.relationButton.m_93674_(buttonWidth);
        this.relationButton.m_93666_((Component)Component.m_237115_((String)this.currentRelation.getTranslationKey()).m_130938_(style -> style.m_178520_(this.currentRelation.getColor())));
        this.relationButton.m_88315_(guiGraphics, mouseX, mouseY, partialTick);
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        for (GuiEventListener child : this.children) {
            if (!child.m_5953_(mouseX, mouseY) || !child.m_6375_(mouseX, mouseY, button)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public List<? extends GuiEventListener> m_6702_() {
        return this.children;
    }

    @NotNull
    public List<? extends NarratableEntry> m_142437_() {
        return this.children.stream().filter(child -> child instanceof NarratableEntry).map(child -> (NarratableEntry)child).collect(ArrayList::new, ArrayList::add, ArrayList::addAll);
    }

    public void setButtonText(Component text) {
        if (this.relationButton != null) {
            this.relationButton.m_93666_(text);
        }
    }

    public void setButtonClickHandler(Runnable handler) {
        if (this.relationButton != null) {
            this.relationButton = new CustomButton(this.relationButton.m_252754_(), this.relationButton.m_252907_(), this.relationButton.m_5711_(), this.relationButton.m_93694_(), this.relationButton.m_6035_(), button -> handler.run());
        }
    }

    public static enum RelationType {
        HOSTILE(0, "relation.type.hostile", 0xFF5555),
        NEUTRAL(1, "relation.type.neutral", 0xFFFF55),
        FRIENDLY(2, "relation.type.friendly", 0xFFFF55),
        SHARED_CONTROL(3, "relation.type.control", 0x55FF55);

        private final int id;
        private final String translationKey;
        private final int color;

        private RelationType(int id, String translationKey, int color) {
            this.id = id;
            this.translationKey = translationKey;
            this.color = color;
        }

        public RelationType next() {
            RelationType[] values = RelationType.values();
            return values[(this.id + 1) % values.length];
        }

        public String getTranslationKey() {
            return this.translationKey;
        }

        public int getColor() {
            return this.color;
        }
    }

    public static enum EntryType {
        PERSONAL,
        TEAM;

    }
}

