/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.client.freecam.ui.manual;

import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.util.FormattedCharSequence;
import ydmsama.hundred_years_war.client.freecam.ui.manual.ManualImage;

public class ManualPage {
    private final List<FormattedCharSequence> wrappedContent;
    private final List<ManualImage> images;
    private final int contentHeight;
    private final int lineHeight;

    public ManualPage(List<FormattedCharSequence> wrappedContent, List<ManualImage> images, int lineHeight) {
        this.wrappedContent = wrappedContent;
        this.images = images;
        this.contentHeight = wrappedContent.size() * lineHeight;
        this.lineHeight = lineHeight;
    }

    public List<ManualImage> getImages() {
        return this.images;
    }

    public List<FormattedCharSequence> getWrappedContent() {
        return this.wrappedContent;
    }

    public int getContentHeight() {
        return this.contentHeight;
    }

    public void render(GuiGraphics guiGraphics, int x, int y, int color) {
        Font font = Minecraft.m_91087_().f_91062_;
        int yOffset = y;
        for (FormattedCharSequence line : this.wrappedContent) {
            guiGraphics.m_280649_(font, line, x, yOffset, color, false);
            yOffset += this.lineHeight;
        }
        for (ManualImage image : this.images) {
            image.render(guiGraphics, x, y);
        }
    }

    public void renderTooltips(GuiGraphics guiGraphics, int mouseX, int mouseY, int x, int y) {
        for (ManualImage image : this.images) {
            image.renderTooltip(guiGraphics, mouseX, mouseY, x, y);
        }
    }
}

