/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.client.freecam.ui.wheel;

import java.util.List;
import java.util.Optional;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import ydmsama.hundred_years_war.client.freecam.ui.wheel.CommandWheelUI;
import ydmsama.hundred_years_war.client.network.ClientPacketHandler;
import ydmsama.hundred_years_war.client.utils.ClientRelationHelper;
import ydmsama.hundred_years_war.main.entity.entities.BaseCombatEntity;
import ydmsama.hundred_years_war.main.utils.FormationTypes;
import ydmsama.hundred_years_war.main.utils.RelationSystem;

public class CommandWheelHandler {
    private static CommandWheelHandler instance;
    private boolean isWheelOpen = false;
    private boolean isFollowing = false;
    private String currentFormation = "none";
    private String lastNonNoneFormation = "tight";
    private HitResult lastHitResult = null;
    public static final int PICK_DISTANCE = 200;
    private long lastCommandTime = 0L;
    private static final long COMMAND_RENDER_DURATION = 3000L;

    private CommandWheelHandler() {
    }

    public static synchronized CommandWheelHandler getInstance() {
        if (instance == null) {
            instance = new CommandWheelHandler();
        }
        return instance;
    }

    public void recordCommandTime() {
        this.lastCommandTime = System.currentTimeMillis();
    }

    public boolean shouldRenderCommandEffect() {
        return CommandWheelHandler.getInstance().isWheelOpen() || System.currentTimeMillis() - this.lastCommandTime < 3000L;
    }

    public void openCommandWheel() {
        Minecraft minecraft = Minecraft.m_91087_();
        if (minecraft.f_91074_ == null || minecraft.f_91080_ != null) {
            return;
        }
        if (!this.isWheelOpen) {
            this.isWheelOpen = true;
            minecraft.m_91152_((Screen)new CommandWheelUI());
        }
    }

    public void closeCommandWheel() {
        if (this.isWheelOpen) {
            this.isWheelOpen = false;
            if (Minecraft.m_91087_().f_91080_ instanceof CommandWheelUI) {
                Minecraft.m_91087_().m_91152_(null);
            }
        }
    }

    public boolean isWheelOpen() {
        return this.isWheelOpen;
    }

    public boolean isFollowing() {
        return this.isFollowing;
    }

    public void setFollowing(boolean following) {
        this.isFollowing = following;
    }

    public void toggleFollowing() {
        this.isFollowing = !this.isFollowing;
    }

    public String getCurrentFormation() {
        return this.currentFormation;
    }

    public boolean isFormationActive() {
        return FormationTypes.isActive(this.currentFormation);
    }

    public void selectFormation(String formation) {
        this.setFormationInternal(formation, true);
    }

    public void applyServerFormation(String formation, String lastNonNone) {
        this.lastNonNoneFormation = FormationTypes.sanitizeNonNone(lastNonNone);
        this.setFormationInternal(formation, false);
    }

    public String toggleFormationShortcut() {
        if (this.isFormationActive()) {
            this.setFormationInternal("none", true);
        } else {
            this.setFormationInternal(this.lastNonNoneFormation, true);
        }
        return this.currentFormation;
    }

    private void setFormationInternal(String desiredFormation, boolean sync) {
        String sanitized;
        this.currentFormation = sanitized = FormationTypes.sanitize(desiredFormation);
        if (FormationTypes.isActive(sanitized)) {
            this.lastNonNoneFormation = FormationTypes.sanitizeNonNone(sanitized);
        }
        if (sync) {
            ClientPacketHandler.sendFormationSelectionUpdate(this.currentFormation, this.lastNonNoneFormation);
        }
    }

    public HitResult getLastHitResult() {
        return this.lastHitResult;
    }

    public void tick() {
        if (this.isWheelOpen) {
            this.lastHitResult = this.performWheelRayTrace();
            Minecraft minecraft = Minecraft.m_91087_();
            Screen screen = minecraft.f_91080_;
            if (screen instanceof CommandWheelUI) {
                CommandWheelUI wheelUI = (CommandWheelUI)screen;
                wheelUI.getCommandWheelTree().updateNodesOnTick();
            }
        }
    }

    public HitResult performWheelRayTrace() {
        return this.performWheelRayTrace(false);
    }

    public HitResult performWheelRayTrace(boolean ignoreControlledEntities) {
        Minecraft minecraft = Minecraft.m_91087_();
        LocalPlayer player = minecraft.f_91074_;
        if (player == null) {
            return null;
        }
        Camera camera = minecraft.f_91063_.m_109153_();
        Vec3 eyePos = camera.m_90583_();
        Vec3 lookVec = Vec3.m_82498_((float)camera.m_90589_(), (float)camera.m_90590_());
        Vec3 targetPos = eyePos.m_82520_(lookVec.f_82479_ * 200.0, lookVec.f_82480_ * 200.0, lookVec.f_82481_ * 200.0);
        BlockHitResult blockResult = minecraft.f_91073_.m_45547_(new ClipContext(eyePos, targetPos, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)player));
        double blockDistance = Double.MAX_VALUE;
        if (blockResult.m_6662_() != HitResult.Type.MISS) {
            blockDistance = eyePos.m_82557_(blockResult.m_82450_());
        }
        Entity closestEntity = null;
        Vec3 closestHitPos = null;
        double closestDistance = Double.MAX_VALUE;
        AABB searchBox = new AABB(eyePos.f_82479_ - 200.0, eyePos.f_82480_ - 200.0, eyePos.f_82481_ - 200.0, eyePos.f_82479_ + 200.0, eyePos.f_82480_ + 200.0, eyePos.f_82481_ + 200.0);
        List entities = minecraft.f_91073_.m_45933_((Entity)player, searchBox);
        for (Entity entity : entities) {
            double distance;
            AABB entityBox;
            Optional hitPos;
            if (!(entity instanceof LivingEntity) || entity == player || !entity.m_6084_() || !entity.m_6087_() || ignoreControlledEntities && this.shouldIgnoreControlledEntity(entity) || !(hitPos = (entityBox = entity.m_20191_().m_82400_(0.3)).m_82371_(eyePos, targetPos)).isPresent() || !((distance = eyePos.m_82557_((Vec3)hitPos.get())) < closestDistance) || !(distance < blockDistance)) continue;
            closestEntity = entity;
            closestHitPos = (Vec3)hitPos.get();
            closestDistance = distance;
        }
        if (closestEntity != null) {
            return new EntityHitResult(closestEntity, closestHitPos);
        }
        if (blockResult.m_6662_() != HitResult.Type.MISS) {
            return blockResult;
        }
        BlockPos targetBlockPos = BlockPos.m_274561_((double)targetPos.f_82479_, (double)targetPos.f_82480_, (double)targetPos.f_82481_);
        return BlockHitResult.m_82426_((Vec3)targetPos, (Direction)Direction.m_122366_((double)lookVec.f_82479_, (double)lookVec.f_82480_, (double)lookVec.f_82481_), (BlockPos)targetBlockPos);
    }

    private boolean shouldIgnoreControlledEntity(Entity entity) {
        if (entity instanceof BaseCombatEntity) {
            RelationSystem.RelationType relation = ClientRelationHelper.getInstance().getRelationWithPlayer(entity);
            return relation == RelationSystem.RelationType.CONTROL;
        }
        return false;
    }

    public static void init() {
        CommandWheelHandler.getInstance();
    }
}

