/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.client.freecam.ui.wheel;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.MultiLineLabel;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.Mth;
import org.joml.Matrix4f;

public class TrapezoidButton
extends AbstractWidget {
    private final int cx;
    private final int cy;
    private final float innerR;
    private final float outerR;
    private final float a0;
    private final float a1;
    private int normalColor;
    private int hoverColor;
    private final MultiLineLabel ml;
    private final Runnable onPress;
    private float alphaFactor = 1.0f;

    public TrapezoidButton(int cx, int cy, float innerR, float outerR, float startDeg, float endDeg, Component label, Runnable onPress) {
        super((int)((float)cx - outerR), (int)((float)cy - outerR), (int)(outerR * 2.0f), (int)(outerR * 2.0f), label);
        this.cx = cx;
        this.cy = cy;
        this.innerR = innerR;
        this.outerR = outerR;
        this.a0 = (float)Math.toRadians(startDeg);
        this.a1 = (float)Math.toRadians(endDeg);
        this.normalColor = -1073741824;
        this.hoverColor = -1070583760;
        int maxLineWidth = (int)((outerR - innerR) * 0.6f);
        this.ml = MultiLineLabel.m_94341_((Font)Minecraft.m_91087_().f_91062_, (FormattedText)label, (int)maxLineWidth);
        this.onPress = onPress;
    }

    public void m_93650_(float alpha) {
        this.alphaFactor = Mth.m_14036_((float)alpha, (float)0.0f, (float)1.0f);
        this.updateColors();
    }

    private void updateColors() {
        int normalAlpha = this.normalColor >> 24 & 0xFF;
        int hoverAlpha = this.hoverColor >> 24 & 0xFF;
        normalAlpha = (int)((float)normalAlpha * this.alphaFactor);
        hoverAlpha = (int)((float)hoverAlpha * this.alphaFactor);
        this.normalColor = normalAlpha << 24 | this.normalColor & 0xFFFFFF;
        this.hoverColor = hoverAlpha << 24 | this.hoverColor & 0xFFFFFF;
    }

    public void m_87963_(GuiGraphics g, int mouseX, int mouseY, float partialTicks) {
        boolean hovered = this.m_5953_(mouseX, mouseY);
        int fillColor = hovered ? this.hoverColor : this.normalColor;
        int borderColor = -1;
        if (this.alphaFactor < 1.0f) {
            int a = borderColor >> 24 & 0xFF;
            a = (int)((float)a * this.alphaFactor);
            borderColor = a << 24 | borderColor & 0xFFFFFF;
        }
        this.fillTrapezoid(g, fillColor);
        if (borderColor != 0) {
            this.drawBorderAll(g, 1.0f, borderColor);
        }
        this.drawLabel(g);
    }

    private void fillTrapezoid(GuiGraphics g, int fillColor) {
        float[] xs = new float[]{(float)this.cx + this.innerR * Mth.m_14089_((float)this.a0), (float)this.cx + this.outerR * Mth.m_14089_((float)this.a0), (float)this.cx + this.outerR * Mth.m_14089_((float)this.a1), (float)this.cx + this.innerR * Mth.m_14089_((float)this.a1)};
        float[] ys = new float[]{(float)this.cy + this.innerR * Mth.m_14031_((float)this.a0), (float)this.cy + this.outerR * Mth.m_14031_((float)this.a0), (float)this.cy + this.outerR * Mth.m_14031_((float)this.a1), (float)this.cy + this.innerR * Mth.m_14031_((float)this.a1)};
        PoseStack poseStack = g.m_280168_();
        Matrix4f matrix = poseStack.m_85850_().m_252922_();
        RenderSystem.disableDepthTest();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShader(GameRenderer::m_172811_);
        float alpha = (float)(fillColor >> 24 & 0xFF) / 255.0f;
        float red = (float)(fillColor >> 16 & 0xFF) / 255.0f;
        float green = (float)(fillColor >> 8 & 0xFF) / 255.0f;
        float blue = (float)(fillColor & 0xFF) / 255.0f;
        BufferBuilder bufferBuilder = Tesselator.m_85913_().m_85915_();
        RenderSystem.disableCull();
        bufferBuilder.m_166779_(VertexFormat.Mode.TRIANGLES, DefaultVertexFormat.f_85815_);
        bufferBuilder.m_252986_(matrix, xs[0], ys[0], 0.0f).m_85950_(red, green, blue, alpha).m_5752_();
        bufferBuilder.m_252986_(matrix, xs[1], ys[1], 0.0f).m_85950_(red, green, blue, alpha).m_5752_();
        bufferBuilder.m_252986_(matrix, xs[2], ys[2], 0.0f).m_85950_(red, green, blue, alpha).m_5752_();
        bufferBuilder.m_252986_(matrix, xs[0], ys[0], 0.0f).m_85950_(red, green, blue, alpha).m_5752_();
        bufferBuilder.m_252986_(matrix, xs[2], ys[2], 0.0f).m_85950_(red, green, blue, alpha).m_5752_();
        bufferBuilder.m_252986_(matrix, xs[3], ys[3], 0.0f).m_85950_(red, green, blue, alpha).m_5752_();
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferBuilder.m_231175_());
    }

    private void drawBorderAll(GuiGraphics g, float thickness, int color) {
        PoseStack poseStack = g.m_280168_();
        Matrix4f matrix = poseStack.m_85850_().m_252922_();
        RenderSystem.disableDepthTest();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShader(GameRenderer::m_172811_);
        RenderSystem.disableCull();
        float alpha = (float)(color >> 24 & 0xFF) / 255.0f;
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float gC = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        BufferBuilder vb = Tesselator.m_85913_().m_85915_();
        float outerR2 = this.outerR + thickness;
        vb.m_166779_(VertexFormat.Mode.TRIANGLE_STRIP, DefaultVertexFormat.f_85815_);
        vb.m_252986_(matrix, (float)this.cx + outerR2 * Mth.m_14089_((float)this.a0), (float)this.cy + outerR2 * Mth.m_14031_((float)this.a0), 0.0f).m_85950_(r, gC, b, alpha).m_5752_();
        vb.m_252986_(matrix, (float)this.cx + this.outerR * Mth.m_14089_((float)this.a0), (float)this.cy + this.outerR * Mth.m_14031_((float)this.a0), 0.0f).m_85950_(r, gC, b, alpha).m_5752_();
        vb.m_252986_(matrix, (float)this.cx + outerR2 * Mth.m_14089_((float)this.a1), (float)this.cy + outerR2 * Mth.m_14031_((float)this.a1), 0.0f).m_85950_(r, gC, b, alpha).m_5752_();
        vb.m_252986_(matrix, (float)this.cx + this.outerR * Mth.m_14089_((float)this.a1), (float)this.cy + this.outerR * Mth.m_14031_((float)this.a1), 0.0f).m_85950_(r, gC, b, alpha).m_5752_();
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)vb.m_231175_());
        float innerR2 = this.innerR - thickness;
        vb.m_166779_(VertexFormat.Mode.TRIANGLE_STRIP, DefaultVertexFormat.f_85815_);
        vb.m_252986_(matrix, (float)this.cx + this.innerR * Mth.m_14089_((float)this.a0), (float)this.cy + this.innerR * Mth.m_14031_((float)this.a0), 0.0f).m_85950_(r, gC, b, alpha).m_5752_();
        vb.m_252986_(matrix, (float)this.cx + innerR2 * Mth.m_14089_((float)this.a0), (float)this.cy + innerR2 * Mth.m_14031_((float)this.a0), 0.0f).m_85950_(r, gC, b, alpha).m_5752_();
        vb.m_252986_(matrix, (float)this.cx + this.innerR * Mth.m_14089_((float)this.a1), (float)this.cy + this.innerR * Mth.m_14031_((float)this.a1), 0.0f).m_85950_(r, gC, b, alpha).m_5752_();
        vb.m_252986_(matrix, (float)this.cx + innerR2 * Mth.m_14089_((float)this.a1), (float)this.cy + innerR2 * Mth.m_14031_((float)this.a1), 0.0f).m_85950_(r, gC, b, alpha).m_5752_();
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)vb.m_231175_());
        vb.m_166779_(VertexFormat.Mode.TRIANGLE_STRIP, DefaultVertexFormat.f_85815_);
        vb.m_252986_(matrix, (float)this.cx + this.outerR * Mth.m_14089_((float)this.a0), (float)this.cy + this.outerR * Mth.m_14031_((float)this.a0), 0.0f).m_85950_(r, gC, b, alpha).m_5752_();
        vb.m_252986_(matrix, (float)this.cx + this.innerR * Mth.m_14089_((float)this.a0), (float)this.cy + this.innerR * Mth.m_14031_((float)this.a0), 0.0f).m_85950_(r, gC, b, alpha).m_5752_();
        vb.m_252986_(matrix, (float)this.cx + outerR2 * Mth.m_14089_((float)this.a0), (float)this.cy + outerR2 * Mth.m_14031_((float)this.a0), 0.0f).m_85950_(r, gC, b, alpha).m_5752_();
        vb.m_252986_(matrix, (float)this.cx + innerR2 * Mth.m_14089_((float)this.a0), (float)this.cy + innerR2 * Mth.m_14031_((float)this.a0), 0.0f).m_85950_(r, gC, b, alpha).m_5752_();
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)vb.m_231175_());
        vb.m_166779_(VertexFormat.Mode.TRIANGLE_STRIP, DefaultVertexFormat.f_85815_);
        vb.m_252986_(matrix, (float)this.cx + this.outerR * Mth.m_14089_((float)this.a1), (float)this.cy + this.outerR * Mth.m_14031_((float)this.a1), 0.0f).m_85950_(r, gC, b, alpha).m_5752_();
        vb.m_252986_(matrix, (float)this.cx + this.innerR * Mth.m_14089_((float)this.a1), (float)this.cy + this.innerR * Mth.m_14031_((float)this.a1), 0.0f).m_85950_(r, gC, b, alpha).m_5752_();
        vb.m_252986_(matrix, (float)this.cx + outerR2 * Mth.m_14089_((float)this.a1), (float)this.cy + outerR2 * Mth.m_14031_((float)this.a1), 0.0f).m_85950_(r, gC, b, alpha).m_5752_();
        vb.m_252986_(matrix, (float)this.cx + innerR2 * Mth.m_14089_((float)this.a1), (float)this.cy + innerR2 * Mth.m_14031_((float)this.a1), 0.0f).m_85950_(r, gC, b, alpha).m_5752_();
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)vb.m_231175_());
        RenderSystem.enableDepthTest();
        RenderSystem.disableBlend();
        RenderSystem.enableCull();
    }

    private void drawRadialEdge(GuiGraphics g, float angle, float thickness, int color, float inner, float outer) {
        float sin = Mth.m_14031_((float)angle);
        float cos = Mth.m_14089_((float)angle);
        float px = -sin * thickness * 0.5f;
        float py = cos * thickness * 0.5f;
        PoseStack ps = g.m_280168_();
        Matrix4f m = ps.m_85850_().m_252922_();
        float alpha = (float)(color >> 24 & 0xFF) / 255.0f;
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float gC = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        RenderSystem.disableCull();
        BufferBuilder bb = Tesselator.m_85913_().m_85915_();
        bb.m_166779_(VertexFormat.Mode.TRIANGLE_STRIP, DefaultVertexFormat.f_85815_);
        bb.m_252986_(m, (float)this.cx + inner * cos - px, (float)this.cy + inner * sin - py, 0.0f).m_85950_(r, gC, b, alpha).m_5752_();
        bb.m_252986_(m, (float)this.cx + inner * cos + px, (float)this.cy + inner * sin + py, 0.0f).m_85950_(r, gC, b, alpha).m_5752_();
        bb.m_252986_(m, (float)this.cx + outer * cos - px, (float)this.cy + outer * sin - py, 0.0f).m_85950_(r, gC, b, alpha).m_5752_();
        bb.m_252986_(m, (float)this.cx + outer * cos + px, (float)this.cy + outer * sin + py, 0.0f).m_85950_(r, gC, b, alpha).m_5752_();
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bb.m_231175_());
    }

    private void drawLabel(GuiGraphics g) {
        if (this.ml.m_5770_() == 0) {
            return;
        }
        float deltaA = this.a1 >= this.a0 ? this.a1 - this.a0 : this.a1 + (float)Math.PI * 2 - this.a0;
        float midA = this.a0 + deltaA / 2.0f;
        if ((double)midA > Math.PI * 2) {
            midA -= (float)Math.PI * 2;
        }
        float midR = (this.innerR + this.outerR) / 2.0f;
        int tx = (int)((float)this.cx + midR * Mth.m_14089_((float)midA));
        int totalHeight = this.ml.m_5770_() * 9;
        int ty = (int)((float)this.cy + midR * Mth.m_14031_((float)midA)) - totalHeight / 2;
        if (this.alphaFactor < 1.0f) {
            float currentAlpha = RenderSystem.getShaderColor()[3];
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)(currentAlpha * this.alphaFactor));
            this.ml.m_6276_(g, tx, ty);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)currentAlpha);
        } else {
            this.ml.m_6276_(g, tx, ty);
        }
    }

    private void drawVertexMarkers(GuiGraphics g) {
        float[] xs = new float[]{(float)this.cx + this.innerR * Mth.m_14089_((float)this.a0), (float)this.cx + this.outerR * Mth.m_14089_((float)this.a0), (float)this.cx + this.outerR * Mth.m_14089_((float)this.a1), (float)this.cx + this.innerR * Mth.m_14089_((float)this.a1)};
        float[] ys = new float[]{(float)this.cy + this.innerR * Mth.m_14031_((float)this.a0), (float)this.cy + this.outerR * Mth.m_14031_((float)this.a0), (float)this.cy + this.outerR * Mth.m_14031_((float)this.a1), (float)this.cy + this.innerR * Mth.m_14031_((float)this.a1)};
        int markerSize = 4;
        int[] colors = new int[]{-65536, -16711936, -16776961, -256};
        for (int i = 0; i < 4; ++i) {
            int x = (int)xs[i] - markerSize / 2;
            int y = (int)ys[i] - markerSize / 2;
            g.m_280509_(x, y, x + markerSize, y + markerSize, colors[i]);
        }
    }

    public boolean m_5953_(double mouseX, double mouseY) {
        if (this.alphaFactor < 0.1f) {
            return false;
        }
        double dx = mouseX - (double)this.cx;
        double dy = mouseY - (double)this.cy;
        double r = Math.hypot(dx, dy);
        if (r < (double)this.innerR || r > (double)this.outerR) {
            return false;
        }
        double ang = Math.atan2(dy, dx);
        if (ang < 0.0) {
            ang += Math.PI * 2;
        }
        if (this.a0 < this.a1) {
            return ang >= (double)this.a0 && ang <= (double)this.a1;
        }
        return ang >= (double)this.a0 || ang <= (double)this.a1;
    }

    protected void m_168797_(NarrationElementOutput output) {
        this.m_168802_(output);
    }

    public void m_5716_(double mouseX, double mouseY) {
        this.m_7435_(Minecraft.m_91087_().m_91106_());
        if (this.onPress != null) {
            this.onPress.run();
        }
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (this.f_93623_ && this.f_93624_ && this.m_5953_(mouseX, mouseY)) {
            this.m_7435_(Minecraft.m_91087_().m_91106_());
            if (this.onPress != null) {
                this.onPress.run();
            }
            return true;
        }
        return false;
    }
}

