/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.client.gui;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.CycleButton;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratedElementType;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ydmsama.hundred_years_war.client.gui.BuildingMoreOptionsScreen;
import ydmsama.hundred_years_war.client.gui.TemplatePropertiesScreen;
import ydmsama.hundred_years_war.client.network.ClientPacketHandler;
import ydmsama.hundred_years_war.main.item.BuildingToolItem;
import ydmsama.hundred_years_war.main.template.TemplateManager;
import ydmsama.hundred_years_war.main.template.TemplateMetadata;

public class BuildingPlaceScreen
extends Screen {
    private static final Logger LOGGER = LoggerFactory.getLogger(BuildingPlaceScreen.class);
    private final ItemStack toolStack;
    private EditBox searchBox;
    private Button confirmButton;
    private Button cancelButton;
    private Button refreshButton;
    private Button backButton;
    private TemplateListWidget templateList;
    private List<FileSystemEntry> currentEntries = new ArrayList<FileSystemEntry>();
    private TemplateMetadata selectedTemplate = null;
    private boolean templatesLoading = false;
    private String currentPath = "";
    private Stack<String> pathStack = new Stack();
    private CycleButton<Integer> rotationButton;
    private Button moreOptionsButton;
    private static String cachedTemplateId = null;
    private static int cachedRotation = 0;
    private static long cachedBuildTime = 0L;
    private static boolean cachedGenerateConnectionLayer = false;
    private static boolean cachedTerrainCheck = false;
    private static final int WINDOW_WIDTH = 320;
    private static final int WINDOW_HEIGHT = 240;

    public BuildingPlaceScreen(ItemStack toolStack) {
        super((Component)Component.m_237115_((String)"gui.hundred_years_war.building_place_title"));
        this.toolStack = toolStack;
        String existingTemplate = BuildingToolItem.getSelectedTemplate(toolStack);
        if (existingTemplate != null && !existingTemplate.isEmpty()) {
            String[] parts = existingTemplate.split("\\|");
            cachedTemplateId = parts[0];
            try {
                cachedRotation = parts.length > 1 ? Integer.parseInt(parts[1]) : 0;
                cachedBuildTime = parts.length > 2 ? Long.parseLong(parts[2]) : 0L;
                cachedGenerateConnectionLayer = parts.length > 3 && Boolean.parseBoolean(parts[3]);
                cachedTerrainCheck = parts.length > 4 && Boolean.parseBoolean(parts[4]);
            }
            catch (NumberFormatException e) {
                cachedRotation = 0;
                cachedBuildTime = 0L;
                cachedGenerateConnectionLayer = false;
                cachedTerrainCheck = false;
            }
        }
    }

    protected void m_7856_() {
        super.m_7856_();
        int startX = (this.f_96543_ - 320) / 2;
        int startY = (this.f_96544_ - 240) / 2;
        this.searchBox = new EditBox(this.f_96547_, startX + 10, startY + 25, 150, 20, (Component)Component.m_237115_((String)"gui.hundred_years_war.common.search"));
        this.searchBox.m_94199_(50);
        this.searchBox.m_257771_((Component)Component.m_237115_((String)"gui.hundred_years_war.building_place.search_hint"));
        this.searchBox.m_94151_(this::onSearchChanged);
        this.m_142416_((GuiEventListener)this.searchBox);
        this.backButton = Button.m_253074_((Component)Component.m_237115_((String)"gui.hundred_years_war.common.back"), button -> this.navigateBack()).m_252794_(startX + 165, startY + 25).m_253046_(60, 20).m_253136_();
        this.backButton.f_93623_ = !this.pathStack.isEmpty();
        this.m_142416_((GuiEventListener)this.backButton);
        this.refreshButton = Button.m_253074_((Component)Component.m_237115_((String)"gui.hundred_years_war.common.refresh"), button -> this.requestTemplateMetadata()).m_252794_(startX + 230, startY + 25).m_253046_(60, 20).m_253136_();
        this.m_142416_((GuiEventListener)this.refreshButton);
        this.templateList = new TemplateListWidget(this.f_96541_, 300, 115, startX + 10, startY + 55);
        this.m_7787_((GuiEventListener)this.templateList);
        this.rotationButton = CycleButton.m_168894_(i -> Component.m_237110_((String)"gui.hundred_years_war.building_place.rotation", (Object[])new Object[]{i})).m_168961_((Object[])new Integer[]{0, 90, 180, 270}).m_168948_((Object)cachedRotation).m_168930_(startX + 10, startY + 175, 100, 20, (Component)Component.m_237115_((String)"gui.hundred_years_war.building_place.rotation_button"));
        this.m_142416_((GuiEventListener)this.rotationButton);
        this.moreOptionsButton = Button.m_253074_((Component)Component.m_237115_((String)"gui.hundred_years_war.building_place.more_options"), button -> this.openMoreOptions()).m_252794_(startX + 250, startY + 175).m_253046_(60, 20).m_253136_();
        this.m_142416_((GuiEventListener)this.moreOptionsButton);
        this.confirmButton = Button.m_253074_((Component)Component.m_237115_((String)"gui.hundred_years_war.common.confirm"), button -> this.confirmSelection()).m_252794_(startX + 320 - 115, startY + 240 - 30).m_253046_(50, 20).m_253136_();
        this.confirmButton.f_93623_ = false;
        this.m_142416_((GuiEventListener)this.confirmButton);
        this.cancelButton = Button.m_253074_((Component)Component.m_237115_((String)"gui.hundred_years_war.common.cancel"), button -> this.m_7379_()).m_252794_(startX + 320 - 60, startY + 240 - 30).m_253046_(50, 20).m_253136_();
        this.m_142416_((GuiEventListener)this.cancelButton);
        this.requestTemplateMetadata();
        this.restoreCachedSelection();
    }

    private void onSearchChanged(String search) {
        this.filterTemplates();
        this.backButton.f_93623_ = !search.isEmpty() ? false : !this.pathStack.isEmpty();
    }

    private void navigateBack() {
        if (!this.pathStack.isEmpty()) {
            this.currentPath = this.pathStack.pop();
            this.refreshTemplates();
        }
        this.backButton.f_93623_ = !this.pathStack.isEmpty();
    }

    private void openMoreOptions() {
        if (this.f_96541_ != null) {
            this.f_96541_.m_91152_((Screen)new BuildingMoreOptionsScreen(this));
        }
    }

    public static void updateConnectionLayer(boolean generateConnectionLayer) {
        cachedGenerateConnectionLayer = generateConnectionLayer;
    }

    public static boolean getCachedConnectionLayer() {
        return cachedGenerateConnectionLayer;
    }

    public static void updateBuildTime(long buildTime) {
        cachedBuildTime = buildTime;
    }

    public static long getCachedBuildTime() {
        return cachedBuildTime;
    }

    public static void updateTerrainCheck(boolean terrainCheck) {
        cachedTerrainCheck = terrainCheck;
    }

    public static boolean getCachedTerrainCheck() {
        return cachedTerrainCheck;
    }

    private void navigateToFolder(String folder) {
        this.pathStack.push(this.currentPath);
        this.currentPath = this.currentPath.isEmpty() ? folder : this.currentPath + "/" + folder;
        this.refreshTemplates();
        this.backButton.f_93623_ = true;
    }

    private void filterTemplates() {
        String search = this.searchBox.m_94155_().toLowerCase();
        if (this.templatesLoading) {
            this.templateList.updateEntries(Collections.emptyList());
            return;
        }
        if (search.isEmpty()) {
            this.templateList.updateEntries(this.currentEntries);
        } else {
            ArrayList<FileSystemEntry> filtered = new ArrayList<FileSystemEntry>();
            if (TemplateManager.getInstance() != null) {
                for (TemplateMetadata template : TemplateManager.getInstance().getAllMetadata()) {
                    if (!template.getName().toLowerCase().contains(search) && !template.getDescription().toLowerCase().contains(search) && !template.getCategory().toLowerCase().contains(search)) continue;
                    filtered.add(new TemplateEntry(template));
                }
            }
            this.templateList.updateEntries(filtered);
        }
    }

    private void refreshTemplates() {
        this.currentEntries.clear();
        if (this.templatesLoading) {
            this.templateList.updateEntries(Collections.emptyList());
            this.confirmButton.f_93623_ = false;
            return;
        }
        if (TemplateManager.getInstance() != null) {
            HashMap<String, Set> folderStructure = new HashMap<String, Set>();
            ArrayList<TemplateMetadata> templatesInCurrentPath = new ArrayList<TemplateMetadata>();
            for (TemplateMetadata template : TemplateManager.getInstance().getAllMetadata()) {
                String templateId = template.getTemplateId();
                if (templateId != null && templateId.contains("/")) {
                    String[] parts = templateId.split("/");
                    String currentFolderPath = "";
                    for (int i = 0; i < parts.length - 1; ++i) {
                        String parentPath = currentFolderPath;
                        String folderName = parts[i];
                        if (folderName.equals("resource")) continue;
                        currentFolderPath = parentPath.isEmpty() ? folderName : parentPath + "/" + folderName;
                        folderStructure.computeIfAbsent(parentPath, k -> new HashSet()).add(folderName);
                    }
                    String templateDir = "";
                    if (parts.length > 1) {
                        int startIdx;
                        int n = startIdx = parts[0].equals("resource") ? 1 : 0;
                        if (parts.length - startIdx > 1) {
                            StringBuilder sb = new StringBuilder();
                            for (int i = startIdx; i < parts.length - 1; ++i) {
                                if (sb.length() > 0) {
                                    sb.append("/");
                                }
                                sb.append(parts[i]);
                            }
                            templateDir = sb.toString();
                        }
                    }
                    if (!templateDir.equals(this.currentPath)) continue;
                    templatesInCurrentPath.add(template);
                    continue;
                }
                if (!this.currentPath.isEmpty()) continue;
                templatesInCurrentPath.add(template);
            }
            Set foldersHere = (Set)folderStructure.get(this.currentPath);
            if (foldersHere != null) {
                for (String folder : foldersHere) {
                    this.currentEntries.add(new FolderEntry(folder));
                }
            }
            for (TemplateMetadata template : templatesInCurrentPath) {
                this.currentEntries.add(new TemplateEntry(template));
            }
            this.currentEntries.sort((a, b) -> {
                if (a.isFolder() != b.isFolder()) {
                    return a.isFolder() ? -1 : 1;
                }
                return a.getName().compareTo(b.getName());
            });
            LOGGER.debug("Current path: '{}', Found {} folders and {} templates", new Object[]{this.currentPath, foldersHere != null ? foldersHere.size() : 0, templatesInCurrentPath.size()});
        }
        this.filterTemplates();
    }

    private void confirmSelection() {
        if (this.selectedTemplate != null) {
            String templateData = this.selectedTemplate.getTemplateId() + "|" + this.rotationButton.m_168883_() + "|" + cachedBuildTime + "|" + cachedGenerateConnectionLayer + "|" + cachedTerrainCheck;
            BuildingToolItem.setSelectedTemplate(this.toolStack, templateData);
            cachedTemplateId = this.selectedTemplate.getTemplateId();
            cachedRotation = (Integer)this.rotationButton.m_168883_();
            if (this.f_96541_ != null && this.f_96541_.f_91074_ != null) {
                this.f_96541_.f_91074_.m_5661_((Component)Component.m_237115_((String)"gui.hundred_years_war.building_place.template_selected").m_130940_(ChatFormatting.GREEN).m_7220_((Component)Component.m_237113_((String)this.selectedTemplate.getName()).m_130940_(ChatFormatting.GOLD)), true);
            }
            this.m_7379_();
        }
    }

    public void m_88315_(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        this.m_280273_(graphics);
        int startX = (this.f_96543_ - 320) / 2;
        int startY = (this.f_96544_ - 240) / 2;
        graphics.m_280509_(startX - 2, startY - 2, startX + 320 + 2, startY + 240 + 2, -16777216);
        graphics.m_280509_(startX, startY, startX + 320, startY + 240, -3750202);
        graphics.m_280509_(startX + 2, startY + 2, startX + 320 - 2, startY + 20, -11908534);
        graphics.m_280653_(this.f_96547_, (Component)Component.m_237115_((String)"gui.hundred_years_war.building_place.select_template"), this.f_96543_ / 2, startY + 7, 0xFFFFFF);
        if (!this.searchBox.m_94155_().isEmpty()) {
            graphics.m_280430_(this.f_96547_, (Component)Component.m_237110_((String)"gui.hundred_years_war.building_place.global_search", (Object[])new Object[]{this.searchBox.m_94155_()}), startX + 10, startY + 50, 0x60A060);
        }
        graphics.m_280509_(startX + 8, startY + 53, startX + 320 - 8, startY + 172, -1);
        graphics.m_280509_(startX + 9, startY + 54, startX + 320 - 9, startY + 171, -16777216);
        graphics.m_280509_(startX + 10, startY + 55, startX + 320 - 10, startY + 170, -2039584);
        if (this.templateList != null) {
            graphics.m_280588_(startX + 10, startY + 55, startX + 320 - 10, startY + 170);
            this.templateList.m_88315_(graphics, mouseX, mouseY, partialTick);
            graphics.m_280618_();
            if (this.templatesLoading) {
                graphics.m_280653_(this.f_96547_, (Component)Component.m_237113_((String)"Loading templates..."), startX + 160, startY + 115, 0x606060);
            } else if (this.templateList.isEmpty()) {
                graphics.m_280653_(this.f_96547_, (Component)Component.m_237113_((String)"No templates available"), startX + 160, startY + 115, 0x606060);
            }
        }
        if (this.selectedTemplate != null) {
            int infoY = startY + 200;
            graphics.m_280430_(this.f_96547_, (Component)Component.m_237110_((String)"gui.hundred_years_war.building_place.selected", (Object[])new Object[]{this.selectedTemplate.getName()}), startX + 10, infoY, 0xFFFFFF);
            graphics.m_280430_(this.f_96547_, (Component)Component.m_237110_((String)"gui.hundred_years_war.building_place.size", (Object[])new Object[]{this.selectedTemplate.getSize().m_123344_()}), startX + 10, infoY + 10, 0xFFFFFF);
            graphics.m_280430_(this.f_96547_, (Component)Component.m_237110_((String)"gui.hundred_years_war.building_place.block_count", (Object[])new Object[]{this.selectedTemplate.getTotalBlocks()}), startX + 100, infoY + 10, 0xFFFFFF);
        }
        super.m_88315_(graphics, mouseX, mouseY, partialTick);
    }

    public boolean m_7043_() {
        return false;
    }

    private void requestTemplateMetadata() {
        TemplateManager manager;
        this.templatesLoading = true;
        this.confirmButton.f_93623_ = false;
        if (this.refreshButton != null) {
            this.refreshButton.f_93623_ = false;
        }
        if (this.searchBox != null) {
            this.searchBox.m_94186_(false);
        }
        if (this.backButton != null) {
            this.backButton.f_93623_ = false;
        }
        if ((manager = TemplateManager.getInstance()) != null) {
            manager.clearClientMetadata();
        }
        if (this.templateList != null) {
            this.templateList.setSelected(null);
        }
        this.refreshTemplates();
        ClientPacketHandler.sendTemplateListRequest();
    }

    private void restoreCachedSelection() {
        TemplateMetadata cached;
        if (cachedTemplateId != null && TemplateManager.getInstance() != null && this.templateList != null && (cached = TemplateManager.getInstance().getMetadata(cachedTemplateId)) != null) {
            this.selectedTemplate = cached;
            this.confirmButton.f_93623_ = true;
            this.templateList.selectTemplateById(cachedTemplateId);
        }
    }

    public void onTemplateListUpdated() {
        this.templatesLoading = false;
        if (this.refreshButton != null) {
            this.refreshButton.f_93623_ = true;
        }
        if (this.searchBox != null) {
            this.searchBox.m_94186_(true);
        }
        TemplateManager manager = TemplateManager.getInstance();
        TemplateMetadata toSelect = null;
        if (manager != null) {
            if (this.selectedTemplate != null) {
                toSelect = manager.getMetadata(this.selectedTemplate.getTemplateId());
            }
            if (toSelect == null && cachedTemplateId != null) {
                toSelect = manager.getMetadata(cachedTemplateId);
            }
        }
        this.selectedTemplate = toSelect;
        this.confirmButton.f_93623_ = this.selectedTemplate != null;
        this.refreshTemplates();
        if (this.selectedTemplate != null && this.templateList != null) {
            this.templateList.selectTemplateById(this.selectedTemplate.getTemplateId());
        }
        if (this.backButton != null) {
            this.backButton.f_93623_ = !this.pathStack.isEmpty();
        }
    }

    private class TemplateListWidget
    extends AbstractSelectionList<EntryWidget> {
        public TemplateListWidget(Minecraft minecraft, int width, int height, int x, int y) {
            super(minecraft, width, height, y, y + height, 20);
            this.m_93507_(x);
        }

        protected int m_5756_() {
            return this.f_93393_ + this.f_93388_ - 6;
        }

        public int m_5759_() {
            return this.f_93388_ - 15;
        }

        public void m_142291_(NarrationElementOutput narrationElementOutput) {
            if (this.m_93511_() != null) {
                narrationElementOutput.m_169146_(NarratedElementType.TITLE, (Component)Component.m_237113_((String)("Selected: " + ((EntryWidget)this.m_93511_()).entry.getName())));
            }
        }

        public void updateEntries(List<FileSystemEntry> entries) {
            this.m_93516_();
            for (FileSystemEntry entry : entries) {
                this.m_7085_(new EntryWidget(entry));
            }
        }

        public int getEntryCount() {
            return this.m_6702_().size();
        }

        public boolean isEmpty() {
            return this.m_6702_().isEmpty();
        }

        public void selectTemplateById(String templateId) {
            if (templateId == null) {
                this.setSelected(null);
                return;
            }
            for (EntryWidget widget : this.m_6702_()) {
                TemplateEntry templateEntry;
                if (widget.entry.isFolder() || !templateId.equals((templateEntry = (TemplateEntry)widget.entry).getTemplate().getTemplateId())) continue;
                this.setSelected(widget);
                this.m_93498_(widget);
                return;
            }
            this.setSelected(null);
        }

        public void setSelected(EntryWidget entry) {
            super.m_6987_((AbstractSelectionList.Entry)entry);
            if (entry != null && !entry.entry.isFolder()) {
                BuildingPlaceScreen.this.selectedTemplate = ((TemplateEntry)entry.entry).getTemplate();
                BuildingPlaceScreen.this.confirmButton.f_93623_ = true;
            } else {
                BuildingPlaceScreen.this.selectedTemplate = null;
                BuildingPlaceScreen.this.confirmButton.f_93623_ = cachedTemplateId != null;
            }
        }

        public class EntryWidget
        extends AbstractSelectionList.Entry<EntryWidget> {
            private final FileSystemEntry entry;
            private int cachedButtonX = -1;
            private int cachedButtonY = -1;
            private int cachedButtonWidth = 20;
            private int cachedButtonHeight = 12;

            public EntryWidget(FileSystemEntry entry) {
                this.entry = entry;
            }

            public void m_6311_(@NotNull GuiGraphics graphics, int index, int y, int x, int width, int height, int mouseX, int mouseY, boolean hovering, float partialTick) {
                int top = y;
                int left = x;
                boolean onButton = false;
                if (!this.entry.isFolder()) {
                    this.cachedButtonX = left + width - this.cachedButtonWidth - 15;
                    this.cachedButtonY = top + 2;
                    boolean bl = onButton = mouseX >= this.cachedButtonX && mouseX <= this.cachedButtonX + this.cachedButtonWidth && mouseY >= this.cachedButtonY && mouseY <= this.cachedButtonY + this.cachedButtonHeight;
                }
                if (hovering && !onButton) {
                    graphics.m_280509_(left, top, left + width - 10, top + height, 0x40FFFFFF);
                }
                if (this.entry.isFolder()) {
                    graphics.m_280430_(BuildingPlaceScreen.this.f_96547_, (Component)Component.m_237110_((String)"gui.hundred_years_war.building_place.folder_prefix", (Object[])new Object[]{this.entry.getName()}), left + 5, top + 5, 26316);
                } else {
                    TemplateEntry templateEntry = (TemplateEntry)this.entry;
                    TemplateMetadata template = templateEntry.getTemplate();
                    graphics.m_280488_(BuildingPlaceScreen.this.f_96547_, template.getName(), left + 5, top + 2, 0xFFFFFF);
                    String info = Component.m_237110_((String)"gui.hundred_years_war.building_place.template_info", (Object[])new Object[]{template.getSize().m_123344_(), template.getTotalBlocks()}).getString();
                    graphics.m_280488_(BuildingPlaceScreen.this.f_96547_, info, left + 5, top + 11, 0xA0A0A0);
                    boolean buttonHover = mouseX >= this.cachedButtonX && mouseX <= this.cachedButtonX + this.cachedButtonWidth && mouseY >= this.cachedButtonY && mouseY <= this.cachedButtonY + this.cachedButtonHeight;
                    graphics.m_280509_(this.cachedButtonX, this.cachedButtonY, this.cachedButtonX + this.cachedButtonWidth, this.cachedButtonY + this.cachedButtonHeight, buttonHover ? -10461088 : -12566464);
                    graphics.m_280509_(this.cachedButtonX + 1, this.cachedButtonY + 1, this.cachedButtonX + this.cachedButtonWidth - 1, this.cachedButtonY + this.cachedButtonHeight - 1, buttonHover ? -8355712 : -10461088);
                    graphics.m_280137_(BuildingPlaceScreen.this.f_96547_, "...", this.cachedButtonX + this.cachedButtonWidth / 2, this.cachedButtonY + 2, 0xFFFFFF);
                }
                if (TemplateListWidget.this.m_93511_() == this) {
                    graphics.m_280509_(left, top, left + 2, top + height, -16744193);
                }
            }

            public boolean m_6375_(double mouseX, double mouseY, int button) {
                if (button == 0) {
                    if (!this.entry.isFolder()) {
                        TemplateEntry templateEntry = (TemplateEntry)this.entry;
                        TemplateMetadata template = templateEntry.getTemplate();
                        if (this.cachedButtonX < 0 || this.cachedButtonY < 0) {
                            int entryIndex = BuildingPlaceScreen.this.templateList.m_6702_().indexOf((Object)this);
                            int entryY = BuildingPlaceScreen.this.templateList.m_7610_(entryIndex);
                            int entryX = BuildingPlaceScreen.this.templateList.f_93393_;
                            int entryWidth = BuildingPlaceScreen.this.templateList.m_5759_();
                            this.cachedButtonX = entryX + entryWidth - this.cachedButtonWidth - 15;
                            this.cachedButtonY = entryY + 2;
                        }
                        if (mouseX >= (double)(this.cachedButtonX - 2) && mouseX <= (double)(this.cachedButtonX + this.cachedButtonWidth + 2) && mouseY >= (double)(this.cachedButtonY - 2) && mouseY <= (double)(this.cachedButtonY + this.cachedButtonHeight + 2)) {
                            if (TemplateListWidget.this.f_93386_ != null) {
                                TemplateListWidget.this.f_93386_.m_91152_((Screen)new TemplatePropertiesScreen(BuildingPlaceScreen.this, template.getTemplateId()));
                            }
                            return true;
                        }
                        TemplateListWidget.this.setSelected(this);
                        return true;
                    }
                    if (this.entry.isFolder()) {
                        if (BuildingPlaceScreen.this.searchBox.m_94155_().isEmpty()) {
                            BuildingPlaceScreen.this.navigateToFolder(this.entry.getName());
                        }
                        return true;
                    }
                }
                return false;
            }

            private int getX() {
                return BuildingPlaceScreen.this.templateList.f_93393_;
            }

            private int getY() {
                return BuildingPlaceScreen.this.templateList.m_7610_(BuildingPlaceScreen.this.templateList.m_6702_().indexOf((Object)this));
            }

            @NotNull
            public Component getNarration() {
                return Component.m_237113_((String)this.entry.getName());
            }
        }
    }

    private static class TemplateEntry
    extends FileSystemEntry {
        private final TemplateMetadata template;

        TemplateEntry(TemplateMetadata template) {
            this.template = template;
        }

        @Override
        String getName() {
            return this.template.getName();
        }

        @Override
        boolean isFolder() {
            return false;
        }

        @Override
        boolean matchesSearch(String search) {
            return search.isEmpty() || this.template.getName().toLowerCase().contains(search) || this.template.getDescription().toLowerCase().contains(search) || this.template.getCategory().toLowerCase().contains(search);
        }

        TemplateMetadata getTemplate() {
            return this.template;
        }
    }

    private static class FolderEntry
    extends FileSystemEntry {
        private final String name;

        FolderEntry(String name) {
            this.name = name;
        }

        @Override
        String getName() {
            return this.name;
        }

        @Override
        boolean isFolder() {
            return true;
        }

        @Override
        boolean matchesSearch(String search) {
            return search.isEmpty() || this.name.toLowerCase().contains(search);
        }
    }

    private static abstract class FileSystemEntry {
        private FileSystemEntry() {
        }

        abstract String getName();

        abstract boolean isFolder();

        abstract boolean matchesSearch(String var1);
    }
}

