/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.client.gui;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.world.item.ItemStack;
import ydmsama.hundred_years_war.client.gui.TemplatePropertiesScreen;
import ydmsama.hundred_years_war.client.network.ClientPacketHandler;
import ydmsama.hundred_years_war.main.item.BuildingToolItem;
import ydmsama.hundred_years_war.main.template.TemplateMetadata;

public class BuildingSaveScreen
extends Screen {
    private static final Gson GSON = new GsonBuilder().disableHtmlEscaping().create();
    private final ItemStack toolStack;
    private EditBox nameBox;
    private EditBox categoryBox;
    private EditBox descriptionBox;
    private Button saveButton;
    private Button cancelButton;
    private Button moreOptionsButton;
    private boolean isSaving = false;
    private CheckBox includeEntitiesBox;
    private CheckBox includeBlockDataBox;
    private CheckBox generateMirrorBox;
    private boolean cachedEnableGeneration = false;
    private int cachedGenerationWeight = 1;
    private int cachedConnectionLayerDepth = 10;
    private int cachedMinGenerationHeight = -64;
    private int cachedMaxGenerationHeight = 320;
    private boolean cachedGenerateOnSurface = true;
    private Map<String, JsonElement> cachedCustomAttributes = new LinkedHashMap<String, JsonElement>(TemplateMetadata.createDefaultAttributes());
    private String cachedName = "";
    private String cachedCategory = "";
    private String cachedDescription = "";
    private static final int WINDOW_WIDTH = 280;
    private static final int WINDOW_HEIGHT = 220;
    private static final int LABEL_MAX_WIDTH = 35;
    private int scrollOffset = 0;
    private int scrollDirection = 1;
    private int scrollDelay = 0;

    public BuildingSaveScreen(ItemStack toolStack) {
        super((Component)Component.m_237115_((String)"gui.hundred_years_war.building_save.title"));
        this.toolStack = toolStack;
    }

    protected void m_7856_() {
        super.m_7856_();
        int centerX = this.f_96543_ / 2;
        int centerY = this.f_96544_ / 2;
        int startX = centerX - 140;
        int startY = centerY - 110;
        this.nameBox = new EditBox(this.f_96547_, startX + 70, startY + 30, 180, 16, (Component)Component.m_237115_((String)"gui.hundred_years_war.building_save.name"));
        this.nameBox.m_94199_(50);
        this.nameBox.m_257771_((Component)Component.m_237115_((String)"gui.hundred_years_war.building_save.name_hint"));
        this.nameBox.m_94144_(this.cachedName);
        this.m_142416_((GuiEventListener)this.nameBox);
        this.categoryBox = new EditBox(this.f_96547_, startX + 70, startY + 55, 180, 16, (Component)Component.m_237115_((String)"gui.hundred_years_war.building_save.category"));
        this.categoryBox.m_94199_(30);
        this.categoryBox.m_257771_((Component)Component.m_237115_((String)"gui.hundred_years_war.building_save.category_hint"));
        this.categoryBox.m_94144_(this.cachedCategory);
        this.m_142416_((GuiEventListener)this.categoryBox);
        this.descriptionBox = new EditBox(this.f_96547_, startX + 70, startY + 80, 180, 30, (Component)Component.m_237115_((String)"gui.hundred_years_war.building_save.description"));
        this.descriptionBox.m_94199_(200);
        this.descriptionBox.m_257771_((Component)Component.m_237115_((String)"gui.hundred_years_war.building_save.description_hint"));
        this.descriptionBox.m_94144_(this.cachedDescription);
        this.m_142416_((GuiEventListener)this.descriptionBox);
        this.includeEntitiesBox = new CheckBox(startX + 30, startY + 130, 200, 12, (Component)Component.m_237115_((String)"gui.hundred_years_war.building_save.include_entities"), true, null, this.f_96547_);
        this.m_142416_((GuiEventListener)this.includeEntitiesBox);
        this.includeBlockDataBox = new CheckBox(startX + 30, startY + 145, 200, 12, (Component)Component.m_237115_((String)"gui.hundred_years_war.building_save.include_block_data"), true, null, this.f_96547_);
        this.m_142416_((GuiEventListener)this.includeBlockDataBox);
        this.generateMirrorBox = new CheckBox(startX + 30, startY + 160, 200, 12, (Component)Component.m_237115_((String)"gui.hundred_years_war.building_save.generate_mirror"), false, null, this.f_96547_);
        this.m_142416_((GuiEventListener)this.generateMirrorBox);
        this.moreOptionsButton = Button.m_253074_((Component)Component.m_237115_((String)"gui.hundred_years_war.building_save.more_options"), button -> this.openMoreOptions()).m_252794_(startX + 10, startY + 220 - 30).m_253046_(80, 20).m_253136_();
        this.m_142416_((GuiEventListener)this.moreOptionsButton);
        this.saveButton = Button.m_253074_((Component)Component.m_237115_((String)"gui.hundred_years_war.common.save"), button -> this.saveBuilding()).m_252794_(startX + 280 - 110, startY + 220 - 30).m_253046_(50, 20).m_253136_();
        this.m_142416_((GuiEventListener)this.saveButton);
        this.cancelButton = Button.m_253074_((Component)Component.m_237115_((String)"gui.hundred_years_war.common.cancel"), button -> this.m_7379_()).m_252794_(startX + 280 - 55, startY + 220 - 30).m_253046_(50, 20).m_253136_();
        this.m_142416_((GuiEventListener)this.cancelButton);
    }

    private void openMoreOptions() {
        if (this.f_96541_ != null) {
            this.cachedName = this.nameBox.m_94155_();
            this.cachedCategory = this.categoryBox.m_94155_();
            this.cachedDescription = this.descriptionBox.m_94155_();
            String templateName = this.cachedName.trim();
            if (templateName.isEmpty()) {
                templateName = Component.m_237115_((String)"gui.hundred_years_war.building_save.unnamed").getString();
            }
            this.f_96541_.m_91152_((Screen)new TemplatePropertiesScreen(this, templateName, this.cachedEnableGeneration, this.cachedGenerationWeight, this.cachedConnectionLayerDepth, this.cachedMinGenerationHeight, this.cachedMaxGenerationHeight, this.cachedGenerateOnSurface, new LinkedHashMap<String, JsonElement>(this.cachedCustomAttributes), data -> {
                this.cachedEnableGeneration = data.enableGeneration();
                this.cachedGenerationWeight = data.generationWeight();
                this.cachedConnectionLayerDepth = data.connectionLayerDepth();
                this.cachedMinGenerationHeight = data.minGenerationHeight();
                this.cachedMaxGenerationHeight = data.maxGenerationHeight();
                this.cachedGenerateOnSurface = data.generateOnSurface();
                this.cachedCustomAttributes = new LinkedHashMap<String, JsonElement>();
                data.customAttributes().forEach((key, value) -> this.cachedCustomAttributes.put((String)key, (JsonElement)(value == null ? JsonNull.INSTANCE : value.deepCopy())));
            }));
        }
    }

    public void m_86600_() {
        super.m_86600_();
        if (this.nameBox != null) {
            this.nameBox.m_94120_();
        }
        if (this.categoryBox != null) {
            this.categoryBox.m_94120_();
        }
        if (this.descriptionBox != null) {
            this.descriptionBox.m_94120_();
        }
        this.updateLabelScroll();
    }

    private void updateLabelScroll() {
        if (++this.scrollDelay >= 2) {
            this.scrollDelay = 0;
            this.scrollOffset += this.scrollDirection;
            if (Math.abs(this.scrollOffset) > 10) {
                this.scrollDirection = -this.scrollDirection;
            }
        }
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        this.m_280273_(graphics);
        int centerX = this.f_96543_ / 2;
        int centerY = this.f_96544_ / 2;
        int startX = centerX - 140;
        int startY = centerY - 110;
        graphics.m_280509_(startX, startY, startX + 280, startY + 220, -533712848);
        graphics.m_280509_(startX + 1, startY + 1, startX + 280 - 1, startY + 220 - 1, -535818224);
        graphics.m_280653_(this.f_96547_, (Component)Component.m_237115_((String)"gui.hundred_years_war.building_save.title"), centerX, startY + 8, 0xFFFFFF);
        this.drawScrollingLabel(graphics, (Component)Component.m_237115_((String)"gui.hundred_years_war.building_save.name_label"), startX + 30, startY + 33, 35);
        this.drawScrollingLabel(graphics, (Component)Component.m_237115_((String)"gui.hundred_years_war.building_save.category_label"), startX + 30, startY + 58, 35);
        this.drawScrollingLabel(graphics, (Component)Component.m_237115_((String)"gui.hundred_years_war.building_save.description_label"), startX + 30, startY + 83, 35);
        graphics.m_280430_(this.f_96547_, (Component)Component.m_237115_((String)"gui.hundred_years_war.building_save.save_options"), startX + 30, startY + 115, 0xFFFF00);
        super.m_88315_(graphics, mouseX, mouseY, partialTick);
        if (this.nameBox.m_94155_().isEmpty()) {
            graphics.m_280430_(this.f_96547_, (Component)Component.m_237115_((String)"gui.hundred_years_war.building_save.name_required"), startX + 30, startY + 220 - 45, 0xFF5555);
        }
    }

    private void drawScrollingLabel(GuiGraphics graphics, Component text, int x, int y, int maxWidth) {
        int textWidth = this.f_96547_.m_92852_((FormattedText)text);
        if (textWidth <= maxWidth) {
            graphics.m_280430_(this.f_96547_, text, x, y, 0xFFFFFF);
        } else {
            Objects.requireNonNull(this.f_96547_);
            graphics.m_280588_(x, y - 2, x + maxWidth, y + 9 + 2);
            int totalWidth = textWidth + 20;
            int scrollPos = this.scrollOffset % totalWidth;
            graphics.m_280430_(this.f_96547_, text, x - scrollPos, y, 0xFFFFFF);
            graphics.m_280430_(this.f_96547_, text, x - scrollPos + totalWidth, y, 0xFFFFFF);
            graphics.m_280618_();
        }
    }

    private void saveBuilding() {
        String name = this.nameBox.m_94155_().trim();
        if (name.isEmpty()) {
            if (this.f_96541_ != null && this.f_96541_.f_91074_ != null) {
                this.f_96541_.f_91074_.m_5661_((Component)Component.m_237115_((String)"gui.hundred_years_war.building_save.enter_name").m_6881_().m_130940_(ChatFormatting.RED), true);
            }
            return;
        }
        String category = this.categoryBox.m_94155_().trim();
        String description = this.descriptionBox.m_94155_().trim();
        JsonObject settings = new JsonObject();
        settings.addProperty("category", category);
        settings.addProperty("description", description);
        settings.addProperty("includeEntities", Boolean.valueOf(this.includeEntitiesBox.isChecked()));
        settings.addProperty("includeBlockData", Boolean.valueOf(this.includeBlockDataBox.isChecked()));
        settings.addProperty("generateMirror", Boolean.valueOf(this.generateMirrorBox.isChecked()));
        settings.addProperty("enableGeneration", Boolean.valueOf(this.cachedEnableGeneration));
        settings.addProperty("generationWeight", (Number)this.cachedGenerationWeight);
        settings.addProperty("connectionLayerDepth", (Number)this.cachedConnectionLayerDepth);
        settings.addProperty("minGenerationHeight", (Number)this.cachedMinGenerationHeight);
        settings.addProperty("maxGenerationHeight", (Number)this.cachedMaxGenerationHeight);
        settings.addProperty("generateOnSurface", Boolean.valueOf(this.cachedGenerateOnSurface));
        JsonObject attributes = new JsonObject();
        this.cachedCustomAttributes.forEach((key, value) -> attributes.add(key, (JsonElement)(value == null ? JsonNull.INSTANCE : value.deepCopy())));
        settings.add("customAttributes", (JsonElement)attributes);
        ClientPacketHandler.sendBuildingToolSaveBuilding(name, GSON.toJson((JsonElement)settings));
        BuildingToolItem.resetSaveState(this.toolStack);
        if (this.f_96541_ != null && this.f_96541_.f_91074_ != null) {
            this.f_96541_.f_91074_.m_5661_((Component)Component.m_237110_((String)"gui.hundred_years_war.building_save.saved", (Object[])new Object[]{name}).m_6881_().m_130940_(ChatFormatting.GREEN), true);
        }
        this.isSaving = true;
        this.m_7379_();
    }

    public void m_7379_() {
        ItemStack mainHand;
        super.m_7379_();
        if (!this.isSaving && this.f_96541_ != null && this.f_96541_.f_91074_ != null && (mainHand = this.f_96541_.f_91074_.m_21205_()).m_41720_() instanceof BuildingToolItem) {
            BuildingToolItem.setSaveState(mainHand, BuildingToolItem.SaveState.NONE);
            BuildingToolItem.setFirstPos(mainHand, null);
            BuildingToolItem.setSecondPos(mainHand, null);
            BuildingToolItem.setEntrancePos(mainHand, null);
        }
    }

    public boolean m_7043_() {
        return false;
    }

    private static class CheckBox
    extends AbstractWidget {
        private boolean checked;
        private final Runnable onChange;
        private final Font font;

        public CheckBox(int x, int y, int width, int height, Component message, boolean defaultValue, Runnable onChange, Font font) {
            super(x, y, width, height, message);
            this.checked = defaultValue;
            this.onChange = onChange;
            this.font = font;
        }

        protected void m_87963_(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
            int boxSize = 10;
            graphics.m_280509_(this.m_252754_(), this.m_252907_(), this.m_252754_() + boxSize, this.m_252907_() + boxSize, -1);
            graphics.m_280509_(this.m_252754_() + 1, this.m_252907_() + 1, this.m_252754_() + boxSize - 1, this.m_252907_() + boxSize - 1, -16777216);
            if (this.checked) {
                graphics.m_280488_(this.font, "\u2713", this.m_252754_() + 2, this.m_252907_() + 1, 65280);
            }
            graphics.m_280430_(this.font, this.m_6035_(), this.m_252754_() + boxSize + 5, this.m_252907_() + 1, 0xFFFFFF);
        }

        public void m_5716_(double mouseX, double mouseY) {
            boolean bl = this.checked = !this.checked;
            if (this.onChange != null) {
                this.onChange.run();
            }
        }

        protected void m_168797_(NarrationElementOutput output) {
        }

        public boolean isChecked() {
            return this.checked;
        }
    }
}

