/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.client.gui;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import ydmsama.hundred_years_war.main.item.BuildingToolItem;

public class BuildingSelectionScreen
extends Screen {
    private final ItemStack toolStack;
    private EditBox searchBox;
    private Button confirmButton;
    private Button cancelButton;
    private final List<TemplateCategory> categories = new ArrayList<TemplateCategory>();
    private final List<TemplateCategory> filteredCategories = new ArrayList<TemplateCategory>();
    private String selectedTemplate = null;
    private int scrollOffset = 0;
    private int maxScroll = 0;
    private boolean isScrolling = false;
    private static final int WINDOW_WIDTH = 300;
    private static final int WINDOW_HEIGHT = 200;
    private static final int LIST_WIDTH = 260;
    private static final int LIST_HEIGHT = 130;
    private static final int ENTRY_HEIGHT = 16;
    private static final int CATEGORY_HEIGHT = 18;
    private static final int SCROLL_BAR_WIDTH = 6;

    public BuildingSelectionScreen(ItemStack toolStack) {
        super((Component)Component.m_237115_((String)"gui.hundred_years_war.building_place_title"));
        this.toolStack = toolStack;
        this.loadTemplates();
    }

    private void loadTemplates() {
        TemplateCategory houses = new TemplateCategory("\u623f\u5c4b");
        houses.templates.add("\u5c0f\u6728\u5c4b");
        houses.templates.add("\u77f3\u5934\u623f\u5b50");
        houses.templates.add("\u519c\u820d");
        houses.templates.add("\u8c6a\u5b85");
        this.categories.add(houses);
        TemplateCategory military = new TemplateCategory("\u519b\u4e8b");
        military.templates.add("\u7bad\u5854");
        military.templates.add("\u57ce\u5899");
        military.templates.add("\u5175\u8425");
        military.templates.add("\u5821\u5792");
        this.categories.add(military);
        TemplateCategory production = new TemplateCategory("\u751f\u4ea7");
        production.templates.add("\u519c\u7530");
        production.templates.add("\u4f10\u6728\u573a");
        production.templates.add("\u77ff\u573a");
        production.templates.add("\u94c1\u5320\u94fa");
        this.categories.add(production);
        TemplateCategory decoration = new TemplateCategory("\u88c5\u9970");
        decoration.templates.add("\u55b7\u6cc9");
        decoration.templates.add("\u82b1\u56ed");
        decoration.templates.add("\u96d5\u50cf");
        decoration.templates.add("\u8def\u706f");
        this.categories.add(decoration);
        this.filteredCategories.addAll(this.categories);
        this.calculateMaxScroll();
    }

    protected void m_7856_() {
        super.m_7856_();
        int centerX = this.f_96543_ / 2;
        int centerY = this.f_96544_ / 2;
        int startX = centerX - 150;
        int startY = centerY - 100;
        this.searchBox = new EditBox(this.f_96547_, startX + 20, startY + 10, 240, 16, (Component)Component.m_237115_((String)"gui.hundred_years_war.common.search"));
        this.searchBox.m_257771_((Component)Component.m_237115_((String)"gui.hundred_years_war.building_selection.search_hint"));
        this.searchBox.m_94151_(this::onSearchChanged);
        this.m_142416_((GuiEventListener)this.searchBox);
        this.confirmButton = Button.m_253074_((Component)Component.m_237115_((String)"gui.hundred_years_war.common.confirm"), button -> this.confirmSelection()).m_252794_(startX + 300 - 110, startY + 200 - 25).m_253046_(50, 20).m_253136_();
        this.m_142416_((GuiEventListener)this.confirmButton);
        this.cancelButton = Button.m_253074_((Component)Component.m_237115_((String)"gui.hundred_years_war.common.cancel"), button -> this.m_7379_()).m_252794_(startX + 300 - 55, startY + 200 - 25).m_253046_(50, 20).m_253136_();
        this.m_142416_((GuiEventListener)this.cancelButton);
        this.updateConfirmButton();
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        this.m_280273_(graphics);
        int centerX = this.f_96543_ / 2;
        int centerY = this.f_96544_ / 2;
        int startX = centerX - 150;
        int startY = centerY - 100;
        graphics.m_280509_(startX, startY, startX + 300, startY + 200, -533712848);
        graphics.m_280509_(startX + 1, startY + 1, startX + 300 - 1, startY + 200 - 1, -535818224);
        graphics.m_280653_(this.f_96547_, (Component)Component.m_237115_((String)"gui.hundred_years_war.building_selection.title"), centerX, startY + 5, 0xFFFFFF);
        int listX = startX + 20;
        int listY = startY + 30;
        graphics.m_280509_(listX, listY, listX + 260, listY + 130, -14671840);
        graphics.m_280509_(listX + 1, listY + 1, listX + 260 - 1, listY + 130 - 1, -16777216);
        int scrollBarX = listX + 260 - 6 - 2;
        graphics.m_280509_(scrollBarX, listY + 2, scrollBarX + 6, listY + 130 - 2, -12566464);
        if (this.maxScroll > 0) {
            int scrollBarHeight = Math.max(10, (int)(130.0f / (float)this.getTotalHeight() * 130.0f));
            int scrollBarY = listY + 2 + (int)((float)this.scrollOffset / (float)this.maxScroll * (float)(126 - scrollBarHeight));
            graphics.m_280509_(scrollBarX, scrollBarY, scrollBarX + 6, scrollBarY + scrollBarHeight, -8355712);
        }
        graphics.m_280588_(listX + 2, listY + 2, listX + 260 - 6 - 4, listY + 130 - 2);
        int currentY = listY + 2 - this.scrollOffset;
        for (TemplateCategory category : this.filteredCategories) {
            if (currentY + 18 > listY && currentY < listY + 130) {
                boolean hover = mouseX >= listX + 2 && mouseX <= listX + 260 - 6 - 4 && mouseY >= currentY && mouseY <= currentY + 18;
                graphics.m_280509_(listX + 2, currentY, listX + 260 - 6 - 4, currentY + 18, hover ? -12566464 : -13619152);
                String categoryText = (category.isExpanded ? "\u25bc " : "\u25b6 ") + category.name;
                graphics.m_280488_(this.f_96547_, categoryText, listX + 5, currentY + 5, 0xFFFF00);
            }
            currentY += 18;
            if (!category.isExpanded) continue;
            for (String template : category.templates) {
                if (currentY + 16 > listY && currentY < listY + 130) {
                    boolean hover;
                    boolean isSelected = template.equals(this.selectedTemplate);
                    boolean bl = hover = mouseX >= listX + 2 && mouseX <= listX + 260 - 6 - 4 && mouseY >= currentY && mouseY <= currentY + 16;
                    int bgColor = isSelected ? -11513776 : (hover ? -13290187 : -14342875);
                    graphics.m_280509_(listX + 2, currentY, listX + 260 - 6 - 4, currentY + 16, bgColor);
                    int textColor = isSelected ? 65280 : 0xFFFFFF;
                    graphics.m_280488_(this.f_96547_, "  " + template, listX + 15, currentY + 4, textColor);
                }
                currentY += 16;
            }
        }
        graphics.m_280618_();
        super.m_88315_(graphics, mouseX, mouseY, partialTick);
        if (this.selectedTemplate != null) {
            graphics.m_280430_(this.f_96547_, (Component)Component.m_237110_((String)"gui.hundred_years_war.building_selection.selected", (Object[])new Object[]{this.selectedTemplate}), startX + 20, startY + 200 - 18, 65280);
        }
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        int scrollBarX;
        int centerX = this.f_96543_ / 2;
        int centerY = this.f_96544_ / 2;
        int startX = centerX - 150;
        int startY = centerY - 100;
        int listX = startX + 20;
        int listY = startY + 30;
        if (mouseX >= (double)(listX + 2) && mouseX <= (double)(listX + 260 - 6 - 4) && mouseY >= (double)(listY + 2) && mouseY <= (double)(listY + 130 - 2)) {
            int currentY = listY + 2 - this.scrollOffset;
            for (TemplateCategory category : this.filteredCategories) {
                if (mouseY >= (double)currentY && mouseY <= (double)(currentY + 18)) {
                    category.isExpanded = !category.isExpanded;
                    this.calculateMaxScroll();
                    return true;
                }
                currentY += 18;
                if (!category.isExpanded) continue;
                for (String template : category.templates) {
                    if (mouseY >= (double)currentY && mouseY <= (double)(currentY + 16)) {
                        this.selectedTemplate = template;
                        this.updateConfirmButton();
                        return true;
                    }
                    currentY += 16;
                }
            }
        }
        if (mouseX >= (double)(scrollBarX = listX + 260 - 6 - 2) && mouseX <= (double)(scrollBarX + 6) && mouseY >= (double)listY && mouseY <= (double)(listY + 130)) {
            this.isScrolling = true;
            return true;
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        this.isScrolling = false;
        return super.m_6348_(mouseX, mouseY, button);
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.isScrolling && this.maxScroll > 0) {
            this.scrollOffset = (int)Math.max(0.0, Math.min((double)this.maxScroll, (double)this.scrollOffset + dragY));
            return true;
        }
        return super.m_7979_(mouseX, mouseY, button, dragX, dragY);
    }

    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        int centerX = this.f_96543_ / 2;
        int centerY = this.f_96544_ / 2;
        int startX = centerX - 150;
        int startY = centerY - 100;
        int listX = startX + 20;
        int listY = startY + 30;
        if (mouseX >= (double)listX && mouseX <= (double)(listX + 260) && mouseY >= (double)listY && mouseY <= (double)(listY + 130)) {
            this.scrollOffset = (int)Math.max(0.0, Math.min((double)this.maxScroll, (double)this.scrollOffset - delta * 10.0));
            return true;
        }
        return super.m_6050_(mouseX, mouseY, delta);
    }

    private void onSearchChanged(String text) {
        this.filteredCategories.clear();
        if (text.isEmpty()) {
            this.filteredCategories.addAll(this.categories);
        } else {
            String searchLower = text.toLowerCase();
            for (TemplateCategory category : this.categories) {
                TemplateCategory filtered = new TemplateCategory(category.name);
                filtered.isExpanded = category.isExpanded;
                for (String template : category.templates) {
                    if (!template.toLowerCase().contains(searchLower)) continue;
                    filtered.templates.add(template);
                }
                if (filtered.templates.isEmpty()) continue;
                filtered.isExpanded = true;
                this.filteredCategories.add(filtered);
            }
        }
        this.calculateMaxScroll();
        this.scrollOffset = 0;
    }

    private void calculateMaxScroll() {
        int totalHeight = this.getTotalHeight();
        this.maxScroll = Math.max(0, totalHeight - 130);
    }

    private int getTotalHeight() {
        int height = 0;
        for (TemplateCategory category : this.filteredCategories) {
            height += 18;
            if (!category.isExpanded) continue;
            height += category.templates.size() * 16;
        }
        return height;
    }

    private void updateConfirmButton() {
        if (this.confirmButton != null) {
            this.confirmButton.f_93623_ = this.selectedTemplate != null;
        }
    }

    private void confirmSelection() {
        if (this.selectedTemplate != null) {
            BuildingToolItem.setSelectedTemplate(this.toolStack, this.selectedTemplate);
            if (this.f_96541_ != null && this.f_96541_.f_91074_ != null) {
                this.f_96541_.f_91074_.m_5661_((Component)Component.m_237115_((String)"gui.hundred_years_war.building_selection.template_selected").m_6881_().m_130940_(ChatFormatting.GREEN).m_7220_((Component)Component.m_237113_((String)this.selectedTemplate).m_130940_(ChatFormatting.GOLD)), true);
            }
            this.m_7379_();
        }
    }

    public boolean m_7043_() {
        return false;
    }

    private static class TemplateCategory {
        public final String name;
        public final List<String> templates = new ArrayList<String>();
        public boolean isExpanded = false;

        public TemplateCategory(String name) {
            this.name = name;
        }
    }
}

