/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.client.handler;

import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import ydmsama.hundred_years_war.client.freecam.Freecam;
import ydmsama.hundred_years_war.client.freecam.config.keys.HotKeyManager;
import ydmsama.hundred_years_war.client.freecam.ui.wheel.CommandWheelHandler;
import ydmsama.hundred_years_war.client.item.CommandStaffHandler;
import ydmsama.hundred_years_war.client.models.siege.BombardCartModel;
import ydmsama.hundred_years_war.client.models.siege.CannonModel;
import ydmsama.hundred_years_war.client.models.siege.CulverinModel;
import ydmsama.hundred_years_war.client.models.siege.GreatBombardCartModel;
import ydmsama.hundred_years_war.client.models.siege.MangonelsCartModel;
import ydmsama.hundred_years_war.client.models.siege.RibauldequinModel;
import ydmsama.hundred_years_war.client.models.siege.SpringaldModel;
import ydmsama.hundred_years_war.client.models.siege.TrebuchetsCartModel;
import ydmsama.hundred_years_war.client.network.ClientPacketHandler;
import ydmsama.hundred_years_war.client.renderer.blockentity.BreedingWorkstationRenderer;
import ydmsama.hundred_years_war.client.renderer.blockentity.FarmingWorkstationRenderer;
import ydmsama.hundred_years_war.client.renderer.blockentity.FishingWorkstationRenderer;
import ydmsama.hundred_years_war.client.renderer.blockentity.LumberWorkstationRenderer;
import ydmsama.hundred_years_war.client.renderer.blockentity.MiningWorkstationRenderer;
import ydmsama.hundred_years_war.client.utils.ClientCreativeModeSettings;
import ydmsama.hundred_years_war.main.item.TransportOrderItem;

@Mod.EventBusSubscriber(modid="hundred_years_war", value={Dist.CLIENT})
public final class ClientTickHandler {
    @SubscribeEvent
    public static void onClientTick(TickEvent.ClientTickEvent event) {
        Minecraft mc = Minecraft.m_91087_();
        if (event.phase == TickEvent.Phase.START) {
            Freecam.preTick(mc);
            return;
        }
        Freecam.postTick(mc);
        CommandStaffHandler.getInstance().clientTick();
        CommandWheelHandler.getInstance().tick();
        ClientTickHandler.handleTransportActionKey(mc);
        ClientTickHandler.handleSummonRelationToggleKey(mc);
        ClientTickHandler.clearWorkstationRenderers();
        if (mc.f_91074_ == null && mc.f_91073_ == null) {
            ClientTickHandler.clearSiegeModelsCache();
        }
    }

    private static void handleTransportActionKey(Minecraft mc) {
        if (mc.f_91074_ == null) {
            return;
        }
        while (HotKeyManager.getTransportActionKey().m_90859_()) {
            ItemStack mainHand = mc.f_91074_.m_21205_();
            ItemStack offHand = mc.f_91074_.m_21206_();
            if (mainHand.m_41720_() instanceof TransportOrderItem) {
                ClientPacketHandler.sendTransportActionPacket(true);
                continue;
            }
            if (!(offHand.m_41720_() instanceof TransportOrderItem)) continue;
            ClientPacketHandler.sendTransportActionPacket(false);
        }
    }

    private static void handleSummonRelationToggleKey(Minecraft mc) {
        if (mc.f_91074_ == null) {
            return;
        }
        while (HotKeyManager.getSummonRelationToggleKey().m_90859_()) {
            if (!mc.f_91074_.m_7500_() || !ClientCreativeModeSettings.shouldShowSummonIndicator()) continue;
            boolean newValue = !ClientCreativeModeSettings.isSummonFriendly();
            ClientCreativeModeSettings.setSummonFriendly(newValue);
            ClientPacketHandler.sendCreativeSettingsUpdate(newValue, ClientCreativeModeSettings.canControlAllUnits());
            MutableComponent feedback = Component.m_237115_((String)(newValue ? "message.hundred_years_war.creative_summon_relation.friendly" : "message.hundred_years_war.creative_summon_relation.hostile")).m_130940_(newValue ? ChatFormatting.GREEN : ChatFormatting.RED);
            mc.f_91074_.m_5661_((Component)feedback, true);
        }
    }

    private static void clearWorkstationRenderers() {
        LumberWorkstationRenderer.clearRenderedEntities();
        FarmingWorkstationRenderer.clearRenderedEntities();
        MiningWorkstationRenderer.clearRenderedEntities();
        BreedingWorkstationRenderer.clearRenderedEntities();
        FishingWorkstationRenderer.clearRenderedEntities();
    }

    private static void clearSiegeModelsCache() {
        RibauldequinModel.clearUnusedEntities();
        CulverinModel.clearUnusedEntities();
        CannonModel.clearUnusedEntities();
        MangonelsCartModel.clearUnusedEntities();
        TrebuchetsCartModel.clearUnusedEntities();
        BombardCartModel.clearUnusedEntities();
        GreatBombardCartModel.clearUnusedEntities();
        SpringaldModel.clearUnusedEntities();
    }

    private ClientTickHandler() {
    }
}

