/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.client.item;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import ydmsama.hundred_years_war.client.freecam.ui.wheel.CommandWheelHandler;
import ydmsama.hundred_years_war.main.entity.entities.BaseCombatEntity;
import ydmsama.hundred_years_war.main.item.CommandStaffItem;

public class CommandStaffHandler {
    private static CommandStaffHandler instance;
    private ItemStack currentCommandStaff;
    private BlockPos targetBlockPos;
    private Entity attackTargetEntity;
    private BlockPos attackMoveBlockPos;
    private final Set<BaseCombatEntity> teamEntities = new HashSet<BaseCombatEntity>();

    private CommandStaffHandler() {
    }

    public static CommandStaffHandler getInstance() {
        if (instance == null) {
            instance = new CommandStaffHandler();
        }
        return instance;
    }

    public void updateCurrentCommandStaff(Player player) {
        ItemStack mainHandItem = player.m_21205_();
        if (!mainHandItem.m_41619_() && mainHandItem.m_41720_() instanceof CommandStaffItem) {
            this.currentCommandStaff = mainHandItem;
            this.updateTeamEntities();
            this.updateRenderTargets();
        } else {
            this.currentCommandStaff = null;
            this.teamEntities.clear();
            this.clearRenderData();
        }
    }

    private void updateTeamEntities() {
        this.teamEntities.clear();
        Minecraft minecraft = Minecraft.m_91087_();
        if (this.currentCommandStaff != null && minecraft.f_91073_ != null && this.currentCommandStaff.m_41782_() && this.currentCommandStaff.m_41783_().m_128425_("TeamEntityUUIDs", 9)) {
            ArrayList<UUID> teamUUIDs = new ArrayList<UUID>();
            ListTag uuidList = this.currentCommandStaff.m_41783_().m_128437_("TeamEntityUUIDs", 8);
            for (int i = 0; i < uuidList.size(); ++i) {
                String uuidString = uuidList.m_128778_(i);
                teamUUIDs.add(UUID.fromString(uuidString));
            }
            for (Entity entity : minecraft.f_91073_.m_104735_()) {
                if (!(entity instanceof BaseCombatEntity) || !teamUUIDs.contains(entity.m_20148_())) continue;
                this.teamEntities.add((BaseCombatEntity)entity);
            }
        }
    }

    private void updateRenderTargets() {
        CompoundTag posTag;
        this.targetBlockPos = null;
        this.attackTargetEntity = null;
        this.attackMoveBlockPos = null;
        if (this.currentCommandStaff == null || !this.currentCommandStaff.m_41782_()) {
            return;
        }
        CompoundTag nbt = this.currentCommandStaff.m_41783_();
        Minecraft minecraft = Minecraft.m_91087_();
        if (nbt.m_128425_("TargetBlockPos", 10)) {
            posTag = nbt.m_128469_("TargetBlockPos");
            this.targetBlockPos = new BlockPos(posTag.m_128451_("X"), posTag.m_128451_("Y"), posTag.m_128451_("Z"));
        }
        if (nbt.m_128425_("AttackMoveBlockPos", 10)) {
            posTag = nbt.m_128469_("AttackMoveBlockPos");
            this.attackMoveBlockPos = new BlockPos(posTag.m_128451_("X"), posTag.m_128451_("Y"), posTag.m_128451_("Z"));
        }
        if (nbt.m_128425_("AttackTargetEntity", 11) && minecraft.f_91073_ != null) {
            UUID targetUUID = nbt.m_128342_("AttackTargetEntity");
            for (Entity entity : minecraft.f_91073_.m_104735_()) {
                if (!entity.m_20148_().equals(targetUUID)) continue;
                this.attackTargetEntity = entity;
                break;
            }
        }
    }

    public void setTargetBlockPos(BlockPos pos) {
        this.targetBlockPos = pos;
    }

    public void setAttackMoveBlockPos(BlockPos pos) {
        this.attackMoveBlockPos = pos;
    }

    public void setTargetEntity(Entity entity) {
        this.targetBlockPos = null;
        this.attackMoveBlockPos = null;
        this.attackTargetEntity = null;
    }

    public void setAttackTargetEntity(Entity entity) {
        this.targetBlockPos = null;
        this.attackMoveBlockPos = null;
        this.attackTargetEntity = entity;
    }

    public BlockPos getTargetBlockPos() {
        return this.targetBlockPos;
    }

    public BlockPos getAttackMoveBlockPos() {
        return this.attackMoveBlockPos;
    }

    public Entity getAttackTargetEntity() {
        return this.attackTargetEntity;
    }

    public Set<BaseCombatEntity> getTeamEntities() {
        return this.teamEntities;
    }

    public boolean isEntityInTeam(Entity entity) {
        return entity instanceof BaseCombatEntity && this.teamEntities.contains(entity);
    }

    public void clearRenderData() {
        this.targetBlockPos = null;
        this.attackMoveBlockPos = null;
        this.attackTargetEntity = null;
    }

    public String toggleFormationMode() {
        return CommandWheelHandler.getInstance().toggleFormationShortcut();
    }

    public boolean isFormationMode() {
        return CommandWheelHandler.getInstance().isFormationActive();
    }

    public void clientTick() {
        Minecraft minecraft = Minecraft.m_91087_();
        if (minecraft.f_91074_ == null) {
            return;
        }
        this.updateCurrentCommandStaff((Player)minecraft.f_91074_);
    }
}

