/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.client.mixins;

import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.MouseHandler;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import ydmsama.hundred_years_war.client.freecam.Freecam;
import ydmsama.hundred_years_war.client.item.CommandStaffHandler;
import ydmsama.hundred_years_war.client.network.ClientPacketHandler;
import ydmsama.hundred_years_war.client.utils.ClientCreativeModeSettings;
import ydmsama.hundred_years_war.client.utils.ClientRelationHelper;
import ydmsama.hundred_years_war.client.utils.TraceHelper;
import ydmsama.hundred_years_war.main.entity.entities.BaseCombatEntity;
import ydmsama.hundred_years_war.main.item.CommandStaffItem;
import ydmsama.hundred_years_war.main.utils.RelationSystem;

@Mixin(value={MouseHandler.class})
public class CommandStaffMouseHandlerMixin {
    @Shadow
    @Final
    private Minecraft f_91503_;
    @Unique
    private static final int PICK_DISTANCE = 200;
    @Unique
    private static final long LONG_PRESS_THRESHOLD_MS = 500L;
    @Unique
    private static final double AREA_SELECT_RADIUS = 10.0;
    @Unique
    private long rightMousePressStartTime = 0L;
    @Unique
    private boolean rightMouseLongPressHandled = false;
    @Unique
    private HitResult lastHitResult = null;

    @Unique
    private boolean isLookingDown() {
        Camera camera = this.f_91503_.f_91063_.m_109153_();
        return camera.m_90589_() > 80.0f;
    }

    @Inject(method={"onPress"}, at={@At(value="HEAD")}, cancellable=true)
    private void onCommandStaffPress(long window, int button, int action, int mods, CallbackInfo ci) {
        if (this.f_91503_.m_91268_().m_85439_() != window || this.f_91503_.f_91074_ == null || this.f_91503_.f_91080_ != null || Freecam.isEnabled()) {
            return;
        }
        ItemStack mainHandItem = this.f_91503_.f_91074_.m_21205_();
        if (mainHandItem.m_41619_() || !(mainHandItem.m_41720_() instanceof CommandStaffItem)) {
            return;
        }
        UUID staffUUID = CommandStaffItem.getItemUUID(mainHandItem);
        if (button == 2 && action == 1) {
            this.f_91503_.f_91074_.m_6674_(InteractionHand.MAIN_HAND);
            CommandStaffHandler handler = CommandStaffHandler.getInstance();
            String formationId = handler.toggleFormationMode();
            MutableComponent message = Component.m_237115_((String)"msg.hyw.formation_switched").m_7220_((Component)Component.m_237115_((String)("wheel.hundred_years_war.formation." + formationId)).m_130940_(ChatFormatting.YELLOW));
            this.f_91503_.f_91074_.m_5661_((Component)message, true);
            ci.cancel();
        } else if (button == 0 && action == 1) {
            this.f_91503_.f_91074_.m_6674_(InteractionHand.MAIN_HAND);
            this.handleLeftClick(staffUUID, mainHandItem);
            ci.cancel();
        } else if (button == 1) {
            if (action == 1) {
                this.rightMousePressStartTime = System.currentTimeMillis();
                this.rightMouseLongPressHandled = false;
                this.lastHitResult = this.performStaffRayTrace(mainHandItem);
                this.f_91503_.f_91074_.m_6674_(InteractionHand.MAIN_HAND);
                ci.cancel();
            } else if (action == 0) {
                long pressDuration = System.currentTimeMillis() - this.rightMousePressStartTime;
                if (this.lastHitResult != null) {
                    if (pressDuration >= 500L) {
                        if (this.f_91503_.f_91074_.m_6144_()) {
                            this.handleClearSelection(staffUUID, mainHandItem);
                        } else {
                            this.handleAreaSelection(staffUUID, mainHandItem, this.lastHitResult);
                        }
                    } else if (!this.rightMouseLongPressHandled) {
                        this.handleRightClick(staffUUID, mainHandItem, this.f_91503_.f_91074_.m_6144_());
                    }
                }
                this.rightMousePressStartTime = 0L;
                this.rightMouseLongPressHandled = false;
                this.lastHitResult = null;
                ci.cancel();
            }
        }
    }

    @Unique
    private HitResult performStaffRayTrace(ItemStack staffItem) {
        return this.performStaffRayTrace(staffItem, false);
    }

    @Unique
    private HitResult performStaffRayTrace(ItemStack staffItem, boolean ignoreControlledEntities) {
        LocalPlayer player = this.f_91503_.f_91074_;
        if (player == null) {
            return null;
        }
        Camera camera = this.f_91503_.f_91063_.m_109153_();
        Vec3 eyePos = camera.m_90583_();
        Vec3 lookVec = Vec3.m_82498_((float)camera.m_90589_(), (float)camera.m_90590_());
        Vec3 targetPos = eyePos.m_82520_(lookVec.f_82479_ * 200.0, lookVec.f_82480_ * 200.0, lookVec.f_82481_ * 200.0);
        BlockHitResult blockResult = this.f_91503_.f_91073_.m_45547_(new ClipContext(eyePos, targetPos, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)player));
        double blockDistance = Double.MAX_VALUE;
        if (blockResult.m_6662_() != HitResult.Type.MISS) {
            blockDistance = eyePos.m_82557_(blockResult.m_82450_());
        }
        Entity closestEntity = null;
        Vec3 closestHitPos = null;
        double closestDistance = Double.MAX_VALUE;
        AABB searchBox = new AABB(eyePos.f_82479_ - 200.0, eyePos.f_82480_ - 200.0, eyePos.f_82481_ - 200.0, eyePos.f_82479_ + 200.0, eyePos.f_82480_ + 200.0, eyePos.f_82481_ + 200.0);
        List entities = this.f_91503_.f_91073_.m_45933_((Entity)player, searchBox);
        boolean isShiftDown = player.m_6144_();
        for (Entity entity : entities) {
            double distance;
            AABB entityBox;
            Optional hitPos;
            if (entity == player || !entity.m_6084_() || !entity.m_6087_() || ignoreControlledEntities && this.shouldIgnoreControlledEntity(entity) || !isShiftDown && entity instanceof BaseCombatEntity && this.isEntityInTeam(staffItem, entity.m_20148_()) || !(hitPos = (entityBox = entity.m_20191_().m_82400_(0.3)).m_82371_(eyePos, targetPos)).isPresent() || !((distance = eyePos.m_82557_((Vec3)hitPos.get())) < closestDistance) || !(distance < blockDistance)) continue;
            closestEntity = entity;
            closestHitPos = (Vec3)hitPos.get();
            closestDistance = distance;
        }
        if (closestEntity != null) {
            return new EntityHitResult(closestEntity, closestHitPos);
        }
        if (blockResult.m_6662_() != HitResult.Type.MISS) {
            return blockResult;
        }
        BlockPos targetBlockPos = new BlockPos((int)targetPos.f_82479_, (int)targetPos.f_82480_, (int)targetPos.f_82481_);
        return BlockHitResult.m_82426_((Vec3)targetPos, (Direction)Direction.m_122366_((double)lookVec.f_82479_, (double)lookVec.f_82480_, (double)lookVec.f_82481_), (BlockPos)targetBlockPos);
    }

    @Unique
    private boolean shouldIgnoreControlledEntity(Entity entity) {
        if (entity instanceof BaseCombatEntity) {
            RelationSystem.RelationType relation = ClientRelationHelper.getInstance().getRelationWithPlayer(entity);
            return relation == RelationSystem.RelationType.CONTROL;
        }
        return false;
    }

    @Unique
    private boolean isEntityInTeam(ItemStack staffItem, UUID entityUUID) {
        CompoundTag nbt = staffItem.m_41783_();
        if (nbt != null && nbt.m_128425_("TeamEntityUUIDs", 9)) {
            ListTag uuidList = nbt.m_128437_("TeamEntityUUIDs", 8);
            String entityUUIDString = entityUUID.toString();
            for (int i = 0; i < uuidList.size(); ++i) {
                if (!uuidList.m_128778_(i).equals(entityUUIDString)) continue;
                return true;
            }
        }
        return false;
    }

    @Unique
    private void handleLeftClick(UUID staffUUID, ItemStack staffItem) {
        LocalPlayer player = this.f_91503_.f_91074_;
        boolean ignoreControlledEntities = !player.m_7500_() || !ClientCreativeModeSettings.canControlAllUnits();
        HitResult hitResult = this.performStaffRayTrace(staffItem, ignoreControlledEntities);
        if (hitResult == null) {
            return;
        }
        CommandStaffHandler handler = CommandStaffHandler.getInstance();
        boolean isFormationMode = handler.isFormationMode();
        if (hitResult.m_6662_() == HitResult.Type.ENTITY) {
            EntityHitResult entityHit = (EntityHitResult)hitResult;
            Entity target = entityHit.m_82443_();
            if (target instanceof LivingEntity) {
                handler.setAttackTargetEntity(target);
                ClientPacketHandler.sendCommandStaffAttackPacket(staffUUID, target.m_20148_());
                player.m_5661_((Component)Component.m_237115_((String)"message.hundred_years_war.command_staff.attack"), true);
            }
        } else if (hitResult.m_6662_() == HitResult.Type.BLOCK || hitResult.m_6662_() == HitResult.Type.MISS) {
            BlockHitResult blockHit = (BlockHitResult)hitResult;
            handler.setAttackMoveBlockPos(blockHit.m_82425_());
            ClientPacketHandler.sendCommandStaffMovePacket(staffUUID, blockHit.m_82425_(), 3, isFormationMode);
            if (isFormationMode) {
                player.m_5661_((Component)Component.m_237115_((String)"message.hundred_years_war.command_staff.formation_move_attack"), true);
            } else {
                player.m_5661_((Component)Component.m_237115_((String)"message.hundred_years_war.command_staff.move_attack"), true);
            }
        }
    }

    @Unique
    private void handleRightClick(UUID staffUUID, ItemStack staffItem, boolean isShiftDown) {
        HitResult originalHitResult = this.lastHitResult;
        if (originalHitResult == null) {
            return;
        }
        LocalPlayer player = this.f_91503_.f_91074_;
        CommandStaffHandler handler = CommandStaffHandler.getInstance();
        boolean isFormationMode = handler.isFormationMode();
        if (this.isLookingDown()) {
            handler.clearRenderData();
            ClientPacketHandler.sendCommandStaffFollowPacket(staffUUID);
            player.m_5661_((Component)Component.m_237115_((String)"message.hundred_years_war.command_staff.follow"), true);
            return;
        }
        if (isShiftDown) {
            if (originalHitResult.m_6662_() == HitResult.Type.ENTITY) {
                BaseCombatEntity baseCombatEntity;
                BaseCombatEntity entityToProcess;
                Entity targetEntity = ((EntityHitResult)originalHitResult).m_82443_();
                handler.setTargetEntity(targetEntity);
                if (targetEntity instanceof BaseCombatEntity && this.canPlayerControl((Player)player, entityToProcess = this.getActualEntity(baseCombatEntity = (BaseCombatEntity)targetEntity)) && this.isEntityInTeam(staffItem, entityToProcess.m_20148_())) {
                    ClientPacketHandler.sendCommandStaffAddEntityPacket(staffUUID, entityToProcess.m_20148_(), false);
                    return;
                }
            }
            BlockPos movePos = this.getBlockPosFromHitResult(originalHitResult);
            handler.setTargetBlockPos(movePos);
            ClientPacketHandler.sendCommandStaffMovePacket(staffUUID, movePos, 1, isFormationMode);
            this.displayStandardMoveMessage((Player)player, isFormationMode);
            return;
        }
        if (originalHitResult.m_6662_() == HitResult.Type.ENTITY) {
            BaseCombatEntity baseCombatEntity;
            BaseCombatEntity entityToProcess;
            Entity targetEntity = ((EntityHitResult)originalHitResult).m_82443_();
            handler.setTargetEntity(targetEntity);
            if (targetEntity instanceof BaseCombatEntity && this.canPlayerControl((Player)player, entityToProcess = this.getActualEntity(baseCombatEntity = (BaseCombatEntity)targetEntity)) && !this.isEntityInTeam(staffItem, entityToProcess.m_20148_())) {
                ClientPacketHandler.sendCommandStaffAddEntityPacket(staffUUID, entityToProcess.m_20148_(), true);
                return;
            }
        }
        HitResult blockOnlyHit = TraceHelper.blockRayTrace(200.0);
        BlockPos movePos = this.getBlockPosFromHitResult(blockOnlyHit);
        handler.setTargetBlockPos(movePos);
        ClientPacketHandler.sendCommandStaffMovePacket(staffUUID, movePos, 1, isFormationMode);
        this.displayStandardMoveMessage((Player)player, isFormationMode);
    }

    @Unique
    private BaseCombatEntity getActualEntity(BaseCombatEntity entity) {
        Entity entity2;
        if (entity.m_20202_() != null && (entity2 = entity.m_20202_()) instanceof BaseCombatEntity) {
            BaseCombatEntity vehicle = (BaseCombatEntity)entity2;
            return vehicle;
        }
        return entity;
    }

    @Unique
    private boolean canPlayerControl(Player player, BaseCombatEntity entity) {
        return ClientRelationHelper.getInstance().getRelationWithPlayer((Entity)entity) == RelationSystem.RelationType.CONTROL || player.m_7500_() && ClientCreativeModeSettings.canControlAllUnits();
    }

    @Unique
    private BlockPos getBlockPosFromHitResult(HitResult hitResult) {
        if (hitResult.m_6662_() == HitResult.Type.ENTITY) {
            return ((EntityHitResult)hitResult).m_82443_().m_20183_();
        }
        return ((BlockHitResult)hitResult).m_82425_();
    }

    @Unique
    private void displayStandardMoveMessage(Player player, boolean isFormationMode) {
        if (isFormationMode) {
            player.m_5661_((Component)Component.m_237115_((String)"message.hundred_years_war.command_staff.formation_move"), true);
        } else {
            player.m_5661_((Component)Component.m_237115_((String)"message.hundred_years_war.command_staff.move"), true);
        }
    }

    @Inject(method={"turnPlayer"}, at={@At(value="HEAD")})
    private void onCommandStaffTurnPlayer(CallbackInfo ci) {
        if (this.rightMousePressStartTime > 0L && !this.rightMouseLongPressHandled) {
            LocalPlayer player = this.f_91503_.f_91074_;
            if (player == null || this.f_91503_.f_91080_ != null || player.m_21205_().m_41619_() || !(player.m_21205_().m_41720_() instanceof CommandStaffItem)) {
                this.rightMousePressStartTime = 0L;
                this.rightMouseLongPressHandled = false;
                this.lastHitResult = null;
                return;
            }
            long pressDuration = System.currentTimeMillis() - this.rightMousePressStartTime;
            if (pressDuration >= 500L) {
                this.rightMouseLongPressHandled = true;
                ItemStack mainHandItem = player.m_21205_();
                UUID staffUUID = CommandStaffItem.getItemUUID(mainHandItem);
                if (player.m_6144_()) {
                    this.handleClearSelection(staffUUID, mainHandItem);
                } else if (this.lastHitResult != null) {
                    this.handleAreaSelection(staffUUID, mainHandItem, this.lastHitResult);
                }
            }
        }
    }

    @Unique
    private void handleAreaSelection(UUID staffUUID, ItemStack staffItem, HitResult hitResult) {
        LocalPlayer player = this.f_91503_.f_91074_;
        if (player == null || hitResult == null) {
            return;
        }
        Vec3 centerPos = hitResult.m_6662_() == HitResult.Type.ENTITY ? ((EntityHitResult)hitResult).m_82443_().m_20182_() : hitResult.m_82450_();
        int selectionCount = 0;
        AABB searchBox = new AABB(centerPos.f_82479_ - 10.0, centerPos.f_82480_ - 10.0, centerPos.f_82481_ - 10.0, centerPos.f_82479_ + 10.0, centerPos.f_82480_ + 10.0, centerPos.f_82481_ + 10.0);
        List entities = this.f_91503_.f_91073_.m_45933_((Entity)player, searchBox);
        for (Entity entity : entities) {
            boolean isInTeam;
            Entity entity2;
            if (!(entity instanceof BaseCombatEntity)) continue;
            BaseCombatEntity baseCombatEntity = (BaseCombatEntity)entity;
            if (baseCombatEntity.m_20202_() != null && (entity2 = baseCombatEntity.m_20202_()) instanceof BaseCombatEntity) {
                BaseCombatEntity vehicle;
                baseCombatEntity = vehicle = (BaseCombatEntity)entity2;
            }
            if (ClientRelationHelper.getInstance().getRelationWithPlayer((Entity)baseCombatEntity) != RelationSystem.RelationType.CONTROL && (!player.m_7500_() || !ClientCreativeModeSettings.canControlAllUnits()) || (isInTeam = this.isEntityInTeam(staffItem, baseCombatEntity.m_20148_()))) continue;
            ClientPacketHandler.sendCommandStaffAddEntityPacket(staffUUID, baseCombatEntity.m_20148_(), true);
            ++selectionCount;
        }
        if (selectionCount > 0) {
            player.m_5661_((Component)Component.m_237110_((String)"message.hundred_years_war.command_staff.area_selection", (Object[])new Object[]{selectionCount}), true);
        }
    }

    @Unique
    private void handleClearSelection(UUID staffUUID, ItemStack staffItem) {
        LocalPlayer player = this.f_91503_.f_91074_;
        if (player == null) {
            return;
        }
        CompoundTag nbt = staffItem.m_41783_();
        if (nbt != null && nbt.m_128425_("TeamEntityUUIDs", 9)) {
            ListTag uuidList = nbt.m_128437_("TeamEntityUUIDs", 8);
            int entityCount = uuidList.size();
            for (int i = 0; i < uuidList.size(); ++i) {
                String uuidString = uuidList.m_128778_(i);
                try {
                    UUID entityUUID = UUID.fromString(uuidString);
                    ClientPacketHandler.sendCommandStaffAddEntityPacket(staffUUID, entityUUID, false);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (entityCount > 0) {
                player.m_5661_((Component)Component.m_237110_((String)"message.hundred_years_war.command_staff.clear_selection", (Object[])new Object[]{entityCount}), true);
            }
        }
    }
}

