/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.client.mixins;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CopyOnWriteArraySet;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.AABB;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import ydmsama.hundred_years_war.client.freecam.Freecam;
import ydmsama.hundred_years_war.client.freecam.selection.SelectionHandler;
import ydmsama.hundred_years_war.client.freecam.selection.TargetInfo;
import ydmsama.hundred_years_war.client.freecam.ui.wheel.CommandWheelHandler;
import ydmsama.hundred_years_war.client.utils.ClientRelationHelper;
import ydmsama.hundred_years_war.client.utils.RenderingEntityTracker;
import ydmsama.hundred_years_war.main.entity.entities.puppets.IPuppet;
import ydmsama.hundred_years_war.main.entity.entities.tags.SiegeUnit;
import ydmsama.hundred_years_war.main.utils.RelationSystem;

@Mixin(value={EntityRenderDispatcher.class})
public abstract class EntityRenderDispatcherMixin {
    @Inject(method={"render"}, at={@At(value="HEAD")})
    private <E extends Entity> void onRenderHead(E entity, double x, double y, double z, float yaw, float tickDelta, PoseStack poseStack, MultiBufferSource multiBufferSource, int light, CallbackInfo ci) {
        RenderingEntityTracker.setCurrentRenderingEntity(entity);
    }

    @Inject(method={"render"}, at={@At(value="INVOKE", target="Lcom/mojang/blaze3d/vertex/PoseStack;popPose()V", shift=At.Shift.BEFORE)})
    private <E extends Entity> void onRender(E entity, double x, double y, double z, float yaw, float tickDelta, PoseStack poseStack, MultiBufferSource multiBufferSource, int light, CallbackInfo ci) {
        if (entity.m_6084_() && (Freecam.isEnabled() || CommandWheelHandler.getInstance().shouldRenderCommandEffect())) {
            this.renderSelectedEntityBaseBox(entity, poseStack, multiBufferSource, x, y, z);
            this.renderTargetedEntityBaseBox(entity, poseStack, multiBufferSource, x, y, z);
            this.renderFollowedEntityBaseBox(entity, poseStack, multiBufferSource, x, y, z);
        }
    }

    @Inject(method={"render"}, at={@At(value="TAIL")})
    private <E extends Entity> void onRenderTail(E entity, double x, double y, double z, float yaw, float tickDelta, PoseStack poseStack, MultiBufferSource multiBufferSource, int light, CallbackInfo ci) {
        RenderingEntityTracker.clearCurrentRenderingEntity();
    }

    @Unique
    private void renderSelectedEntityBaseBox(Entity entity, PoseStack poseStack, MultiBufferSource multiBufferSource, double cameraX, double cameraY, double cameraZ) {
        if (this.isSelected(entity)) {
            float b;
            float g;
            float r;
            AABB box = entity.m_20191_().m_82386_(-entity.m_20185_(), -entity.m_20186_(), -entity.m_20189_());
            double xOffset = 0.2;
            double zOffset = 0.2;
            if (entity instanceof SiegeUnit) {
                xOffset = 2.0;
                zOffset = 2.0;
            }
            double minX = box.f_82288_ - xOffset;
            double minY = box.f_82289_ + 0.2;
            double minZ = box.f_82290_ - zOffset;
            double maxX = box.f_82291_ + xOffset;
            double maxY = box.f_82289_ + 0.2;
            double maxZ = box.f_82293_ + zOffset;
            VertexConsumer vertexConsumer = multiBufferSource.m_6299_(RenderType.m_110504_());
            ClientRelationHelper relationHelper = ClientRelationHelper.getInstance();
            RelationSystem.RelationType relationType = relationHelper.getRelationWithPlayer(entity);
            if (relationType == RelationSystem.RelationType.CONTROL) {
                r = 0.0f;
                g = 1.0f;
                b = 0.0f;
            } else if (relationType == RelationSystem.RelationType.HOSTILE) {
                r = 1.0f;
                g = 0.0f;
                b = 0.0f;
            } else {
                r = 1.0f;
                g = 1.0f;
                b = 0.0f;
            }
            LevelRenderer.m_109608_((PoseStack)poseStack, (VertexConsumer)vertexConsumer, (double)minX, (double)minY, (double)minZ, (double)maxX, (double)maxY, (double)maxZ, (float)r, (float)g, (float)b, (float)1.0f);
        }
    }

    @Unique
    private void renderTargetedEntityBaseBox(Entity entity, PoseStack poseStack, MultiBufferSource multiBufferSource, double cameraX, double cameraY, double cameraZ) {
        if (this.isTargeted(entity)) {
            AABB box = entity.m_20191_().m_82386_(-entity.m_20185_(), -entity.m_20186_(), -entity.m_20189_());
            double xOffset = 0.25;
            double zOffset = 0.25;
            if (entity instanceof SiegeUnit) {
                xOffset = 2.4;
                zOffset = 2.4;
            }
            double minX = box.f_82288_ - xOffset;
            double minY = box.f_82289_ + 0.2;
            double minZ = box.f_82290_ - zOffset;
            double maxX = box.f_82291_ + xOffset;
            double maxY = box.f_82289_ + 0.2;
            double maxZ = box.f_82293_ + zOffset;
            VertexConsumer vertexConsumer = multiBufferSource.m_6299_(RenderType.m_110504_());
            float r = 1.0f;
            float g = 0.0f;
            float b = 0.0f;
            LevelRenderer.m_109608_((PoseStack)poseStack, (VertexConsumer)vertexConsumer, (double)minX, (double)minY, (double)minZ, (double)maxX, (double)maxY, (double)maxZ, (float)r, (float)g, (float)b, (float)1.0f);
        }
    }

    @Unique
    private boolean isSelected(Entity entity) {
        return SelectionHandler.getInstance().getSelectedEntities().contains(entity);
    }

    @Unique
    private boolean isTargeted(Entity entity) {
        Entity entityToCheck = this.getEntityToCheck(entity);
        Map<Entity, CopyOnWriteArraySet<TargetInfo>> combinedTargetMap = SelectionHandler.getInstance().getCombinedTargetMap();
        for (Map.Entry<Entity, CopyOnWriteArraySet<TargetInfo>> entry : combinedTargetMap.entrySet()) {
            Entity attacker = entry.getKey();
            CopyOnWriteArraySet<TargetInfo> targets = entry.getValue();
            for (TargetInfo targetInfo : targets) {
                if (!"entityTarget".equals(targetInfo.getType()) || !entityToCheck.equals((Object)targetInfo.getHywTarget()) || !this.isSelected(attacker)) continue;
                return true;
            }
        }
        return false;
    }

    @Unique
    private void renderFollowedEntityBaseBox(Entity entity, PoseStack poseStack, MultiBufferSource multiBufferSource, double cameraX, double cameraY, double cameraZ) {
        if (this.isFollowed(entity)) {
            AABB box = entity.m_20191_().m_82386_(-entity.m_20185_(), -entity.m_20186_(), -entity.m_20189_());
            double xOffset = 0.3;
            double zOffset = 0.3;
            if (entity instanceof SiegeUnit) {
                xOffset = 2.8;
                zOffset = 2.8;
            }
            double minX = box.f_82288_ - xOffset;
            double minY = box.f_82289_ + 0.2;
            double minZ = box.f_82290_ - zOffset;
            double maxX = box.f_82291_ + xOffset;
            double maxY = box.f_82289_ + 0.2;
            double maxZ = box.f_82293_ + zOffset;
            VertexConsumer vertexConsumer = multiBufferSource.m_6299_(RenderType.m_110504_());
            float r = 0.0f;
            float g = 1.0f;
            float b = 0.0f;
            LevelRenderer.m_109608_((PoseStack)poseStack, (VertexConsumer)vertexConsumer, (double)minX, (double)minY, (double)minZ, (double)maxX, (double)maxY, (double)maxZ, (float)r, (float)g, (float)b, (float)1.0f);
        }
    }

    @Unique
    private boolean isFollowed(Entity entity) {
        Entity entityToCheck = this.getEntityToCheck(entity);
        Map<Entity, CopyOnWriteArraySet<TargetInfo>> combinedTargetMap = SelectionHandler.getInstance().getCombinedTargetMap();
        for (Map.Entry<Entity, CopyOnWriteArraySet<TargetInfo>> entry : combinedTargetMap.entrySet()) {
            Entity follower = entry.getKey();
            CopyOnWriteArraySet<TargetInfo> followedEntities = entry.getValue();
            for (TargetInfo targetInfo : followedEntities) {
                if (!"followTarget".equals(targetInfo.getType()) || !entityToCheck.equals((Object)targetInfo.getHywTarget()) || !this.isSelected(follower)) continue;
                return true;
            }
        }
        return false;
    }

    @Unique
    private Entity getEntityToCheck(Entity entity) {
        Player ownerPlayer;
        IPuppet puppet;
        UUID ownerUUID;
        if (entity instanceof IPuppet && (ownerUUID = (puppet = (IPuppet)entity).m_21805_()) != null && (ownerPlayer = this.findPlayerByUUID(ownerUUID)) != null) {
            return ownerPlayer;
        }
        return entity;
    }

    @Unique
    private Player findPlayerByUUID(UUID uuid) {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91073_ != null) {
            for (Player player : mc.f_91073_.m_6907_()) {
                if (!uuid.equals(player.m_20148_())) continue;
                return player;
            }
        }
        return null;
    }
}

