/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.client.mixins;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import ydmsama.hundred_years_war.client.utils.RenderingEntityTracker;
import ydmsama.hundred_years_war.main.entity.entities.BaseCombatEntity;

@Mixin(value={ItemRenderer.class})
public abstract class ItemRendererMixin {
    @Shadow
    private Minecraft f_265848_;
    @Unique
    private static final float DISTANCE_THRESHOLD_SQ = 225.0f;
    @Unique
    private final Map<BakedQuad, BakedQuad> flippedQuadCache = new WeakHashMap<BakedQuad, BakedQuad>();

    @Shadow
    protected abstract void m_115162_(PoseStack var1, VertexConsumer var2, List<BakedQuad> var3, ItemStack var4, int var5, int var6);

    @Unique
    private BakedQuad createFlippedQuad(BakedQuad orig) {
        BakedQuad cached = this.flippedQuadCache.get(orig);
        if (cached != null) {
            return cached;
        }
        int[] vertices = orig.m_111303_();
        int stride = vertices.length / 4;
        int[] flipped = new int[vertices.length];
        for (int i = 0; i < 4; ++i) {
            System.arraycopy(vertices, (3 - i) * stride, flipped, i * stride, stride);
        }
        Direction face = orig.m_111306_();
        Direction flippedFace = face == null ? null : face.m_122424_();
        TextureAtlasSprite sprite = orig.m_173410_();
        int tint = orig.m_111305_();
        boolean shade = orig.m_111307_();
        BakedQuad newQuad = new BakedQuad(flipped, tint, flippedFace, sprite, shade);
        this.flippedQuadCache.put(orig, newQuad);
        return newQuad;
    }

    @Unique
    private boolean shouldOptimizeRendering() {
        if (this.f_265848_ == null || this.f_265848_.f_91074_ == null || this.f_265848_.f_91075_ == null) {
            return false;
        }
        if (RenderingEntityTracker.isOptimizationSuppressed()) {
            return false;
        }
        Object renderingEntity = RenderingEntityTracker.getCurrentRenderingEntity();
        if (renderingEntity instanceof BaseCombatEntity) {
            double dz;
            double dy;
            BaseCombatEntity combatEntity = (BaseCombatEntity)renderingEntity;
            double dx = combatEntity.m_20185_() - this.f_265848_.f_91075_.m_20185_();
            double distanceSq = dx * dx + (dy = combatEntity.m_20186_() - this.f_265848_.f_91075_.m_20186_()) * dy + (dz = combatEntity.m_20189_() - this.f_265848_.f_91075_.m_20189_()) * dz;
            return distanceSq > 225.0;
        }
        return false;
    }

    @Inject(method={"renderQuadList"}, at={@At(value="HEAD")}, cancellable=true)
    private void optimizeQuadRendering(PoseStack poseStack, VertexConsumer vertexConsumer, List<BakedQuad> list, ItemStack itemStack, int lightColor, int overlayColor, CallbackInfo ci) {
        if (!this.shouldOptimizeRendering()) {
            return;
        }
        if (!list.isEmpty()) {
            PoseStack.Pose pose = poseStack.m_85850_();
            BakedQuad mainQuad = list.get(0);
            float r = 1.0f;
            float g = 1.0f;
            float b = 1.0f;
            vertexConsumer.m_85987_(pose, mainQuad, r, g, b, lightColor, overlayColor);
            BakedQuad flipped = this.createFlippedQuad(mainQuad);
            vertexConsumer.m_85987_(pose, flipped, r, g, b, lightColor, overlayColor);
            ci.cancel();
        }
    }

    @Inject(method={"renderModelLists"}, at={@At(value="HEAD")}, cancellable=true)
    private void optimizeDirectionalRendering(BakedModel bakedModel, ItemStack itemStack, int lightColor, int overlayColor, PoseStack poseStack, VertexConsumer vertexConsumer, CallbackInfo ci) {
        if (!this.shouldOptimizeRendering()) {
            return;
        }
        RandomSource randomSource = RandomSource.m_216327_();
        long seed = 42L;
        randomSource.m_188584_(seed);
        List generalQuads = bakedModel.m_213637_(null, null, randomSource);
        if (!generalQuads.isEmpty()) {
            this.m_115162_(poseStack, vertexConsumer, generalQuads, itemStack, lightColor, overlayColor);
        }
        ci.cancel();
    }
}

