/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.client.mixins;

import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import ydmsama.hundred_years_war.main.entity.entities.puppets.IPuppet;
import ydmsama.hundred_years_war.main.item.HandgonneItem;
import ydmsama.hundred_years_war.main.item.MatchlockItem;

@Mixin(value={PlayerModel.class})
public class PlayerModelMixin<T extends LivingEntity> {
    @Inject(method={"setupAnim(Lnet/minecraft/world/entity/LivingEntity;FFFFF)V"}, at={@At(value="HEAD")})
    private void setupAnimHandgonne(LivingEntity livingEntity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, CallbackInfo ci) {
        boolean offHandHasFirearm;
        PlayerModel model = (PlayerModel)this;
        ItemStack mainHandItem = livingEntity.m_21120_(InteractionHand.MAIN_HAND);
        ItemStack offHandItem = livingEntity.m_21120_(InteractionHand.OFF_HAND);
        boolean mainHandHasFirearm = mainHandItem.m_41720_() instanceof HandgonneItem || mainHandItem.m_41720_() instanceof MatchlockItem;
        boolean bl = offHandHasFirearm = offHandItem.m_41720_() instanceof HandgonneItem || offHandItem.m_41720_() instanceof MatchlockItem;
        if (mainHandHasFirearm) {
            model.f_102816_ = HumanoidModel.ArmPose.CROSSBOW_HOLD;
        }
        if (offHandHasFirearm) {
            model.f_102815_ = HumanoidModel.ArmPose.CROSSBOW_HOLD;
        }
    }

    @Inject(method={"setupAnim(Lnet/minecraft/world/entity/LivingEntity;FFFFF)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void onSetupAnimPuppetSync(LivingEntity livingEntity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, CallbackInfo ci) {
        if (livingEntity instanceof Player) {
            Entity entity;
            Player player = (Player)livingEntity;
            LocalPlayer localPlayer = Minecraft.m_91087_().f_91074_;
            if (localPlayer != null && localPlayer.equals((Object)player) && player.m_20159_() && (entity = player.m_20202_()) instanceof IPuppet) {
                IPuppet puppet = (IPuppet)entity;
                PlayerModel thisModel = (PlayerModel)this;
                boolean originalRiding = thisModel.f_102609_;
                thisModel.f_102609_ = false;
                this.callSuperSetupAnim((PlayerModel<LivingEntity>)thisModel, livingEntity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
                thisModel.f_102609_ = originalRiding;
                this.syncHeadWithPuppet((LivingEntity)puppet, (PlayerModel<LivingEntity>)thisModel);
                ci.cancel();
            }
        }
    }

    private void callSuperSetupAnim(PlayerModel<LivingEntity> model, LivingEntity livingEntity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        try {
            model.f_102808_.f_104204_ = netHeadYaw * ((float)Math.PI / 180);
            model.f_102808_.f_104203_ = headPitch * ((float)Math.PI / 180);
            model.f_102811_.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f + (float)Math.PI)) * 2.0f * limbSwingAmount * 0.5f;
            model.f_102812_.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f)) * 2.0f * limbSwingAmount * 0.5f;
            model.f_102813_.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
            model.f_102814_.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount;
            model.f_102811_.f_104204_ = 0.0f;
            model.f_102812_.f_104204_ = 0.0f;
            model.f_102811_.f_104205_ = 0.0f;
            model.f_102812_.f_104205_ = 0.0f;
            model.f_102813_.f_104204_ = 0.005f;
            model.f_102814_.f_104204_ = -0.005f;
            model.f_102813_.f_104205_ = 0.005f;
            model.f_102814_.f_104205_ = -0.005f;
            model.f_103376_.m_104315_(model.f_102814_);
            model.f_103377_.m_104315_(model.f_102813_);
            model.f_103374_.m_104315_(model.f_102812_);
            model.f_103375_.m_104315_(model.f_102811_);
            model.f_103378_.m_104315_(model.f_102810_);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void syncHeadWithPuppet(LivingEntity puppet, PlayerModel<LivingEntity> playerModel) {
        LivingEntityRenderer livingRenderer;
        EntityModel puppetModel;
        if (!(puppet instanceof IPuppet)) {
            return;
        }
        EntityRenderer renderer = Minecraft.m_91087_().m_91290_().m_114382_((Entity)puppet);
        if (renderer instanceof LivingEntityRenderer && (puppetModel = (livingRenderer = (LivingEntityRenderer)renderer).m_7200_()) instanceof HumanoidModel) {
            HumanoidModel puppetHumanoidModel = (HumanoidModel)puppetModel;
            playerModel.f_102808_.m_104315_(puppetHumanoidModel.f_102808_);
            playerModel.f_102809_.m_104315_(puppetHumanoidModel.f_102809_);
        }
    }
}

