/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.client.models;

import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import ydmsama.hundred_years_war.client.utils.BetterMobCombatClientIntegration;
import ydmsama.hundred_years_war.main.entity.entities.BaseCombatEntity;
import ydmsama.hundred_years_war.main.entity.entities.SpearManEntity;
import ydmsama.hundred_years_war.main.utils.WeaponTypeHelper;

public class SpearManModel<T extends SpearManEntity>
extends HumanoidModel<T> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(new ResourceLocation("hundred_years_war", "spear_man"), "main");

    public SpearManModel(ModelPart root) {
        super(root);
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshDefinition = HumanoidModel.m_170681_((CubeDeformation)CubeDeformation.f_171458_, (float)0.0f);
        PartDefinition root = meshDefinition.m_171576_();
        CubeDeformation overlay = CubeDeformation.f_171458_.m_171469_(0.25f);
        root.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(16, 16).m_171481_(-4.0f, 0.0f, -2.0f, 8.0f, 12.0f, 4.0f).m_171514_(16, 32).m_171488_(-4.0f, 0.0f, -2.0f, 8.0f, 12.0f, 4.0f, overlay), PartPose.f_171404_);
        root.m_171599_("right_arm", CubeListBuilder.m_171558_().m_171514_(40, 16).m_171481_(-3.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f).m_171514_(40, 32).m_171488_(-3.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, overlay), PartPose.m_171419_((float)-5.0f, (float)2.0f, (float)0.0f));
        root.m_171599_("left_arm", CubeListBuilder.m_171558_().m_171514_(32, 48).m_171481_(-1.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f).m_171514_(48, 48).m_171488_(-1.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, overlay), PartPose.m_171419_((float)5.0f, (float)2.0f, (float)0.0f));
        root.m_171599_("right_leg", CubeListBuilder.m_171558_().m_171514_(0, 16).m_171481_(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f).m_171514_(0, 32).m_171488_(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, overlay), PartPose.m_171419_((float)-1.9f, (float)12.0f, (float)0.0f));
        root.m_171599_("left_leg", CubeListBuilder.m_171558_().m_171514_(16, 48).m_171481_(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f).m_171514_(0, 48).m_171488_(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, overlay), PartPose.m_171419_((float)1.9f, (float)12.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshDefinition, (int)64, (int)64);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        boolean usingShield = entity.m_6117_() && WeaponTypeHelper.isShieldLikeItem(entity.m_21206_());
        this.f_102815_ = usingShield ? HumanoidModel.ArmPose.BLOCK : HumanoidModel.ArmPose.EMPTY;
        super.m_6973_(entity, limbSwing, limbSwingAmount / 6.0f, ageInTicks, netHeadYaw, headPitch);
        ItemStack mainHandItem = entity.m_21205_();
        if (!mainHandItem.m_41619_() && WeaponTypeHelper.isPikeLikeWeapon(mainHandItem)) {
            if (((SpearManEntity)entity).shouldHoldWeaponVertically()) {
                this.f_102811_.f_104203_ = -0.8f;
                this.f_102811_.f_104204_ = 0.1f;
                this.f_102811_.f_104205_ = 0.0f;
            } else if (!((BaseCombatEntity)entity).getStartAttacking() || !BetterMobCombatClientIntegration.hasActiveAttackAnimation(entity)) {
                this.f_102811_.f_104203_ += -0.15f;
                this.f_102811_.f_104204_ += -0.15f;
                this.f_102811_.f_104205_ += -0.15f;
                this.f_102811_.f_104200_ += 0.25f;
                this.f_102811_.f_104202_ += 2.0f;
                this.f_102814_.f_104203_ *= 6.0f;
                this.f_102813_.f_104203_ *= 6.0f;
                if (!usingShield) {
                    this.f_102812_.f_104203_ = this.f_102811_.f_104203_ - 0.5f;
                    this.f_102812_.f_104204_ += 0.5f;
                    this.f_102812_.f_104205_ += 0.5f;
                    this.f_102812_.f_104200_ += -2.0f;
                    this.f_102812_.f_104201_ += 1.0f;
                    this.f_102812_.f_104202_ += -2.0f;
                }
            }
        }
    }
}

