/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.client.models;

import com.google.common.collect.ImmutableList;
import net.minecraft.client.model.AgeableListModel;
import net.minecraft.client.model.WolfModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import ydmsama.hundred_years_war.main.entity.entities.bandits.BanditWarHoundEntity;

public class WarHoundModel<T extends LivingEntity>
extends AgeableListModel<T> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(new ResourceLocation("hundred_years_war", "bandit_war_hound"), "main");
    private final ModelPart head;
    private final ModelPart realHead;
    private final ModelPart body;
    private final ModelPart rightHindLeg;
    private final ModelPart leftHindLeg;
    private final ModelPart rightFrontLeg;
    private final ModelPart leftFrontLeg;
    private final ModelPart tail;
    private final ModelPart realTail;
    private final ModelPart upperBody;

    public WarHoundModel(ModelPart root) {
        this.head = root.m_171324_("head");
        this.realHead = this.head.m_171324_("real_head");
        this.body = root.m_171324_("body");
        this.upperBody = root.m_171324_("upper_body");
        this.rightHindLeg = root.m_171324_("right_hind_leg");
        this.leftHindLeg = root.m_171324_("left_hind_leg");
        this.rightFrontLeg = root.m_171324_("right_front_leg");
        this.leftFrontLeg = root.m_171324_("left_front_leg");
        this.tail = root.m_171324_("tail");
        this.realTail = this.tail.m_171324_("real_tail");
    }

    public static LayerDefinition createBodyLayer() {
        return WolfModel.m_171088_();
    }

    protected Iterable<ModelPart> m_5607_() {
        return ImmutableList.of((Object)this.head);
    }

    protected Iterable<ModelPart> m_5608_() {
        return ImmutableList.of((Object)this.body, (Object)this.rightHindLeg, (Object)this.leftHindLeg, (Object)this.rightFrontLeg, (Object)this.leftFrontLeg, (Object)this.tail, (Object)this.upperBody);
    }

    public void prepareMobModel(T entity, float limbSwing, float limbSwingAmount, float partialTick) {
        float f;
        this.body.m_104227_(0.0f, 14.0f, 2.0f);
        this.body.f_104203_ = 1.5707964f;
        this.upperBody.m_104227_(-1.0f, 14.0f, -3.0f);
        this.upperBody.f_104203_ = this.body.f_104203_;
        this.tail.m_104227_(-1.0f, 12.0f, 8.0f);
        this.rightHindLeg.m_104227_(-2.5f, 16.0f, 7.0f);
        this.leftHindLeg.m_104227_(0.5f, 16.0f, 7.0f);
        this.rightFrontLeg.m_104227_(-2.5f, 16.0f, -4.0f);
        this.leftFrontLeg.m_104227_(0.5f, 16.0f, -4.0f);
        this.rightHindLeg.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
        this.leftHindLeg.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount;
        this.rightFrontLeg.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount;
        this.leftFrontLeg.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
        if (entity instanceof BanditWarHoundEntity) {
            BanditWarHoundEntity hound = (BanditWarHoundEntity)entity;
            f = hound.getTailAnimation(partialTick);
        } else {
            f = limbSwing;
        }
        float tailAnim = f;
        this.tail.f_104204_ = Mth.m_14089_((float)tailAnim) * 0.2f;
        this.realHead.f_104205_ = 0.0f;
        this.upperBody.f_104205_ = 0.0f;
        this.body.f_104205_ = 0.0f;
        this.realTail.f_104205_ = 0.0f;
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.head.f_104203_ = headPitch * ((float)Math.PI / 180);
        this.head.f_104204_ = netHeadYaw * ((float)Math.PI / 180);
        this.tail.f_104203_ = 0.7f;
    }
}

