/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.client.network;

import com.google.gson.JsonElement;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import ydmsama.hundred_years_war.client.freecam.config.keys.HotKeyManager;
import ydmsama.hundred_years_war.client.freecam.selection.SelectionHandler;
import ydmsama.hundred_years_war.client.freecam.ui.RelationUI;
import ydmsama.hundred_years_war.client.freecam.ui.TeamApplicationsUI;
import ydmsama.hundred_years_war.client.freecam.ui.TeamCreateUI;
import ydmsama.hundred_years_war.client.freecam.ui.TeamInfoUI;
import ydmsama.hundred_years_war.client.freecam.ui.TeamJoinUI;
import ydmsama.hundred_years_war.client.freecam.ui.TeamMembersUI;
import ydmsama.hundred_years_war.client.freecam.ui.TeamRelationUI;
import ydmsama.hundred_years_war.client.freecam.ui.TeamUI;
import ydmsama.hundred_years_war.client.freecam.ui.manual.ManualUI;
import ydmsama.hundred_years_war.client.freecam.ui.wheel.CommandWheelHandler;
import ydmsama.hundred_years_war.client.freecam.ui.wheel.CommandWheelTree;
import ydmsama.hundred_years_war.client.freecam.ui.wheel.CommandWheelUI;
import ydmsama.hundred_years_war.client.gui.BuildingPlaceScreen;
import ydmsama.hundred_years_war.client.render.BuildingPreviewRenderer;
import ydmsama.hundred_years_war.client.render.PlacedBuildingRenderer;
import ydmsama.hundred_years_war.client.screen.WarehouseControlScreen;
import ydmsama.hundred_years_war.client.utils.ClientCreativeModeSettings;
import ydmsama.hundred_years_war.client.utils.ClientRelationHelper;
import ydmsama.hundred_years_war.main.blocks.warehouse.WarehouseControlScreenHandler;
import ydmsama.hundred_years_war.main.blocks.workstation.BreedingWorkstationScreenHandler;
import ydmsama.hundred_years_war.main.blocks.workstation.CraftingWorkstationInventoryScreenHandler;
import ydmsama.hundred_years_war.main.blocks.workstation.CraftingWorkstationScreenHandler;
import ydmsama.hundred_years_war.main.blocks.workstation.FarmingWorkstationScreenHandler;
import ydmsama.hundred_years_war.main.blocks.workstation.FishingWorkstationScreenHandler;
import ydmsama.hundred_years_war.main.blocks.workstation.LumberWorkstationScreenHandler;
import ydmsama.hundred_years_war.main.blocks.workstation.MiningWorkstationScreenHandler;
import ydmsama.hundred_years_war.main.blocks.workstation.TransportOrderScreenHandler;
import ydmsama.hundred_years_war.main.blocks.workstation.TransportWorkstationScreenHandler;
import ydmsama.hundred_years_war.main.data.TransportData;
import ydmsama.hundred_years_war.main.entity.entities.siege.PositionAttackable;
import ydmsama.hundred_years_war.main.entity.entities.siege.UnloadPassengerable;
import ydmsama.hundred_years_war.main.entity.utils.AttackStrategy;
import ydmsama.hundred_years_war.main.network.ServerPacketHandler;
import ydmsama.hundred_years_war.main.network.packets.AttackStrategyUpdatePacket;
import ydmsama.hundred_years_war.main.network.packets.BombardPositionPacket;
import ydmsama.hundred_years_war.main.network.packets.BreedingWorkstationRangePacket;
import ydmsama.hundred_years_war.main.network.packets.BuildingToolActionPacket;
import ydmsama.hundred_years_war.main.network.packets.ClearFollowTargetPacket;
import ydmsama.hundred_years_war.main.network.packets.ClearSelectionPacket;
import ydmsama.hundred_years_war.main.network.packets.CommandPacket;
import ydmsama.hundred_years_war.main.network.packets.CommandStaffAddEntityPacket;
import ydmsama.hundred_years_war.main.network.packets.CommandStaffAttackPacket;
import ydmsama.hundred_years_war.main.network.packets.CommandStaffFollowPacket;
import ydmsama.hundred_years_war.main.network.packets.CommandStaffMovePacket;
import ydmsama.hundred_years_war.main.network.packets.CraftingRecipeUpdatePacket;
import ydmsama.hundred_years_war.main.network.packets.CreativeSettingsUpdatePacket;
import ydmsama.hundred_years_war.main.network.packets.FarmingWorkstationRangePacket;
import ydmsama.hundred_years_war.main.network.packets.FishingWorkstationRangePacket;
import ydmsama.hundred_years_war.main.network.packets.FollowTargetPacket;
import ydmsama.hundred_years_war.main.network.packets.FormationSelectionUpdatePacket;
import ydmsama.hundred_years_war.main.network.packets.FreecamTogglePacket;
import ydmsama.hundred_years_war.main.network.packets.LumberWorkstationRangePacket;
import ydmsama.hundred_years_war.main.network.packets.MiningWorkstationRangePacket;
import ydmsama.hundred_years_war.main.network.packets.MoveAttackCommandPacket;
import ydmsama.hundred_years_war.main.network.packets.MoveCommandPacket;
import ydmsama.hundred_years_war.main.network.packets.OpenCraftingInventoryPacket;
import ydmsama.hundred_years_war.main.network.packets.OpenCraftingRecipePacket;
import ydmsama.hundred_years_war.main.network.packets.OpenPlayerSupplyPacket;
import ydmsama.hundred_years_war.main.network.packets.OpenTransportOrderAckPacket;
import ydmsama.hundred_years_war.main.network.packets.OpenTransportOrderSyncPacket;
import ydmsama.hundred_years_war.main.network.packets.OpenWorkstationAckPacket;
import ydmsama.hundred_years_war.main.network.packets.OpenWorkstationSyncPacket;
import ydmsama.hundred_years_war.main.network.packets.PatrolPointPacket;
import ydmsama.hundred_years_war.main.network.packets.PatrolPointsRequestPacket;
import ydmsama.hundred_years_war.main.network.packets.PlacedBuildingSyncPacket;
import ydmsama.hundred_years_war.main.network.packets.PlayerSettingsSyncPacket;
import ydmsama.hundred_years_war.main.network.packets.PlayerSupplyConvertPacket;
import ydmsama.hundred_years_war.main.network.packets.RecruitmentConfigUpdatePacket;
import ydmsama.hundred_years_war.main.network.packets.RecruitmentDataRequestPacket;
import ydmsama.hundred_years_war.main.network.packets.RecruitmentDataResponsePacket;
import ydmsama.hundred_years_war.main.network.packets.RelationRequestPacket;
import ydmsama.hundred_years_war.main.network.packets.RelationResponsePacket;
import ydmsama.hundred_years_war.main.network.packets.RelationSyncPacket;
import ydmsama.hundred_years_war.main.network.packets.RelationUpdatePacket;
import ydmsama.hundred_years_war.main.network.packets.SelectionPacket;
import ydmsama.hundred_years_war.main.network.packets.SiegeModeTogglePacket;
import ydmsama.hundred_years_war.main.network.packets.SpawnPointConfigPacket;
import ydmsama.hundred_years_war.main.network.packets.SquadCreatePacket;
import ydmsama.hundred_years_war.main.network.packets.SquadSelectPacket;
import ydmsama.hundred_years_war.main.network.packets.SupplyRangeTogglePacket;
import ydmsama.hundred_years_war.main.network.packets.SupplyTransferPacket;
import ydmsama.hundred_years_war.main.network.packets.TargetUpdatePacket;
import ydmsama.hundred_years_war.main.network.packets.TeamApplicationsRequestPacket;
import ydmsama.hundred_years_war.main.network.packets.TeamApplicationsResponsePacket;
import ydmsama.hundred_years_war.main.network.packets.TeamCreateRequestPacket;
import ydmsama.hundred_years_war.main.network.packets.TeamCreateResponsePacket;
import ydmsama.hundred_years_war.main.network.packets.TeamInfoRequestPacket;
import ydmsama.hundred_years_war.main.network.packets.TeamInfoResponsePacket;
import ydmsama.hundred_years_war.main.network.packets.TeamJoinRequestPacket;
import ydmsama.hundred_years_war.main.network.packets.TeamLeaveRequestPacket;
import ydmsama.hundred_years_war.main.network.packets.TeamListRequestPacket;
import ydmsama.hundred_years_war.main.network.packets.TeamListResponsePacket;
import ydmsama.hundred_years_war.main.network.packets.TeamManageRequestPacket;
import ydmsama.hundred_years_war.main.network.packets.TeamMembersRequestPacket;
import ydmsama.hundred_years_war.main.network.packets.TeamMembersResponsePacket;
import ydmsama.hundred_years_war.main.network.packets.TeamRelationRequestPacket;
import ydmsama.hundred_years_war.main.network.packets.TeamRelationResponsePacket;
import ydmsama.hundred_years_war.main.network.packets.TeamRelationUpdatePacket;
import ydmsama.hundred_years_war.main.network.packets.TemplateDataRequestPacket;
import ydmsama.hundred_years_war.main.network.packets.TemplateListRequestPacket;
import ydmsama.hundred_years_war.main.network.packets.TransportActionPacket;
import ydmsama.hundred_years_war.main.network.packets.TransportDataUpdatePacket;
import ydmsama.hundred_years_war.main.network.packets.UnbindTransportOrderPacket;
import ydmsama.hundred_years_war.main.network.packets.UnloadPassengersPacket;
import ydmsama.hundred_years_war.main.network.packets.UpdateTemplatePropertiesPacket;
import ydmsama.hundred_years_war.main.network.packets.warehouse.WarehouseDataSyncPacket;
import ydmsama.hundred_years_war.main.network.packets.warehouse.WarehouseItemDepositPacket;
import ydmsama.hundred_years_war.main.network.packets.warehouse.WarehouseItemRequestPacket;
import ydmsama.hundred_years_war.main.network.packets.warehouse.WarehouseRangeUpdatePacket;
import ydmsama.hundred_years_war.main.network.packets.warehouse.WarehouseSortPacket;
import ydmsama.hundred_years_war.main.recruitment.PlayerRecruitmentData;
import ydmsama.hundred_years_war.main.spawn.SpawnPointScreenHandler;
import ydmsama.hundred_years_war.main.supply.SupplyPointScreenHandler;
import ydmsama.hundred_years_war.main.template.TemplateManager;
import ydmsama.hundred_years_war.main.template.TemplateMetadata;

public class ClientPacketHandler {
    public static final ResourceLocation TRANSPORT_ACTION_PACKET = new ResourceLocation("hundred_years_war", "transport_action");
    private static RelationResponsePacket latestRelationData;
    private static TeamInfoResponsePacket latestTeamData;
    private static TeamListResponsePacket latestTeamListData;
    private static TeamApplicationsResponsePacket latestTeamApplicationsData;
    private static TeamMembersResponsePacket latestTeamMembersData;
    private static TeamRelationResponsePacket latestTeamRelationData;
    private static Map<String, RecruitmentDataResponsePacket> latestRecruitmentData;

    public static RelationResponsePacket getLatestRelationData() {
        return latestRelationData;
    }

    public static TeamInfoResponsePacket getLatestTeamData() {
        return latestTeamData;
    }

    public static TeamListResponsePacket getLatestTeamListData() {
        return latestTeamListData;
    }

    public static TeamApplicationsResponsePacket getLatestTeamApplicationsData() {
        return latestTeamApplicationsData;
    }

    public static TeamMembersResponsePacket getLatestTeamMembersData() {
        return latestTeamMembersData;
    }

    public static TeamRelationResponsePacket getLatestTeamRelationData() {
        return latestTeamRelationData;
    }

    public static RecruitmentDataResponsePacket getLatestRecruitmentData(String categoryId) {
        return latestRecruitmentData.get(categoryId);
    }

    public static Map<String, RecruitmentDataResponsePacket> getAllRecruitmentData() {
        return latestRecruitmentData;
    }

    public static void onRelationResponse(RelationResponsePacket packet) {
        latestRelationData = packet;
        Minecraft mc = Minecraft.m_91087_();
        mc.execute(() -> {
            Screen patt5491$temp = mc.f_91080_;
            if (patt5491$temp instanceof RelationUI) {
                RelationUI ui = (RelationUI)patt5491$temp;
                ui.onRelationDataUpdate(packet);
            }
        });
    }

    public static void onTeamInfoResponse(TeamInfoResponsePacket packet) {
        latestTeamData = packet;
        Minecraft mc = Minecraft.m_91087_();
        mc.execute(() -> {
            Screen patt5855$temp = mc.f_91080_;
            if (patt5855$temp instanceof TeamUI) {
                TeamUI ui = (TeamUI)patt5855$temp;
                ui.onTeamDataUpdate(packet);
            }
        });
    }

    public static void onTeamCreateResponse(TeamCreateResponsePacket packet) {
        Minecraft mc = Minecraft.m_91087_();
        mc.execute(() -> {
            Screen patt6183$temp = mc.f_91080_;
            if (patt6183$temp instanceof TeamCreateUI) {
                TeamCreateUI ui = (TeamCreateUI)patt6183$temp;
                ui.onTeamCreateResponse(packet);
            }
        });
    }

    public static void onRelationSync(RelationSyncPacket packet) {
        Minecraft.m_91087_().execute(() -> {
            ClientRelationHelper.getInstance().updateEnemyRelations(packet.getEnemyUUIDs());
            ClientRelationHelper.getInstance().updateSharedControlRelations(packet.getSharedControlUUIDs());
        });
    }

    public static void onTeamListResponse(TeamListResponsePacket packet) {
        latestTeamListData = packet;
        Minecraft mc = Minecraft.m_91087_();
        mc.execute(() -> {
            Screen patt6938$temp = mc.f_91080_;
            if (patt6938$temp instanceof TeamJoinUI) {
                TeamJoinUI ui = (TeamJoinUI)patt6938$temp;
                ui.onTeamListUpdate(packet);
            }
        });
    }

    public static void onTeamApplicationsResponse(TeamApplicationsResponsePacket packet) {
        latestTeamApplicationsData = packet;
        Minecraft mc = Minecraft.m_91087_();
        mc.execute(() -> {
            Screen patt7334$temp = mc.f_91080_;
            if (patt7334$temp instanceof TeamApplicationsUI) {
                TeamApplicationsUI ui = (TeamApplicationsUI)patt7334$temp;
                ui.onApplicationsDataUpdate(packet);
            }
        });
    }

    public static void onTeamMembersResponse(TeamMembersResponsePacket packet) {
        latestTeamMembersData = packet;
        System.out.println("\u6536\u5230\u56e2\u961f\u6210\u5458\u54cd\u5e94\u5305\uff1a" + packet.getTeamName() + ", \u6210\u5458\u6570\u91cf: " + packet.getMembers().size());
        packet.getMembers().forEach(m -> System.out.println("\u6210\u5458: " + m.getPlayerName() + ", \u89d2\u8272: " + m.getRole()));
        Minecraft mc = Minecraft.m_91087_();
        mc.execute(() -> {
            Screen patt7988$temp = mc.f_91080_;
            if (patt7988$temp instanceof TeamInfoUI) {
                TeamInfoUI ui = (TeamInfoUI)patt7988$temp;
                ui.onMembersDataUpdate(packet);
            } else {
                Screen patt8099$temp = mc.f_91080_;
                if (patt8099$temp instanceof TeamMembersUI) {
                    TeamMembersUI ui = (TeamMembersUI)patt8099$temp;
                    ui.updateMembersFromResponse(packet);
                }
            }
        });
    }

    public static void onTeamRelationResponse(TeamRelationResponsePacket packet) {
        latestTeamRelationData = packet;
        Minecraft mc = Minecraft.m_91087_();
        mc.execute(() -> {
            Screen patt8487$temp = mc.f_91080_;
            if (patt8487$temp instanceof TeamRelationUI) {
                TeamRelationUI ui = (TeamRelationUI)patt8487$temp;
                ui.onTeamRelationDataUpdate(packet);
            }
        });
    }

    public static void onPlayerSettingsSync(PlayerSettingsSyncPacket packet) {
        Minecraft mc = Minecraft.m_91087_();
        mc.execute(() -> {
            CommandWheelHandler.getInstance().applyServerFormation(packet.getCurrentFormation(), packet.getLastNonNoneFormation());
            if (mc.f_91074_ != null) {
                PlayerRecruitmentData.setPlayerSelection((Player)mc.f_91074_, packet.getSelection());
            }
        });
    }

    public static void onRecruitmentDataResponse(RecruitmentDataResponsePacket packet) {
        latestRecruitmentData.put(packet.getCategoryId(), packet);
        Minecraft mc = Minecraft.m_91087_();
        mc.execute(() -> {
            System.out.println("\u6536\u5230\u62db\u52df\u6570\u636e: " + packet.getCategoryId() + ", \u5175\u79cd\u6570\u91cf: " + packet.getUnitTypes().size());
            Screen patt9621$temp = mc.f_91080_;
            if (patt9621$temp instanceof CommandWheelUI) {
                CommandWheelUI wheelUI = (CommandWheelUI)patt9621$temp;
                CommandWheelTree tree = wheelUI.getCommandWheelTree();
                tree.refreshRecruitmentMenu(packet.getCategoryId());
                wheelUI.refreshUI();
            }
        });
    }

    public static void onOpenManual() {
        Minecraft mc = Minecraft.m_91087_();
        mc.execute(() -> mc.m_91152_((Screen)new ManualUI()));
    }

    public static void onClearFollowTarget(ClearFollowTargetPacket packet) {
        Minecraft.m_91087_().execute(() -> {
            Entity entity = ClientPacketHandler.getEntityByUUID(packet.getEntityUUID());
            if (entity != null) {
                SelectionHandler.getInstance().clearAllFollowTargets(entity);
            }
        });
    }

    public static void onClearSelection(ClearSelectionPacket packet) {
        Minecraft.m_91087_().execute(() -> {
            Entity entity = ClientPacketHandler.getEntityByUUID(packet.getEntityUUID());
            if (entity != null) {
                SelectionHandler.getInstance().getSelectedEntities().remove(entity);
                SelectionHandler.getInstance().getCombinedTargetMap().remove(entity);
                SelectionHandler.getInstance().getPatrolPointsMap().remove(entity);
            }
        });
    }

    public static void onOpenTransportOrderSync(OpenTransportOrderSyncPacket packet) {
        Minecraft mc = Minecraft.m_91087_();
        mc.execute(() -> {
            TransportOrderScreenHandler.setClientItemStack(packet.getItemStack());
            ServerPacketHandler.sendToServer(new OpenTransportOrderAckPacket(packet.getRequestId()));
        });
    }

    public static void onWarehouseDataSync(WarehouseDataSyncPacket packet) {
        Minecraft mc = Minecraft.m_91087_();
        mc.execute(() -> {
            WarehouseControlScreen warehouseScreen;
            Screen patt11821$temp = mc.f_91080_;
            if (patt11821$temp instanceof WarehouseControlScreen && (warehouseScreen = (WarehouseControlScreen)patt11821$temp).getMenu() != null && warehouseScreen.getMenu().getBlockPos().equals((Object)packet.getBlockPos())) {
                warehouseScreen.updateItemData(packet.getDisplayItems(), packet.getTotalCapacity(), packet.getUsedCapacity());
                warehouseScreen.updateSortState(packet.getSortType(), packet.isSortAscending());
            }
        });
    }

    public static void onTemplateDataResponse(String templateId, BlockPos size, BlockPos entrance, Map<BlockPos, BlockState> blocks, float playerYaw) {
        Minecraft.m_91087_().execute(() -> BuildingPreviewRenderer.receiveTemplateData(templateId, size, entrance, blocks, playerYaw));
    }

    public static void onTemplateListResponse(List<TemplateMetadata> metadataList) {
        Minecraft mc = Minecraft.m_91087_();
        mc.execute(() -> {
            Screen patt13314$temp;
            TemplateManager manager = TemplateManager.getInstance();
            if (manager != null) {
                manager.replaceMetadataFromServer(metadataList);
            }
            if ((patt13314$temp = mc.f_91080_) instanceof BuildingPlaceScreen) {
                BuildingPlaceScreen screen = (BuildingPlaceScreen)patt13314$temp;
                screen.onTemplateListUpdated();
            }
        });
    }

    public static void onPlacedBuildingSync(PlacedBuildingSyncPacket packet) {
        try {
            long chunkOrFlag = packet.getChunkOrFlag();
            if (chunkOrFlag == -1L) {
                boolean isRemoval = packet.isRemoval();
                if (isRemoval) {
                    UUID buildingId = packet.getRemovalBuildingId();
                    Minecraft.m_91087_().execute(() -> {
                        PlacedBuildingRenderer.getInstance().removeBuilding(buildingId);
                        PlacedBuildingRenderer.getInstance().forceRefresh();
                    });
                } else {
                    List<PlacedBuildingSyncPacket.BuildingData> singleBuilding = packet.getBuildings();
                    Minecraft.m_91087_().execute(() -> {
                        for (PlacedBuildingSyncPacket.BuildingData building : singleBuilding) {
                            PlacedBuildingRenderer.getInstance().addBuilding(building);
                        }
                        PlacedBuildingRenderer.getInstance().forceRefresh();
                    });
                }
            } else {
                List<PlacedBuildingSyncPacket.BuildingData> buildings = packet.getBuildings();
                Minecraft.m_91087_().execute(() -> {
                    for (PlacedBuildingSyncPacket.BuildingData building : buildings) {
                        PlacedBuildingRenderer.getInstance().addBuilding(building);
                    }
                    PlacedBuildingRenderer.getInstance().forceRefresh();
                });
            }
        }
        catch (Exception e) {
            System.err.println("Error handling PlacedBuildingSyncPacket: " + e.getMessage());
            e.printStackTrace();
        }
    }

    public static void onOpenWorkstationSync(OpenWorkstationSyncPacket packet) {
        Minecraft.m_91087_().execute(() -> {
            switch (packet.getType()) {
                case FARMING: {
                    FarmingWorkstationScreenHandler.setClientBlockPos(packet.getPos());
                    break;
                }
                case MINING: {
                    MiningWorkstationScreenHandler.setClientBlockPos(packet.getPos());
                    break;
                }
                case TRANSPORT: {
                    TransportWorkstationScreenHandler.setClientBlockPos(packet.getPos());
                    break;
                }
                case FISHING: {
                    FishingWorkstationScreenHandler.setClientBlockPos(packet.getPos());
                    break;
                }
                case LUMBER: {
                    LumberWorkstationScreenHandler.setClientBlockPos(packet.getPos());
                    break;
                }
                case CRAFTING: {
                    CraftingWorkstationScreenHandler.setClientBlockPos(packet.getPos());
                    CraftingWorkstationInventoryScreenHandler.setClientBlockPos(packet.getPos());
                    break;
                }
                case BREEDING: {
                    BreedingWorkstationScreenHandler.setClientBlockPos(packet.getPos());
                    break;
                }
                case WAREHOUSE: {
                    WarehouseControlScreenHandler.setClientBlockPos(packet.getPos());
                    break;
                }
                case SUPPLY_POINT: {
                    SupplyPointScreenHandler.setClientBlockPos(packet.getPos());
                    break;
                }
                case SPAWN_POINT: {
                    SpawnPointScreenHandler.setClientBlockPos(packet.getPos());
                }
            }
            OpenWorkstationAckPacket ackPacket = new OpenWorkstationAckPacket(packet.getRequestId());
            ServerPacketHandler.INSTANCE.sendToServer((Object)ackPacket);
        });
    }

    public static void onCreativeSettingsSync(boolean summonFriendly, boolean controlAllUnits) {
        Minecraft.m_91087_().execute(() -> ClientCreativeModeSettings.applySync(summonFriendly, controlAllUnits));
    }

    public static void sendSelectionPacket(List<UUID> selectedEntityIds) {
        SelectionPacket packet = new SelectionPacket(selectedEntityIds);
        ServerPacketHandler.INSTANCE.sendToServer((Object)packet);
    }

    public static void sendCommandPacket(String command, boolean queueMode) {
        SelectionHandler.clearAllRenderingIfNotQueued();
        SelectionHandler.clearPatrolPoints();
        CommandPacket packet = new CommandPacket(command, queueMode);
        ServerPacketHandler.INSTANCE.sendToServer((Object)packet);
    }

    public static void sendMoveCommandPacket(HitResult result, boolean queueMode, boolean formationMode) {
        SelectionHandler.clearAllRenderingIfNotQueued();
        SelectionHandler.clearPatrolPoints();
        List<Entity> selectedEntities = SelectionHandler.getInstance().getSelectedEntities();
        BlockHitResult bhr = (BlockHitResult)result;
        if (!formationMode) {
            for (Entity e : selectedEntities) {
                SelectionHandler.getInstance().updateTargetPos(e, bhr.m_82425_());
            }
        } else {
            for (Entity e : selectedEntities) {
                SelectionHandler.getInstance().updateFormTargetPos(e, bhr.m_82425_());
            }
        }
        if (selectedEntities.size() == 1) {
            formationMode = false;
        }
        String formationType = formationMode ? CommandWheelHandler.getInstance().getCurrentFormation() : "loose";
        MoveCommandPacket packet = new MoveCommandPacket(bhr, queueMode, formationMode, formationType);
        ServerPacketHandler.INSTANCE.sendToServer((Object)packet);
    }

    public static void sendTargetUpdatePacket(HitResult result, boolean queueMode) {
        SelectionHandler.clearAllRenderingIfNotQueued();
        SelectionHandler.clearPatrolPoints();
        if (result instanceof EntityHitResult) {
            EntityHitResult ehr = (EntityHitResult)result;
            Entity target = ehr.m_82443_();
            UUID targetUUID = target.m_20148_();
            List<Entity> selected = SelectionHandler.getInstance().getSelectedEntities();
            for (Entity e : selected) {
                SelectionHandler.getInstance().updateTarget(e, target);
            }
            TargetUpdatePacket packet = new TargetUpdatePacket(targetUUID, queueMode);
            ServerPacketHandler.INSTANCE.sendToServer((Object)packet);
        }
    }

    public static void sendMoveAttackCommandPacket(HitResult result, boolean queueMode, boolean formationMode) {
        SelectionHandler.clearAllRenderingIfNotQueued();
        SelectionHandler.clearPatrolPoints();
        List<Entity> selected = SelectionHandler.getInstance().getSelectedEntities();
        BlockHitResult bhr = (BlockHitResult)result;
        if (!formationMode) {
            for (Entity e : selected) {
                SelectionHandler.getInstance().updateAttackTargetPos(e, bhr.m_82425_());
            }
        } else {
            for (Entity e : selected) {
                SelectionHandler.getInstance().updateFormAttackTargetPos(e, bhr.m_82425_());
            }
        }
        String formationType = formationMode ? CommandWheelHandler.getInstance().getCurrentFormation() : "loose";
        MoveAttackCommandPacket packet = new MoveAttackCommandPacket(bhr, queueMode, formationMode, formationType);
        ServerPacketHandler.INSTANCE.sendToServer((Object)packet);
    }

    public static void sendPatrolPointPacket(BlockHitResult hitResult, boolean queueMode) {
        if (!queueMode) {
            SelectionHandler.clearAllRenderingIfNotQueued();
        } else {
            SelectionHandler.getInstance().clearSelectedNonPatrolTargets();
        }
        List<Entity> selected = SelectionHandler.getInstance().getSelectedEntities();
        for (Entity e : selected) {
            SelectionHandler.getInstance().updatePatrolPoint(e, hitResult.m_82425_());
        }
        PatrolPointPacket packet = new PatrolPointPacket(hitResult, queueMode);
        ServerPacketHandler.INSTANCE.sendToServer((Object)packet);
    }

    public static void sendFollowTargetPacket(EntityHitResult hitResult, boolean queueMode) {
        SelectionHandler.clearAllRenderingIfNotQueued();
        SelectionHandler.clearPatrolPoints();
        List<Entity> selected = SelectionHandler.getInstance().getSelectedEntities();
        for (Entity e : selected) {
            SelectionHandler.getInstance().updateFollowTarget(e, hitResult.m_82443_());
        }
        FollowTargetPacket packet = new FollowTargetPacket(hitResult.m_82443_().m_20148_(), queueMode);
        ServerPacketHandler.INSTANCE.sendToServer((Object)packet);
    }

    public static void sendPatrolPointsRequestPacket(Entity selectedEntity) {
        PatrolPointsRequestPacket packet = new PatrolPointsRequestPacket(selectedEntity.m_20148_());
        ServerPacketHandler.INSTANCE.sendToServer((Object)packet);
    }

    public static void sendSquadCreatePacket(int numberPressed) {
        SquadCreatePacket packet = new SquadCreatePacket(numberPressed);
        ServerPacketHandler.INSTANCE.sendToServer((Object)packet);
    }

    public static void sendSelectSquadPacket(int numberPressed) {
        SquadSelectPacket packet = new SquadSelectPacket(numberPressed);
        ServerPacketHandler.INSTANCE.sendToServer((Object)packet);
    }

    public static void sendCommandStaffAddEntityPacket(UUID staffUUID, UUID entityUUID, boolean isAdding) {
        CommandStaffAddEntityPacket packet = new CommandStaffAddEntityPacket(staffUUID, entityUUID, isAdding);
        ServerPacketHandler.INSTANCE.sendToServer((Object)packet);
    }

    public static void sendCommandStaffMovePacket(UUID staffUUID, BlockPos targetPos, int priority) {
        ClientPacketHandler.sendCommandStaffMovePacket(staffUUID, targetPos, priority, false);
    }

    public static void sendCommandStaffMovePacket(UUID staffUUID, BlockPos targetPos, int priority, boolean formationMode) {
        String formationType = formationMode ? CommandWheelHandler.getInstance().getCurrentFormation() : "loose";
        CommandStaffMovePacket packet = new CommandStaffMovePacket(staffUUID, targetPos, priority, formationMode, formationType);
        ServerPacketHandler.INSTANCE.sendToServer((Object)packet);
    }

    public static void sendCommandStaffFollowPacket(UUID staffUUID) {
        CommandStaffFollowPacket packet = new CommandStaffFollowPacket(staffUUID);
        ServerPacketHandler.INSTANCE.sendToServer((Object)packet);
    }

    public static void sendCommandStaffAttackPacket(UUID staffUUID, UUID targetEntityUUID) {
        CommandStaffAttackPacket packet = new CommandStaffAttackPacket(staffUUID, targetEntityUUID);
        ServerPacketHandler.INSTANCE.sendToServer((Object)packet);
    }

    public static void requestRelationData() {
        ServerPacketHandler.INSTANCE.sendToServer((Object)new RelationRequestPacket());
    }

    public static void requestTeamData() {
        ServerPacketHandler.INSTANCE.sendToServer((Object)new TeamInfoRequestPacket());
    }

    public static void sendRelationUpdate(RelationUpdatePacket updatePacket) {
        ServerPacketHandler.INSTANCE.sendToServer((Object)updatePacket);
    }

    public static void requestTeamList() {
        ServerPacketHandler.INSTANCE.sendToServer((Object)new TeamListRequestPacket());
    }

    public static void requestTeamApplications() {
        ServerPacketHandler.INSTANCE.sendToServer((Object)new TeamApplicationsRequestPacket());
    }

    public static void requestTeamMembers(UUID teamUUID) {
        ServerPacketHandler.INSTANCE.sendToServer((Object)new TeamMembersRequestPacket(teamUUID));
    }

    public static void requestTeamRelationData(UUID teamUUID) {
        ServerPacketHandler.INSTANCE.sendToServer((Object)new TeamRelationRequestPacket(teamUUID));
    }

    public static void sendTeamRelationUpdate(TeamRelationUpdatePacket updatePacket) {
        ServerPacketHandler.INSTANCE.sendToServer((Object)updatePacket);
    }

    public static void requestCreateTeam(String name) {
        ServerPacketHandler.INSTANCE.sendToServer((Object)new TeamCreateRequestPacket(name));
    }

    public static void requestJoinTeam(UUID uuid) {
        ServerPacketHandler.INSTANCE.sendToServer((Object)new TeamJoinRequestPacket(uuid));
    }

    public static void requestLeaveTeam(UUID uuid) {
        ServerPacketHandler.INSTANCE.sendToServer((Object)new TeamLeaveRequestPacket(uuid));
    }

    public static void requestTeamManage(UUID teamUUID, String action, UUID targetUUID) {
        ServerPacketHandler.INSTANCE.sendToServer((Object)new TeamManageRequestPacket(teamUUID, action, targetUUID));
    }

    public static void sendTeamMemberRolesUpdate(UUID teamUUID, Map<UUID, TeamMembersResponsePacket.Member.Role> changes) {
        changes.forEach((uuid, role) -> {
            String action = switch (role) {
                default -> throw new IncompatibleClassChangeError();
                case TeamMembersResponsePacket.Member.Role.OWNER -> "set_owner";
                case TeamMembersResponsePacket.Member.Role.ADMIN -> "promote";
                case TeamMembersResponsePacket.Member.Role.MEMBER -> "demote";
            };
            ClientPacketHandler.requestTeamManage(teamUUID, action, uuid);
        });
    }

    public static void sendSiegeModeTogglePacket(boolean newState) {
        SelectionHandler.clearPatrolPoints();
        ServerPacketHandler.INSTANCE.sendToServer((Object)new SiegeModeTogglePacket(newState));
    }

    public static void sendBombardPositionPacket(Vec3 pos) {
        boolean queue = HotKeyManager.getQueueMode();
        if (!queue) {
            SelectionHandler.clearAllRenderingIfNotQueued();
        }
        SelectionHandler.clearPatrolPoints();
        if (pos != null) {
            List<Entity> sel = SelectionHandler.getInstance().getSelectedEntities();
            for (Entity e : sel) {
                if (!(e instanceof PositionAttackable)) continue;
                BlockPos bp = new BlockPos((int)pos.f_82479_, (int)pos.f_82480_, (int)pos.f_82481_);
                SelectionHandler.getInstance().updateBombardTarget(e, bp);
            }
        } else {
            SelectionHandler.getInstance().clearSelectedBombardTargets();
        }
        ServerPacketHandler.INSTANCE.sendToServer((Object)new BombardPositionPacket(pos, pos == null, queue));
    }

    public static void sendUnloadPassengersPacket(Vec3 position) {
        boolean queueMode = HotKeyManager.getQueueMode();
        if (!queueMode) {
            SelectionHandler.clearAllRenderingIfNotQueued();
        }
        SelectionHandler.clearPatrolPoints();
        if (position != null) {
            List<Entity> selectedEntities = SelectionHandler.getInstance().getSelectedEntities();
            for (Entity entity : selectedEntities) {
                if (!(entity instanceof UnloadPassengerable)) continue;
                BlockPos unloadTarget = BlockPos.m_274446_((Position)position);
                SelectionHandler.getInstance().updateUnloadTarget(entity, unloadTarget);
            }
        } else {
            SelectionHandler.getInstance().clearSelectedUnloadTargets();
        }
        ServerPacketHandler.INSTANCE.sendToServer((Object)new UnloadPassengersPacket(position, position == null, queueMode));
    }

    public static void requestRecruitmentData(String categoryId) {
        RecruitmentDataRequestPacket packet = categoryId != null ? new RecruitmentDataRequestPacket(categoryId) : new RecruitmentDataRequestPacket();
        ServerPacketHandler.INSTANCE.sendToServer((Object)packet);
    }

    public static void sendRecruitmentConfigUpdate(String categoryId, String unitTypeId, int level) {
        RecruitmentConfigUpdatePacket packet = new RecruitmentConfigUpdatePacket(categoryId, unitTypeId, level);
        ServerPacketHandler.INSTANCE.sendToServer((Object)packet);
    }

    public static void sendFormationSelectionUpdate(String currentFormation, String lastNonNoneFormation) {
        FormationSelectionUpdatePacket packet = new FormationSelectionUpdatePacket(currentFormation, lastNonNoneFormation);
        ServerPacketHandler.INSTANCE.sendToServer((Object)packet);
    }

    public static void sendAttackStrategyUpdate(AttackStrategy strategy) {
        AttackStrategyUpdatePacket packet = new AttackStrategyUpdatePacket(strategy.getId());
        ServerPacketHandler.INSTANCE.sendToServer((Object)packet);
    }

    public static void sendCreativeSettingsUpdate(boolean summonFriendly, boolean controlAllUnits) {
        CreativeSettingsUpdatePacket packet = new CreativeSettingsUpdatePacket(summonFriendly, controlAllUnits);
        ServerPacketHandler.INSTANCE.sendToServer((Object)packet);
    }

    public static void sendLumberWorkstationRangePacket(BlockPos pos, int rangeLeft, int rangeRight, int rangeUp, boolean showRange) {
        LumberWorkstationRangePacket packet = new LumberWorkstationRangePacket(pos, rangeLeft, rangeRight, rangeUp, showRange);
        ServerPacketHandler.INSTANCE.sendToServer((Object)packet);
    }

    public static void sendFarmingWorkstationRangePacket(BlockPos pos, int rangeLeft, int rangeRight, int rangeUp, boolean showRange) {
        FarmingWorkstationRangePacket packet = new FarmingWorkstationRangePacket(pos, rangeLeft, rangeRight, rangeUp, showRange);
        ServerPacketHandler.INSTANCE.sendToServer((Object)packet);
    }

    public static void sendMiningWorkstationRangePacket(BlockPos pos, int rangeLeft, int rangeRight, int rangeUp, int rangeDown, boolean showRange) {
        MiningWorkstationRangePacket packet = new MiningWorkstationRangePacket(pos, rangeLeft, rangeRight, rangeUp, rangeDown, showRange);
        ServerPacketHandler.INSTANCE.sendToServer((Object)packet);
    }

    public static void sendBreedingWorkstationRangePacket(BlockPos pos, int rangeLeft, int rangeRight, int rangeUp, boolean showRange, int maxAnimals) {
        BreedingWorkstationRangePacket packet = new BreedingWorkstationRangePacket(pos, rangeLeft, rangeRight, rangeUp, showRange, maxAnimals);
        ServerPacketHandler.INSTANCE.sendToServer((Object)packet);
    }

    public static void sendFishingWorkstationRangePacket(BlockPos pos, int rangeLeft, int rangeRight, int rangeUp, int rangeDown, boolean showRange) {
        FishingWorkstationRangePacket packet = new FishingWorkstationRangePacket(pos, rangeLeft, rangeRight, rangeUp, rangeDown, showRange);
        ServerPacketHandler.INSTANCE.sendToServer((Object)packet);
    }

    public static void sendTransportActionPacket(boolean isMainHand) {
        TransportActionPacket packet = new TransportActionPacket(isMainHand);
        ServerPacketHandler.INSTANCE.sendToServer((Object)packet);
    }

    public static void sendTransportDataUpdate(BlockPos pos, TransportData transportData) {
        TransportDataUpdatePacket packet = new TransportDataUpdatePacket(pos, transportData);
        ServerPacketHandler.INSTANCE.sendToServer((Object)packet);
    }

    public static void sendUnbindTransportOrder() {
        UnbindTransportOrderPacket packet = new UnbindTransportOrderPacket();
        ServerPacketHandler.INSTANCE.sendToServer((Object)packet);
    }

    public static void sendOpenCraftingInventory(BlockPos pos) {
        ServerPacketHandler.INSTANCE.sendToServer((Object)new OpenCraftingInventoryPacket(pos));
    }

    public static void sendOpenCraftingRecipe(BlockPos pos) {
        ServerPacketHandler.INSTANCE.sendToServer((Object)new OpenCraftingRecipePacket(pos));
    }

    public static void sendCraftingRecipeUpdate(BlockPos pos, ItemStack[] recipeTemplate, ItemStack expectedOutput) {
        CraftingRecipeUpdatePacket packet = new CraftingRecipeUpdatePacket(pos, recipeTemplate, expectedOutput);
        ServerPacketHandler.INSTANCE.sendToServer((Object)packet);
    }

    public static void sendWarehouseItemRequest(BlockPos warehousePos, ItemStack requestItem, boolean shiftClick, boolean rightClick) {
        WarehouseItemRequestPacket packet = new WarehouseItemRequestPacket(warehousePos, requestItem, shiftClick, rightClick);
        ServerPacketHandler.INSTANCE.sendToServer((Object)packet);
    }

    public static void sendWarehouseSortChange(BlockPos warehousePos, boolean changeSortType, boolean changeSortOrder) {
        WarehouseSortPacket packet = new WarehouseSortPacket(warehousePos, changeSortType, changeSortOrder);
        ServerPacketHandler.INSTANCE.sendToServer((Object)packet);
    }

    public static void sendWarehouseRangeUpdate(BlockPos blockPos, int left, int right, int up, int down, boolean showRange) {
        WarehouseRangeUpdatePacket packet = new WarehouseRangeUpdatePacket(blockPos, left, right, up, down, showRange);
        ServerPacketHandler.INSTANCE.sendToServer((Object)packet);
    }

    public static void sendWarehouseItemDeposit(BlockPos warehousePos) {
        WarehouseItemDepositPacket packet = new WarehouseItemDepositPacket(warehousePos);
        ServerPacketHandler.INSTANCE.sendToServer((Object)packet);
    }

    public static void sendSupplyTransferPacket(BlockPos blockPos, double amount, boolean isDeposit) {
        SupplyTransferPacket packet = new SupplyTransferPacket(blockPos, amount, isDeposit);
        ServerPacketHandler.INSTANCE.sendToServer((Object)packet);
    }

    public static void sendPlayerSupplyConvertPacket() {
        PlayerSupplyConvertPacket packet = new PlayerSupplyConvertPacket();
        ServerPacketHandler.INSTANCE.sendToServer((Object)packet);
    }

    public static void sendOpenPlayerSupplyPacket() {
        OpenPlayerSupplyPacket packet = new OpenPlayerSupplyPacket();
        ServerPacketHandler.INSTANCE.sendToServer((Object)packet);
    }

    public static void sendSupplyRangeTogglePacket(BlockPos blockPos, boolean showRange) {
        SupplyRangeTogglePacket packet = new SupplyRangeTogglePacket(blockPos, showRange);
        ServerPacketHandler.INSTANCE.sendToServer((Object)packet);
    }

    public static void sendBuildingToolSwitchMode() {
        BuildingToolActionPacket packet = new BuildingToolActionPacket(BuildingToolActionPacket.Action.SWITCH_MODE, null, null);
        ServerPacketHandler.INSTANCE.sendToServer((Object)packet);
    }

    public static void sendBuildingToolSetPos(BuildingToolActionPacket.Action action, BlockPos pos) {
        BuildingToolActionPacket packet = new BuildingToolActionPacket(action, pos, null);
        ServerPacketHandler.INSTANCE.sendToServer((Object)packet);
    }

    public static void sendBuildingToolUndo(BuildingToolActionPacket.Action action) {
        BuildingToolActionPacket packet = new BuildingToolActionPacket(action, null, null);
        ServerPacketHandler.INSTANCE.sendToServer((Object)packet);
    }

    public static void sendBuildingToolSaveBuilding(String buildingName, String settings) {
        BuildingToolActionPacket packet = new BuildingToolActionPacket(BuildingToolActionPacket.Action.SAVE_BUILDING, null, buildingName + "|" + settings);
        ServerPacketHandler.INSTANCE.sendToServer((Object)packet);
    }

    public static void sendTemplateListRequest() {
        ServerPacketHandler.INSTANCE.sendToServer((Object)new TemplateListRequestPacket());
    }

    public static void sendTemplateDataRequest(String templateId) {
        TemplateDataRequestPacket packet = new TemplateDataRequestPacket(templateId);
        ServerPacketHandler.INSTANCE.sendToServer((Object)packet);
    }

    public static void sendBuildingToolPlaceBuilding(BlockPos pos, String templateName) {
        BuildingToolActionPacket packet = new BuildingToolActionPacket(BuildingToolActionPacket.Action.PLACE_BUILDING, pos, templateName + "|0");
        ServerPacketHandler.INSTANCE.sendToServer((Object)packet);
    }

    public static void sendBuildingToolPlaceBuilding(BlockPos pos, String templateName, int rotation) {
        BuildingToolActionPacket packet = new BuildingToolActionPacket(BuildingToolActionPacket.Action.PLACE_BUILDING, pos, templateName + "|" + rotation);
        ServerPacketHandler.INSTANCE.sendToServer((Object)packet);
    }

    public static void sendBuildingToolPlaceBuilding(BlockPos pos, String templateName, int rotation, long buildTime) {
        ClientPacketHandler.sendBuildingToolPlaceBuilding(pos, templateName, rotation, buildTime, false);
    }

    public static void sendBuildingToolPlaceBuilding(BlockPos pos, String templateName, int rotation, long buildTime, boolean generateConnectionLayer) {
        ClientPacketHandler.sendBuildingToolPlaceBuilding(pos, templateName, rotation, buildTime, generateConnectionLayer, false);
    }

    public static void sendBuildingToolPlaceBuilding(BlockPos pos, String templateName, int rotation, long buildTime, boolean generateConnectionLayer, boolean terrainCheck) {
        BuildingToolActionPacket packet = new BuildingToolActionPacket(BuildingToolActionPacket.Action.PLACE_BUILDING, pos, templateName + "|" + rotation + "|" + buildTime + "|" + generateConnectionLayer + "|" + terrainCheck);
        ServerPacketHandler.INSTANCE.sendToServer((Object)packet);
    }

    public static void sendBuildingToolPlaceholderOperation(boolean fill) {
        BuildingToolActionPacket packet = new BuildingToolActionPacket(BuildingToolActionPacket.Action.APPLY_PLACEHOLDER_OPERATION, null, fill ? "fill" : "clear");
        ServerPacketHandler.INSTANCE.sendToServer((Object)packet);
    }

    public static void sendSpawnPointConfig(BlockPos pos, SpawnPointConfigPacket.ConfigData data) {
        SpawnPointConfigPacket packet = new SpawnPointConfigPacket(pos, data);
        ServerPacketHandler.INSTANCE.sendToServer((Object)packet);
    }

    public static void sendSpawnPointConfigCommand(BlockPos pos, SpawnPointConfigPacket.Mode mode) {
        SpawnPointConfigPacket packet = new SpawnPointConfigPacket(pos, mode);
        ServerPacketHandler.INSTANCE.sendToServer((Object)packet);
    }

    public static void sendBuildingToolResetFillSelection() {
        BuildingToolActionPacket packet = new BuildingToolActionPacket(BuildingToolActionPacket.Action.RESET_FILL_SELECTION, null, null);
        ServerPacketHandler.INSTANCE.sendToServer((Object)packet);
    }

    public static void sendUpdateTemplateProperties(String templateId, boolean enableGeneration, int generationWeight, int connectionLayerDepth, int minGenerationHeight, int maxGenerationHeight, boolean generateOnSurface, Map<String, JsonElement> customAttributes) {
        UpdateTemplatePropertiesPacket packet = new UpdateTemplatePropertiesPacket(templateId, enableGeneration, generationWeight, connectionLayerDepth, minGenerationHeight, maxGenerationHeight, generateOnSurface, customAttributes);
        ServerPacketHandler.INSTANCE.sendToServer((Object)packet);
    }

    public static void sendFreecamTogglePacket(boolean enabled) {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.m_91403_() != null) {
            try {
                FreecamTogglePacket packet = new FreecamTogglePacket(enabled);
                ServerPacketHandler.INSTANCE.sendToServer((Object)packet);
            }
            catch (Exception e) {
                System.err.println("Failed to send freecam toggle packet: " + e.getMessage());
            }
        }
    }

    public static Entity getEntityByUUID(UUID uuid) {
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        if (level != null) {
            for (Entity e : level.m_104735_()) {
                if (!e.m_20148_().equals(uuid)) continue;
                return e;
            }
        }
        return null;
    }

    static {
        latestRecruitmentData = new HashMap<String, RecruitmentDataResponsePacket>();
    }
}

