/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.client.render;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ColorResolver;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.lighting.LevelLightEngine;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ydmsama.hundred_years_war.client.network.ClientPacketHandler;

public class BuildingPreviewRenderer {
    private static final Logger LOGGER = LoggerFactory.getLogger(BuildingPreviewRenderer.class);
    private static final Map<String, PreviewData> previewCache = new HashMap<String, PreviewData>();
    private static String currentTemplateId = null;
    private static PreviewData currentPreview = null;
    private static boolean isLoading = false;
    private static BlockPos previewPos = BlockPos.f_121853_;
    private static int rotation = 0;
    private static RenderCache currentRenderCache = null;
    private static int lastRotation = -1;
    private static String lastCacheKey = null;
    private static RenderMode currentRenderMode = RenderMode.CUTOUT;

    public static void setTemplate(String templateId) {
        if (templateId == null) {
            currentTemplateId = null;
            currentPreview = null;
            currentRenderCache = null;
            isLoading = false;
            return;
        }
        if (!templateId.equals(currentTemplateId)) {
            currentRenderCache = null;
            lastCacheKey = null;
        }
        if (templateId.equals(currentTemplateId)) {
            if (currentPreview == null && !isLoading) {
                BuildingPreviewRenderer.loadTemplate(templateId);
            }
            return;
        }
        currentTemplateId = templateId;
        currentPreview = null;
        isLoading = false;
        if (previewCache.containsKey(templateId)) {
            currentPreview = previewCache.get(templateId);
        } else {
            BuildingPreviewRenderer.loadTemplate(templateId);
        }
    }

    private static void loadTemplate(String templateId) {
        if (isLoading) {
            return;
        }
        isLoading = true;
        BuildingPreviewRenderer.requestTemplateFromServer(templateId);
    }

    private static void requestTemplateFromServer(String templateId) {
        ClientPacketHandler.sendTemplateDataRequest(templateId);
    }

    public static void receiveTemplateData(String templateId, BlockPos size, BlockPos entrance, Map<BlockPos, BlockState> blocks, float playerYaw) {
        PreviewData data = new PreviewData(blocks, size, entrance, playerYaw);
        previewCache.put(templateId, data);
        if (templateId.equals(currentTemplateId)) {
            currentPreview = data;
            currentRenderCache = null;
            lastCacheKey = null;
        }
        isLoading = false;
    }

    public static void receiveTemplateData(String templateId, BlockPos size, BlockPos entrance, Map<BlockPos, BlockState> blocks) {
        BuildingPreviewRenderer.receiveTemplateData(templateId, size, entrance, blocks, 0.0f);
    }

    public static void setPreviewPosition(BlockPos pos) {
        previewPos = pos;
    }

    public static void setRotation(int rot) {
        rotation = rot % 360;
        if (rotation != lastRotation) {
            currentRenderCache = null;
        }
    }

    public static void render(PoseStack poseStack, MultiBufferSource bufferSource, Vec3 cameraPos) {
        if (currentPreview == null || previewPos == null) {
            return;
        }
        Minecraft minecraft = Minecraft.m_91087_();
        BlockRenderDispatcher blockRenderer = minecraft.m_91289_();
        float currentPlayerYaw = minecraft.f_91074_ != null ? minecraft.f_91074_.m_146908_() : 0.0f;
        float savedYaw = BuildingPreviewRenderer.currentPreview.playerYaw;
        float relativeYaw = BuildingPreviewRenderer.normalizeAngle(savedYaw - currentPlayerYaw);
        int relativeRotation = Math.round(relativeYaw / 90.0f) * 90;
        relativeRotation = BuildingPreviewRenderer.normalizeRotation(relativeRotation);
        int totalRotation = BuildingPreviewRenderer.normalizeRotation(rotation + relativeRotation);
        String cacheKey = currentTemplateId + "_" + totalRotation;
        if (currentRenderCache == null || !cacheKey.equals(lastCacheKey)) {
            BuildingPreviewRenderer.buildRenderCache(currentPreview, totalRotation);
            lastCacheKey = cacheKey;
            lastRotation = rotation;
        }
        if (currentRenderCache == null || BuildingPreviewRenderer.currentRenderCache.allBlocks.isEmpty()) {
            return;
        }
        BlockPos entrance = BuildingPreviewRenderer.currentPreview.entrance != null ? BuildingPreviewRenderer.currentPreview.entrance : BlockPos.f_121853_;
        BlockPos transformedEntrance = BuildingPreviewRenderer.transformPosition(entrance, BuildingPreviewRenderer.currentPreview.size, totalRotation);
        BlockPos offset = previewPos.m_121996_((Vec3i)transformedEntrance);
        poseStack.m_85836_();
        poseStack.m_85837_(-cameraPos.f_82479_, -cameraPos.f_82480_, -cameraPos.f_82481_);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.enableDepthTest();
        switch (currentRenderMode) {
            case WIREFRAME: {
                BuildingPreviewRenderer.renderWireframe(poseStack, bufferSource, currentRenderCache, offset);
                break;
            }
            case HYBRID: {
                BuildingPreviewRenderer.renderHybrid(poseStack, bufferSource, blockRenderer, currentRenderCache, offset);
                break;
            }
            default: {
                RenderType renderType = BuildingPreviewRenderer.currentRenderMode.renderType != null ? BuildingPreviewRenderer.currentRenderMode.renderType : RenderType.m_110463_();
                for (Map.Entry<BlockState, List<RenderCache.RenderableBlock>> entry : BuildingPreviewRenderer.currentRenderCache.blocksByType.entrySet()) {
                    BlockState blockState = entry.getKey();
                    List<RenderCache.RenderableBlock> blocks = entry.getValue();
                    BakedModel model = blockRenderer.m_110910_(blockState);
                    VertexConsumer consumer = bufferSource.m_6299_(renderType);
                    for (RenderCache.RenderableBlock block : blocks) {
                        BuildingPreviewRenderer.renderCachedBlock(poseStack, consumer, model, block, offset);
                    }
                }
            }
        }
        poseStack.m_85849_();
        if (BuildingPreviewRenderer.currentRenderCache.minBounds != null && BuildingPreviewRenderer.currentRenderCache.maxBounds != null) {
            BuildingPreviewRenderer.renderBoundingBox(poseStack, bufferSource, offset.m_121955_((Vec3i)BuildingPreviewRenderer.currentRenderCache.minBounds), offset.m_121955_((Vec3i)BuildingPreviewRenderer.currentRenderCache.maxBounds), cameraPos);
        }
        BuildingPreviewRenderer.renderEntranceMarker(poseStack, bufferSource, previewPos, cameraPos);
    }

    private static void buildRenderCache(PreviewData preview, int totalRotation) {
        long startTime = System.currentTimeMillis();
        HashMap<BlockPos, BlockState> transformedBlocks = new HashMap<BlockPos, BlockState>();
        for (Map.Entry<BlockPos, BlockState> entry : preview.blocks.entrySet()) {
            BlockPos relativePos = entry.getKey();
            BlockState state = entry.getValue();
            if (state.m_60795_()) continue;
            BlockPos transformedPos = BuildingPreviewRenderer.transformPosition(relativePos, preview.size, totalRotation);
            BlockState transformedState = BuildingPreviewRenderer.transformBlockState(state, totalRotation);
            transformedBlocks.put(transformedPos, transformedState);
        }
        VirtualBlockGetter virtualWorld = new VirtualBlockGetter(transformedBlocks);
        currentRenderCache = new RenderCache();
        currentRenderCache.build(transformedBlocks, virtualWorld);
        long totalTime = System.currentTimeMillis() - startTime;
        LOGGER.info("Built render cache in {}ms for {} blocks", (Object)totalTime, (Object)transformedBlocks.size());
    }

    private static void renderCachedBlock(PoseStack poseStack, VertexConsumer consumer, BakedModel model, RenderCache.RenderableBlock block, BlockPos offset) {
        BlockPos worldPos = offset.m_121955_((Vec3i)block.worldPos);
        poseStack.m_85836_();
        poseStack.m_252880_((float)worldPos.m_123341_(), (float)worldPos.m_123342_(), (float)worldPos.m_123343_());
        RandomSource random = RandomSource.m_216327_();
        random.m_188584_(42L);
        for (Direction direction : block.visibleFaces) {
            List quads = model.m_213637_(block.state, direction, random);
            for (BakedQuad quad : quads) {
                consumer.m_85987_(poseStack.m_85850_(), quad, 1.0f, 1.0f, 1.0f, 0xF00000, OverlayTexture.f_118083_);
            }
        }
        List quads = model.m_213637_(block.state, null, random);
        for (BakedQuad quad : quads) {
            consumer.m_85987_(poseStack.m_85850_(), quad, 1.0f, 1.0f, 1.0f, 0xF00000, OverlayTexture.f_118083_);
        }
        poseStack.m_85849_();
    }

    private static void renderBoundingBox(PoseStack poseStack, MultiBufferSource bufferSource, BlockPos minPos, BlockPos maxPos, Vec3 cameraPos) {
        VertexConsumer consumer = bufferSource.m_6299_(RenderType.m_110504_());
        poseStack.m_85836_();
        poseStack.m_85837_(-cameraPos.f_82479_, -cameraPos.f_82480_, -cameraPos.f_82481_);
        LevelRenderer.m_109608_((PoseStack)poseStack, (VertexConsumer)consumer, (double)minPos.m_123341_(), (double)minPos.m_123342_(), (double)minPos.m_123343_(), (double)(maxPos.m_123341_() + 1), (double)(maxPos.m_123342_() + 1), (double)(maxPos.m_123343_() + 1), (float)1.0f, (float)1.0f, (float)0.0f, (float)1.0f);
        poseStack.m_85849_();
    }

    private static void renderEntranceMarker(PoseStack poseStack, MultiBufferSource bufferSource, BlockPos entrancePos, Vec3 cameraPos) {
        VertexConsumer consumer = bufferSource.m_6299_(RenderType.m_110504_());
        poseStack.m_85836_();
        poseStack.m_85837_(-cameraPos.f_82479_, -cameraPos.f_82480_, -cameraPos.f_82481_);
        AABB box = new AABB(entrancePos).m_82400_(0.1);
        LevelRenderer.m_109608_((PoseStack)poseStack, (VertexConsumer)consumer, (double)box.f_82288_, (double)box.f_82289_, (double)box.f_82290_, (double)box.f_82291_, (double)box.f_82292_, (double)box.f_82293_, (float)0.0f, (float)0.5f, (float)1.0f, (float)1.0f);
        poseStack.m_85849_();
    }

    private static BlockPos transformPosition(BlockPos pos, BlockPos size, int rotation) {
        BlockPos result = pos;
        BlockPos currentSize = size;
        for (int i = 0; i < rotation / 90; ++i) {
            int newX = result.m_123343_();
            int newZ = currentSize.m_123341_() - 1 - result.m_123341_();
            result = new BlockPos(newX, result.m_123342_(), newZ);
            int temp = currentSize.m_123341_();
            currentSize = new BlockPos(currentSize.m_123343_(), currentSize.m_123342_(), temp);
        }
        return result;
    }

    private static BlockState transformBlockState(BlockState state, int rotation) {
        Rotation rot = switch (rotation) {
            case 90 -> Rotation.COUNTERCLOCKWISE_90;
            case 180 -> Rotation.CLOCKWISE_180;
            case 270 -> Rotation.CLOCKWISE_90;
            default -> Rotation.NONE;
        };
        return state.m_60717_(rot);
    }

    private static float normalizeAngle(float angle) {
        while (angle > 180.0f) {
            angle -= 360.0f;
        }
        while (angle < -180.0f) {
            angle += 360.0f;
        }
        return angle;
    }

    private static int normalizeRotation(int rotation) {
        if ((rotation %= 360) < 0) {
            rotation += 360;
        }
        return rotation;
    }

    private static void renderWireframe(PoseStack poseStack, MultiBufferSource bufferSource, RenderCache cache, BlockPos offset) {
        VertexConsumer consumer = bufferSource.m_6299_(RenderType.m_110504_());
        for (RenderCache.RenderableBlock block : cache.allBlocks) {
            BlockPos worldPos = offset.m_121955_((Vec3i)block.worldPos);
            LevelRenderer.m_109608_((PoseStack)poseStack, (VertexConsumer)consumer, (double)worldPos.m_123341_(), (double)worldPos.m_123342_(), (double)worldPos.m_123343_(), (double)(worldPos.m_123341_() + 1), (double)(worldPos.m_123342_() + 1), (double)(worldPos.m_123343_() + 1), (float)0.5f, (float)0.5f, (float)1.0f, (float)0.8f);
        }
    }

    private static void renderHybrid(PoseStack poseStack, MultiBufferSource bufferSource, BlockRenderDispatcher blockRenderer, RenderCache cache, BlockPos offset) {
        for (Map.Entry<BlockState, List<RenderCache.RenderableBlock>> entry : cache.blocksByType.entrySet()) {
            BlockState blockState = entry.getKey();
            List<RenderCache.RenderableBlock> blocks = entry.getValue();
            BakedModel model = blockRenderer.m_110910_(blockState);
            VertexConsumer consumer = bufferSource.m_6299_(RenderType.m_110463_());
            for (RenderCache.RenderableBlock block : blocks) {
                BuildingPreviewRenderer.renderCachedBlock(poseStack, consumer, model, block, offset);
            }
        }
        VertexConsumer lineConsumer = bufferSource.m_6299_(RenderType.m_110504_());
        for (RenderCache.RenderableBlock block : cache.allBlocks) {
            BlockPos worldPos = offset.m_121955_((Vec3i)block.worldPos);
            if (block.visibleFaces.isEmpty()) continue;
            LevelRenderer.m_109608_((PoseStack)poseStack, (VertexConsumer)lineConsumer, (double)((double)worldPos.m_123341_() + 0.002), (double)((double)worldPos.m_123342_() + 0.002), (double)((double)worldPos.m_123343_() + 0.002), (double)((double)worldPos.m_123341_() + 0.998), (double)((double)worldPos.m_123342_() + 0.998), (double)((double)worldPos.m_123343_() + 0.998), (float)0.2f, (float)0.2f, (float)0.6f, (float)0.3f);
        }
    }

    public static void setRenderMode(RenderMode mode) {
        if (currentRenderMode != mode) {
            currentRenderMode = mode;
            LOGGER.info("Preview render mode changed to: {}", (Object)mode.displayName);
        }
    }

    public static RenderMode getRenderMode() {
        return currentRenderMode;
    }

    public static void cycleRenderMode() {
        RenderMode[] modes = RenderMode.values();
        int currentIndex = currentRenderMode.ordinal();
        int nextIndex = (currentIndex + 1) % modes.length;
        BuildingPreviewRenderer.setRenderMode(modes[nextIndex]);
    }

    public static void clearCache() {
        previewCache.clear();
        currentTemplateId = null;
        currentPreview = null;
        currentRenderCache = null;
        lastCacheKey = null;
    }

    public static boolean isPreviewReady() {
        return currentPreview != null;
    }

    private static class PreviewData {
        final Map<BlockPos, BlockState> blocks;
        final BlockPos size;
        final BlockPos entrance;
        final float playerYaw;

        PreviewData(Map<BlockPos, BlockState> blocks, BlockPos size, BlockPos entrance, float playerYaw) {
            this.blocks = blocks;
            this.size = size;
            this.entrance = entrance;
            this.playerYaw = playerYaw;
        }
    }

    private static class RenderCache {
        final Map<BlockState, List<RenderableBlock>> blocksByType = new HashMap<BlockState, List<RenderableBlock>>();
        final List<RenderableBlock> allBlocks = new ArrayList<RenderableBlock>();
        BlockPos minBounds;
        BlockPos maxBounds;

        private RenderCache() {
        }

        void build(Map<BlockPos, BlockState> transformedBlocks, VirtualBlockGetter virtualWorld) {
            long startTime = System.currentTimeMillis();
            this.blocksByType.clear();
            this.allBlocks.clear();
            int totalFaces = 0;
            int culledFaces = 0;
            for (Map.Entry<BlockPos, BlockState> entry : transformedBlocks.entrySet()) {
                BlockPos worldPos = entry.getKey();
                BlockState state = entry.getValue();
                if (state.m_60795_()) continue;
                HashSet<Direction> visibleFaces = new HashSet<Direction>();
                for (Direction direction : Direction.values()) {
                    ++totalFaces;
                    BlockPos neighborPos = worldPos.m_121945_(direction);
                    if (Block.m_152444_((BlockState)state, (BlockGetter)virtualWorld, (BlockPos)worldPos, (Direction)direction, (BlockPos)neighborPos)) {
                        visibleFaces.add(direction);
                        continue;
                    }
                    ++culledFaces;
                }
                if (!visibleFaces.isEmpty()) {
                    RenderableBlock renderableBlock = new RenderableBlock(worldPos, state, visibleFaces);
                    this.allBlocks.add(renderableBlock);
                    this.blocksByType.computeIfAbsent(state, k -> new ArrayList()).add(renderableBlock);
                }
                if (this.minBounds == null) {
                    this.minBounds = worldPos;
                    this.maxBounds = worldPos;
                    continue;
                }
                this.minBounds = new BlockPos(Math.min(this.minBounds.m_123341_(), worldPos.m_123341_()), Math.min(this.minBounds.m_123342_(), worldPos.m_123342_()), Math.min(this.minBounds.m_123343_(), worldPos.m_123343_()));
                this.maxBounds = new BlockPos(Math.max(this.maxBounds.m_123341_(), worldPos.m_123341_()), Math.max(this.maxBounds.m_123342_(), worldPos.m_123342_()), Math.max(this.maxBounds.m_123343_(), worldPos.m_123343_()));
            }
            long buildTime = System.currentTimeMillis() - startTime;
            float cullPercent = totalFaces > 0 ? (float)culledFaces * 100.0f / (float)totalFaces : 0.0f;
            LOGGER.info("Render cache built in {}ms: {} blocks, {} visible faces, {} culled ({:.1f}% reduction)", new Object[]{buildTime, this.allBlocks.size(), totalFaces - culledFaces, culledFaces, Float.valueOf(cullPercent)});
        }

        static class RenderableBlock {
            final BlockPos worldPos;
            final BlockState state;
            final Set<Direction> visibleFaces;

            RenderableBlock(BlockPos worldPos, BlockState state, Set<Direction> faces) {
                this.worldPos = worldPos;
                this.state = state;
                this.visibleFaces = faces;
            }
        }
    }

    public static enum RenderMode {
        TRANSLUCENT("\u534a\u900f\u660e", RenderType.m_110466_()),
        CUTOUT("\u526a\u5207", RenderType.m_110463_()),
        WIREFRAME("\u7ebf\u6846", RenderType.m_110504_()),
        HYBRID("\u6df7\u5408", null);

        final String displayName;
        final RenderType renderType;

        private RenderMode(String displayName, RenderType renderType) {
            this.displayName = displayName;
            this.renderType = renderType;
        }
    }

    private static class VirtualBlockGetter
    implements BlockAndTintGetter {
        private final Map<BlockPos, BlockState> blocks;

        VirtualBlockGetter(Map<BlockPos, BlockState> blocks) {
            this.blocks = blocks;
        }

        public BlockState m_8055_(BlockPos pos) {
            BlockState state = this.blocks.get(pos);
            return state != null ? state : Blocks.f_50016_.m_49966_();
        }

        public FluidState m_6425_(BlockPos pos) {
            return Fluids.f_76191_.m_76145_();
        }

        @Nullable
        public BlockEntity m_7702_(BlockPos pos) {
            return null;
        }

        public int m_6171_(BlockPos blockPos, ColorResolver colorResolver) {
            return -1;
        }

        public int m_7146_(BlockPos pos) {
            return 15;
        }

        public int m_141928_() {
            return 384;
        }

        public int m_141937_() {
            return -64;
        }

        public float m_7717_(Direction direction, boolean bl) {
            return 1.0f;
        }

        public LevelLightEngine m_5518_() {
            return null;
        }

        public int m_45517_(LightLayer lightLayer, BlockPos blockPos) {
            return 15;
        }

        public int m_45524_(BlockPos blockPos, int i) {
            return 15;
        }

        public boolean m_45527_(BlockPos blockPos) {
            return true;
        }
    }
}

