/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import ydmsama.hundred_years_war.client.freecam.Freecam;
import ydmsama.hundred_years_war.main.item.BuildingToolItem;
import ydmsama.hundred_years_war.main.network.packets.PlacedBuildingSyncPacket;

public class PlacedBuildingRenderer {
    private static final PlacedBuildingRenderer INSTANCE = new PlacedBuildingRenderer();
    private final Map<UUID, PlacedBuildingSyncPacket.BuildingData> buildings = new ConcurrentHashMap<UUID, PlacedBuildingSyncPacket.BuildingData>();
    private final Map<ChunkPos, Set<UUID>> chunkToBuildingsMap = new ConcurrentHashMap<ChunkPos, Set<UUID>>();
    private boolean lastRenderState = false;
    private long lastUpdateTime = 0L;
    private static final long UPDATE_INTERVAL = 500L;

    private PlacedBuildingRenderer() {
    }

    public static PlacedBuildingRenderer getInstance() {
        return INSTANCE;
    }

    public void addBuilding(PlacedBuildingSyncPacket.BuildingData building) {
        PlacedBuildingSyncPacket.BuildingData oldBuilding = this.buildings.get(building.buildingId);
        if (oldBuilding != null) {
            this.removeFromChunkMappings(oldBuilding);
        }
        this.buildings.put(building.buildingId, building);
        this.updateChunkMappings(building);
    }

    public void removeBuilding(UUID buildingId) {
        PlacedBuildingSyncPacket.BuildingData building = this.buildings.remove(buildingId);
        if (building != null) {
            this.removeFromChunkMappings(building);
        }
    }

    public void clear() {
        this.buildings.clear();
        this.chunkToBuildingsMap.clear();
        this.lastRenderState = false;
        this.lastUpdateTime = 0L;
    }

    public void forceRefresh() {
        this.lastUpdateTime = 0L;
    }

    private void updateChunkMappings(PlacedBuildingSyncPacket.BuildingData building) {
        int minChunkX = building.minPos.m_123341_() >> 4;
        int maxChunkX = building.maxPos.m_123341_() >> 4;
        int minChunkZ = building.minPos.m_123343_() >> 4;
        int maxChunkZ = building.maxPos.m_123343_() >> 4;
        for (int chunkX = minChunkX; chunkX <= maxChunkX; ++chunkX) {
            for (int chunkZ = minChunkZ; chunkZ <= maxChunkZ; ++chunkZ) {
                ChunkPos chunkPos = new ChunkPos(chunkX, chunkZ);
                this.chunkToBuildingsMap.computeIfAbsent(chunkPos, k -> ConcurrentHashMap.newKeySet()).add(building.buildingId);
            }
        }
    }

    private void removeFromChunkMappings(PlacedBuildingSyncPacket.BuildingData building) {
        int minChunkX = building.minPos.m_123341_() >> 4;
        int maxChunkX = building.maxPos.m_123341_() >> 4;
        int minChunkZ = building.minPos.m_123343_() >> 4;
        int maxChunkZ = building.maxPos.m_123343_() >> 4;
        for (int chunkX = minChunkX; chunkX <= maxChunkX; ++chunkX) {
            for (int chunkZ = minChunkZ; chunkZ <= maxChunkZ; ++chunkZ) {
                ChunkPos chunkPos = new ChunkPos(chunkX, chunkZ);
                Set<UUID> chunkBuildings = this.chunkToBuildingsMap.get(chunkPos);
                if (chunkBuildings == null) continue;
                chunkBuildings.remove(building.buildingId);
                if (!chunkBuildings.isEmpty()) continue;
                this.chunkToBuildingsMap.remove(chunkPos);
            }
        }
    }

    public void renderBuildings(PoseStack poseStack, MultiBufferSource bufferSource, Vec3 cameraPos) {
        Minecraft minecraft = Minecraft.m_91087_();
        LocalPlayer player = minecraft.f_91074_;
        if (player == null || minecraft.f_91073_ == null) {
            return;
        }
        boolean shouldRender = false;
        ItemStack mainHand = player.m_21205_();
        ItemStack offHand = player.m_21206_();
        if (mainHand.m_41720_() instanceof BuildingToolItem || offHand.m_41720_() instanceof BuildingToolItem) {
            shouldRender = true;
        }
        if (Freecam.isEnabled()) {
            shouldRender = true;
        }
        if (!shouldRender) {
            this.lastRenderState = false;
            return;
        }
        this.lastRenderState = true;
        int maxBuildingRenderDistance = 256;
        double maxDistanceSqr = maxBuildingRenderDistance * maxBuildingRenderDistance;
        VertexConsumer vertexConsumer = bufferSource.m_6299_(RenderType.m_110504_());
        for (Map.Entry<UUID, PlacedBuildingSyncPacket.BuildingData> entry : this.buildings.entrySet()) {
            double centerZ;
            double centerY;
            PlacedBuildingSyncPacket.BuildingData building = entry.getValue();
            double centerX = (double)(building.minPos.m_123341_() + building.maxPos.m_123341_()) * 0.5;
            double distanceSqr = (centerX - cameraPos.f_82479_) * (centerX - cameraPos.f_82479_) + ((centerY = (double)(building.minPos.m_123342_() + building.maxPos.m_123342_()) * 0.5) - cameraPos.f_82480_) * (centerY - cameraPos.f_82480_) + ((centerZ = (double)(building.minPos.m_123343_() + building.maxPos.m_123343_()) * 0.5) - cameraPos.f_82481_) * (centerZ - cameraPos.f_82481_);
            if (distanceSqr > maxDistanceSqr) continue;
            int centerChunkX = (int)centerX >> 4;
            int centerChunkZ = (int)centerZ >> 4;
            if (!minecraft.f_91073_.m_7726_().m_5563_(centerChunkX, centerChunkZ)) continue;
            this.renderBuildingOutline(poseStack, vertexConsumer, building, cameraPos);
        }
    }

    private void renderBuildingOutline(PoseStack poseStack, VertexConsumer vertexConsumer, PlacedBuildingSyncPacket.BuildingData building, Vec3 cameraPos) {
        float red = 0.0f;
        float green = 1.0f;
        float blue = 0.0f;
        float alpha = 0.8f;
        poseStack.m_85836_();
        poseStack.m_85837_(-cameraPos.f_82479_, -cameraPos.f_82480_, -cameraPos.f_82481_);
        AABB aabb = new AABB((double)building.minPos.m_123341_(), (double)building.minPos.m_123342_(), (double)building.minPos.m_123343_(), (double)(building.maxPos.m_123341_() + 1), (double)(building.maxPos.m_123342_() + 1), (double)(building.maxPos.m_123343_() + 1)).m_82400_(0.002);
        LevelRenderer.m_109608_((PoseStack)poseStack, (VertexConsumer)vertexConsumer, (double)aabb.f_82288_, (double)aabb.f_82289_, (double)aabb.f_82290_, (double)aabb.f_82291_, (double)aabb.f_82292_, (double)aabb.f_82293_, (float)red, (float)green, (float)blue, (float)alpha);
        poseStack.m_85849_();
    }

    public PlacedBuildingSyncPacket.BuildingData getBuildingAt(BlockPos pos) {
        for (PlacedBuildingSyncPacket.BuildingData building : this.buildings.values()) {
            if (pos.m_123341_() < building.minPos.m_123341_() || pos.m_123341_() > building.maxPos.m_123341_() || pos.m_123342_() < building.minPos.m_123342_() || pos.m_123342_() > building.maxPos.m_123342_() || pos.m_123343_() < building.minPos.m_123343_() || pos.m_123343_() > building.maxPos.m_123343_()) continue;
            return building;
        }
        return null;
    }

    public List<PlacedBuildingSyncPacket.BuildingData> getBuildingsInArea(BlockPos center, int radius) {
        ArrayList<PlacedBuildingSyncPacket.BuildingData> result = new ArrayList<PlacedBuildingSyncPacket.BuildingData>();
        BlockPos minPos = center.m_7918_(-radius, -radius, -radius);
        BlockPos maxPos = center.m_7918_(radius, radius, radius);
        for (PlacedBuildingSyncPacket.BuildingData building : this.buildings.values()) {
            AABB searchBox;
            AABB buildingBox = new AABB(building.minPos, building.maxPos.m_7918_(1, 1, 1));
            if (!buildingBox.m_82381_(searchBox = new AABB(minPos, maxPos.m_7918_(1, 1, 1)))) continue;
            result.add(building);
        }
        return result;
    }
}

