/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.HorseModel;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.AbstractHorseRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.item.DyeableHorseArmorItem;
import net.minecraft.world.item.HorseArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import ydmsama.hundred_years_war.main.entity.entities.HywSkeletonHorseEntity;

public class HywSkeletonHorseRenderer
extends AbstractHorseRenderer<HywSkeletonHorseEntity, HorseModel<HywSkeletonHorseEntity>> {
    private static final ResourceLocation TEXTURE = new ResourceLocation("textures/entity/horse/horse_skeleton.png");

    public HywSkeletonHorseRenderer(EntityRendererProvider.Context context) {
        super(context, new HorseModel(context.m_174023_(ModelLayers.f_171237_)), 1.0f);
        this.m_115326_(new HywSkeletonHorseArmorLayer((RenderLayerParent<HywSkeletonHorseEntity, HorseModel<HywSkeletonHorseEntity>>)this, context.m_174027_()));
    }

    public ResourceLocation getTextureLocation(HywSkeletonHorseEntity entity) {
        return TEXTURE;
    }

    private static class HywSkeletonHorseArmorLayer
    extends RenderLayer<HywSkeletonHorseEntity, HorseModel<HywSkeletonHorseEntity>> {
        private final HorseModel<HywSkeletonHorseEntity> model;

        HywSkeletonHorseArmorLayer(RenderLayerParent<HywSkeletonHorseEntity, HorseModel<HywSkeletonHorseEntity>> parent, EntityModelSet models) {
            super(parent);
            this.model = new HorseModel(models.m_171103_(ModelLayers.f_171187_));
        }

        public void render(PoseStack poseStack, MultiBufferSource buffer, int light, HywSkeletonHorseEntity horse, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
            ItemStack armorStack = horse.m_30722_();
            Item item = armorStack.m_41720_();
            if (!(item instanceof HorseArmorItem)) {
                return;
            }
            HorseArmorItem armorItem = (HorseArmorItem)item;
            ((HorseModel)this.m_117386_()).m_102624_(this.model);
            this.model.m_6839_((AbstractHorse)horse, limbSwing, limbSwingAmount, partialTicks);
            this.model.m_6973_((AbstractHorse)horse, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
            float r = 1.0f;
            float g = 1.0f;
            float b = 1.0f;
            if (armorItem instanceof DyeableHorseArmorItem) {
                DyeableHorseArmorItem dyeable = (DyeableHorseArmorItem)armorItem;
                int color = dyeable.m_41121_(armorStack);
                r = (float)(color >> 16 & 0xFF) / 255.0f;
                g = (float)(color >> 8 & 0xFF) / 255.0f;
                b = (float)(color & 0xFF) / 255.0f;
            }
            VertexConsumer vertexConsumer = buffer.m_6299_(RenderType.m_110458_((ResourceLocation)armorItem.m_41367_()));
            this.model.m_7695_(poseStack, vertexConsumer, light, OverlayTexture.f_118083_, r, g, b, 1.0f);
        }
    }
}

