/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.client.renderer.mounted;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.ItemInHandRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.ItemInHandLayer;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import ydmsama.hundred_years_war.client.models.mounted.MountedLancerRiderModel;
import ydmsama.hundred_years_war.client.utils.ChargeWeaponHelper;
import ydmsama.hundred_years_war.main.entity.entities.mounted.MountedLightLancerRiderEntity;

class MountedLightLancerChargingItemInHandLayer
extends ItemInHandLayer<MountedLightLancerRiderEntity, MountedLancerRiderModel<MountedLightLancerRiderEntity>> {
    private final ItemInHandRenderer itemInHandRenderer;

    public MountedLightLancerChargingItemInHandLayer(RenderLayerParent<MountedLightLancerRiderEntity, MountedLancerRiderModel<MountedLightLancerRiderEntity>> renderLayerParent, ItemInHandRenderer itemInHandRenderer) {
        super(renderLayerParent, itemInHandRenderer);
        this.itemInHandRenderer = itemInHandRenderer;
    }

    public void render(PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, MountedLightLancerRiderEntity entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        ItemStack mainHandStack;
        boolean mainHandRight = entity.m_5737_() == HumanoidArm.RIGHT;
        ItemStack offhandStack = mainHandRight ? entity.m_21206_() : entity.m_21205_();
        ItemStack itemStack = mainHandStack = mainHandRight ? entity.m_21205_() : entity.m_21206_();
        if (!mainHandStack.m_41619_() && ChargeWeaponHelper.isChargeWeapon(mainHandStack) || !offhandStack.m_41619_() && ChargeWeaponHelper.isChargeWeapon(offhandStack)) {
            poseStack.m_85836_();
            if (((MountedLancerRiderModel)this.m_117386_()).f_102610_) {
                float f = 0.5f;
                poseStack.m_252880_(0.0f, 0.75f, 0.0f);
                poseStack.m_85841_(0.5f, 0.5f, 0.5f);
            }
            if (!mainHandStack.m_41619_() && ChargeWeaponHelper.isChargeWeapon(mainHandStack)) {
                this.renderItemInHand(entity, mainHandStack, ItemDisplayContext.THIRD_PERSON_RIGHT_HAND, HumanoidArm.RIGHT, poseStack, bufferSource, packedLight);
            }
            if (!offhandStack.m_41619_() && ChargeWeaponHelper.isChargeWeapon(offhandStack)) {
                this.renderItemInHand(entity, offhandStack, ItemDisplayContext.THIRD_PERSON_LEFT_HAND, HumanoidArm.LEFT, poseStack, bufferSource, packedLight);
            }
            poseStack.m_85849_();
        }
    }

    private void renderItemInHand(MountedLightLancerRiderEntity entity, ItemStack stack, ItemDisplayContext displayContext, HumanoidArm arm, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight) {
        if (!stack.m_41619_()) {
            boolean isPikeCharge;
            poseStack.m_85836_();
            ((MountedLancerRiderModel)this.m_117386_()).m_6002_(arm, poseStack);
            poseStack.m_252781_(Axis.f_252529_.m_252977_(-90.0f));
            poseStack.m_252781_(Axis.f_252436_.m_252977_(180.0f));
            boolean leftHand = arm == HumanoidArm.LEFT;
            poseStack.m_252880_((float)(leftHand ? -1 : 1) / 16.0f, 0.125f, -0.625f);
            if (entity.isCharging() && arm == HumanoidArm.RIGHT && (isPikeCharge = ChargeWeaponHelper.isPikeCharge(stack))) {
                poseStack.m_252781_(Axis.f_252529_.m_252977_(-38.0f));
            }
            this.itemInHandRenderer.m_269530_((LivingEntity)entity, stack, displayContext, leftHand, poseStack, bufferSource, packedLight);
            poseStack.m_85849_();
        }
    }
}

