/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.client.screen;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import ydmsama.hundred_years_war.client.network.ClientPacketHandler;
import ydmsama.hundred_years_war.client.screen.EntitySelectionScreen;
import ydmsama.hundred_years_war.main.network.packets.SpawnPointConfigPacket;
import ydmsama.hundred_years_war.main.spawn.SpawnPointBlockEntity;
import ydmsama.hundred_years_war.main.spawn.SpawnPointScreenHandler;

public class SpawnPointScreen
extends AbstractContainerScreen<SpawnPointScreenHandler> {
    private static final int SCROLLABLE_AREA_Y = 40;
    private static final int SCROLLABLE_AREA_HEIGHT = 200;
    private static final int CONTENT_WIDTH = 256;
    private int scrollOffset = 0;
    private int totalContentHeight = 0;
    private int maxScrollOffset = 0;
    private final Map<EditBox, ConfigField> editBoxMap = new HashMap<EditBox, ConfigField>();
    private final List<ScrollableWidget> scrollableWidgets = new ArrayList<ScrollableWidget>();
    private CheckBox infiniteCheckbox;
    private CheckBox showActivationCheckbox;
    private CheckBox pauseCheckbox;
    private CheckBox periodicResetCheckbox;
    private int lastCurrentInterval = -1;
    private int lastRemainingCount = -1;
    private int lastEntryCount = -1;
    private boolean lastHasSavedState = false;
    private boolean lastShowActivationRange = false;
    private boolean lastPaused = false;
    private boolean lastPeriodicReset = false;
    private boolean lastInfinite = false;
    private boolean draggingScrollbar = false;
    private int scrollbarDragOffset = 0;

    public SpawnPointScreen(SpawnPointScreenHandler handler, Inventory inventory, Component title) {
        super((AbstractContainerMenu)handler, inventory, title);
        this.f_97726_ = 256;
        this.f_97727_ = 240;
    }

    public void m_181908_() {
        super.m_181908_();
        SpawnPointBlockEntity blockEntity = ((SpawnPointScreenHandler)this.f_97732_).getBlockEntity();
        if (blockEntity == null) {
            return;
        }
        int currentInterval = blockEntity.getCurrentInterval();
        int remainingCount = blockEntity.getRemainingCount();
        boolean hasSavedState = blockEntity.getSavedState() != null;
        boolean showActivationRange = blockEntity.isShowActivationRange();
        boolean paused = blockEntity.isPaused();
        boolean periodicReset = blockEntity.isPeriodicResetEnabled();
        boolean infiniteSummon = blockEntity.isInfiniteSummon();
        if (currentInterval != this.lastCurrentInterval || remainingCount != this.lastRemainingCount || hasSavedState != this.lastHasSavedState || showActivationRange != this.lastShowActivationRange || paused != this.lastPaused || periodicReset != this.lastPeriodicReset || infiniteSummon != this.lastInfinite) {
            ConfigField field;
            EditBox editBox;
            this.lastCurrentInterval = currentInterval;
            this.lastRemainingCount = remainingCount;
            this.lastHasSavedState = hasSavedState;
            this.lastShowActivationRange = showActivationRange;
            this.lastPaused = paused;
            this.lastPeriodicReset = periodicReset;
            this.lastInfinite = infiniteSummon;
            HashMap<ConfigField, String> userEditedValues = new HashMap<ConfigField, String>();
            ConfigField focusedField = null;
            int cursorPosition = 0;
            for (Map.Entry<EditBox, ConfigField> entry : this.editBoxMap.entrySet()) {
                editBox = entry.getKey();
                field = entry.getValue();
                if (!editBox.m_93696_()) continue;
                focusedField = field;
                cursorPosition = editBox.m_94207_();
                userEditedValues.put(field, editBox.m_94155_());
            }
            this.setupElements();
            for (Map.Entry<EditBox, ConfigField> entry : this.editBoxMap.entrySet()) {
                editBox = entry.getKey();
                field = entry.getValue();
                String savedValue = (String)userEditedValues.get(field);
                if (savedValue != null) {
                    editBox.m_94144_(savedValue);
                }
                if (field == null || !field.equals(focusedField)) continue;
                this.m_7522_((GuiEventListener)editBox);
                editBox.m_93692_(true);
                editBox.m_94196_(cursorPosition);
            }
        }
    }

    protected void m_7856_() {
        super.m_7856_();
        this.setupElements();
    }

    private void setupElements() {
        this.m_169413_();
        this.editBoxMap.clear();
        this.scrollableWidgets.clear();
        this.infiniteCheckbox = null;
        this.showActivationCheckbox = null;
        this.pauseCheckbox = null;
        this.periodicResetCheckbox = null;
        this.draggingScrollbar = false;
        this.scrollbarDragOffset = 0;
        Button doneButton = Button.m_253074_((Component)Component.m_237115_((String)"gui.done"), button -> this.m_7379_()).m_252987_(this.f_97735_ + 256 - 8 - 55, this.f_97736_ + 8, 55, 12).m_253136_();
        this.m_142416_((GuiEventListener)doneButton);
        this.buildScrollableContent();
    }

    private void buildScrollableContent() {
        SpawnPointBlockEntity blockEntity = ((SpawnPointScreenHandler)this.f_97732_).getBlockEntity();
        if (blockEntity == null) {
            return;
        }
        int yPos = 3;
        boolean hasSavedState = blockEntity.getSavedState() != null;
        this.showActivationCheckbox = this.createCheckBox(8, yPos, 150, 10, (Component)Component.m_237115_((String)"gui.hundred_years_war.spawn_point.show_activation_range"), blockEntity.isShowActivationRange(), this::onBooleanOptionChanged);
        this.scrollableWidgets.add(new ScrollableWidget((Object)this.showActivationCheckbox, yPos));
        this.pauseCheckbox = this.createCheckBox(8, yPos += 14, 150, 10, (Component)Component.m_237115_((String)"gui.hundred_years_war.spawn_point.pause"), blockEntity.isPaused(), this::onBooleanOptionChanged);
        this.scrollableWidgets.add(new ScrollableWidget((Object)this.pauseCheckbox, yPos));
        this.periodicResetCheckbox = this.createCheckBox(8, yPos += 14, 150, 10, (Component)Component.m_237115_((String)"gui.hundred_years_war.spawn_point.periodic_reset"), blockEntity.isPeriodicResetEnabled() && hasSavedState, this::onBooleanOptionChanged);
        this.periodicResetCheckbox.setEnabled(hasSavedState);
        if (!hasSavedState) {
            this.periodicResetCheckbox.setSelected(false);
        }
        this.scrollableWidgets.add(new ScrollableWidget((Object)this.periodicResetCheckbox, yPos));
        this.infiniteCheckbox = this.createCheckBox(8, yPos += 14, 120, 10, (Component)Component.m_237115_((String)"gui.hundred_years_war.spawn_point.infinite"), blockEntity.isInfiniteSummon(), null);
        this.scrollableWidgets.add(new ScrollableWidget((Object)this.infiniteCheckbox, yPos));
        yPos += 14;
        yPos = this.addNumberField(yPos, "activation_distance", (Component)Component.m_237115_((String)"gui.hundred_years_war.spawn_point.activation_distance"), String.valueOf((int)blockEntity.getActivationDistance()), ConfigField.ACTIVATION_DISTANCE);
        yPos = this.addNumberField(yPos, "horizontal_range", (Component)Component.m_237115_((String)"gui.hundred_years_war.spawn_point.horizontal_range"), String.valueOf((int)blockEntity.getHorizontalRange()), ConfigField.HORIZONTAL_RANGE);
        yPos = this.addNumberField(yPos, "vertical_range", (Component)Component.m_237115_((String)"gui.hundred_years_war.spawn_point.vertical_range"), String.valueOf((int)blockEntity.getVerticalRange()), ConfigField.VERTICAL_RANGE);
        yPos = this.addNumberField(yPos, "per_spawn", (Component)Component.m_237115_((String)"gui.hundred_years_war.spawn_point.per_spawn"), String.valueOf(blockEntity.getPerSpawnCount()), ConfigField.PER_SPAWN);
        yPos = this.addNumberField(yPos, "remaining", (Component)Component.m_237115_((String)"gui.hundred_years_war.spawn_point.remaining"), String.valueOf(blockEntity.getRemainingCount()), ConfigField.REMAINING);
        yPos = this.addNumberField(yPos, "min_interval", (Component)Component.m_237115_((String)"gui.hundred_years_war.spawn_point.min_interval"), String.valueOf(blockEntity.getMinInterval()), ConfigField.MIN_INTERVAL);
        yPos = this.addNumberField(yPos, "max_interval", (Component)Component.m_237115_((String)"gui.hundred_years_war.spawn_point.max_interval"), String.valueOf(blockEntity.getMaxInterval()), ConfigField.MAX_INTERVAL);
        yPos = this.addNumberField(yPos, "max_active", (Component)Component.m_237115_((String)"gui.hundred_years_war.spawn_point.max_active"), String.valueOf(blockEntity.getMaxActiveEntities()), ConfigField.MAX_ACTIVE);
        yPos = this.addNumberField(yPos, "reset_interval", (Component)Component.m_237115_((String)"gui.hundred_years_war.spawn_point.reset_interval"), String.valueOf(blockEntity.getResetInterval()), ConfigField.RESET_INTERVAL);
        yPos += 4;
        yPos = this.addLabel(yPos, (Component)Component.m_237115_((String)"gui.hundred_years_war.spawn_point.current_state_section"));
        yPos += 12;
        yPos = this.addNumberField(yPos, "current_summon_cooldown", (Component)Component.m_237115_((String)"gui.hundred_years_war.spawn_point.current_summon_cooldown"), String.valueOf(blockEntity.getCurrentInterval()), ConfigField.CURRENT_SUMMON_COOLDOWN);
        yPos = this.addNumberField(yPos, "current_reset_cooldown", (Component)Component.m_237115_((String)"gui.hundred_years_war.spawn_point.current_reset_cooldown"), String.valueOf(blockEntity.getCurrentResetCooldown()), ConfigField.CURRENT_RESET_COOLDOWN);
        yPos += 4;
        yPos = this.addLabel(yPos, (Component)Component.m_237115_((String)"gui.hundred_years_war.spawn_point.status_section"));
        yPos += 12;
        int activeCount = blockEntity.getActiveEntityCount(blockEntity.m_58904_());
        yPos = this.addReadOnlyField(yPos, (Component)Component.m_237115_((String)"gui.hundred_years_war.spawn_point.active_entities"), String.valueOf(activeCount));
        yPos += 4;
        yPos = this.addLabel(yPos, (Component)Component.m_237115_((String)"gui.hundred_years_war.spawn_point.spawn_entries"));
        yPos += 12;
        yPos = this.addLabel(yPos, (Component)Component.m_237115_((String)"gui.hundred_years_war.spawn_point.entity_list_header"));
        yPos += 12;
        List<SpawnPointBlockEntity.SpawnEntry> entries = blockEntity.getSpawnEntries();
        int i = 0;
        while (i < entries.size()) {
            int index = i++;
            SpawnPointBlockEntity.SpawnEntry entry = entries.get(index);
            Button entityButton = this.createButton(30, yPos, 90, 12, (Component)Component.m_237113_((String)this.getEntityName(entry.entityId())), btn -> this.openEntityEditDialog(index, entry));
            this.scrollableWidgets.add(new ScrollableWidget(entityButton, yPos));
            EditBox weightInput = this.createEditBox(125, yPos, 26, String.valueOf(entry.weight()));
            this.editBoxMap.put(weightInput, new ConfigField("entry_weight_" + index, 100));
            this.scrollableWidgets.add(new ScrollableWidget(weightInput, yPos));
            EditBox levelInput = this.createEditBox(155, yPos, 26, String.valueOf(entry.level()));
            this.editBoxMap.put(levelInput, new ConfigField("entry_level_" + index, 101));
            this.scrollableWidgets.add(new ScrollableWidget(levelInput, yPos));
            EditBox equipmentInput = this.createEditBox(185, yPos, 26, String.valueOf(entry.equipmentLevel()));
            this.editBoxMap.put(equipmentInput, new ConfigField("entry_equipment_" + index, 102));
            this.scrollableWidgets.add(new ScrollableWidget(equipmentInput, yPos));
            Button removeButton = this.createButton(215, yPos, 12, 12, (Component)Component.m_237113_((String)"X"), btn -> this.removeEntry(index));
            this.scrollableWidgets.add(new ScrollableWidget(removeButton, yPos));
            yPos += 12;
        }
        Button addEntityButton = this.createButton(30, yPos, 120, 12, (Component)Component.m_237115_((String)"gui.hundred_years_war.spawn_point.add_entity"), btn -> this.openEntitySelectDialog());
        this.scrollableWidgets.add(new ScrollableWidget(addEntityButton, yPos));
        Button saveButton = this.createButton(8, yPos += 14, 80, 12, (Component)Component.m_237115_((String)"gui.hundred_years_war.spawn_point.save_state"), btn -> {
            this.sendAllConfigUpdates();
            ClientPacketHandler.sendSpawnPointConfigCommand(((SpawnPointScreenHandler)this.f_97732_).getBlockPos(), SpawnPointConfigPacket.Mode.SAVE_DEFAULTS);
        });
        this.scrollableWidgets.add(new ScrollableWidget(saveButton, yPos));
        Button loadButton = this.createButton(92, yPos, 80, 12, (Component)Component.m_237115_((String)"gui.hundred_years_war.spawn_point.load_state"), btn -> {
            this.m_7522_(null);
            ClientPacketHandler.sendSpawnPointConfigCommand(((SpawnPointScreenHandler)this.f_97732_).getBlockPos(), SpawnPointConfigPacket.Mode.RESTORE_DEFAULTS);
        });
        loadButton.f_93623_ = hasSavedState;
        this.scrollableWidgets.add(new ScrollableWidget(loadButton, yPos));
        if (hasSavedState) {
            this.scrollableWidgets.add(new ScrollableWidget(new LabelWidget(180, yPos, (Component)Component.m_237113_((String)"\u2713").m_130938_(style -> style.m_178520_(65280))), yPos));
        }
        this.totalContentHeight = yPos += 12;
        this.maxScrollOffset = Math.max(0, this.totalContentHeight - 200);
        this.updateWidgetPositions();
    }

    private int addNumberField(int yPos, String key, Component label, String value, ConfigField field) {
        this.scrollableWidgets.add(new ScrollableWidget(new LabelWidget(8, yPos, label), yPos));
        EditBox editBox = this.createEditBox(180, yPos, 50, value);
        this.editBoxMap.put(editBox, field);
        this.scrollableWidgets.add(new ScrollableWidget(editBox, yPos));
        return yPos + 12;
    }

    private int addLabel(int yPos, Component text) {
        this.scrollableWidgets.add(new ScrollableWidget(new LabelWidget(8, yPos, text), yPos));
        return yPos;
    }

    private int addReadOnlyField(int yPos, Component label, String value) {
        this.scrollableWidgets.add(new ScrollableWidget(new LabelWidget(8, yPos, label), yPos));
        this.scrollableWidgets.add(new ScrollableWidget(new LabelWidget(180, yPos, (Component)Component.m_237113_((String)value)), yPos));
        return yPos + 12;
    }

    private EditBox createEditBox(int x, int y, int width, String value) {
        EditBox editBox = new EditBox(this.f_96547_, this.f_97735_ + x, this.f_97736_ + 40 + y - this.scrollOffset, width, 12, (Component)Component.m_237113_((String)""));
        editBox.m_94199_(10);
        editBox.m_94144_(value);
        editBox.m_94153_(text -> {
            if (text.isEmpty()) {
                return true;
            }
            try {
                Double.parseDouble(text);
                return true;
            }
            catch (NumberFormatException e) {
                return false;
            }
        });
        return editBox;
    }

    private Button createButton(int x, int y, int width, int height, Component text, Button.OnPress onPress) {
        return Button.m_253074_((Component)text, (Button.OnPress)onPress).m_252987_(this.f_97735_ + x, this.f_97736_ + 40 + y - this.scrollOffset, width, height).m_253136_();
    }

    private CheckBox createCheckBox(int x, int y, int width, int height, Component text, boolean defaultValue, Runnable onChange) {
        return new CheckBox(this.f_97735_ + x, this.f_97736_ + 40 + y - this.scrollOffset, width, height, text, defaultValue, onChange, this.f_96547_);
    }

    private void updateWidgetPositions() {
        for (ScrollableWidget widget : this.scrollableWidgets) {
            int newY = this.f_97736_ + 40 + widget.yPos - this.scrollOffset;
            Object object = widget.widget;
            if (object instanceof Button) {
                Button button = (Button)object;
                button.m_253211_(newY);
                continue;
            }
            object = widget.widget;
            if (object instanceof EditBox) {
                EditBox editBox = (EditBox)object;
                editBox.m_253211_(newY);
                continue;
            }
            object = widget.widget;
            if (!(object instanceof CheckBox)) continue;
            CheckBox checkbox = (CheckBox)((Object)object);
            checkbox.m_264152_(this.f_97735_ + 8, newY);
        }
    }

    private void openEntitySelectDialog() {
        if (this.f_96541_ != null) {
            this.f_96541_.m_91152_((Screen)new EntitySelectionScreen(this, -1, null));
        }
    }

    private void openEntityEditDialog(int index, SpawnPointBlockEntity.SpawnEntry entry) {
        if (this.f_96541_ != null) {
            this.f_96541_.m_91152_((Screen)new EntitySelectionScreen(this, index, entry));
        }
    }

    private void removeEntry(int index) {
        this.removeEntityEntry(index);
    }

    private String getEntityName(ResourceLocation entityId) {
        EntityType entityType = (EntityType)BuiltInRegistries.f_256780_.m_7745_(entityId);
        if (entityType != null) {
            return entityType.m_20676_().getString();
        }
        String path = entityId.m_135815_();
        return path.substring(path.lastIndexOf(47) + 1);
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float delta) {
        this.m_280273_(graphics);
        super.m_88315_(graphics, mouseX, mouseY, delta);
        this.m_280072_(graphics, mouseX, mouseY);
    }

    protected void m_7286_(GuiGraphics graphics, float delta, int mouseX, int mouseY) {
        graphics.m_280509_(this.f_97735_, this.f_97736_, this.f_97735_ + this.f_97726_, this.f_97736_ + this.f_97727_, -3750202);
        graphics.m_280509_(this.f_97735_, this.f_97736_, this.f_97735_ + this.f_97726_, this.f_97736_ + 40, -2039584);
        graphics.m_280509_(this.f_97735_, this.f_97736_ + 40, this.f_97735_ + this.f_97726_ - 12, this.f_97736_ + 40 + 200, -986896);
        graphics.m_280588_(this.f_97735_, this.f_97736_ + 40, this.f_97735_ + this.f_97726_ - 12, this.f_97736_ + 40 + 200);
        for (ScrollableWidget widget : this.scrollableWidgets) {
            int widgetY = this.f_97736_ + 40 + widget.yPos - this.scrollOffset;
            if (widgetY + 20 < this.f_97736_ + 40 || widgetY > this.f_97736_ + 40 + 200) continue;
            Object object = widget.widget;
            if (object instanceof Button) {
                Button button = (Button)object;
                button.m_88315_(graphics, mouseX, mouseY, delta);
                continue;
            }
            object = widget.widget;
            if (object instanceof EditBox) {
                EditBox editBox = (EditBox)object;
                editBox.m_88315_(graphics, mouseX, mouseY, delta);
                continue;
            }
            object = widget.widget;
            if (object instanceof CheckBox) {
                CheckBox checkbox = (CheckBox)((Object)object);
                checkbox.m_88315_(graphics, mouseX, mouseY, delta);
                continue;
            }
            object = widget.widget;
            if (!(object instanceof LabelWidget)) continue;
            LabelWidget label = (LabelWidget)object;
            graphics.m_280614_(this.f_96547_, label.text, this.f_97735_ + label.x, widgetY, 0x404040, false);
        }
        graphics.m_280618_();
        if (this.maxScrollOffset > 0) {
            int scrollbarX = this.f_97735_ + this.f_97726_ - 10;
            int scrollbarY = this.f_97736_ + 40;
            int scrollbarHeight = 200;
            graphics.m_280509_(scrollbarX, scrollbarY, scrollbarX + 8, scrollbarY + scrollbarHeight, -7631989);
            int thumbHeight = Math.max(20, 40000 / this.totalContentHeight);
            int thumbY = scrollbarY + (int)((float)this.scrollOffset / (float)this.maxScrollOffset * (float)(scrollbarHeight - thumbHeight));
            graphics.m_280509_(scrollbarX + 1, thumbY, scrollbarX + 7, thumbY + thumbHeight, -4144960);
        }
    }

    protected void m_280003_(GuiGraphics graphics, int mouseX, int mouseY) {
        graphics.m_280614_(this.f_96547_, this.f_96539_, 8, 8, 0x404040, false);
    }

    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        if (this.isMouseOverScrollableArea(mouseX, mouseY)) {
            int scrollAmount = (int)(delta * 10.0);
            this.scrollOffset = Math.max(0, Math.min(this.maxScrollOffset, this.scrollOffset - scrollAmount));
            this.updateWidgetPositions();
            return true;
        }
        return super.m_6050_(mouseX, mouseY, delta);
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (!this.isMouseOverScrollableArea(mouseX, mouseY)) {
            return super.m_6375_(mouseX, mouseY, button);
        }
        if (this.maxScrollOffset > 0) {
            int scrollbarX = this.getScrollbarX();
            int scrollbarY = this.getScrollbarY();
            int scrollbarWidth = 8;
            int scrollbarHeight = 200;
            if (mouseX >= (double)scrollbarX && mouseX <= (double)(scrollbarX + scrollbarWidth) && mouseY >= (double)scrollbarY && mouseY <= (double)(scrollbarY + scrollbarHeight)) {
                int thumbHeight = this.computeThumbHeight();
                int thumbY = this.computeThumbY(thumbHeight);
                if (mouseY >= (double)thumbY && mouseY <= (double)(thumbY + thumbHeight)) {
                    this.draggingScrollbar = true;
                    this.scrollbarDragOffset = (int)(mouseY - (double)thumbY);
                } else {
                    double targetThumbTop = Math.max((double)scrollbarY, Math.min((double)(scrollbarY + scrollbarHeight - thumbHeight), mouseY - (double)thumbHeight / 2.0));
                    this.applyThumbPosition(targetThumbTop, thumbHeight);
                    this.draggingScrollbar = true;
                    this.scrollbarDragOffset = thumbHeight / 2;
                }
                this.updateWidgetPositions();
                return true;
            }
        }
        for (ScrollableWidget widget : this.scrollableWidgets) {
            CheckBox checkbox;
            Object object = widget.widget;
            if (object instanceof Button) {
                Button btn = (Button)object;
                if (!btn.m_5953_(mouseX, mouseY)) continue;
                btn.m_6375_(mouseX, mouseY, button);
                return true;
            }
            object = widget.widget;
            if (object instanceof EditBox) {
                EditBox editBox = (EditBox)object;
                if (!editBox.m_5953_(mouseX, mouseY)) continue;
                editBox.m_6375_(mouseX, mouseY, button);
                this.m_7522_((GuiEventListener)editBox);
                return true;
            }
            object = widget.widget;
            if (!(object instanceof CheckBox) || !(checkbox = (CheckBox)((Object)object)).m_5953_(mouseX, mouseY)) continue;
            checkbox.m_6375_(mouseX, mouseY, button);
            return true;
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (this.draggingScrollbar && button == 0 && this.maxScrollOffset > 0) {
            int thumbHeight = this.computeThumbHeight();
            int scrollbarY = this.getScrollbarY();
            int scrollbarHeight = 200;
            double targetThumbTop = Math.max((double)scrollbarY, Math.min((double)(scrollbarY + scrollbarHeight - thumbHeight), mouseY - (double)this.scrollbarDragOffset));
            this.applyThumbPosition(targetThumbTop, thumbHeight);
            this.updateWidgetPositions();
            return true;
        }
        return super.m_7979_(mouseX, mouseY, button, deltaX, deltaY);
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        if (button == 0 && this.draggingScrollbar) {
            this.draggingScrollbar = false;
            return true;
        }
        return super.m_6348_(mouseX, mouseY, button);
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        EditBox editBox;
        GuiEventListener guiEventListener = this.m_7222_();
        if (guiEventListener instanceof EditBox && (editBox = (EditBox)guiEventListener).m_7933_(keyCode, scanCode, modifiers)) {
            return true;
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    public boolean m_5534_(char codePoint, int modifiers) {
        EditBox editBox;
        GuiEventListener guiEventListener = this.m_7222_();
        if (guiEventListener instanceof EditBox && (editBox = (EditBox)guiEventListener).m_5534_(codePoint, modifiers)) {
            return true;
        }
        return super.m_5534_(codePoint, modifiers);
    }

    private boolean isMouseOverScrollableArea(double mouseX, double mouseY) {
        return mouseX >= (double)this.f_97735_ && mouseX < (double)(this.f_97735_ + this.f_97726_) && mouseY >= (double)(this.f_97736_ + 40) && mouseY < (double)(this.f_97736_ + 40 + 200);
    }

    private int getScrollbarX() {
        return this.f_97735_ + this.f_97726_ - 10;
    }

    private int getScrollbarY() {
        return this.f_97736_ + 40;
    }

    private int computeThumbHeight() {
        if (this.totalContentHeight <= 0) {
            return 20;
        }
        return Math.max(20, 40000 / this.totalContentHeight);
    }

    private int computeThumbY(int thumbHeight) {
        if (this.maxScrollOffset <= 0) {
            return this.getScrollbarY();
        }
        int track = 200 - thumbHeight;
        if (track <= 0) {
            return this.getScrollbarY();
        }
        return this.getScrollbarY() + (int)((float)this.scrollOffset / (float)this.maxScrollOffset * (float)track);
    }

    private void applyThumbPosition(double thumbTop, int thumbHeight) {
        int scrollbarY = this.getScrollbarY();
        int track = 200 - thumbHeight;
        if (track <= 0) {
            this.scrollOffset = 0;
            return;
        }
        double relative = (thumbTop - (double)scrollbarY) / (double)track;
        relative = Math.max(0.0, Math.min(1.0, relative));
        this.scrollOffset = Math.max(0, Math.min(this.maxScrollOffset, (int)Math.round(relative * (double)this.maxScrollOffset)));
    }

    public void m_7861_() {
        super.m_7861_();
        this.sendAllConfigUpdates();
    }

    private void onBooleanOptionChanged() {
        SpawnPointBlockEntity blockEntity = ((SpawnPointScreenHandler)this.f_97732_).getBlockEntity();
        if (blockEntity == null) {
            return;
        }
        ArrayList<SpawnPointConfigPacket.SpawnEntryData> entryDataList = new ArrayList<SpawnPointConfigPacket.SpawnEntryData>();
        for (SpawnPointBlockEntity.SpawnEntry entry : blockEntity.getSpawnEntries()) {
            entryDataList.add(new SpawnPointConfigPacket.SpawnEntryData(entry.entityId(), entry.weight(), entry.level(), entry.equipmentLevel()));
        }
        boolean infiniteValue = this.infiniteCheckbox != null && this.infiniteCheckbox.selected();
        boolean showActivationValue = this.showActivationCheckbox != null && this.showActivationCheckbox.selected();
        boolean pausedValue = this.pauseCheckbox != null && this.pauseCheckbox.selected();
        boolean periodicResetValue = this.periodicResetCheckbox != null && this.periodicResetCheckbox.m_142518_() && this.periodicResetCheckbox.selected();
        SpawnPointConfigPacket.ConfigData configData = new SpawnPointConfigPacket.ConfigData(blockEntity.getActivationDistance(), blockEntity.getHorizontalRange(), blockEntity.getVerticalRange(), blockEntity.getPerSpawnCount(), blockEntity.getRemainingCount(), blockEntity.getMinInterval(), blockEntity.getMaxInterval(), blockEntity.getCurrentInterval(), blockEntity.getMaxActiveEntities(), infiniteValue, showActivationValue, pausedValue, periodicResetValue, blockEntity.getResetInterval(), blockEntity.getCurrentResetCooldown(), entryDataList);
        ClientPacketHandler.sendSpawnPointConfig(((SpawnPointScreenHandler)this.f_97732_).getBlockPos(), configData);
    }

    private void sendAllConfigUpdates() {
        SpawnPointBlockEntity blockEntity = ((SpawnPointScreenHandler)this.f_97732_).getBlockEntity();
        if (blockEntity == null) {
            return;
        }
        double activationDistance = this.getDoubleValue(ConfigField.ACTIVATION_DISTANCE, blockEntity.getActivationDistance());
        double horizontalRange = this.getDoubleValue(ConfigField.HORIZONTAL_RANGE, blockEntity.getHorizontalRange());
        double verticalRange = this.getDoubleValue(ConfigField.VERTICAL_RANGE, blockEntity.getVerticalRange());
        int perSpawn = this.getIntValue(ConfigField.PER_SPAWN, blockEntity.getPerSpawnCount());
        int remaining = this.getIntValue(ConfigField.REMAINING, blockEntity.getRemainingCount());
        int minInterval = this.getIntValue(ConfigField.MIN_INTERVAL, blockEntity.getMinInterval());
        int maxInterval = this.getIntValue(ConfigField.MAX_INTERVAL, blockEntity.getMaxInterval());
        int currentInterval = this.getIntValue(ConfigField.CURRENT_SUMMON_COOLDOWN, this.getIntValue(ConfigField.CURRENT_INTERVAL, blockEntity.getCurrentInterval()));
        int maxActive = this.getIntValue(ConfigField.MAX_ACTIVE, blockEntity.getMaxActiveEntities());
        long resetInterval = this.getLongValue(ConfigField.RESET_INTERVAL, blockEntity.getResetInterval());
        long currentResetCooldown = this.getLongValue(ConfigField.CURRENT_RESET_COOLDOWN, blockEntity.getCurrentResetCooldown());
        ArrayList<SpawnPointBlockEntity.SpawnEntry> entries = new ArrayList<SpawnPointBlockEntity.SpawnEntry>();
        for (int i = 0; i < blockEntity.getSpawnEntries().size(); ++i) {
            SpawnPointBlockEntity.SpawnEntry originalEntry = blockEntity.getSpawnEntries().get(i);
            int weight = this.getIntValue(new ConfigField("entry_weight_" + i, 100), originalEntry.weight());
            int level = this.getIntValue(new ConfigField("entry_level_" + i, 101), originalEntry.level());
            int equipmentLevel = this.getIntValue(new ConfigField("entry_equipment_" + i, 102), originalEntry.equipmentLevel());
            entries.add(new SpawnPointBlockEntity.SpawnEntry(originalEntry.entityId(), weight, level, equipmentLevel));
        }
        ArrayList<SpawnPointConfigPacket.SpawnEntryData> entryDataList = new ArrayList<SpawnPointConfigPacket.SpawnEntryData>();
        for (SpawnPointBlockEntity.SpawnEntry entry : entries) {
            entryDataList.add(new SpawnPointConfigPacket.SpawnEntryData(entry.entityId(), entry.weight(), entry.level(), entry.equipmentLevel()));
        }
        boolean infiniteValue = this.infiniteCheckbox != null && this.infiniteCheckbox.selected();
        boolean showActivationValue = this.showActivationCheckbox != null && this.showActivationCheckbox.selected();
        boolean pausedValue = this.pauseCheckbox != null && this.pauseCheckbox.selected();
        boolean periodicResetValue = this.periodicResetCheckbox != null && this.periodicResetCheckbox.m_142518_() && this.periodicResetCheckbox.selected();
        SpawnPointConfigPacket.ConfigData configData = new SpawnPointConfigPacket.ConfigData(activationDistance, horizontalRange, verticalRange, perSpawn, remaining, minInterval, maxInterval, currentInterval, maxActive, infiniteValue, showActivationValue, pausedValue, periodicResetValue, resetInterval, currentResetCooldown, entryDataList);
        ClientPacketHandler.sendSpawnPointConfig(((SpawnPointScreenHandler)this.f_97732_).getBlockPos(), configData);
    }

    private void sendConfigUpdate(List<SpawnPointBlockEntity.SpawnEntry> entries) {
        SpawnPointBlockEntity blockEntity = ((SpawnPointScreenHandler)this.f_97732_).getBlockEntity();
        if (blockEntity == null) {
            return;
        }
        ArrayList<SpawnPointConfigPacket.SpawnEntryData> entryDataList = new ArrayList<SpawnPointConfigPacket.SpawnEntryData>();
        for (SpawnPointBlockEntity.SpawnEntry entry : entries) {
            entryDataList.add(new SpawnPointConfigPacket.SpawnEntryData(entry.entityId(), entry.weight(), entry.level(), entry.equipmentLevel()));
        }
        boolean infiniteValue = this.infiniteCheckbox != null ? this.infiniteCheckbox.selected() : blockEntity.isInfiniteSummon();
        boolean showActivationValue = this.showActivationCheckbox != null ? this.showActivationCheckbox.selected() : blockEntity.isShowActivationRange();
        boolean pausedValue = this.pauseCheckbox != null ? this.pauseCheckbox.selected() : blockEntity.isPaused();
        boolean periodicResetValue = this.periodicResetCheckbox != null && this.periodicResetCheckbox.m_142518_() ? this.periodicResetCheckbox.selected() : blockEntity.isPeriodicResetEnabled();
        SpawnPointConfigPacket.ConfigData configData = new SpawnPointConfigPacket.ConfigData(blockEntity.getActivationDistance(), blockEntity.getHorizontalRange(), blockEntity.getVerticalRange(), blockEntity.getPerSpawnCount(), blockEntity.getRemainingCount(), blockEntity.getMinInterval(), blockEntity.getMaxInterval(), blockEntity.getCurrentInterval(), blockEntity.getMaxActiveEntities(), infiniteValue, showActivationValue, pausedValue, periodicResetValue, blockEntity.getResetInterval(), blockEntity.getCurrentResetCooldown(), entryDataList);
        ClientPacketHandler.sendSpawnPointConfig(((SpawnPointScreenHandler)this.f_97732_).getBlockPos(), configData);
    }

    public void updateEntityEntry(int index, ResourceLocation entityId) {
        SpawnPointBlockEntity blockEntity = ((SpawnPointScreenHandler)this.f_97732_).getBlockEntity();
        if (blockEntity == null) {
            return;
        }
        ArrayList<SpawnPointBlockEntity.SpawnEntry> entries = new ArrayList<SpawnPointBlockEntity.SpawnEntry>(blockEntity.getSpawnEntries());
        if (index < 0) {
            entries.add(new SpawnPointBlockEntity.SpawnEntry(entityId, 1, 1, 1));
        } else if (index < entries.size()) {
            SpawnPointBlockEntity.SpawnEntry existing = (SpawnPointBlockEntity.SpawnEntry)entries.get(index);
            entries.set(index, new SpawnPointBlockEntity.SpawnEntry(entityId, existing.weight(), existing.level(), existing.equipmentLevel()));
        }
        blockEntity.setSpawnEntries(entries);
        this.sendConfigUpdate(entries);
        this.lastEntryCount = entries.size();
        this.setupElements();
    }

    public void removeEntityEntry(int index) {
        SpawnPointBlockEntity blockEntity = ((SpawnPointScreenHandler)this.f_97732_).getBlockEntity();
        if (blockEntity == null) {
            return;
        }
        ArrayList<SpawnPointBlockEntity.SpawnEntry> entries = new ArrayList<SpawnPointBlockEntity.SpawnEntry>(blockEntity.getSpawnEntries());
        if (index >= 0 && index < entries.size()) {
            SpawnPointBlockEntity.SpawnEntry removed = (SpawnPointBlockEntity.SpawnEntry)entries.remove(index);
            blockEntity.setSpawnEntries(entries);
            this.sendConfigUpdate(entries);
            this.lastEntryCount = entries.size();
            this.setupElements();
        }
    }

    private double getDoubleValue(ConfigField field, double defaultValue) {
        for (Map.Entry<EditBox, ConfigField> entry : this.editBoxMap.entrySet()) {
            if (!entry.getValue().equals(field)) continue;
            String value = entry.getKey().m_94155_();
            if (value == null || value.trim().isEmpty()) {
                return defaultValue;
            }
            try {
                double parsed = Double.parseDouble(value);
                return parsed;
            }
            catch (NumberFormatException e) {
                return defaultValue;
            }
        }
        return defaultValue;
    }

    private int getIntValue(ConfigField field, int defaultValue) {
        return (int)this.getDoubleValue(field, defaultValue);
    }

    private long getLongValue(ConfigField field, long defaultValue) {
        return (long)this.getDoubleValue(field, defaultValue);
    }

    private static class ConfigField {
        static final ConfigField ACTIVATION_DISTANCE = new ConfigField("activation_distance", 0);
        static final ConfigField HORIZONTAL_RANGE = new ConfigField("horizontal_range", 1);
        static final ConfigField VERTICAL_RANGE = new ConfigField("vertical_range", 2);
        static final ConfigField PER_SPAWN = new ConfigField("per_spawn", 3);
        static final ConfigField REMAINING = new ConfigField("remaining", 4);
        static final ConfigField MIN_INTERVAL = new ConfigField("min_interval", 5);
        static final ConfigField MAX_INTERVAL = new ConfigField("max_interval", 6);
        static final ConfigField MAX_ACTIVE = new ConfigField("max_active", 7);
        static final ConfigField RESET_INTERVAL = new ConfigField("reset_interval", 8);
        static final ConfigField CURRENT_INTERVAL = new ConfigField("current_interval", 9);
        static final ConfigField CURRENT_SUMMON_COOLDOWN = new ConfigField("current_summon_cooldown", 10);
        static final ConfigField CURRENT_RESET_COOLDOWN = new ConfigField("current_reset_cooldown", 11);
        static final int ENTRY_WEIGHT = 100;
        static final int ENTRY_LEVEL = 101;
        static final int ENTRY_EQUIPMENT_LEVEL = 102;
        final String key;
        final int type;

        ConfigField(String key, int type) {
            this.key = key;
            this.type = type;
        }

        ConfigField(String key, ConfigField template) {
            this.key = key;
            this.type = template.type;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ConfigField)) {
                return false;
            }
            ConfigField field = (ConfigField)o;
            return this.type == field.type && this.key.equals(field.key);
        }

        public int hashCode() {
            return 31 * this.key.hashCode() + this.type;
        }
    }

    private static class CheckBox
    extends AbstractWidget {
        private boolean checked;
        private final Runnable onChange;
        private final Font fontRenderer;

        public CheckBox(int x, int y, int width, int height, Component message, boolean defaultValue, Runnable onChange, Font font) {
            super(x, y, width, height, message);
            this.checked = defaultValue;
            this.onChange = onChange;
            this.fontRenderer = font;
        }

        protected void m_87963_(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
            int boxSize = 10;
            int outerColor = this.m_142518_() ? -1 : -5197648;
            int innerColor = this.m_142518_() ? -16777216 : -10855846;
            graphics.m_280509_(this.m_252754_(), this.m_252907_(), this.m_252754_() + boxSize, this.m_252907_() + boxSize, outerColor);
            graphics.m_280509_(this.m_252754_() + 1, this.m_252907_() + 1, this.m_252754_() + boxSize - 1, this.m_252907_() + boxSize - 1, innerColor);
            if (this.checked) {
                int checkColor = this.m_142518_() ? 65280 : 39168;
                graphics.m_280056_(this.fontRenderer, "\u2713", this.m_252754_() + 2, this.m_252907_() + 1, checkColor, false);
            }
            int labelColor = this.m_142518_() ? 0x404040 : 0x707070;
            graphics.m_280614_(this.fontRenderer, this.m_6035_(), this.m_252754_() + boxSize + 5, this.m_252907_() + 1, labelColor, false);
        }

        public void m_5716_(double mouseX, double mouseY) {
            if (!this.m_142518_()) {
                return;
            }
            boolean bl = this.checked = !this.checked;
            if (this.onChange != null) {
                this.onChange.run();
            }
        }

        public boolean selected() {
            return this.checked;
        }

        public void setSelected(boolean selected) {
            this.checked = selected;
        }

        public void setEnabled(boolean enabled) {
            this.f_93623_ = enabled;
        }

        public void m_264152_(int x, int y) {
            this.m_252865_(x);
            this.m_253211_(y);
        }

        protected void m_168797_(NarrationElementOutput output) {
        }
    }

    private static class ScrollableWidget {
        final Object widget;
        final int yPos;

        ScrollableWidget(Object widget, int yPos) {
            this.widget = widget;
            this.yPos = yPos;
        }
    }

    private record LabelWidget(int x, int yPos, Component text) {
    }
}

