/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.client.screen;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import ydmsama.hundred_years_war.client.network.ClientPacketHandler;
import ydmsama.hundred_years_war.main.blocks.workstation.TransportOrderScreenHandler;
import ydmsama.hundred_years_war.main.data.TransportData;

public class TransportOrderScreen
extends AbstractContainerScreen<TransportOrderScreenHandler> {
    private static final ResourceLocation TEXTURE = new ResourceLocation("minecraft", "textures/gui/container/generic_54.png");
    private static final int SCROLL_AREA_HEIGHT = 120;
    private static final int ENTRY_HEIGHT = 52;
    private TransportData transportData;
    private TransportData originalData;
    private List<RouteEntry> routeEntries = new ArrayList<RouteEntry>();
    private int scrollOffset = 0;
    private int totalContentHeight = 0;
    private boolean isDraggingScrollbar = false;
    private double scrollDragStartY = 0.0;
    private int scrollDragStartOffset = 0;

    public TransportOrderScreen(TransportOrderScreenHandler handler, Inventory playerInventory, Component title) {
        super((AbstractContainerMenu)handler, playerInventory, title);
        this.f_97726_ = 256;
        this.f_97727_ = 240;
        this.f_97731_ = this.f_97727_ - 94;
        this.transportData = this.cloneTransportData(handler.getTransportData());
        this.originalData = this.cloneTransportData(handler.getTransportData());
    }

    private TransportData cloneTransportData(TransportData source) {
        TransportData clone = new TransportData();
        clone.deserializeNBT(source.serializeNBT());
        return clone;
    }

    protected void m_7856_() {
        super.m_7856_();
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237115_((String)"gui.apply"), button -> this.applyChanges()).m_252794_(this.f_97735_ + this.f_97726_ - 85, this.f_97736_ + 5).m_253046_(40, 20).m_253136_());
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237115_((String)"gui.cancel"), button -> this.m_7379_()).m_252794_(this.f_97735_ + this.f_97726_ - 42, this.f_97736_ + 5).m_253046_(40, 20).m_253136_());
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237115_((String)"gui.hundred_years_war.transport_order.unbind"), button -> this.unbindWorkstation()).m_252794_(this.f_97735_ + 5, this.f_97736_ + 15).m_253046_(50, 12).m_253136_());
        this.updateRouteEntries();
    }

    private void applyChanges() {
        BlockPos boundPos = ((TransportOrderScreenHandler)this.f_97732_).getBoundPos();
        if (boundPos != null) {
            ClientPacketHandler.sendTransportDataUpdate(boundPos, this.transportData);
        }
        this.m_7379_();
    }

    private void unbindWorkstation() {
        ClientPacketHandler.sendUnbindTransportOrder();
        this.m_7379_();
    }

    private void updateRouteEntries() {
        for (RouteEntry entry : this.routeEntries) {
            if (entry == null || entry.quantityBox == null) continue;
            this.m_169411_((GuiEventListener)entry.quantityBox);
        }
        this.routeEntries.clear();
        List<TransportData.TransportRoute> routes = this.transportData.getRoutes();
        this.totalContentHeight = routes.size() * 52;
        for (int i = 0; i < routes.size(); ++i) {
            RouteEntry entry = new RouteEntry(i, routes.get(i));
            this.routeEntries.add(entry);
            this.m_7787_((GuiEventListener)entry.quantityBox);
        }
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float delta) {
        this.m_280273_(graphics);
        super.m_88315_(graphics, mouseX, mouseY, delta);
        this.m_280072_(graphics, mouseX, mouseY);
    }

    protected void m_7286_(GuiGraphics graphics, float delta, int mouseX, int mouseY) {
        this.drawGuiFrame(graphics, mouseX, mouseY);
        graphics.m_280588_(this.f_97735_, this.f_97736_ + 30, this.f_97735_ + this.f_97726_ - 10, this.f_97736_ + 30 + 120);
        for (RouteEntry entry : this.routeEntries) {
            int entryY = this.f_97736_ + 30 + entry.index * 52 - this.scrollOffset;
            boolean isVisible = entryY + 52 > this.f_97736_ + 30 && entryY < this.f_97736_ + 30 + 120;
            entry.quantityBox.m_252865_(this.f_97735_ + 8 + 65);
            entry.quantityBox.m_253211_(entryY + 12);
            entry.quantityBox.f_93624_ = isVisible;
            entry.quantityBox.f_93623_ = isVisible;
            if (!isVisible) continue;
            entry.render(graphics, this.f_97735_ + 8, entryY, mouseX, mouseY);
        }
        graphics.m_280618_();
    }

    protected void m_280003_(GuiGraphics graphics, int mouseX, int mouseY) {
        graphics.m_280614_(this.f_96547_, this.f_96539_, this.f_97728_, this.f_97729_, 0x404040, false);
    }

    private void drawGuiFrame(GuiGraphics graphics, int mouseX, int mouseY) {
        graphics.m_280509_(this.f_97735_, this.f_97736_, this.f_97735_ + this.f_97726_, this.f_97736_ + this.f_97727_, -3750202);
        graphics.m_280509_(this.f_97735_, this.f_97736_, this.f_97735_ + this.f_97726_, this.f_97736_ + 1, -13158601);
        graphics.m_280509_(this.f_97735_, this.f_97736_ + this.f_97727_ - 1, this.f_97735_ + this.f_97726_, this.f_97736_ + this.f_97727_, -13158601);
        graphics.m_280509_(this.f_97735_, this.f_97736_, this.f_97735_ + 1, this.f_97736_ + this.f_97727_, -13158601);
        graphics.m_280509_(this.f_97735_ + this.f_97726_ - 1, this.f_97736_, this.f_97735_ + this.f_97726_, this.f_97736_ + this.f_97727_, -13158601);
        graphics.m_280509_(this.f_97735_ + 1, this.f_97736_ + 1, this.f_97735_ + this.f_97726_ - 1, this.f_97736_ + this.f_97727_ - 1, -2039584);
        graphics.m_280509_(this.f_97735_ + 4, this.f_97736_ + 30, this.f_97735_ + this.f_97726_ - 14, this.f_97736_ + 30 + 120, -986896);
        graphics.m_280509_(this.f_97735_ + this.f_97726_ - 10, this.f_97736_ + 30, this.f_97735_ + this.f_97726_ - 4, this.f_97736_ + 30 + 120, -5592406);
        if (this.totalContentHeight > 120) {
            boolean isHovered;
            int scrollBarHeight = Math.max(20, (int)(14400.0f / (float)this.totalContentHeight));
            int scrollBarY = this.f_97736_ + 30 + (int)((float)this.scrollOffset * (float)(120 - scrollBarHeight) / (float)(this.totalContentHeight - 120));
            int scrollBarX = this.f_97735_ + this.f_97726_ - 9;
            int scrollBarRight = this.f_97735_ + this.f_97726_ - 5;
            boolean bl = isHovered = mouseX >= scrollBarX && mouseX < scrollBarRight && mouseY >= scrollBarY && mouseY < scrollBarY + scrollBarHeight;
            int scrollBarColor = this.isDraggingScrollbar ? -12566464 : (isHovered ? -11513776 : -10461088);
            graphics.m_280509_(scrollBarX, scrollBarY, scrollBarRight, scrollBarY + scrollBarHeight, scrollBarColor);
        }
        int invY = this.f_97736_ + 158;
        for (int row = 0; row < 3; ++row) {
            for (int col = 0; col < 9; ++col) {
                int x = this.f_97735_ + 47 + col * 18;
                int y = invY + row * 18;
                graphics.m_280509_(x - 1, y - 1, x + 17, y + 17, -7631989);
                graphics.m_280509_(x, y, x + 16, y + 16, -13158601);
            }
        }
        for (int col = 0; col < 9; ++col) {
            int x = this.f_97735_ + 47 + col * 18;
            int y = invY + 58;
            graphics.m_280509_(x - 1, y - 1, x + 17, y + 17, -7631989);
            graphics.m_280509_(x, y, x + 16, y + 16, -13158601);
        }
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        boolean handled = super.m_6375_(mouseX, mouseY, button);
        if (button == 0 && this.totalContentHeight > 120) {
            int scrollBarX = this.f_97735_ + this.f_97726_ - 10;
            int scrollBarRight = this.f_97735_ + this.f_97726_ - 4;
            int scrollBarTop = this.f_97736_ + 30;
            int scrollBarBottom = this.f_97736_ + 30 + 120;
            if (mouseX >= (double)scrollBarX && mouseX < (double)scrollBarRight && mouseY >= (double)scrollBarTop && mouseY < (double)scrollBarBottom) {
                int scrollBarHeight = Math.max(20, (int)(14400.0f / (float)this.totalContentHeight));
                int scrollBarY = scrollBarTop + (int)((float)this.scrollOffset * (float)(120 - scrollBarHeight) / (float)(this.totalContentHeight - 120));
                if (mouseY >= (double)scrollBarY && mouseY < (double)(scrollBarY + scrollBarHeight)) {
                    this.isDraggingScrollbar = true;
                    this.scrollDragStartY = mouseY;
                    this.scrollDragStartOffset = this.scrollOffset;
                    return true;
                }
                float clickRatio = (float)(mouseY - (double)scrollBarTop) / 120.0f;
                this.scrollOffset = (int)(clickRatio * (float)(this.totalContentHeight - 120));
                this.scrollOffset = Math.max(0, Math.min(this.scrollOffset, this.totalContentHeight - 120));
                return true;
            }
        }
        int scrollAreaTop = this.f_97736_ + 30;
        int scrollAreaBottom = this.f_97736_ + 30 + 120;
        if (mouseY >= (double)scrollAreaTop && mouseY < (double)scrollAreaBottom) {
            for (RouteEntry entry : this.routeEntries) {
                int entryY = this.f_97736_ + 30 + entry.index * 52 - this.scrollOffset;
                if (entryY + 52 <= scrollAreaTop || entryY >= scrollAreaBottom) continue;
                entry.quantityBox.m_252865_(this.f_97735_ + 8 + 65);
                entry.quantityBox.m_253211_(entryY + 12);
                boolean needsUpdate = entry.handleClick(this.f_97735_ + 8, entryY, mouseX, mouseY, button);
                if (!needsUpdate) continue;
                if (entry.needsListUpdate) {
                    this.updateRouteEntries();
                }
                return true;
            }
        }
        return handled;
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.isDraggingScrollbar && button == 0 && this.totalContentHeight > 120) {
            int scrollBarHeight = Math.max(20, (int)(14400.0f / (float)this.totalContentHeight));
            double mouseDelta = mouseY - this.scrollDragStartY;
            double scrollRatio = mouseDelta / (double)(120 - scrollBarHeight);
            int newOffset = this.scrollDragStartOffset + (int)(scrollRatio * (double)(this.totalContentHeight - 120));
            this.scrollOffset = Math.max(0, Math.min(newOffset, this.totalContentHeight - 120));
            return true;
        }
        return super.m_7979_(mouseX, mouseY, button, dragX, dragY);
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        ItemStack heldStack;
        if (button == 0 && this.isDraggingScrollbar) {
            this.isDraggingScrollbar = false;
            return true;
        }
        if (this.f_97734_ != null && this.f_97734_.m_6657_() && !(heldStack = this.f_97734_.m_7993_()).m_41619_()) {
            int scrollAreaTop = this.f_97736_ + 30;
            int scrollAreaBottom = this.f_97736_ + 30 + 120;
            for (RouteEntry entry : this.routeEntries) {
                int entryY = this.f_97736_ + 30 + entry.index * 52 - this.scrollOffset;
                if (entryY + 52 <= scrollAreaTop || entryY >= scrollAreaBottom) continue;
                int slotY = entryY + 26;
                for (int i = 0; i < 8; ++i) {
                    int slotX = this.f_97735_ + 8 + i * 18;
                    if (!(mouseX >= (double)slotX) || !(mouseX < (double)(slotX + 16)) || !(mouseY >= (double)slotY) || !(mouseY < (double)(slotY + 16))) continue;
                    ItemStack filterStack = heldStack.m_41777_();
                    filterStack.m_41764_(1);
                    entry.route.setFilter(i, filterStack);
                    this.updateRouteEntries();
                    return true;
                }
            }
        }
        return super.m_6348_(mouseX, mouseY, button);
    }

    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        if (this.totalContentHeight > 120) {
            this.scrollOffset -= (int)(delta * 10.0);
            this.scrollOffset = Math.max(0, Math.min(this.scrollOffset, this.totalContentHeight - 120));
            return true;
        }
        return super.m_6050_(mouseX, mouseY, delta);
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    public boolean m_5534_(char chr, int modifiers) {
        return super.m_5534_(chr, modifiers);
    }

    private boolean isSlotUnderMouse(Slot slot, double mouseX, double mouseY) {
        int x = this.f_97735_ + slot.f_40220_;
        int y = this.f_97736_ + slot.f_40221_;
        return mouseX >= (double)x && mouseX < (double)(x + 16) && mouseY >= (double)y && mouseY < (double)(y + 16);
    }

    private String ellipsizeByWidth(String text, int maxWidthPixels) {
        if (text == null) {
            return "";
        }
        if (this.f_96547_.m_92895_(text) <= maxWidthPixels) {
            return text;
        }
        String ell = "\u2026";
        int ellW = this.f_96547_.m_92895_(ell);
        if (ellW > maxWidthPixels) {
            return ell;
        }
        int totalCodePoints = text.codePointCount(0, text.length());
        int lo = 0;
        int hi = totalCodePoints;
        while (lo < hi) {
            int mid = (lo + hi + 1) / 2;
            int charIndex = text.offsetByCodePoints(0, mid);
            String substr = text.substring(0, charIndex);
            if (this.f_96547_.m_92895_(substr) <= maxWidthPixels - ellW) {
                lo = mid;
                continue;
            }
            hi = mid - 1;
        }
        if (lo == 0) {
            return ell;
        }
        int cutIndex = text.offsetByCodePoints(0, lo);
        return text.substring(0, cutIndex) + ell;
    }

    private class RouteEntry {
        final int index;
        final TransportData.TransportRoute route;
        private EditBox quantityBox;
        boolean needsListUpdate = false;

        RouteEntry(int index, TransportData.TransportRoute route) {
            this.index = index;
            this.route = route;
            this.quantityBox = new EditBox(TransportOrderScreen.this.f_96547_, 0, 0, 30, 12, (Component)Component.m_237113_((String)""));
            this.quantityBox.m_94199_(3);
            this.quantityBox.m_94144_(String.valueOf(route.getQuantity()));
            this.quantityBox.m_94153_(s -> s.matches("^[0-9]{0,3}$"));
            this.quantityBox.m_94190_(true);
            this.quantityBox.m_94202_(0xFFFFFF);
            this.quantityBox.m_94205_(0x808080);
            this.quantityBox.m_94182_(true);
            this.quantityBox.m_94151_(s -> {
                try {
                    int quantity = s.isEmpty() ? 0 : Integer.parseInt(s);
                    quantity = Math.max(0, Math.min(quantity, 999));
                    route.setQuantity(quantity);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            });
        }

        void render(GuiGraphics graphics, int x, int y, int mouseX, int mouseY) {
            ClientLevel level = ((TransportOrderScreen)TransportOrderScreen.this).f_96541_.f_91073_;
            if (level == null) {
                return;
            }
            BlockPos pos = this.route.getTargetPos();
            BlockState state = level.m_8055_(pos);
            Block block = state.m_60734_();
            String blockName = String.format("%d. %s", this.index + 1, block.m_49954_().getString());
            blockName = TransportOrderScreen.this.ellipsizeByWidth(blockName, 112);
            graphics.m_280056_(TransportOrderScreen.this.f_96547_, blockName, x, y, 0x404040, false);
            String posString = String.format("[%d, %d, %d]", pos.m_123341_(), pos.m_123342_(), pos.m_123343_());
            graphics.m_280056_(TransportOrderScreen.this.f_96547_, posString, x + 120, y, 0x404040, false);
            int buttonY = y + 12;
            String modeText = Component.m_237115_((String)this.route.getMode().getTranslationKey()).getString();
            modeText = TransportOrderScreen.this.ellipsizeByWidth(modeText, 54);
            this.drawButton(graphics, x, buttonY, 60, 12, modeText, this.isInside(mouseX, mouseY, x, buttonY, 60, 12));
            this.quantityBox.m_252865_(x + 65);
            this.quantityBox.m_253211_(buttonY);
            this.quantityBox.m_88315_(graphics, mouseX, mouseY, 0.0f);
            this.drawButton(graphics, x + 220, y, 12, 9, "X", this.isInside(mouseX, mouseY, x + 220, y, 12, 9));
            this.drawButton(graphics, x + 220, buttonY, 12, 12, "\u25b2", this.isInside(mouseX, mouseY, x + 220, buttonY, 12, 12));
            this.drawButton(graphics, x + 220, buttonY + 14, 12, 12, "\u25bc", this.isInside(mouseX, mouseY, x + 220, buttonY + 14, 12, 12));
            int slotY = buttonY + 14;
            List<ItemStack> filters = this.route.getFilters();
            for (int i = 0; i < 8; ++i) {
                int slotX = x + i * 18;
                boolean hovered = this.isInside(mouseX, mouseY, slotX, slotY, 16, 16);
                int bgColor = hovered ? -5197648 : -8355712;
                int innerColor = hovered ? -3092272 : -4144960;
                graphics.m_280509_(slotX, slotY, slotX + 16, slotY + 16, bgColor);
                graphics.m_280509_(slotX + 1, slotY + 1, slotX + 15, slotY + 15, innerColor);
                if (i >= filters.size() || filters.get(i).m_41619_()) continue;
                ItemStack displayStack = filters.get(i).m_41777_();
                displayStack.m_41764_(1);
                graphics.m_280480_(displayStack, slotX, slotY);
            }
            graphics.m_280509_(x - 4, y + 52 - 2, x + 232, y + 52 - 1, -8355712);
        }

        boolean handleClick(int x, int y, double mouseX, double mouseY, int button) {
            List<TransportData.TransportRoute> routes;
            this.needsListUpdate = false;
            if (this.isInside(mouseX, mouseY, x, y + 12, 60, 12)) {
                this.route.toggleMode();
                return true;
            }
            if (this.isInside(mouseX, mouseY, x + 220, y, 12, 9)) {
                TransportOrderScreen.this.transportData.getRoutes().remove(this.index);
                this.needsListUpdate = true;
                return true;
            }
            if (this.isInside(mouseX, mouseY, x + 220, y + 12, 12, 12) && this.index > 0) {
                List<TransportData.TransportRoute> routes2 = TransportOrderScreen.this.transportData.getRoutes();
                TransportData.TransportRoute temp = routes2.get(this.index);
                routes2.set(this.index, routes2.get(this.index - 1));
                routes2.set(this.index - 1, temp);
                this.needsListUpdate = true;
                return true;
            }
            if (this.isInside(mouseX, mouseY, x + 220, y + 26, 12, 12) && this.index < (routes = TransportOrderScreen.this.transportData.getRoutes()).size() - 1) {
                TransportData.TransportRoute temp = routes.get(this.index);
                routes.set(this.index, routes.get(this.index + 1));
                routes.set(this.index + 1, temp);
                this.needsListUpdate = true;
                return true;
            }
            int slotY = y + 26;
            for (int i = 0; i < 8; ++i) {
                if (!this.isInside(mouseX, mouseY, x + i * 18, slotY, 16, 16)) continue;
                if (button == 0) {
                    ItemStack carriedStack = ((TransportOrderScreen)TransportOrderScreen.this).f_96541_.f_91074_.f_36096_.m_142621_();
                    if (!carriedStack.m_41619_()) {
                        ItemStack filterStack = carriedStack.m_41777_();
                        filterStack.m_41764_(1);
                        this.route.setFilter(i, filterStack);
                        return true;
                    }
                    for (Slot slot : ((TransportOrderScreenHandler)((TransportOrderScreen)TransportOrderScreen.this).f_97732_).f_38839_) {
                        if (!slot.m_6657_() || !TransportOrderScreen.this.isSlotUnderMouse(slot, mouseX, mouseY)) continue;
                        ItemStack filterStack = slot.m_7993_().m_41777_();
                        filterStack.m_41764_(1);
                        this.route.setFilter(i, filterStack);
                        return true;
                    }
                    continue;
                }
                if (button != 1) continue;
                this.route.setFilter(i, ItemStack.f_41583_);
                return true;
            }
            return false;
        }

        private boolean isInside(double mouseX, double mouseY, int x, int y, int width, int height) {
            return mouseX >= (double)x && mouseX < (double)(x + width) && mouseY >= (double)y && mouseY < (double)(y + height);
        }

        private void drawButton(GuiGraphics graphics, int x, int y, int width, int height, String text, boolean hovered) {
            int bgColor = hovered ? -5197648 : -6250336;
            graphics.m_280509_(x, y, x + width, y + height, bgColor);
            graphics.m_280509_(x, y, x + width, y + 1, -10461088);
            graphics.m_280509_(x, y + height - 1, x + width, y + height, -10461088);
            graphics.m_280509_(x, y, x + 1, y + height, -10461088);
            graphics.m_280509_(x + width - 1, y, x + width, y + height, -10461088);
            int textWidth = TransportOrderScreen.this.f_96547_.m_92895_(text);
            int textX = x + (width - textWidth) / 2;
            Objects.requireNonNull(TransportOrderScreen.this.f_96547_);
            int textY = y + (height - 9) / 2;
            graphics.m_280056_(TransportOrderScreen.this.f_96547_, text, textX, textY, 0xFFFFFF, false);
        }
    }
}

