/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.client.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import ydmsama.hundred_years_war.client.network.ClientPacketHandler;
import ydmsama.hundred_years_war.client.screen.widgets.RepeatButton;
import ydmsama.hundred_years_war.main.blocks.warehouse.WarehouseControlBlockEntity;

public class WarehouseControlRangeScreen
extends Screen {
    private static final int GUI_WIDTH = 256;
    private static final int GUI_HEIGHT = 200;
    private final WarehouseControlBlockEntity blockEntity;
    private int tempRangeLeft;
    private int tempRangeRight;
    private int tempRangeUp;
    private int tempRangeDown;
    private boolean tempShowRange;
    private static final int PREVIEW_SIZE = 120;
    private static final int CELL_SIZE = 8;
    private final List<RepeatButton> repeatButtons = new ArrayList<RepeatButton>();

    public WarehouseControlRangeScreen(WarehouseControlBlockEntity blockEntity) {
        super((Component)Component.m_237113_((String)""));
        this.blockEntity = blockEntity;
        this.tempRangeLeft = blockEntity.getWorkRangeLeft();
        this.tempRangeRight = blockEntity.getWorkRangeRight();
        this.tempRangeUp = blockEntity.getWorkRangeUp();
        this.tempRangeDown = blockEntity.getWorkRangeDown();
        this.tempShowRange = blockEntity.isShowRange();
    }

    protected void m_7856_() {
        super.m_7856_();
        int centerX = this.f_96543_ / 2;
        int centerY = this.f_96544_ / 2;
        RepeatButton leftPlusBtn = new RepeatButton(centerX - 120, centerY, 20, 20, (Component)Component.m_237113_((String)"+"), () -> {
            if (this.tempRangeLeft < this.blockEntity.getMaxRangeLeft()) {
                ++this.tempRangeLeft;
            }
        });
        this.m_142416_((GuiEventListener)leftPlusBtn);
        this.repeatButtons.add(leftPlusBtn);
        RepeatButton leftMinusBtn = new RepeatButton(centerX - 95, centerY, 20, 20, (Component)Component.m_237113_((String)"-"), () -> {
            if (this.tempRangeLeft > 0) {
                --this.tempRangeLeft;
            }
        });
        this.m_142416_((GuiEventListener)leftMinusBtn);
        this.repeatButtons.add(leftMinusBtn);
        RepeatButton rightMinusBtn = new RepeatButton(centerX + 75, centerY, 20, 20, (Component)Component.m_237113_((String)"-"), () -> {
            if (this.tempRangeRight > 0) {
                --this.tempRangeRight;
            }
        });
        this.m_142416_((GuiEventListener)rightMinusBtn);
        this.repeatButtons.add(rightMinusBtn);
        RepeatButton rightPlusBtn = new RepeatButton(centerX + 100, centerY, 20, 20, (Component)Component.m_237113_((String)"+"), () -> {
            if (this.tempRangeRight < this.blockEntity.getMaxRangeRight()) {
                ++this.tempRangeRight;
            }
        });
        this.m_142416_((GuiEventListener)rightPlusBtn);
        this.repeatButtons.add(rightPlusBtn);
        RepeatButton upPlusBtn = new RepeatButton(centerX - 10, centerY - 80, 20, 20, (Component)Component.m_237113_((String)"+"), () -> {
            if (this.tempRangeUp < this.blockEntity.getMaxRangeUp()) {
                ++this.tempRangeUp;
            }
        });
        this.m_142416_((GuiEventListener)upPlusBtn);
        this.repeatButtons.add(upPlusBtn);
        RepeatButton upMinusBtn = new RepeatButton(centerX - 10, centerY - 55, 20, 20, (Component)Component.m_237113_((String)"-"), () -> {
            if (this.tempRangeUp > 0) {
                --this.tempRangeUp;
            }
        });
        this.m_142416_((GuiEventListener)upMinusBtn);
        this.repeatButtons.add(upMinusBtn);
        RepeatButton heightPlusBtn = new RepeatButton(centerX - 135, centerY + 75, 20, 20, (Component)Component.m_237113_((String)"+"), () -> {
            if (this.tempRangeDown < this.blockEntity.getMaxRangeDown()) {
                ++this.tempRangeDown;
            }
        });
        this.m_142416_((GuiEventListener)heightPlusBtn);
        this.repeatButtons.add(heightPlusBtn);
        RepeatButton heightMinusBtn = new RepeatButton(centerX - 110, centerY + 75, 20, 20, (Component)Component.m_237113_((String)"-"), () -> {
            if (this.tempRangeDown > -10) {
                --this.tempRangeDown;
            }
        });
        this.m_142416_((GuiEventListener)heightMinusBtn);
        this.repeatButtons.add(heightMinusBtn);
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237115_((String)"ui.hundred_years_war.warehouse_control.confirm"), button -> {
            this.applyChanges();
            this.m_7379_();
        }).m_252987_(centerX - 50, centerY + 80, 40, 15).m_253136_());
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237115_((String)"ui.hundred_years_war.warehouse_control.cancel"), button -> this.m_7379_()).m_252987_(centerX + 10, centerY + 80, 40, 15).m_253136_());
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237115_((String)"ui.hundred_years_war.warehouse_control.reset"), button -> {
            this.tempRangeLeft = 3;
            this.tempRangeRight = 3;
            this.tempRangeUp = 3;
            this.tempRangeDown = -3;
        }).m_252987_(centerX - 20, centerY + 63, 40, 15).m_253136_());
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237115_((String)(this.tempShowRange ? "ui.hundred_years_war.warehouse_control.hide_range" : "ui.hundred_years_war.warehouse_control.show_range")), button -> {
            this.tempShowRange = !this.tempShowRange;
            button.m_93666_((Component)Component.m_237115_((String)(this.tempShowRange ? "ui.hundred_years_war.warehouse_control.hide_range" : "ui.hundred_years_war.warehouse_control.show_range")));
            ClientPacketHandler.sendWarehouseRangeUpdate(this.blockEntity.m_58899_(), this.blockEntity.getWorkRangeLeft(), this.blockEntity.getWorkRangeRight(), this.blockEntity.getWorkRangeUp(), this.blockEntity.getWorkRangeDown(), this.tempShowRange);
        }).m_252987_(centerX + 30, centerY + 63, 60, 15).m_253136_());
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float delta) {
        for (RepeatButton button : this.repeatButtons) {
            button.tick();
        }
        this.m_280273_(graphics);
        int centerX = this.f_96543_ / 2;
        int centerY = this.f_96544_ / 2;
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)0.8f);
        graphics.m_280509_(centerX - 140, centerY - 100, centerX + 140, centerY + 100, Integer.MIN_VALUE);
        graphics.m_280653_(this.f_96547_, this.f_96539_, centerX, centerY - 90, 0xFFFFFF);
        this.drawRangePreview(graphics, centerX, centerY);
        this.drawRangeInfo(graphics, centerX, centerY);
        super.m_88315_(graphics, mouseX, mouseY, delta);
    }

    private void drawRangePreview(GuiGraphics graphics, int centerX, int centerY) {
        int excess;
        boolean exceedsUp;
        int previewX = centerX - 60;
        int previewY = centerY - 30;
        graphics.m_280509_(previewX - 2, previewY - 2, previewX + 120 + 2, previewY + 120 - 36 + 2, -13421773);
        graphics.m_280509_(previewX, previewY, previewX + 120, previewY + 120 - 36, -10066330);
        int centerGridX = 7;
        int centerGridY = 8;
        int gridLeft = centerGridX - this.tempRangeLeft;
        int gridRight = centerGridX + this.tempRangeRight;
        int gridTop = centerGridY - this.tempRangeUp;
        int gridBottom = centerGridY;
        for (int gridX = gridLeft; gridX <= gridRight; ++gridX) {
            for (int gridY = gridTop; gridY <= gridBottom; ++gridY) {
                int pixelX = previewX + gridX * 8;
                int pixelY = previewY + gridY * 8;
                if (pixelX < previewX || pixelX + 8 > previewX + 120 || pixelY < previewY || pixelY + 8 > previewY + 120 - 36) continue;
                graphics.m_280509_(pixelX, pixelY, pixelX + 8, pixelY + 8, -2147418368);
            }
        }
        int workstationPixelX = previewX + centerGridX * 8;
        int workstationPixelY = previewY + centerGridY * 8;
        if (workstationPixelX >= previewX && workstationPixelX + 8 <= previewX + 120 && workstationPixelY + 8 >= previewY && workstationPixelY + 16 <= previewY + 120 - 36 + 8) {
            graphics.m_280509_(workstationPixelX, workstationPixelY + 8, workstationPixelX + 8, workstationPixelY + 16, -65536);
        }
        int totalWidth = this.tempRangeLeft + this.tempRangeRight + 1;
        int totalDepth = this.tempRangeUp + 1;
        int workAreaPixelX = previewX + gridLeft * 8;
        int workAreaPixelY = previewY + gridTop * 8;
        int workAreaPixelWidth = totalWidth * 8;
        int workAreaPixelHeight = totalDepth * 8;
        boolean exceedsLeft = workAreaPixelX < previewX;
        boolean exceedsRight = workAreaPixelX + workAreaPixelWidth > previewX + 120;
        boolean bl = exceedsUp = workAreaPixelY < previewY;
        if (exceedsLeft) {
            excess = (previewX - workAreaPixelX) / 8;
            graphics.m_280056_(this.f_96547_, "+" + excess, previewX + 2, previewY + 60, 0xFFFF00, false);
        }
        if (exceedsRight) {
            excess = (workAreaPixelX + workAreaPixelWidth - previewX - 120) / 8;
            graphics.m_280056_(this.f_96547_, "+" + excess, previewX + 120 - 20, previewY + 60, 0xFFFF00, false);
        }
        if (exceedsUp) {
            excess = (previewY - workAreaPixelY) / 8;
            graphics.m_280056_(this.f_96547_, "+" + excess, previewX + 60 - 5, previewY + 2, 0xFFFF00, false);
        }
    }

    private void drawRangeInfo(GuiGraphics graphics, int centerX, int centerY) {
        graphics.m_280056_(this.f_96547_, Component.m_237110_((String)"ui.hundred_years_war.warehouse_control.left", (Object[])new Object[]{this.tempRangeLeft}).getString(), centerX - 120, centerY - 25, 0xFFFFFF, false);
        graphics.m_280056_(this.f_96547_, Component.m_237110_((String)"ui.hundred_years_war.warehouse_control.right", (Object[])new Object[]{this.tempRangeRight}).getString(), centerX + 80, centerY - 25, 0xFFFFFF, false);
        graphics.m_280056_(this.f_96547_, Component.m_237110_((String)"ui.hundred_years_war.warehouse_control.up", (Object[])new Object[]{this.tempRangeUp}).getString(), centerX - 15, centerY - 95, 0xFFFFFF, false);
        String heightLabel = this.tempRangeDown >= 0 ? Component.m_237110_((String)"ui.hundred_years_war.warehouse_control.height_up", (Object[])new Object[]{this.tempRangeDown}).getString() : Component.m_237110_((String)"ui.hundred_years_war.warehouse_control.height_down", (Object[])new Object[]{-this.tempRangeDown}).getString();
        graphics.m_280056_(this.f_96547_, heightLabel, centerX - 135, centerY + 95, 0xFFFFFF, false);
        int totalWidth = this.tempRangeLeft + this.tempRangeRight + 1;
        int totalDepth = this.tempRangeUp + 1;
        int totalHeight = this.tempRangeUp + Math.abs(this.tempRangeDown) + 1;
        graphics.m_280137_(this.f_96547_, Component.m_237110_((String)"ui.hundred_years_war.warehouse_control.work_range", (Object[])new Object[]{totalWidth, totalDepth, totalHeight}).getString(), centerX, centerY + 15, 0xFFFFFF);
        int storageBlocks = this.blockEntity.getStorageBlockCount();
        graphics.m_280137_(this.f_96547_, Component.m_237110_((String)"ui.hundred_years_war.warehouse_control.storage_blocks", (Object[])new Object[]{storageBlocks}).getString(), centerX, centerY + 35, 0xFFFFFF);
    }

    private void applyChanges() {
        ClientPacketHandler.sendWarehouseRangeUpdate(this.blockEntity.m_58899_(), this.tempRangeLeft, this.tempRangeRight, this.tempRangeUp, this.tempRangeDown, this.tempShowRange);
    }

    public boolean m_7043_() {
        return false;
    }
}

