/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.client.screen;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import ydmsama.hundred_years_war.client.network.ClientPacketHandler;
import ydmsama.hundred_years_war.client.screen.WarehouseControlRangeScreen;
import ydmsama.hundred_years_war.main.blocks.warehouse.WarehouseControlScreenHandler;

public class WarehouseControlScreen
extends AbstractContainerScreen<WarehouseControlScreenHandler> {
    private EditBox searchBox;
    private Button sortButton;
    private Button orderButton;
    private Button rangeButton;
    private float scrollOffset = 0.0f;
    private boolean isScrolling = false;
    private int scrollMouseY = 0;
    private static final int ITEMS_PER_ROW = 9;
    private static final int VISIBLE_ROWS = 5;
    private static final int ITEM_SIZE = 18;
    private List<ItemStack> filteredItems = new ArrayList<ItemStack>();
    private String lastSearchText = "";
    private boolean justClickedWarehouseItem = false;

    public WarehouseControlScreen(WarehouseControlScreenHandler handler, Inventory inventory, Component title) {
        super((AbstractContainerMenu)handler, inventory, title);
        this.f_97726_ = 195;
        this.f_97727_ = 256;
        this.f_97731_ = this.f_97727_ - 94;
    }

    protected void m_7856_() {
        super.m_7856_();
        this.searchBox = new EditBox(this.f_96547_, this.f_97735_ + 8, this.f_97736_ + 20, 110, 12, (Component)Component.m_237113_((String)""));
        this.searchBox.m_94199_(50);
        this.searchBox.m_94182_(false);
        this.searchBox.m_94202_(0xFFFFFF);
        this.searchBox.m_94151_(text -> this.updateFilteredItems());
        this.m_142416_((GuiEventListener)this.searchBox);
        this.sortButton = Button.m_253074_((Component)Component.m_237115_((String)("gui.hundred_years_war.warehouse.sort." + this.getCurrentSortType())), button -> {
            ClientPacketHandler.sendWarehouseSortChange(((WarehouseControlScreenHandler)this.f_97732_).getBlockPos(), true, false);
            this.updateSortButton();
        }).m_252794_(this.f_97735_ + 122, this.f_97736_ + 18).m_253046_(50, 16).m_253136_();
        this.m_142416_((GuiEventListener)this.sortButton);
        this.orderButton = Button.m_253074_((Component)Component.m_237113_((String)(this.isAscending() ? "\u25b2" : "\u25bc")), button -> {
            ClientPacketHandler.sendWarehouseSortChange(((WarehouseControlScreenHandler)this.f_97732_).getBlockPos(), false, true);
            this.updateOrderButton();
        }).m_252794_(this.f_97735_ + 174, this.f_97736_ + 18).m_253046_(16, 16).m_253136_();
        this.m_142416_((GuiEventListener)this.orderButton);
        this.rangeButton = Button.m_253074_((Component)Component.m_237115_((String)"gui.hundred_years_war.warehouse.range"), button -> {
            if (((WarehouseControlScreenHandler)this.f_97732_).getBlockEntity() != null) {
                this.f_96541_.m_91152_((Screen)new WarehouseControlRangeScreen(((WarehouseControlScreenHandler)this.f_97732_).getBlockEntity()));
            }
        }).m_252794_(this.f_97735_ + 60, this.f_97736_ + 152).m_253046_(60, 16).m_253136_();
        this.m_142416_((GuiEventListener)this.rangeButton);
        this.updateFilteredItems();
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float delta) {
        int itemIndex;
        this.m_280273_(graphics);
        super.m_88315_(graphics, mouseX, mouseY, delta);
        this.m_280072_(graphics, mouseX, mouseY);
        int startX = this.f_97735_ + 8;
        int startY = this.f_97736_ + 38;
        for (int i = 0; i < this.getVisibleItemCount() && (itemIndex = i + (int)(this.scrollOffset * 9.0f)) < this.filteredItems.size(); ++i) {
            int x = startX + i % 9 * 18;
            int y = startY + i / 9 * 18;
            if (mouseX < x || mouseX >= x + 18 || mouseY < y || mouseY >= y + 18) continue;
            ItemStack stack = this.filteredItems.get(itemIndex);
            graphics.m_280153_(this.f_96547_, stack, mouseX, mouseY);
        }
        if (!((WarehouseControlScreenHandler)this.f_97732_).m_142621_().m_41619_()) {
            int endX = this.f_97735_ + 170;
            int endY = this.f_97736_ + 130;
            if (mouseX >= startX && mouseX <= endX && mouseY >= startY && mouseY <= endY) {
                graphics.m_280509_(startX, startY, endX, endY, 1082195840);
            }
        }
    }

    protected void m_7286_(GuiGraphics graphics, float delta, int mouseX, int mouseY) {
        graphics.m_280509_(this.f_97735_, this.f_97736_, this.f_97735_ + this.f_97726_, this.f_97736_ + this.f_97727_, -3750202);
        graphics.m_280509_(this.f_97735_, this.f_97736_, this.f_97735_ + this.f_97726_, this.f_97736_ + 1, -13158601);
        graphics.m_280509_(this.f_97735_, this.f_97736_ + this.f_97727_ - 1, this.f_97735_ + this.f_97726_, this.f_97736_ + this.f_97727_, -13158601);
        graphics.m_280509_(this.f_97735_, this.f_97736_, this.f_97735_ + 1, this.f_97736_ + this.f_97727_, -13158601);
        graphics.m_280509_(this.f_97735_ + this.f_97726_ - 1, this.f_97736_, this.f_97735_ + this.f_97726_, this.f_97736_ + this.f_97727_, -13158601);
        graphics.m_280509_(this.f_97735_ + 1, this.f_97736_ + 1, this.f_97735_ + this.f_97726_ - 1, this.f_97736_ + this.f_97727_ - 1, -2039584);
        graphics.m_280509_(this.f_97735_ + 7, this.f_97736_ + 19, this.f_97735_ + 120, this.f_97736_ + 33, -13158601);
        graphics.m_280509_(this.f_97735_ + 8, this.f_97736_ + 20, this.f_97735_ + 119, this.f_97736_ + 32, -986896);
        graphics.m_280509_(this.f_97735_ + 7, this.f_97736_ + 37, this.f_97735_ + 171, this.f_97736_ + 131, -7631989);
        graphics.m_280509_(this.f_97735_ + 8, this.f_97736_ + 38, this.f_97735_ + 170, this.f_97736_ + 130, -13158601);
        int scrollbarX = this.f_97735_ + 175;
        int scrollbarY = this.f_97736_ + 38;
        int scrollbarHeight = 92;
        graphics.m_280509_(scrollbarX, scrollbarY, scrollbarX + 12, scrollbarY + scrollbarHeight, -5592406);
        graphics.m_280509_(scrollbarX + 1, scrollbarY + 1, scrollbarX + 11, scrollbarY + scrollbarHeight - 1, -10461088);
        if (this.canScroll()) {
            boolean hovered;
            float scrollPos = this.scrollOffset * (float)(scrollbarHeight - 15);
            int sliderY = scrollbarY + (int)scrollPos;
            boolean bl = hovered = mouseX >= scrollbarX && mouseX < scrollbarX + 12 && mouseY >= sliderY && mouseY < sliderY + 15;
            int sliderColor = this.isScrolling ? -12566464 : (hovered ? -11513776 : -8355712);
            graphics.m_280509_(scrollbarX, sliderY, scrollbarX + 12, sliderY + 15, sliderColor);
            graphics.m_280509_(scrollbarX + 1, sliderY + 1, scrollbarX + 11, sliderY + 14, -3355444);
        } else {
            graphics.m_280509_(scrollbarX, scrollbarY, scrollbarX + 12, scrollbarY + 15, -8355712);
            graphics.m_280509_(scrollbarX + 1, scrollbarY + 1, scrollbarX + 11, scrollbarY + 14, -6710887);
        }
        for (int row = 0; row < 3; ++row) {
            for (int col = 0; col < 9; ++col) {
                int x = this.f_97735_ + 8 + col * 18;
                int y = this.f_97736_ + 174 + row * 18;
                graphics.m_280509_(x - 1, y - 1, x + 17, y + 17, -7631989);
                graphics.m_280509_(x, y, x + 16, y + 16, -13158601);
            }
        }
        for (int col = 0; col < 9; ++col) {
            int x = this.f_97735_ + 8 + col * 18;
            int y = this.f_97736_ + 232;
            graphics.m_280509_(x - 1, y - 1, x + 17, y + 17, -7631989);
            graphics.m_280509_(x, y, x + 16, y + 16, -13158601);
        }
        this.renderItems(graphics);
        graphics.m_280509_(this.f_97735_ + 50, this.f_97736_ + 135, this.f_97735_ + 130, this.f_97736_ + 149, -13158601);
        graphics.m_280509_(this.f_97735_ + 51, this.f_97736_ + 136, this.f_97735_ + 129, this.f_97736_ + 148, -986896);
        String capacityText = String.format("%d/%d", ((WarehouseControlScreenHandler)this.f_97732_).getUsedCapacity(), ((WarehouseControlScreenHandler)this.f_97732_).getTotalCapacity());
        graphics.m_280137_(this.f_96547_, capacityText, this.f_97735_ + 90, this.f_97736_ + 138, 0x404040);
    }

    private void renderItems(GuiGraphics graphics) {
        int itemIndex;
        int startX = this.f_97735_ + 8;
        int startY = this.f_97736_ + 38;
        for (int i = 0; i < this.getVisibleItemCount() && (itemIndex = i + (int)(this.scrollOffset * 9.0f)) < this.filteredItems.size(); ++i) {
            ItemStack stack = this.filteredItems.get(itemIndex);
            int x = startX + i % 9 * 18;
            int y = startY + i / 9 * 18;
            graphics.m_280480_(stack, x, y);
            int actualCount = this.getActualItemCount(stack);
            Object countText = actualCount > 999 ? actualCount / 1000 + "k" : (actualCount > stack.m_41741_() ? String.valueOf(actualCount) : null);
            if (countText != null) {
                graphics.m_280168_().m_85836_();
                graphics.m_280168_().m_252880_(0.0f, 0.0f, 200.0f);
                graphics.m_280056_(this.f_96547_, (String)countText, x + 17 - this.f_96547_.m_92895_((String)countText), y + 9, 0xFFFFFF, true);
                graphics.m_280168_().m_85849_();
                continue;
            }
            graphics.m_280370_(this.f_96547_, stack, x, y);
        }
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        int itemIndex;
        this.justClickedWarehouseItem = false;
        int startX = this.f_97735_ + 8;
        int startY = this.f_97736_ + 38;
        for (int i = 0; i < this.getVisibleItemCount() && (itemIndex = i + (int)(this.scrollOffset * 9.0f)) < this.filteredItems.size(); ++i) {
            int x = startX + i % 9 * 18;
            int y = startY + i / 9 * 18;
            if (!(mouseX >= (double)x) || !(mouseX < (double)(x + 18)) || !(mouseY >= (double)y) || !(mouseY < (double)(y + 18))) continue;
            ItemStack stack = this.filteredItems.get(itemIndex);
            boolean rightClick = button == 1;
            boolean shiftClick = WarehouseControlScreen.m_96638_();
            this.justClickedWarehouseItem = true;
            ClientPacketHandler.sendWarehouseItemRequest(((WarehouseControlScreenHandler)this.f_97732_).getBlockPos(), stack, shiftClick, rightClick);
            return true;
        }
        int scrollbarX = this.f_97735_ + 175;
        int scrollbarY = this.f_97736_ + 38;
        if (mouseX >= (double)scrollbarX && mouseX < (double)(scrollbarX + 12) && mouseY >= (double)scrollbarY && mouseY < (double)(scrollbarY + 90) && this.canScroll()) {
            this.isScrolling = true;
            this.scrollMouseY = (int)mouseY;
            return true;
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        this.isScrolling = false;
        if (button == 0 && !this.justClickedWarehouseItem && ((WarehouseControlScreenHandler)this.f_97732_).m_142621_() != null && !((WarehouseControlScreenHandler)this.f_97732_).m_142621_().m_41619_()) {
            int startX = this.f_97735_ + 8;
            int startY = this.f_97736_ + 38;
            int endX = this.f_97735_ + 170;
            int endY = this.f_97736_ + 130;
            if (mouseX >= (double)startX && mouseX <= (double)endX && mouseY >= (double)startY && mouseY <= (double)endY) {
                ClientPacketHandler.sendWarehouseItemDeposit(((WarehouseControlScreenHandler)this.f_97732_).getBlockPos());
                return true;
            }
        }
        this.justClickedWarehouseItem = false;
        return super.m_6348_(mouseX, mouseY, button);
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.isScrolling) {
            int scrollbarY = this.f_97736_ + 38;
            int scrollbarHeight = 75;
            float newScroll = ((float)mouseY - (float)scrollbarY) / (float)scrollbarHeight;
            this.scrollOffset = Math.max(0.0f, Math.min(1.0f, newScroll));
            return true;
        }
        return super.m_7979_(mouseX, mouseY, button, dragX, dragY);
    }

    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        if (this.canScroll()) {
            int maxScroll = this.getMaxScroll();
            this.scrollOffset -= (float)(delta / (double)maxScroll);
            this.scrollOffset = Math.max(0.0f, Math.min(1.0f, this.scrollOffset));
            return true;
        }
        return super.m_6050_(mouseX, mouseY, delta);
    }

    private void updateFilteredItems() {
        this.filteredItems.clear();
        String searchText = this.searchBox.m_94155_().toLowerCase();
        for (ItemStack stack : ((WarehouseControlScreenHandler)this.f_97732_).getCachedItems()) {
            if (!searchText.isEmpty() && !stack.m_41786_().getString().toLowerCase().contains(searchText) && !stack.m_41720_().toString().toLowerCase().contains(searchText)) continue;
            this.filteredItems.add(stack);
        }
        if (!searchText.equals(this.lastSearchText)) {
            this.scrollOffset = 0.0f;
            this.lastSearchText = searchText;
        }
    }

    private boolean canScroll() {
        return this.filteredItems.size() > 45;
    }

    private int getMaxScroll() {
        return Math.max(1, (this.filteredItems.size() - 1) / 9 - 5 + 1);
    }

    private int getVisibleItemCount() {
        return Math.min(this.filteredItems.size(), 45);
    }

    private int getActualItemCount(ItemStack displayStack) {
        return displayStack.m_41613_();
    }

    private String getCurrentSortType() {
        return ((WarehouseControlScreenHandler)this.f_97732_).getCachedSortType().toLowerCase();
    }

    private boolean isAscending() {
        return ((WarehouseControlScreenHandler)this.f_97732_).getCachedSortAscending();
    }

    private void updateSortButton() {
        this.sortButton.m_93666_((Component)Component.m_237115_((String)("gui.hundred_years_war.warehouse.sort." + this.getCurrentSortType())));
    }

    private void updateOrderButton() {
        this.orderButton.m_93666_((Component)Component.m_237113_((String)(this.isAscending() ? "\u25b2" : "\u25bc")));
    }

    public void updateItemData(List<ItemStack> items, int totalCapacity, int usedCapacity) {
        ((WarehouseControlScreenHandler)this.f_97732_).updateCachedItems(items, totalCapacity, usedCapacity);
        this.updateFilteredItems();
    }

    public WarehouseControlScreenHandler getMenu() {
        return (WarehouseControlScreenHandler)this.f_97732_;
    }

    public void updateSortState(String sortType, boolean ascending) {
        ((WarehouseControlScreenHandler)this.f_97732_).updateSortState(sortType, ascending);
        this.updateSortButton();
        this.updateOrderButton();
        this.updateFilteredItems();
    }
}

