/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.client.utils;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;

public class TooltipHelper {
    private static final float MAX_WIDTH_RATIO = 0.3f;

    public static List<Component> splitComponent(Component component) {
        Minecraft minecraft = Minecraft.m_91087_();
        if (minecraft == null) {
            ArrayList<Component> result = new ArrayList<Component>();
            result.add(component);
            return result;
        }
        Font font = minecraft.f_91062_;
        int maxWidth = (int)((float)minecraft.m_91268_().m_85445_() * 0.3f);
        String fullText = component.getString();
        Style style = component.m_7383_();
        if (font.m_92895_(fullText) <= maxWidth && fullText.indexOf(10) < 0) {
            ArrayList<Component> result = new ArrayList<Component>();
            result.add(component);
            return result;
        }
        ArrayList<Component> lines = new ArrayList<Component>();
        StringBuilder currentLine = new StringBuilder();
        StringBuilder activeFormats = new StringBuilder();
        for (int i = 0; i < fullText.length(); ++i) {
            Object toAppend;
            char c = fullText.charAt(i);
            if (c == '\n') {
                lines.add((Component)Component.m_237113_((String)currentLine.toString()).m_130948_(style));
                currentLine.setLength(0);
                if (activeFormats.length() <= 0) continue;
                currentLine.append((CharSequence)activeFormats);
                continue;
            }
            if (c == '\u00a7' && i + 1 < fullText.length()) {
                char code = fullText.charAt(i + 1);
                toAppend = "\u00a7" + code;
                ++i;
                if (code == 'r' || code == 'R') {
                    activeFormats.setLength(0);
                } else if (code >= '0' && code <= '9' || code >= 'a' && code <= 'f' || code >= 'A' && code <= 'F') {
                    activeFormats.setLength(0);
                    activeFormats.append('\u00a7').append(code);
                } else if (code >= 'k' && code <= 'o' || code >= 'K' && code <= 'O') {
                    activeFormats.append('\u00a7').append(code);
                }
            } else {
                toAppend = String.valueOf(c);
            }
            String testLine = currentLine + (String)toAppend;
            if (font.m_92895_(testLine) > maxWidth && currentLine.length() > 0) {
                lines.add((Component)Component.m_237113_((String)currentLine.toString()).m_130948_(style));
                currentLine.setLength(0);
                if (activeFormats.length() > 0) {
                    currentLine.append((CharSequence)activeFormats);
                }
            }
            currentLine.append((String)toAppend);
        }
        if (currentLine.length() > 0) {
            lines.add((Component)Component.m_237113_((String)currentLine.toString()).m_130948_(style));
        }
        if (lines.isEmpty()) {
            lines.add(component);
        }
        return lines;
    }

    public static void processTooltip(List<Component> tooltip) {
        ArrayList<Component> processedLines = new ArrayList<Component>();
        for (Component line : tooltip) {
            List<Component> splitLines = TooltipHelper.splitComponent(line);
            processedLines.addAll(splitLines);
        }
        tooltip.clear();
        tooltip.addAll(processedLines);
    }

    public static void addToTooltip(List<Component> tooltip, Component component) {
        List<Component> splitLines = TooltipHelper.splitComponent(component);
        tooltip.addAll(splitLines);
    }
}

