/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.main.blocks.warehouse;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;
import ydmsama.hundred_years_war.main.blocks.ModBlockEntities;
import ydmsama.hundred_years_war.main.blocks.warehouse.WarehouseControlBlockEntity;
import ydmsama.hundred_years_war.main.network.ServerPacketHandler;
import ydmsama.hundred_years_war.main.network.packets.OpenWorkstationSyncPacket;

public class WarehouseControlBlock
extends HorizontalDirectionalBlock
implements EntityBlock {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;

    public WarehouseControlBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING});
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_8125_());
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new WarehouseControlBlockEntity(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level world, BlockState state, BlockEntityType<T> type) {
        return type == ModBlockEntities.WAREHOUSE_CONTROL.get() ? (level, pos, blockState, blockEntity) -> ((WarehouseControlBlockEntity)blockEntity).tick() : null;
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        BlockEntity blockEntity;
        if (!world.f_46443_ && (blockEntity = world.m_7702_(pos)) instanceof WarehouseControlBlockEntity) {
            WarehouseControlBlockEntity warehouseControl = (WarehouseControlBlockEntity)blockEntity;
            if (player.m_6144_()) {
                warehouseControl.setShowRange(!warehouseControl.isShowRange());
            } else if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                warehouseControl.syncAllDataToClient(serverPlayer);
                ServerPacketHandler.sendOpenWorkstationSync(serverPlayer, pos, OpenWorkstationSyncPacket.WorkstationType.WAREHOUSE);
            }
        }
        return InteractionResult.m_19078_((boolean)world.f_46443_);
    }

    public void m_6810_(BlockState state, Level world, BlockPos pos, BlockState newState, boolean moved) {
        if (!state.m_60713_(newState.m_60734_())) {
            BlockEntity blockEntity = world.m_7702_(pos);
            if (blockEntity instanceof WarehouseControlBlockEntity) {
                // empty if block
            }
            super.m_6810_(state, world, pos, newState, moved);
        }
    }

    public static boolean canTransportAccess(Level world, BlockPos warehousePos, BlockPos workstationPos) {
        double distance = Math.sqrt(warehousePos.m_123331_((Vec3i)workstationPos));
        return distance <= 64.0;
    }
}

