/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.main.blocks.warehouse;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.Nullable;
import ydmsama.hundred_years_war.main.blocks.ModBlockEntities;
import ydmsama.hundred_years_war.main.blocks.warehouse.WarehouseControlBlock;
import ydmsama.hundred_years_war.main.blocks.warehouse.WarehouseControlScreenHandler;
import ydmsama.hundred_years_war.main.blocks.warehouse.WarehouseStorageBlockEntity;
import ydmsama.hundred_years_war.main.blocks.workstation.BoundedWorkstationBlockEntity;
import ydmsama.hundred_years_war.main.network.ServerPacketHandler;
import ydmsama.hundred_years_war.main.network.packets.warehouse.WarehouseItemData;

public class WarehouseControlBlockEntity
extends BoundedWorkstationBlockEntity
implements MenuProvider {
    private final Set<BlockPos> storagePositions = new HashSet<BlockPos>();
    private final Map<ItemStack, Integer> itemMap = new LinkedHashMap<ItemStack, Integer>();
    private final List<Map.Entry<ItemStack, Integer>> sortedItems = new ArrayList<Map.Entry<ItemStack, Integer>>();
    private int totalCapacity = 0;
    private int usedCapacity = 0;
    private final Set<WarehouseControlScreenHandler> viewers = new HashSet<WarehouseControlScreenHandler>();
    private SortType sortType = SortType.NAME;
    private boolean sortAscending = true;

    public WarehouseControlBlockEntity(BlockPos pos, BlockState blockState) {
        super((BlockEntityType)ModBlockEntities.WAREHOUSE_CONTROL.get(), pos, blockState);
        this.workRangeLeft = 3;
        this.workRangeRight = 3;
        this.workRangeUp = 3;
        this.workRangeDown = 3;
        this.showRange = true;
    }

    @Override
    public int getMaxRangeLeft() {
        return 10;
    }

    @Override
    public int getMaxRangeRight() {
        return 10;
    }

    @Override
    public int getMaxRangeUp() {
        return 10;
    }

    @Override
    public int getMaxRangeDown() {
        return 10;
    }

    @Override
    protected boolean shouldLoadWorkRange() {
        return true;
    }

    @Override
    public Direction getFacing() {
        BlockState state = this.m_58900_();
        if (state.m_61138_((Property)WarehouseControlBlock.FACING)) {
            return (Direction)state.m_61143_((Property)WarehouseControlBlock.FACING);
        }
        return Direction.NORTH;
    }

    @Override
    public void triggerWork() {
        if (!this.f_58857_.f_46443_) {
            this.scanStorageBlocks();
            this.updateItemMap();
        }
    }

    public void tick() {
        if (this.f_58857_ != null && !this.f_58857_.f_46443_ && this.f_58857_.m_46467_() % 20L == 0L) {
            this.scanAndUpdate();
        }
    }

    public void syncAllDataToClient(ServerPlayer player) {
        this.scanAndUpdate();
        this.syncToClient(player);
    }

    public void addViewer(WarehouseControlScreenHandler viewer) {
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            this.viewers.add(viewer);
            viewer.markForUpdate();
        }
    }

    public void removeViewer(WarehouseControlScreenHandler viewer) {
        this.viewers.remove((Object)viewer);
    }

    public void updateViewers() {
        for (WarehouseControlScreenHandler viewer : this.viewers) {
            viewer.markForUpdate();
        }
    }

    public void scanAndUpdate() {
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            this.scanStorageBlocks();
            this.updateItemMap();
        }
    }

    private void scanStorageBlocks() {
        HashSet newStoragePositions = new HashSet();
        AABB workArea = this.getWorkArea();
        if (workArea != null) {
            BlockPos.m_121990_((BlockPos)BlockPos.m_274561_((double)workArea.f_82288_, (double)workArea.f_82289_, (double)workArea.f_82290_), (BlockPos)BlockPos.m_274561_((double)(workArea.f_82291_ - 1.0), (double)(workArea.f_82292_ - 1.0), (double)(workArea.f_82293_ - 1.0))).forEach(pos -> {
                BlockEntity blockEntity = this.f_58857_.m_7702_(pos);
                if (blockEntity instanceof WarehouseStorageBlockEntity) {
                    newStoragePositions.add(pos.m_7949_());
                }
            });
        }
        if (!newStoragePositions.equals(this.storagePositions)) {
            this.storagePositions.clear();
            this.storagePositions.addAll(newStoragePositions);
            this.m_6596_();
        }
    }

    private void updateItemMap() {
        LinkedHashMap<ItemStack, Integer> newItemMap = new LinkedHashMap<ItemStack, Integer>();
        int newTotalCapacity = 0;
        int newUsedCapacity = 0;
        for (BlockPos pos : this.storagePositions) {
            BlockEntity blockEntity = this.f_58857_.m_7702_(pos);
            if (!(blockEntity instanceof WarehouseStorageBlockEntity)) continue;
            WarehouseStorageBlockEntity storage = (WarehouseStorageBlockEntity)blockEntity;
            newTotalCapacity += storage.m_6643_();
            for (int i = 0; i < storage.m_6643_(); ++i) {
                ItemStack stack = storage.m_8020_(i);
                if (stack.m_41619_()) continue;
                ++newUsedCapacity;
                boolean found = false;
                for (Map.Entry entry : newItemMap.entrySet()) {
                    if (!ItemStack.m_150942_((ItemStack)((ItemStack)entry.getKey()), (ItemStack)stack)) continue;
                    entry.setValue((Integer)entry.getValue() + stack.m_41613_());
                    found = true;
                    break;
                }
                if (found) continue;
                ItemStack keyStack = stack.m_41777_();
                keyStack.m_41764_(1);
                newItemMap.put(keyStack, stack.m_41613_());
            }
        }
        if (!newItemMap.equals(this.itemMap) || newTotalCapacity != this.totalCapacity || newUsedCapacity != this.usedCapacity) {
            this.itemMap.clear();
            this.itemMap.putAll(newItemMap);
            this.totalCapacity = newTotalCapacity;
            this.usedCapacity = newUsedCapacity;
            this.updateSortedItems();
            this.updateViewers();
            this.syncToClients();
            this.m_6596_();
        }
    }

    private void updateSortedItems() {
        this.sortedItems.clear();
        ArrayList<Map.Entry<ItemStack, Integer>> entries = new ArrayList<Map.Entry<ItemStack, Integer>>(this.itemMap.entrySet());
        entries.sort((a, b) -> {
            int result = 0;
            switch (this.sortType) {
                case NAME: {
                    result = ((ItemStack)a.getKey()).m_41786_().getString().compareTo(((ItemStack)b.getKey()).m_41786_().getString());
                    break;
                }
                case QUANTITY: {
                    result = Integer.compare((Integer)a.getValue(), (Integer)b.getValue());
                    break;
                }
                case ID: {
                    result = ((ItemStack)a.getKey()).m_41720_().toString().compareTo(((ItemStack)b.getKey()).m_41720_().toString());
                }
            }
            return this.sortAscending ? result : -result;
        });
        this.sortedItems.addAll(entries);
    }

    public ItemStack tryAddItem(ItemStack stack) {
        if (stack.m_41619_() || this.f_58857_.f_46443_) {
            return stack;
        }
        ItemStack remaining = stack.m_41777_();
        for (BlockPos pos : this.storagePositions) {
            if (remaining.m_41619_()) break;
            BlockEntity blockEntity = this.f_58857_.m_7702_(pos);
            if (!(blockEntity instanceof WarehouseStorageBlockEntity)) continue;
            WarehouseStorageBlockEntity storage = (WarehouseStorageBlockEntity)blockEntity;
            remaining = storage.tryAddItem(remaining);
        }
        this.updateItemMap();
        return remaining;
    }

    public ItemStack tryExtractItem(ItemStack requestStack) {
        if (requestStack.m_41619_() || this.f_58857_.f_46443_) {
            return ItemStack.f_41583_;
        }
        int remainingCount = requestStack.m_41613_();
        ItemStack result = requestStack.m_41777_();
        result.m_41764_(0);
        for (BlockPos pos : this.storagePositions) {
            if (remainingCount <= 0) break;
            BlockEntity blockEntity = this.f_58857_.m_7702_(pos);
            if (!(blockEntity instanceof WarehouseStorageBlockEntity)) continue;
            WarehouseStorageBlockEntity storage = (WarehouseStorageBlockEntity)blockEntity;
            int extracted = storage.extractItem(requestStack, remainingCount);
            result.m_41769_(extracted);
            remainingCount -= extracted;
        }
        this.updateItemMap();
        return result;
    }

    public int getItemCount(ItemStack stack) {
        for (Map.Entry<ItemStack, Integer> entry : this.itemMap.entrySet()) {
            if (!ItemStack.m_150942_((ItemStack)entry.getKey(), (ItemStack)stack)) continue;
            return entry.getValue();
        }
        return 0;
    }

    public List<ItemStack> getAvailableItemTypes() {
        ArrayList<ItemStack> types = new ArrayList<ItemStack>();
        for (Map.Entry<ItemStack, Integer> entry : this.itemMap.entrySet()) {
            if (entry.getValue() <= 0) continue;
            types.add(entry.getKey().m_41777_());
        }
        return types;
    }

    private void syncToClients() {
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            List players = this.f_58857_.m_6907_();
            for (Player player : players) {
                if (!(player instanceof ServerPlayer)) continue;
                ServerPlayer serverPlayer = (ServerPlayer)player;
                if (!(player.m_20275_((double)this.m_58899_().m_123341_(), (double)this.m_58899_().m_123342_(), (double)this.m_58899_().m_123343_()) < 4096.0)) continue;
                this.syncToClient(serverPlayer);
            }
        }
    }

    public void syncToClient(ServerPlayer player) {
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            ArrayList<WarehouseItemData> itemDataList = new ArrayList<WarehouseItemData>();
            for (Map.Entry<ItemStack, Integer> entry : this.sortedItems) {
                itemDataList.add(new WarehouseItemData(entry.getKey(), entry.getValue()));
            }
            ServerPacketHandler.sendWarehouseDataSync(player, this.m_58899_(), itemDataList, this.totalCapacity, this.usedCapacity, this.sortType.name(), this.sortAscending);
        }
    }

    @Override
    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        ListTag storageList = new ListTag();
        for (BlockPos pos : this.storagePositions) {
            CompoundTag posTag = new CompoundTag();
            posTag.m_128405_("x", pos.m_123341_());
            posTag.m_128405_("y", pos.m_123342_());
            posTag.m_128405_("z", pos.m_123343_());
            storageList.add((Object)posTag);
        }
        tag.m_128365_("StoragePositions", (Tag)storageList);
        tag.m_128359_("SortType", this.sortType.name());
        tag.m_128379_("SortAscending", this.sortAscending);
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.storagePositions.clear();
        ListTag storageList = tag.m_128437_("StoragePositions", 10);
        for (int i = 0; i < storageList.size(); ++i) {
            CompoundTag posTag = storageList.m_128728_(i);
            this.storagePositions.add(new BlockPos(posTag.m_128451_("x"), posTag.m_128451_("y"), posTag.m_128451_("z")));
        }
        if (tag.m_128441_("SortType")) {
            try {
                this.sortType = SortType.valueOf(tag.m_128461_("SortType"));
            }
            catch (IllegalArgumentException e) {
                this.sortType = SortType.NAME;
            }
        }
        this.sortAscending = tag.m_128471_("SortAscending");
    }

    public Component m_5446_() {
        return Component.m_237115_((String)"block.hundred_years_war.warehouse_control");
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int syncId, Inventory playerInventory, Player player) {
        return new WarehouseControlScreenHandler(syncId, playerInventory, this);
    }

    public List<ItemStack> getSortedItems() {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        for (Map.Entry<ItemStack, Integer> entry : this.sortedItems) {
            ItemStack display = entry.getKey().m_41777_();
            display.m_41764_(Math.min(entry.getValue(), 127));
            items.add(display);
        }
        return items;
    }

    public int getTotalCapacity() {
        return this.totalCapacity;
    }

    public int getUsedCapacity() {
        return this.usedCapacity;
    }

    public SortType getSortType() {
        return this.sortType;
    }

    public void setSortType(SortType sortType) {
        this.sortType = sortType;
        this.updateSortedItems();
        this.syncToClients();
    }

    public boolean isSortAscending() {
        return this.sortAscending;
    }

    public void setSortAscending(boolean ascending) {
        this.sortAscending = ascending;
        this.updateSortedItems();
        this.syncToClients();
    }

    public int getStorageBlockCount() {
        return this.storagePositions.size();
    }

    public boolean stillValid(Player player) {
        if (this.f_58857_.m_7702_(this.f_58858_) != this) {
            return false;
        }
        return player.m_20275_((double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_() + 0.5, (double)this.f_58858_.m_123343_() + 0.5) <= 64.0;
    }

    public static enum SortType {
        NAME,
        QUANTITY,
        ID;


        public SortType next() {
            SortType[] values = SortType.values();
            return values[(this.ordinal() + 1) % values.length];
        }
    }
}

