/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.main.blocks.warehouse;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import ydmsama.hundred_years_war.main.blocks.warehouse.WarehouseControlBlockEntity;

public class WarehouseControlScreenHandler
extends AbstractContainerMenu {
    public static final MenuType<WarehouseControlScreenHandler> TYPE = new MenuType(WarehouseControlScreenHandler::clientCreate, null);
    private static BlockPos clientBlockPos = null;
    private final WarehouseControlBlockEntity blockEntity;
    private final BlockPos blockPos;
    private final Player player;
    private List<ItemStack> cachedItems = new ArrayList<ItemStack>();
    private int totalCapacity = 0;
    private int usedCapacity = 0;
    private String cachedSortType = "NAME";
    private boolean cachedSortAscending = true;
    private boolean shouldUpdate = true;

    public WarehouseControlScreenHandler(int syncId, Inventory playerInventory, WarehouseControlBlockEntity blockEntity) {
        super(TYPE, syncId);
        this.blockEntity = blockEntity;
        this.blockPos = blockEntity.m_58899_();
        this.player = playerInventory.f_35978_;
        this.addPlayerInventory(playerInventory);
        if (blockEntity != null && !playerInventory.f_35978_.m_9236_().f_46443_) {
            blockEntity.addViewer(this);
        }
    }

    public static WarehouseControlScreenHandler clientCreate(int syncId, Inventory playerInventory) {
        BlockPos pos = clientBlockPos;
        clientBlockPos = null;
        if (pos != null) {
            WarehouseControlBlockEntity blockEntity = (WarehouseControlBlockEntity)playerInventory.f_35978_.m_9236_().m_7702_(pos);
            return new WarehouseControlScreenHandler(syncId, playerInventory, blockEntity, true);
        }
        throw new IllegalStateException("No BlockPos set for client screen handler creation");
    }

    public static void setClientBlockPos(BlockPos pos) {
        clientBlockPos = pos;
    }

    private WarehouseControlScreenHandler(int syncId, Inventory playerInventory, WarehouseControlBlockEntity blockEntity, boolean isClient) {
        this(syncId, playerInventory, blockEntity);
        this.cachedItems.clear();
        this.totalCapacity = 0;
        this.usedCapacity = 0;
        if (this.blockEntity != null) {
            this.cachedSortType = blockEntity.getSortType().name();
            this.cachedSortAscending = blockEntity.isSortAscending();
        }
    }

    private void addPlayerInventory(Inventory playerInventory) {
        for (int row = 0; row < 3; ++row) {
            for (int col = 0; col < 9; ++col) {
                this.m_38897_(new Slot((Container)playerInventory, col + row * 9 + 9, 8 + col * 18, 174 + row * 18));
            }
        }
        for (int col = 0; col < 9; ++col) {
            this.m_38897_(new Slot((Container)playerInventory, col, 8 + col * 18, 232));
        }
    }

    public void m_150399_(int slotId, int button, ClickType actionType, Player player) {
        if (slotId >= 36 && slotId < 36 + this.cachedItems.size()) {
            int itemIndex = slotId - 36;
            if (itemIndex < this.cachedItems.size()) {
                ItemStack clickedItem = this.cachedItems.get(itemIndex);
                if (!player.m_9236_().f_46443_) {
                    this.handleItemClick(player, clickedItem, button, actionType);
                }
            }
            return;
        }
        super.m_150399_(slotId, button, actionType, player);
    }

    private void handleItemClick(Player player, ItemStack requestItem, int button, ClickType actionType) {
        boolean rightClick;
        if (this.blockEntity == null) {
            return;
        }
        ItemStack cursorStack = this.m_142621_();
        boolean shiftClick = actionType == ClickType.QUICK_MOVE;
        boolean bl = rightClick = button == 1;
        if (!cursorStack.m_41619_()) {
            ItemStack remaining = this.blockEntity.tryAddItem(cursorStack);
            this.m_142503_(remaining);
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                serverPlayer.f_36096_.m_38946_();
            }
        } else {
            int requestCount = requestItem.m_41741_();
            if (rightClick) {
                int available = this.blockEntity.getItemCount(requestItem);
                requestCount = Math.min(requestCount, (available + 1) / 2);
            }
            ItemStack extractRequest = requestItem.m_41777_();
            extractRequest.m_41764_(requestCount);
            ItemStack extracted = this.blockEntity.tryExtractItem(extractRequest);
            if (!extracted.m_41619_()) {
                if (shiftClick) {
                    if (!this.m_38903_(extracted, 0, 36, false)) {
                        this.blockEntity.tryAddItem(extracted);
                    }
                } else {
                    this.m_142503_(extracted);
                }
                if (player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    serverPlayer.f_36096_.m_38946_();
                }
            }
        }
    }

    public ItemStack m_7648_(Player player, int index) {
        ItemStack result = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot != null && slot.m_6657_()) {
            ItemStack slotStack = slot.m_7993_();
            result = slotStack.m_41777_();
            if (index < 36) {
                if (this.blockEntity != null) {
                    ItemStack remaining = this.blockEntity.tryAddItem(slotStack);
                    slot.m_5852_(remaining);
                    if (remaining.m_41619_() || remaining.m_41613_() != result.m_41613_()) {
                        slot.m_6654_();
                        return result;
                    }
                }
                return ItemStack.f_41583_;
            }
        }
        return result;
    }

    public boolean m_6875_(Player player) {
        if (this.blockEntity != null) {
            return this.blockEntity.stillValid(player);
        }
        return false;
    }

    public void updateCachedItems(List<ItemStack> items, int totalCapacity, int usedCapacity) {
        this.cachedItems = new ArrayList<ItemStack>(items);
        this.totalCapacity = totalCapacity;
        this.usedCapacity = usedCapacity;
    }

    public List<ItemStack> getCachedItems() {
        return this.cachedItems;
    }

    public int getTotalCapacity() {
        return this.totalCapacity;
    }

    public int getUsedCapacity() {
        return this.usedCapacity;
    }

    public BlockPos getBlockPos() {
        return this.blockPos;
    }

    public WarehouseControlBlockEntity getBlockEntity() {
        return this.blockEntity;
    }

    public boolean moveItemStackToPublic(ItemStack stack, int startIndex, int endIndex, boolean reverseDirection) {
        return this.m_38903_(stack, startIndex, endIndex, reverseDirection);
    }

    public void markForUpdate() {
        this.shouldUpdate = true;
    }

    public void m_38946_() {
        Player player;
        super.m_38946_();
        if (this.shouldUpdate && this.blockEntity != null && !this.player.m_9236_().f_46443_ && (player = this.player) instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            this.shouldUpdate = false;
            this.blockEntity.syncToClient(serverPlayer);
        }
    }

    public void m_6877_(Player player) {
        super.m_6877_(player);
        if (this.blockEntity != null) {
            this.blockEntity.removeViewer(this);
        }
    }

    public void updateSortState(String sortType, boolean ascending) {
        this.cachedSortType = sortType;
        this.cachedSortAscending = ascending;
    }

    public String getCachedSortType() {
        return this.cachedSortType;
    }

    public boolean getCachedSortAscending() {
        return this.cachedSortAscending;
    }
}

