/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.main.blocks.workstation;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.Containers;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.Nullable;
import ydmsama.hundred_years_war.main.blocks.workstation.BoundedWorkstationBlockEntity;

public abstract class InventoryBoundedWorkstationBlockEntity
extends BoundedWorkstationBlockEntity
implements WorldlyContainer {
    protected static final int INVENTORY_SIZE = 27;
    protected SimpleContainer inventory;
    protected final ContainerData dataAccess = new ContainerData(){

        public int m_6413_(int index) {
            return switch (index) {
                case 0 -> InventoryBoundedWorkstationBlockEntity.this.workRangeLeft;
                case 1 -> InventoryBoundedWorkstationBlockEntity.this.workRangeRight;
                case 2 -> InventoryBoundedWorkstationBlockEntity.this.workRangeUp;
                case 3 -> InventoryBoundedWorkstationBlockEntity.this.workRangeDown;
                case 4 -> {
                    if (InventoryBoundedWorkstationBlockEntity.this.showRange) {
                        yield 1;
                    }
                    yield 0;
                }
                case 5 -> {
                    if (InventoryBoundedWorkstationBlockEntity.this.activated) {
                        yield 1;
                    }
                    yield 0;
                }
                default -> 0;
            };
        }

        public void m_8050_(int index, int value) {
            switch (index) {
                case 0: {
                    InventoryBoundedWorkstationBlockEntity.this.workRangeLeft = value;
                    break;
                }
                case 1: {
                    InventoryBoundedWorkstationBlockEntity.this.workRangeRight = value;
                    break;
                }
                case 2: {
                    InventoryBoundedWorkstationBlockEntity.this.workRangeUp = value;
                    break;
                }
                case 3: {
                    InventoryBoundedWorkstationBlockEntity.this.workRangeDown = value;
                    break;
                }
                case 4: {
                    InventoryBoundedWorkstationBlockEntity.this.showRange = value != 0;
                    break;
                }
                case 5: {
                    InventoryBoundedWorkstationBlockEntity.this.activated = value != 0;
                }
            }
        }

        public int m_6499_() {
            return 6;
        }
    };

    public InventoryBoundedWorkstationBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState blockState) {
        super(type, pos, blockState);
        this.inventory = new SimpleContainer(27);
    }

    public SimpleContainer getInventory() {
        return this.inventory;
    }

    public ContainerData getDataAccess() {
        return this.dataAccess;
    }

    @Nullable
    public abstract AbstractContainerMenu createMenu(int var1, Inventory var2, Player var3);

    public abstract Component getDisplayName();

    public int m_6643_() {
        return this.inventory.m_6643_();
    }

    public boolean m_7983_() {
        return this.inventory.m_7983_();
    }

    public ItemStack m_8020_(int slot) {
        return this.inventory.m_8020_(slot);
    }

    public ItemStack m_7407_(int slot, int amount) {
        ItemStack result = this.inventory.m_7407_(slot, amount);
        this.m_6596_();
        return result;
    }

    public ItemStack m_8016_(int slot) {
        return this.inventory.m_8016_(slot);
    }

    public void m_6836_(int slot, ItemStack stack) {
        this.inventory.m_6836_(slot, stack);
        this.m_6596_();
    }

    public boolean m_6542_(Player player) {
        return Container.m_272074_((BlockEntity)this, (Player)player);
    }

    public void m_6211_() {
        this.inventory.m_6211_();
        this.m_6596_();
    }

    public int[] m_7071_(Direction side) {
        int[] slots = new int[this.m_6643_()];
        for (int i = 0; i < slots.length; ++i) {
            slots[i] = i;
        }
        return slots;
    }

    public boolean m_7155_(int index, ItemStack itemStack, @Nullable Direction direction) {
        return this.m_7013_(index, itemStack);
    }

    public boolean m_7157_(int index, ItemStack stack, Direction direction) {
        return true;
    }

    public boolean m_7013_(int index, ItemStack stack) {
        return true;
    }

    protected void collectDroppedItems() {
        if (this.f_58857_ == null || this.f_58857_.f_46443_) {
            return;
        }
        AABB workArea = this.getWorkArea();
        List itemEntities = this.f_58857_.m_45976_(ItemEntity.class, workArea);
        for (ItemEntity itemEntity : itemEntities) {
            ItemStack stack;
            if (!itemEntity.m_6084_() || itemEntity.m_213877_() || (stack = itemEntity.m_32055_()).m_41619_()) continue;
            ItemStack remaining = this.insertItemToInventory(stack.m_41777_());
            if (remaining.m_41619_()) {
                itemEntity.m_146870_();
                continue;
            }
            if (remaining.m_41613_() >= stack.m_41613_()) continue;
            itemEntity.m_32045_(remaining);
        }
    }

    protected ItemStack insertItemToInventory(ItemStack stack) {
        for (int i = 0; i < this.inventory.m_6643_(); ++i) {
            int maxStackSize;
            int canAdd;
            ItemStack slotStack = this.inventory.m_8020_(i);
            if (slotStack.m_41619_()) {
                this.inventory.m_6836_(i, stack.m_41777_());
                this.m_6596_();
                return ItemStack.f_41583_;
            }
            if (!ItemStack.m_150942_((ItemStack)slotStack, (ItemStack)stack) || (canAdd = (maxStackSize = Math.min(slotStack.m_41741_(), this.inventory.m_6893_())) - slotStack.m_41613_()) <= 0) continue;
            int toAdd = Math.min(canAdd, stack.m_41613_());
            slotStack.m_41769_(toAdd);
            stack.m_41774_(toAdd);
            this.m_6596_();
            if (!stack.m_41619_()) continue;
            return ItemStack.f_41583_;
        }
        return stack;
    }

    @Override
    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        NonNullList items = NonNullList.m_122780_((int)this.m_6643_(), (Object)ItemStack.f_41583_);
        for (int i = 0; i < this.m_6643_(); ++i) {
            items.set(i, (Object)this.m_8020_(i));
        }
        ContainerHelper.m_18973_((CompoundTag)tag, (NonNullList)items);
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        NonNullList items = NonNullList.m_122780_((int)this.m_6643_(), (Object)ItemStack.f_41583_);
        ContainerHelper.m_18980_((CompoundTag)tag, (NonNullList)items);
        for (int i = 0; i < this.m_6643_(); ++i) {
            this.m_6836_(i, (ItemStack)items.get(i));
        }
    }

    public void dropAllItems(Level world, BlockPos pos) {
        for (int i = 0; i < this.m_6643_(); ++i) {
            ItemStack stack = this.m_8020_(i);
            if (stack.m_41619_()) continue;
            Containers.m_18992_((Level)world, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (ItemStack)stack);
        }
    }
}

