/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.main.chunk;

import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.LongTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.storage.DimensionDataStorage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ydmsama.hundred_years_war.main.chunk.HywChunkManager;

public class ChunkLoadTestManager
extends SavedData {
    private static final Logger LOGGER = LoggerFactory.getLogger(ChunkLoadTestManager.class);
    private static final String DATA_NAME = "hundred_years_war_chunk_load_test";
    public static final boolean ENABLE_CONSOLE_OUTPUT = true;
    private static volatile boolean testEnabled = false;
    private static final int MIN_DISTANCE_FROM_PLAYER = 5000;
    private static final int MAX_DISTANCE_FROM_PLAYER = 10000;
    private static final int MAX_NEW_DISCOVERIES_PER_TICK = 1;
    private static final int MAX_ACTIVE_LOADS = 1;
    private static final int PRELOAD_BATCH_SIZE = 10;
    private static final int PRELOAD_BATCH_COOLDOWN_TICKS = 40;
    private static final int GRID_SIZE = 512;
    private static final boolean RELEASE_AFTER_GENERATION = true;
    private final Long2ObjectOpenHashMap<ChunkLoadRecord> records = new Long2ObjectOpenHashMap();
    private final LongSet knownGrids = new LongOpenHashSet();
    private transient ServerLevel cachedLevel;
    private transient HywChunkManager chunkManager;
    private transient boolean runtimeInitialised;
    private transient Random random;
    private final List<BatchEntry> activeBatch = new ArrayList<BatchEntry>();
    private boolean batchIssued = false;
    private long nextBatchAllowedTick = 0L;
    private long lastTickGameTime = -1L;

    public ChunkLoadTestManager() {
    }

    public ChunkLoadTestManager(CompoundTag tag) {
        long[] known;
        ListTag list = tag.m_128437_("records", 10);
        for (int i = 0; i < list.size(); ++i) {
            ChunkLoadRecord record = new ChunkLoadRecord(list.m_128728_(i));
            this.records.put(record.gridKey, (Object)record);
            this.knownGrids.add(record.gridKey);
        }
        for (long key : known = tag.m_128467_("knownGrids")) {
            this.knownGrids.add(key);
        }
        this.lastTickGameTime = tag.m_128454_("lastTick");
    }

    public CompoundTag m_7176_(CompoundTag tag) {
        ListTag list = new ListTag();
        for (ChunkLoadRecord record : this.records.values()) {
            list.add((Object)record.save());
        }
        tag.m_128365_("records", (Tag)list);
        long[] known = this.knownGrids.toLongArray();
        tag.m_128388_("knownGrids", known);
        tag.m_128356_("lastTick", this.lastTickGameTime);
        return tag;
    }

    public static ChunkLoadTestManager get(ServerLevel level) {
        DimensionDataStorage storage = level.m_8895_();
        return (ChunkLoadTestManager)storage.m_164861_(ChunkLoadTestManager::new, ChunkLoadTestManager::new, DATA_NAME);
    }

    public static boolean isTestEnabled() {
        return testEnabled;
    }

    public static void setTestEnabled(boolean enabled) {
        testEnabled = enabled;
        LOGGER.info("[ChunkLoadTest] \u6d4b\u8bd5\u6a21\u5f0f {}", (Object)(enabled ? "\u542f\u7528" : "\u7981\u7528"));
    }

    public void tick(ServerLevel level) {
        if (!testEnabled) {
            return;
        }
        this.initialiseRuntime(level);
        long gameTime = level.m_46467_();
        if (gameTime == this.lastTickGameTime) {
            return;
        }
        this.lastTickGameTime = gameTime;
        List players = level.m_6907_();
        this.discoverRandomChunks(level, players);
        this.prepareLoadingCandidates(level, players, gameTime);
        this.processLoadingBatches(level, players, gameTime);
        this.monitorActiveLoads(level);
    }

    private void initialiseRuntime(ServerLevel level) {
        if (this.runtimeInitialised && this.cachedLevel == level) {
            return;
        }
        this.cachedLevel = level;
        this.chunkManager = HywChunkManager.get(level);
        this.random = new Random(level.m_7328_());
        this.runtimeInitialised = true;
        this.activeBatch.clear();
        this.batchIssued = false;
        this.nextBatchAllowedTick = level.m_46467_();
    }

    private boolean hasUnfinishedLoads() {
        for (ChunkLoadRecord record : this.records.values()) {
            if (record.state.isTerminal()) continue;
            return true;
        }
        return false;
    }

    private void discoverRandomChunks(ServerLevel level, List<ServerPlayer> players) {
        if (this.hasUnfinishedLoads()) {
            return;
        }
        int discoveredThisTick = 0;
        int maxAttempts = 100;
        for (ServerPlayer player : players) {
            if (discoveredThisTick >= 1) {
                return;
            }
            BlockPos playerPos = player.m_20183_();
            for (int attempt = 0; attempt < maxAttempts; ++attempt) {
                int gridZ;
                int offsetZ;
                double angle = this.random.nextDouble() * Math.PI * 2.0;
                int distanceRange = 5000;
                int distance = 5000 + this.random.nextInt(distanceRange);
                int offsetX = (int)(Math.cos(angle) * (double)distance);
                BlockPos targetPos = playerPos.m_7918_(offsetX, 0, offsetZ = (int)(Math.sin(angle) * (double)distance));
                int gridX = Math.floorDiv(targetPos.m_123341_(), 512) * 512;
                BlockPos alignedPos = new BlockPos(gridX, 64, gridZ = Math.floorDiv(targetPos.m_123343_(), 512) * 512);
                long key = ChunkLoadTestManager.gridKey(alignedPos);
                if (this.knownGrids.contains(key) || this.records.containsKey(key)) continue;
                ChunkLoadRecord record = new ChunkLoadRecord(key, alignedPos, level.m_46467_());
                this.records.put(key, (Object)record);
                this.knownGrids.add(key);
                ++discoveredThisTick;
                this.m_77762_();
                double actualDistance = Math.sqrt(alignedPos.m_123331_((Vec3i)playerPos));
                ChunkLoadTestManager.logInfo("\u53d1\u73b0\u6d4b\u8bd5\u4f4d\u7f6e @ ({}, {}) | \u8ddd\u73a9\u5bb6 {:.0f} \u65b9\u5757 (\u76ee\u6807\uff1a\u6d4b\u8bd5\u65b0\u533a\u5757\u751f\u6210)", alignedPos.m_123341_(), alignedPos.m_123343_(), actualDistance);
                break;
            }
            if (discoveredThisTick < true) continue;
            return;
        }
    }

    private void prepareLoadingCandidates(ServerLevel level, List<ServerPlayer> players, long gameTime) {
        ChunkLoadRecord candidate;
        if (players.isEmpty()) {
            return;
        }
        int activeLoaders = this.countLoadingRecords();
        while (activeLoaders < 1 && (candidate = this.findBestCandidate(players, LoadState.DISCOVERED)) != null) {
            ChunkPos centerChunk = new ChunkPos(candidate.position);
            ArrayList<ChunkPos> requiredChunks = new ArrayList<ChunkPos>();
            for (int dx = -1; dx <= 1; ++dx) {
                for (int dz = -1; dz <= 1; ++dz) {
                    requiredChunks.add(new ChunkPos(centerChunk.f_45578_ + dx, centerChunk.f_45579_ + dz));
                }
            }
            candidate.requiredChunks = requiredChunks;
            if (requiredChunks.isEmpty()) {
                candidate.state = LoadState.COMPLETED;
                candidate.completedTick = gameTime;
                this.m_77762_();
                continue;
            }
            candidate.state = LoadState.LOADING;
            candidate.lastStateTick = gameTime;
            ChunkLoadTestManager.logInfo("\u6d4b\u8bd5\u4f4d\u7f6e ({}, {}) \u5f00\u59cb\u52a0\u8f7d | {} \u4e2a\u533a\u5757", candidate.position.m_123341_(), candidate.position.m_123343_(), requiredChunks.size());
            this.m_77762_();
            ++activeLoaders;
        }
    }

    private void processLoadingBatches(ServerLevel level, List<ServerPlayer> players, long gameTime) {
        if (this.batchIssued) {
            if (this.isCurrentBatchLoaded(level)) {
                this.finalizeBatch(level, gameTime);
            }
            return;
        }
        if (players.isEmpty()) {
            return;
        }
        if (gameTime < this.nextBatchAllowedTick) {
            return;
        }
        List<ChunkLoadRecord> candidates = this.getLoadingRecords(players);
        if (candidates.isEmpty()) {
            return;
        }
        this.activeBatch.clear();
        for (ChunkLoadRecord record : candidates) {
            while (this.activeBatch.size() < 10 && record.requestedCount < record.requiredChunks.size()) {
                int chunkIndex = record.requestedCount;
                ChunkPos chunkPos = record.requiredChunks.get(chunkIndex);
                long chunkKey = chunkPos.m_45588_();
                if (record.requestedChunks.add(chunkKey)) {
                    this.chunkManager.requestChunk(chunkPos.f_45578_, chunkPos.f_45579_);
                }
                this.activeBatch.add(new BatchEntry(record, chunkIndex, chunkPos));
                ++record.requestedCount;
            }
            if (this.activeBatch.size() < 10) continue;
            break;
        }
        if (!this.activeBatch.isEmpty()) {
            this.batchIssued = true;
        }
    }

    private boolean isCurrentBatchLoaded(ServerLevel level) {
        for (BatchEntry entry : this.activeBatch) {
            if (level.m_7232_(entry.chunkPos.f_45578_, entry.chunkPos.f_45579_)) continue;
            return false;
        }
        return true;
    }

    private void finalizeBatch(ServerLevel level, long gameTime) {
        for (BatchEntry entry : this.activeBatch) {
            if (entry.record.loadedCount < entry.chunkIndex + 1) {
                entry.record.loadedCount = entry.chunkIndex + 1;
            }
            if (entry.record.requestedCount >= entry.record.loadedCount) continue;
            entry.record.requestedCount = entry.record.loadedCount;
        }
        this.activeBatch.clear();
        this.batchIssued = false;
        this.nextBatchAllowedTick = gameTime + 40L;
        for (ChunkLoadRecord record : this.records.values()) {
            if (record.state != LoadState.LOADING || record.loadedCount < record.requiredChunks.size()) continue;
            record.state = LoadState.COMPLETED;
            record.completedTick = gameTime;
            long duration = gameTime - record.addedTick;
            ChunkLoadTestManager.logInfo("\u6d4b\u8bd5\u4f4d\u7f6e ({}, {}) \u751f\u6210\u5b8c\u6210 | \u8017\u65f6: {} ticks ({:.2f}\u79d2)", record.position.m_123341_(), record.position.m_123343_(), duration, (double)duration / 20.0);
            record.lastStateTick = gameTime;
            this.releaseRecordChunks(record);
            ChunkLoadTestManager.logInfo("\u6d4b\u8bd5\u4f4d\u7f6e ({}, {}) \u7684\u533a\u5757\u5df2\u91ca\u653e\uff0c\u7b49\u5f85\u5378\u8f7d", record.position.m_123341_(), record.position.m_123343_());
            this.m_77762_();
        }
    }

    private void releaseRecordChunks(ChunkLoadRecord record) {
    }

    private void monitorActiveLoads(ServerLevel level) {
    }

    private List<ChunkLoadRecord> getLoadingRecords(List<ServerPlayer> players) {
        ArrayList<ChunkLoadRecord> list = new ArrayList<ChunkLoadRecord>();
        for (ChunkLoadRecord record2 : this.records.values()) {
            if (record2.state != LoadState.LOADING || record2.loadedCount >= record2.requiredChunks.size()) continue;
            list.add(record2);
        }
        list.sort(Comparator.comparingDouble(record -> this.recordDistanceSquared((ChunkLoadRecord)record, players)));
        return list;
    }

    private int countLoadingRecords() {
        int count = 0;
        for (ChunkLoadRecord record : this.records.values()) {
            if (record.state != LoadState.LOADING || record.loadedCount >= record.requiredChunks.size()) continue;
            ++count;
        }
        return count;
    }

    private ChunkLoadRecord findBestCandidate(List<ServerPlayer> players, LoadState state) {
        if (this.records.isEmpty()) {
            return null;
        }
        if (players.isEmpty()) {
            for (ChunkLoadRecord record : this.records.values()) {
                if (record.state != state) continue;
                return record;
            }
            return null;
        }
        double bestDistance = Double.POSITIVE_INFINITY;
        ChunkLoadRecord bestRecord = null;
        for (ChunkLoadRecord record : this.records.values()) {
            double distance;
            if (record.state != state || !Double.isFinite(distance = this.recordDistanceSquared(record, players)) || !(distance < bestDistance)) continue;
            bestRecord = record;
            bestDistance = distance;
        }
        return bestRecord;
    }

    private double recordDistanceSquared(ChunkLoadRecord record, List<ServerPlayer> players) {
        if (players.isEmpty()) {
            return Double.POSITIVE_INFINITY;
        }
        double best = Double.POSITIVE_INFINITY;
        for (ServerPlayer player : players) {
            double dist = player.m_20183_().m_123331_((Vec3i)record.position);
            if (!(dist < best)) continue;
            best = dist;
        }
        return best;
    }

    public String getStats() {
        long total = this.records.size();
        long completed = this.records.values().stream().filter(r -> r.state == LoadState.COMPLETED).count();
        long loading = this.records.values().stream().filter(r -> r.state == LoadState.LOADING).count();
        long discovered = this.records.values().stream().filter(r -> r.state == LoadState.DISCOVERED).count();
        double avgTime = 0.0;
        int completedCount = 0;
        for (ChunkLoadRecord record : this.records.values()) {
            if (record.state != LoadState.COMPLETED || record.completedTick <= record.addedTick) continue;
            avgTime += (double)(record.completedTick - record.addedTick);
            ++completedCount;
        }
        if (completedCount > 0) {
            avgTime /= (double)completedCount;
        }
        return String.format(Locale.ROOT, "\u6d4b\u8bd5\u603b\u6570:%d | \u5b8c\u6210:%d | \u52a0\u8f7d\u4e2d:%d | \u7b49\u5f85:%d | \u5e73\u5747\u751f\u6210\u65f6\u95f4:%.1f ticks (%.2f\u79d2) | \u8ddd\u79bb:%d-%d\u65b9\u5757 | \u6d4b\u8bd5\u72b6\u6001:%s", total, completed, loading, discovered, avgTime, avgTime / 20.0, 5000, 10000, testEnabled ? "\u542f\u7528" : "\u7981\u7528");
    }

    public void clearRecords() {
        this.records.clear();
        this.knownGrids.clear();
        this.activeBatch.clear();
        this.batchIssued = false;
        this.m_77762_();
        ChunkLoadTestManager.logInfo("\u5df2\u6e05\u9664\u6240\u6709\u6d4b\u8bd5\u8bb0\u5f55", new Object[0]);
    }

    public void releaseAllChunks() {
        if (this.chunkManager == null || this.cachedLevel == null) {
            ChunkLoadTestManager.logWarn("\u65e0\u6cd5\u91ca\u653e\u533a\u5757\uff1a\u7ba1\u7406\u5668\u672a\u521d\u59cb\u5316", new Object[0]);
            return;
        }
        int releasedCount = 0;
        for (ChunkLoadRecord record : this.records.values()) {
            if (record.requiredChunks == null) continue;
            for (ChunkPos chunkPos : record.requiredChunks) {
                if (!record.requestedChunks.contains(chunkPos.m_45588_())) continue;
                ++releasedCount;
            }
        }
        ChunkLoadTestManager.logInfo("\u5df2\u6807\u8bb0\u91ca\u653e {} \u4e2a\u6d4b\u8bd5\u533a\u5757\u7684\u7968\u636e", releasedCount);
        ChunkLoadTestManager.logInfo("\u6ce8\u610f\uff1a\u533a\u5757\u53ef\u80fd\u56e0\u4e3a\u73a9\u5bb6\u6216\u5176\u4ed6\u7cfb\u7edf\u800c\u4fdd\u6301\u52a0\u8f7d\u72b6\u6001", new Object[0]);
    }

    public void reset() {
        this.releaseAllChunks();
        this.clearRecords();
        ChunkLoadTestManager.logInfo("\u6d4b\u8bd5\u7cfb\u7edf\u5df2\u5b8c\u5168\u91cd\u7f6e", new Object[0]);
    }

    private static long gridKey(BlockPos pos) {
        int gridX = Math.floorDiv(pos.m_123341_(), 512);
        int gridZ = Math.floorDiv(pos.m_123343_(), 512);
        return ChunkPos.m_45589_((int)gridX, (int)gridZ);
    }

    private static void logInfo(String message, Object ... args) {
        LOGGER.info(message, args);
    }

    private static void logWarn(String message, Object ... args) {
        LOGGER.warn(message, args);
    }

    private static final class ChunkLoadRecord {
        final long gridKey;
        final BlockPos position;
        LoadState state = LoadState.DISCOVERED;
        long addedTick;
        long completedTick;
        long lastStateTick;
        List<ChunkPos> requiredChunks = Collections.emptyList();
        final LongSet requestedChunks = new LongOpenHashSet();
        int requestedCount = 0;
        int loadedCount = 0;

        ChunkLoadRecord(long gridKey, BlockPos position, long addedTick) {
            this.gridKey = gridKey;
            this.position = position;
            this.addedTick = addedTick;
        }

        ChunkLoadRecord(CompoundTag tag) {
            long[] requested;
            ListTag list;
            this.gridKey = tag.m_128454_("gridKey");
            long posLong = tag.m_128454_("position");
            this.position = BlockPos.m_122022_((long)posLong);
            this.state = LoadState.valueOf(tag.m_128461_("state"));
            this.addedTick = tag.m_128454_("addedTick");
            this.completedTick = tag.m_128454_("completedTick");
            this.lastStateTick = tag.m_128454_("lastStateTick");
            if (tag.m_128441_("requestedCount")) {
                this.requestedCount = tag.m_128451_("requestedCount");
            }
            if (tag.m_128441_("loadedCount")) {
                this.loadedCount = tag.m_128451_("loadedCount");
            }
            if (!(list = tag.m_128437_("requiredChunks", 4)).isEmpty()) {
                this.requiredChunks = new ArrayList<ChunkPos>(list.size());
                for (Tag element : list) {
                    long chunkLong = ((LongTag)element).m_7046_();
                    this.requiredChunks.add(new ChunkPos(chunkLong));
                }
            } else {
                this.requiredChunks = new ArrayList<ChunkPos>();
            }
            for (long value : requested = tag.m_128467_("requestedChunks")) {
                this.requestedChunks.add(value);
            }
        }

        CompoundTag save() {
            CompoundTag tag = new CompoundTag();
            tag.m_128356_("gridKey", this.gridKey);
            tag.m_128356_("position", this.position.m_121878_());
            tag.m_128359_("state", this.state.name());
            tag.m_128356_("addedTick", this.addedTick);
            tag.m_128356_("completedTick", this.completedTick);
            tag.m_128356_("lastStateTick", this.lastStateTick);
            tag.m_128405_("requestedCount", this.requestedCount);
            tag.m_128405_("loadedCount", this.loadedCount);
            if (!this.requiredChunks.isEmpty()) {
                ListTag list = new ListTag();
                for (ChunkPos chunk : this.requiredChunks) {
                    list.add((Object)LongTag.m_128882_((long)chunk.m_45588_()));
                }
                tag.m_128365_("requiredChunks", (Tag)list);
            }
            long[] requested = this.requestedChunks.toLongArray();
            tag.m_128388_("requestedChunks", requested);
            return tag;
        }
    }

    private static enum LoadState {
        DISCOVERED,
        LOADING,
        COMPLETED,
        FAILED;


        boolean isTerminal() {
            return this == COMPLETED || this == FAILED;
        }
    }

    private static final class BatchEntry {
        final ChunkLoadRecord record;
        final int chunkIndex;
        final ChunkPos chunkPos;

        BatchEntry(ChunkLoadRecord record, int chunkIndex, ChunkPos chunkPos) {
            this.record = record;
            this.chunkIndex = chunkIndex;
            this.chunkPos = chunkPos;
        }
    }
}

