/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.main.chunk;

import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ThreadLocalRandom;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ChunkHolder;
import net.minecraft.server.level.ChunkLevel;
import net.minecraft.server.level.ChunkMap;
import net.minecraft.server.level.ChunkTaskPriorityQueueSorter;
import net.minecraft.server.level.DistanceManager;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.TicketType;
import net.minecraft.util.Mth;
import net.minecraft.util.thread.ProcessorHandle;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ydmsama.hundred_years_war.main.generation.PregenManager;
import ydmsama.hundred_years_war.main.mixins.interfaces.ChunkMapAccessor;
import ydmsama.hundred_years_war.main.mixins.interfaces.DistanceManagerAccessor;

public final class HywChunkManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(HywChunkManager.class);
    private static final TicketType<Long> HYW_CHUNK_TICKET = TicketType.m_9462_((String)"hundred_years_war_throttled_chunk", Long::compare);
    private static final TicketType<Long> HYW_PERSISTENT_TICKET = TicketType.m_9462_((String)"hundred_years_war_persistent_chunk", Long::compare);
    private static final TicketType<Long> HYW_PREHEAT_TICKET = TicketType.m_9462_((String)"hundred_years_war_preheat", Long::compare);
    private static final int TICKET_FULL = 33;
    private static final int TICKET_BLOCK_TICKING = 32;
    private static final int LOG_INTERVAL_TICKS = 20;
    private static final int COMPLETED_RETENTION_TICKS = 100;
    private static boolean AUTO_PREHEAT_ENABLED = true;
    private static WarmProfile DEFAULT_PROFILE = WarmProfile.DEFAULT_WARM_LIKE_PLAYER;
    private static int PREHEAT_OPS_BUDGET_PER_TICK = Integer.MAX_VALUE;
    private static final int TICKS_PER_STEP = 1;
    private static volatile boolean skipStructureStage = false;
    private static volatile boolean skipHeightmapStage = false;
    private static volatile boolean skipBlockSampleStage = false;
    private static volatile boolean skipBlockEntityStage = false;
    private static volatile boolean skipLightStage = false;
    private static volatile boolean skipPulseStage = false;
    private static volatile boolean instantPreheatMode = false;
    private static final int SERVER_TPS = 20;
    private static final int SERVER_TICK_TIME_MS = 50;
    private static volatile long serverTickStartNano = System.nanoTime();
    private static volatile long lastServerTickDurationMs = 0L;
    private static final Map<ServerLevel, HywChunkManager> INSTANCES = new IdentityHashMap<ServerLevel, HywChunkManager>();
    private final ServerLevel level;
    private final ServerChunkCache chunkSource;
    private final Long2ObjectOpenHashMap<TrackedChunk> trackedChunks = new Long2ObjectOpenHashMap();
    private final Long2ObjectOpenHashMap<PreheatJob> preheatJobs = new Long2ObjectOpenHashMap();
    private final Long2ObjectOpenHashMap<WarmProfile> deferredPreheatRequests = new Long2ObjectOpenHashMap();
    private final Long2ObjectOpenHashMap<List<CompletableFuture<Void>>> pendingWarmFutures = new Long2ObjectOpenHashMap();
    private int preheatOpsBudgetThisTick = PREHEAT_OPS_BUDGET_PER_TICK;
    private final LongSet warmCompleted = new LongOpenHashSet();
    private final Long2ObjectOpenHashMap<Integer> persistentTickets = new Long2ObjectOpenHashMap();
    private final List<WarmBarrier> barriers = new ArrayList<WarmBarrier>();
    private final ArrayDeque<StepRequest> preheatStepQueue = new ArrayDeque();
    private long nextPreheatStepAllowedTick = 0L;

    private HywChunkManager(ServerLevel level) {
        this.level = level;
        this.chunkSource = level.m_7726_();
    }

    public static HywChunkManager get(ServerLevel level) {
        return INSTANCES.computeIfAbsent(level, HywChunkManager::new);
    }

    public static void setAutoPreheatEnabled(boolean enabled) {
        AUTO_PREHEAT_ENABLED = enabled;
    }

    public static boolean isAutoPreheatEnabled() {
        return AUTO_PREHEAT_ENABLED;
    }

    public static void setDefaultWarmProfile(WarmProfile profile) {
        DEFAULT_PROFILE = profile == null ? WarmProfile.DEFAULT_WARM_LIKE_PLAYER : profile;
    }

    public static void setPreheatBudgets(int opsPerTick, int chunksPerTick) {
        PREHEAT_OPS_BUDGET_PER_TICK = Math.max(1, opsPerTick);
    }

    public static boolean isSkipStructureStage() {
        return skipStructureStage;
    }

    public static void setSkipStructureStage(boolean skip) {
        skipStructureStage = skip;
        LOGGER.info("\u9884\u70ed\u8c03\u8bd5 | \u7ed3\u6784\u7d22\u5f15\u9636\u6bb5\u5df2{}", (Object)(skip ? "\u8df3\u8fc7" : "\u6062\u590d"));
    }

    public static boolean isSkipHeightmapStage() {
        return skipHeightmapStage;
    }

    public static void setSkipHeightmapStage(boolean skip) {
        skipHeightmapStage = skip;
        LOGGER.info("\u9884\u70ed\u8c03\u8bd5 | \u9ad8\u5ea6\u91c7\u6837\u9636\u6bb5\u5df2{}", (Object)(skip ? "\u8df3\u8fc7" : "\u6062\u590d"));
    }

    public static boolean isSkipBlockSampleStage() {
        return skipBlockSampleStage;
    }

    public static void setSkipBlockSampleStage(boolean skip) {
        skipBlockSampleStage = skip;
        LOGGER.info("\u9884\u70ed\u8c03\u8bd5 | \u65b9\u5757\u91c7\u6837\u9636\u6bb5\u5df2{}", (Object)(skip ? "\u8df3\u8fc7" : "\u6062\u590d"));
    }

    public static boolean isSkipBlockEntityStage() {
        return skipBlockEntityStage;
    }

    public static void setSkipBlockEntityStage(boolean skip) {
        skipBlockEntityStage = skip;
        LOGGER.info("\u9884\u70ed\u8c03\u8bd5 | \u65b9\u5757\u5b9e\u4f53\u9636\u6bb5\u5df2{}", (Object)(skip ? "\u8df3\u8fc7" : "\u6062\u590d"));
    }

    public static boolean isSkipLightStage() {
        return skipLightStage;
    }

    public static void setSkipLightStage(boolean skip) {
        skipLightStage = skip;
        LOGGER.info("\u9884\u70ed\u8c03\u8bd5 | \u5149\u7167\u9636\u6bb5\u5df2{}", (Object)(skip ? "\u8df3\u8fc7" : "\u6062\u590d"));
    }

    public static boolean isSkipPulseStage() {
        return skipPulseStage;
    }

    public static void setSkipPulseStage(boolean skip) {
        skipPulseStage = skip;
        LOGGER.info("\u9884\u70ed\u8c03\u8bd5 | 32\u7ea7\u8109\u51b2\u9636\u6bb5\u5df2{}", (Object)(skip ? "\u8df3\u8fc7" : "\u6062\u590d"));
    }

    public static void setInstantModeEnabled(boolean enabled) {
        instantPreheatMode = enabled;
        LOGGER.info("\u9884\u70ed\u8c03\u8bd5 | Instant\u6a21\u5f0f\u5df2{}", (Object)(enabled ? "\u5f00\u542f" : "\u5173\u95ed"));
    }

    public static boolean isInstantModeEnabled() {
        return instantPreheatMode;
    }

    public static void setSkipAllStages(boolean skip) {
        HywChunkManager.setSkipStructureStage(skip);
        HywChunkManager.setSkipHeightmapStage(skip);
        HywChunkManager.setSkipBlockSampleStage(skip);
        HywChunkManager.setSkipBlockEntityStage(skip);
        HywChunkManager.setSkipLightStage(skip);
        HywChunkManager.setSkipPulseStage(skip);
    }

    public static boolean areAllStagesSkipped() {
        return skipStructureStage && skipHeightmapStage && skipBlockSampleStage && skipBlockEntityStage && skipLightStage && skipPulseStage;
    }

    public static boolean isPreheatDebugLoggingEnabled() {
        return PregenManager.isDebugLoggingEnabled();
    }

    public static void setPreheatDebugLoggingEnabled(boolean enabled) {
        PregenManager.setDebugLoggingEnabled(enabled);
    }

    private static void debugPreheat(String message, Object ... args) {
        if (!PregenManager.isDebugLoggingEnabled()) {
            return;
        }
        LOGGER.info("[\u9884\u70ed\u8c03\u8bd5] " + message, args);
    }

    private static void logThrottle(String message, Object ... args) {
        HywChunkManager.debugPreheat(message, args);
    }

    public void requestChunk(int chunkX, int chunkZ) {
        this.internalRequestChunkFull(chunkX, chunkZ, true);
        if (AUTO_PREHEAT_ENABLED) {
            this.maybeSchedulePreheat(chunkX, chunkZ, DEFAULT_PROFILE);
        }
    }

    public void requestChunkWarmLikePlayer(int chunkX, int chunkZ) {
        this.internalRequestChunkFull(chunkX, chunkZ, true);
        this.maybeSchedulePreheat(chunkX, chunkZ, WarmProfile.DEFAULT_WARM_LIKE_PLAYER);
    }

    public void requestChunkWarm(int chunkX, int chunkZ, WarmProfile profile) {
        this.internalRequestChunkFull(chunkX, chunkZ, true);
        this.maybeSchedulePreheat(chunkX, chunkZ, profile == null ? DEFAULT_PROFILE : profile);
    }

    public void cancelWarm(int chunkX, int chunkZ) {
        this.cancelWarm(new ChunkPos(chunkX, chunkZ), "manual cancellation");
    }

    public void cancelWarm(ChunkPos chunkPos) {
        this.cancelWarm(chunkPos, "manual cancellation");
    }

    public void cancelWarm(Collection<ChunkPos> chunkPositions) {
        this.cancelWarm(chunkPositions, "manual cancellation");
    }

    public void cancelWarm(Collection<ChunkPos> chunkPositions, String reason) {
        if (chunkPositions == null || chunkPositions.isEmpty()) {
            return;
        }
        for (ChunkPos pos : chunkPositions) {
            this.cancelWarm(pos, reason);
        }
    }

    public void cancelWarm(ChunkPos chunkPos, String reason) {
        if (chunkPos == null) {
            return;
        }
        long key = chunkPos.m_45588_();
        PreheatJob job = (PreheatJob)this.preheatJobs.remove(key);
        if (job != null) {
            job.cancel(reason == null ? "cancelled" : reason);
        }
        this.deferredPreheatRequests.remove(key);
        this.warmCompleted.remove(key);
        this.removeQueuedSteps(key);
        if (job == null) {
            this.completePendingWarmFutures(key, new CancellationException(reason == null ? "cancelled" : reason));
        }
    }

    private void registerWarmWaiter(long key, CompletableFuture<Void> waiter) {
        List waiters = (List)this.pendingWarmFutures.computeIfAbsent(key, k -> new ArrayList());
        waiters.add(waiter);
    }

    private void attachWaitersToJob(long key, PreheatJob job) {
        List waiters = (List)this.pendingWarmFutures.remove(key);
        if (waiters == null || waiters.isEmpty()) {
            return;
        }
        for (CompletableFuture waiter : waiters) {
            job.future.whenComplete((ignored, throwable) -> {
                if (throwable != null) {
                    waiter.completeExceptionally((Throwable)throwable);
                } else {
                    waiter.complete(null);
                }
            });
        }
    }

    private void completePendingWarmFutures(long key, Throwable throwable) {
        List waiters = (List)this.pendingWarmFutures.remove(key);
        if (waiters == null) {
            return;
        }
        for (CompletableFuture waiter : waiters) {
            if (throwable != null) {
                waiter.completeExceptionally(throwable);
                continue;
            }
            waiter.complete(null);
        }
    }

    public boolean isWarmReady(int chunkX, int chunkZ) {
        long key = ChunkPos.m_45589_((int)chunkX, (int)chunkZ);
        if (this.warmCompleted.contains(key)) {
            return true;
        }
        PreheatJob job = (PreheatJob)this.preheatJobs.get(key);
        if (job != null) {
            return job.state == PreheatState.DONE;
        }
        if (this.deferredPreheatRequests.containsKey(key)) {
            return false;
        }
        TrackedChunk tracked = (TrackedChunk)this.trackedChunks.get(key);
        if (tracked != null && !tracked.completed) {
            return false;
        }
        if (!this.chunkSource.m_5563_(chunkX, chunkZ)) {
            return false;
        }
        if (!AUTO_PREHEAT_ENABLED) {
            return true;
        }
        return true;
    }

    public int getWarmProgress(int chunkX, int chunkZ) {
        if (!this.chunkSource.m_5563_(chunkX, chunkZ)) {
            return 0;
        }
        long key = ChunkPos.m_45589_((int)chunkX, (int)chunkZ);
        PreheatJob job = (PreheatJob)this.preheatJobs.get(key);
        if (job == null) {
            return 100;
        }
        return job.progressPercent();
    }

    public String getWarmStatus(int chunkX, int chunkZ) {
        long key = ChunkPos.m_45589_((int)chunkX, (int)chunkZ);
        PreheatJob job = (PreheatJob)this.preheatJobs.get(key);
        boolean full = this.chunkSource.m_5563_(chunkX, chunkZ);
        if (job == null) {
            return full ? "FULL(\u65e0\u9884\u70ed\u4efb\u52a1/\u5df2\u5b8c\u6210)" : "\u672a\u52a0\u8f7d";
        }
        return (full ? "FULL|" : "\u672aFULL|") + job.state + "|progress=" + job.progressPercent() + "%";
    }

    public CompletableFuture<Void> whenWarm(int chunkX, int chunkZ) {
        long key = ChunkPos.m_45589_((int)chunkX, (int)chunkZ);
        if (this.warmCompleted.contains(key)) {
            return CompletableFuture.completedFuture(null);
        }
        PreheatJob job = (PreheatJob)this.preheatJobs.get(key);
        if (job != null) {
            return job.future;
        }
        if (!AUTO_PREHEAT_ENABLED) {
            return this.chunkSource.m_5563_(chunkX, chunkZ) ? CompletableFuture.completedFuture(null) : this.newFullFuture(chunkX, chunkZ);
        }
        if (!this.trackedChunks.containsKey(key) && !this.deferredPreheatRequests.containsKey(key)) {
            this.requestChunkWarmLikePlayer(chunkX, chunkZ);
        }
        if (this.warmCompleted.contains(key)) {
            return CompletableFuture.completedFuture(null);
        }
        job = (PreheatJob)this.preheatJobs.get(key);
        if (job != null) {
            return job.future;
        }
        CompletableFuture<Void> waiter = new CompletableFuture<Void>();
        this.registerWarmWaiter(key, waiter);
        return waiter;
    }

    public CompletableFuture<Void> whenWarmAll(Collection<ChunkPos> chunks) {
        ArrayList<CompletableFuture<Void>> list = new ArrayList<CompletableFuture<Void>>(chunks.size());
        for (ChunkPos cp : chunks) {
            list.add(this.whenWarm(cp.f_45578_, cp.f_45579_));
        }
        return CompletableFuture.allOf((CompletableFuture[])list.toArray(CompletableFuture[]::new));
    }

    public void onWarmReady(Collection<ChunkPos> chunks, int timeoutTicks, Runnable onReady, Runnable onTimeout) {
        long now = this.level.m_46467_();
        WarmBarrier b = new WarmBarrier(chunks, now, timeoutTicks, onReady, onTimeout);
        this.barriers.add(b);
    }

    public void requestPersistentChunk(int chunkX, int chunkZ) {
        long key = ChunkPos.m_45589_((int)chunkX, (int)chunkZ);
        int ref = this.persistentTickets.containsKey(key) ? (Integer)this.persistentTickets.get(key) : 0;
        this.persistentTickets.put(key, (Object)(++ref));
        if (ref == 1) {
            DistanceManager dm = this.chunkSource.f_8325_.m_143145_();
            dm.m_140792_(HYW_PERSISTENT_TICKET, new ChunkPos(chunkX, chunkZ), 33, (Object)key);
            HywChunkManager.debugPreheat("\u6301\u4e45\u7968\u636e | \u6dfb\u52a0({},{}) FULL", chunkX, chunkZ);
        }
    }

    public void releasePersistentChunk(int chunkX, int chunkZ) {
        long key = ChunkPos.m_45589_((int)chunkX, (int)chunkZ);
        if (!this.persistentTickets.containsKey(key)) {
            LOGGER.warn("\u6301\u4e45\u7968\u636e | \u91ca\u653e\u4e0d\u5b58\u5728\u7684\u7968\u636e: ({},{})", (Object)chunkX, (Object)chunkZ);
            return;
        }
        int ref = (Integer)this.persistentTickets.get(key);
        if (ref <= 0) {
            LOGGER.warn("\u6301\u4e45\u7968\u636e | \u5f15\u7528\u8ba1\u6570\u5f02\u5e38: ({},{}) = {}", new Object[]{chunkX, chunkZ, ref});
            return;
        }
        if (--ref <= 0) {
            this.persistentTickets.remove(key);
            DistanceManager dm = this.chunkSource.f_8325_.m_143145_();
            dm.m_140823_(HYW_PERSISTENT_TICKET, new ChunkPos(chunkX, chunkZ), 33, (Object)key);
            HywChunkManager.debugPreheat("\u6301\u4e45\u7968\u636e | \u79fb\u9664({},{}) FULL", chunkX, chunkZ);
        } else {
            this.persistentTickets.put(key, (Object)ref);
        }
    }

    public int getPersistentTicketCount(int chunkX, int chunkZ) {
        long key = ChunkPos.m_45589_((int)chunkX, (int)chunkZ);
        return this.persistentTickets.containsKey(key) ? (Integer)this.persistentTickets.get(key) : 0;
    }

    public static void onServerTickStart() {
        serverTickStartNano = System.nanoTime();
    }

    public static void onServerTickEnd() {
        lastServerTickDurationMs = (System.nanoTime() - serverTickStartNano) / 1000000L;
    }

    public static void tickWorld(ServerLevel world) {
        HywChunkManager manager = INSTANCES.get(world);
        if (manager != null) {
            manager.tick();
        }
    }

    private void tick() {
        long gameTime = this.level.m_46467_();
        if (!this.trackedChunks.isEmpty()) {
            this.driveTrackedFullLoads(gameTime);
        }
        if (!this.deferredPreheatRequests.isEmpty()) {
            this.driveDeferredPreheats(gameTime);
        }
        if (!this.preheatJobs.isEmpty()) {
            this.drivePreheatJobs(gameTime);
        }
        if (!this.barriers.isEmpty()) {
            this.driveBarriers(gameTime);
        }
    }

    private void internalRequestChunkFull(int chunkX, int chunkZ, boolean log) {
        ChunkPos pos = new ChunkPos(chunkX, chunkZ);
        long key = pos.m_45588_();
        TrackedChunk existing = (TrackedChunk)this.trackedChunks.get(key);
        if (existing != null && !existing.completed) {
            if (log) {
                HywChunkManager.logThrottle("\u533a\u5757\u9884\u8f7d | \u533a\u5757({},{})\u5df2\u5728\u52a0\u8f7d\u961f\u5217\u4e2d", chunkX, chunkZ);
            }
            return;
        }
        long start = this.level.m_46467_();
        TrackedChunk tracked = new TrackedChunk(pos, start);
        this.trackedChunks.put(key, (Object)tracked);
        if (log) {
            int worldX = chunkX * 16;
            int worldZ = chunkZ * 16;
            BlockPos spawn = this.level.m_220360_();
            double dist = Math.hypot(worldX - spawn.m_123341_(), worldZ - spawn.m_123343_());
            HywChunkManager.logThrottle("\u533a\u5757\u9884\u8f7d | \u5f00\u59cb\u52a0\u8f7d\u533a\u5757({},{}) | \u4e16\u754c\u5750\u6807:({},{}) | \u8ddd\u51fa\u751f\u70b9:{} | Ticket:{}(FULL)", chunkX, chunkZ, worldX, worldZ, String.format(Locale.ROOT, "%.0f", dist), 33);
        }
        if (this.chunkSource.m_7131_(chunkX, chunkZ) != null) {
            tracked.markCompleted(start);
            if (log) {
                HywChunkManager.logThrottle("\u533a\u5757\u9884\u8f7d | \u533a\u5757({},{})\u5df2\u52a0\u8f7d\u5b8c\u6210", chunkX, chunkZ);
            }
            return;
        }
        this.enqueueTicket(tracked, 33);
    }

    private void driveTrackedFullLoads(long gameTime) {
        ChunkMap map = this.chunkSource.f_8325_;
        ObjectIterator it = this.trackedChunks.long2ObjectEntrySet().fastIterator();
        while (it.hasNext()) {
            Long2ObjectMap.Entry e = (Long2ObjectMap.Entry)it.next();
            TrackedChunk t = (TrackedChunk)e.getValue();
            if (t.completed) {
                if (gameTime - t.completedTick <= 100L) continue;
                it.remove();
                continue;
            }
            if (!t.ticketAdded) {
                this.enqueueTicket(t, 33);
            }
            if (this.chunkSource.m_7131_(t.chunkPos.f_45578_, t.chunkPos.f_45579_) != null) {
                t.markCompleted(gameTime);
                long dt = t.completedTick - t.startTick;
                HywChunkManager.logThrottle("\u533a\u5757\u9884\u8f7d | \u533a\u5757({},{})\u52a0\u8f7d\u5b8c\u6210 | \u8017\u65f6:{}tick({}\u79d2)", t.chunkPos.f_45578_, t.chunkPos.f_45579_, dt, String.format(Locale.ROOT, "%.2f", (double)dt / 20.0));
                this.releaseTicket(t, 33);
                WarmProfile deferred = (WarmProfile)this.deferredPreheatRequests.remove(t.chunkPos.m_45588_());
                if (deferred == null) continue;
                this.startPreheatJobIfAbsent(t.chunkPos.m_45588_(), t.chunkPos, deferred, gameTime);
                continue;
            }
            if (!t.shouldLog(gameTime)) continue;
            t.lastLogTick = gameTime;
            long elapsed = gameTime - t.startTick;
            String status = this.describeStatus(map, t.chunkPos);
            HywChunkManager.logThrottle("\u533a\u5757\u9884\u8f7d | \u533a\u5757({},{})\u52a0\u8f7d\u4e2d | \u5df2\u7b49\u5f85:{}tick({}\u79d2) | {}", t.chunkPos.f_45578_, t.chunkPos.f_45579_, elapsed, String.format(Locale.ROOT, "%.1f", (double)elapsed / 20.0), status);
        }
    }

    private void driveDeferredPreheats(long gameTime) {
        if (this.deferredPreheatRequests.isEmpty()) {
            return;
        }
        ObjectIterator it = this.deferredPreheatRequests.long2ObjectEntrySet().fastIterator();
        while (it.hasNext()) {
            TrackedChunk tracked;
            int cz;
            Long2ObjectMap.Entry entry = (Long2ObjectMap.Entry)it.next();
            long key = entry.getLongKey();
            int cx = ChunkPos.m_45592_((long)key);
            if (this.chunkSource.m_7131_(cx, cz = ChunkPos.m_45602_((long)key)) == null || (tracked = (TrackedChunk)this.trackedChunks.get(key)) != null && !tracked.completed) continue;
            WarmProfile profile = (WarmProfile)entry.getValue();
            it.remove();
            if (profile == null) continue;
            this.startPreheatJobIfAbsent(key, new ChunkPos(cx, cz), profile, gameTime);
        }
    }

    private void enqueueTicket(TrackedChunk tracked, int levelReq) {
        DistanceManager dm = this.chunkSource.f_8325_.m_143145_();
        DistanceManagerAccessor acc = (DistanceManagerAccessor)dm;
        long key = tracked.chunkPos.m_45588_();
        ProcessorHandle<ChunkTaskPriorityQueueSorter.Message<Runnable>> throttler = acc.hyw$getTicketThrottlerInput();
        throttler.m_6937_((Object)ChunkTaskPriorityQueueSorter.m_140624_(() -> acc.hyw$getMainThreadExecutor().execute(() -> dm.m_140792_(HYW_CHUNK_TICKET, tracked.chunkPos, levelReq, (Object)key)), (long)key, () -> levelReq));
        tracked.ticketAdded = true;
        tracked.ticketLevel = levelReq;
    }

    private void releaseTicket(TrackedChunk tracked, int levelReq) {
        if (tracked.ticketReleased) {
            return;
        }
        DistanceManager dm = this.chunkSource.f_8325_.m_143145_();
        DistanceManagerAccessor acc = (DistanceManagerAccessor)dm;
        long key = tracked.chunkPos.m_45588_();
        acc.hyw$getTicketThrottlerReleaser().m_6937_((Object)ChunkTaskPriorityQueueSorter.m_140628_(() -> acc.hyw$getMainThreadExecutor().execute(() -> dm.m_140823_(HYW_CHUNK_TICKET, tracked.chunkPos, levelReq, (Object)key)), (long)key, (boolean)true));
        tracked.ticketReleased = true;
    }

    private String describeStatus(ChunkMap map, ChunkPos pos) {
        ChunkMapAccessor acc = (ChunkMapAccessor)map;
        ChunkHolder holder = acc.invokeGetVisibleChunkIfPresent(pos.m_45588_());
        if (holder == null) {
            holder = acc.invokeGetUpdatingChunkIfPresent(pos.m_45588_());
        }
        if (holder == null) {
            return "\u72b6\u6001:\u7b49\u5f85\u8c03\u5ea6 (0%)";
        }
        ChunkStatus last = holder.m_140088_();
        int levelReq = holder.m_140093_();
        ChunkStatus ticketStatus = ChunkLevel.m_287158_((int)levelReq);
        if (last == null) {
            return String.format(Locale.ROOT, "\u72b6\u6001:\u7b49\u5f85\u5f00\u59cb (0%%) | TicketLevel:%d(%s)", levelReq, ticketStatus);
        }
        int idx = Math.max(0, last.m_62445_());
        int full = Math.max(1, ChunkStatus.f_62326_.m_62445_());
        int pct = Mth.m_14045_((int)(idx * 100 / full), (int)0, (int)100);
        return String.format(Locale.ROOT, "\u72b6\u6001:%s (%d%%) | TicketLevel:%d(%s)", last, pct, levelReq, ticketStatus);
    }

    private void maybeSchedulePreheat(int x, int z, WarmProfile profile) {
        long now = this.level.m_46467_();
        long key = ChunkPos.m_45589_((int)x, (int)z);
        PreheatJob existing = (PreheatJob)this.preheatJobs.get(key);
        if (existing != null) {
            this.preheatStepQueue.addLast(new StepRequest(key, now));
            return;
        }
        TrackedChunk tracked = (TrackedChunk)this.trackedChunks.get(key);
        if (tracked != null && !tracked.completed) {
            this.deferredPreheatRequests.put(key, (Object)profile);
            HywChunkManager.debugPreheat("\u9884\u70ed | \u5ef6\u540e\u5230\u9884\u8f7d\u5b8c\u6210 ({},{}) | {}", x, z, profile);
            return;
        }
        if (this.chunkSource.m_7131_(x, z) == null) {
            this.deferredPreheatRequests.put(key, (Object)profile);
            HywChunkManager.debugPreheat("\u9884\u70ed | \u533a\u5757({},{})\u672a\u8fbeFULL\uff0c\u5ef6\u540e\u521b\u5efa\u9884\u70ed\u4efb\u52a1 | {}", x, z, profile);
            return;
        }
        this.startPreheatJobIfAbsent(key, new ChunkPos(x, z), profile, now);
    }

    private boolean startPreheatJobIfAbsent(long key, ChunkPos cp, WarmProfile profile, long now) {
        if (this.preheatJobs.containsKey(key)) {
            return false;
        }
        this.deferredPreheatRequests.remove(key);
        DistanceManager dm = this.chunkSource.f_8325_.m_143145_();
        dm.m_140792_(HYW_PREHEAT_TICKET, cp, 33, (Object)key);
        PreheatJob job = new PreheatJob(cp, profile, now);
        int cx = cp.f_45578_;
        int cz = cp.f_45579_;
        job.listeners.add(() -> {
            dm.m_140823_(HYW_PREHEAT_TICKET, cp, 33, (Object)key);
            HywChunkManager.debugPreheat("\u9884\u70ed | \u91ca\u653e\u9884\u70ed\u4fdd\u6301\u7968\u636e ({},{})", cx, cz);
        });
        this.preheatJobs.put(key, (Object)job);
        this.attachWaitersToJob(key, job);
        this.preheatStepQueue.addLast(new StepRequest(key, now));
        HywChunkManager.debugPreheat("\u9884\u70ed | \u521b\u5efa\u4efb\u52a1 ({},{}) | {} | \u5df2\u6dfb\u52a0\u9884\u70ed\u4fdd\u6301\u7968\u636e", cx, cz, profile);
        return true;
    }

    private void drivePreheatJobs(long gameTime) {
        this.preheatOpsBudgetThisTick = PREHEAT_OPS_BUDGET_PER_TICK;
        if (HywChunkManager.isInstantModeEnabled()) {
            this.runInstantPreheat(gameTime);
            return;
        }
        if (gameTime < this.nextPreheatStepAllowedTick) {
            return;
        }
        if (this.preheatStepQueue.isEmpty() && !this.preheatJobs.isEmpty()) {
            for (Long2ObjectMap.Entry e : this.preheatJobs.long2ObjectEntrySet()) {
                PreheatJob job = (PreheatJob)e.getValue();
                if (job.state == PreheatState.DONE || job.state == PreheatState.CANCELLED) continue;
                this.preheatStepQueue.addLast(new StepRequest(e.getLongKey(), gameTime));
            }
        }
        StepRequest req;
        while ((req = this.preheatStepQueue.pollFirst()) != null) {
            PreheatJob job = (PreheatJob)this.preheatJobs.get(req.chunkKey);
            if (job == null || job.state == PreheatState.DONE || job.state == PreheatState.CANCELLED) continue;
            long delay = Math.max(0L, gameTime - req.enqueuedTick);
            int cx = ChunkPos.m_45592_((long)req.chunkKey);
            int cz = ChunkPos.m_45602_((long)req.chunkKey);
            long stepStartNs = System.nanoTime();
            StepResult result = job.step(gameTime);
            StepOutcome outcome = result.outcome();
            long stepEndNs = System.nanoTime();
            if (outcome == StepOutcome.YIELDED) {
                job.throttledDelayTicksAccum += delay;
                HywChunkManager.logThrottle("\u9884\u70ed\u8282\u6d41 | ({},{}) \u6267\u884c\u4e00\u6b65 | \u7b49\u5f85 {} tick ({} \u79d2)", cx, cz, delay, String.format(Locale.ROOT, "%.2f", (double)delay / 20.0));
                long stepMs = (stepEndNs - stepStartNs) / 1000000L;
                long tickSoFarMs = (stepEndNs - serverTickStartNano) / 1000000L;
                long overMs = Math.max(0L, tickSoFarMs - 50L);
                String overTicksStr = String.format(Locale.ROOT, "%.2f", (double)overMs / 50.0);
                HywChunkManager.logThrottle("\u9884\u70ed\u8282\u6d41 | ({},{}) Tick\u8d1f\u8f7d | step={} ms | \u672ctick\u5df2\u7528 {}/{} ms | \u8d85\u51fa {} ms (~{} tick) | \u7d2f\u8ba1\u8282\u6d41 {} tick ({} \u79d2)", cx, cz, stepMs, tickSoFarMs, 50, overMs, overTicksStr, job.throttledDelayTicksAccum, String.format(Locale.ROOT, "%.2f", (double)job.throttledDelayTicksAccum / 20.0));
                if (job.state != PreheatState.DONE && job.state != PreheatState.CANCELLED) {
                    this.preheatStepQueue.addLast(new StepRequest(req.chunkKey, gameTime));
                } else {
                    this.preheatJobs.remove(req.chunkKey);
                }
                this.nextPreheatStepAllowedTick = gameTime + 1L;
                return;
            }
            this.preheatJobs.remove(req.chunkKey);
        }
        return;
    }

    private void removeQueuedSteps(long chunkKey) {
        Iterator<StepRequest> iterator = this.preheatStepQueue.iterator();
        while (iterator.hasNext()) {
            StepRequest request = iterator.next();
            if (request.chunkKey != chunkKey) continue;
            iterator.remove();
        }
    }

    private void driveBarriers(long gameTime) {
        Iterator<WarmBarrier> it = this.barriers.iterator();
        while (it.hasNext()) {
            WarmBarrier b = it.next();
            if (b.checkAndMaybeFire()) {
                it.remove();
                continue;
            }
            if (b.timeoutTick <= 0 || gameTime < b.deadline) continue;
            try {
                if (b.onTimeout != null) {
                    b.onTimeout.run();
                }
            }
            catch (Throwable t) {
                LOGGER.error("WarmBarrier \u8d85\u65f6\u56de\u8c03\u5f02\u5e38", t);
            }
            it.remove();
        }
    }

    private void runInstantPreheat(long gameTime) {
        boolean progressed;
        this.preheatStepQueue.clear();
        if (this.preheatJobs.isEmpty()) {
            return;
        }
        do {
            progressed = false;
            ObjectIterator it = this.preheatJobs.long2ObjectEntrySet().fastIterator();
            while (it.hasNext()) {
                Long2ObjectMap.Entry entry = (Long2ObjectMap.Entry)it.next();
                PreheatJob job = (PreheatJob)entry.getValue();
                if (job.state == PreheatState.DONE || job.state == PreheatState.CANCELLED) {
                    it.remove();
                    continue;
                }
                boolean jobProgress = this.runJobInstantly(job, gameTime);
                progressed |= jobProgress;
                if (job.state != PreheatState.DONE && job.state != PreheatState.CANCELLED) continue;
                it.remove();
            }
        } while (progressed);
    }

    private boolean runJobInstantly(PreheatJob job, long gameTime) {
        boolean progressed = false;
        while (true) {
            this.preheatOpsBudgetThisTick = Integer.MAX_VALUE;
            StepResult result = job.step(gameTime);
            if (result.outcome() == StepOutcome.FINISHED) {
                return true;
            }
            if (!result.progressed()) {
                return progressed;
            }
            progressed = true;
        }
    }

    private CompletableFuture<Void> newFullFuture(int x, int z) {
        CompletableFuture<Void> f = new CompletableFuture<Void>();
        this.onWarmReady(Collections.singletonList(new ChunkPos(x, z)), 0, () -> f.complete(null), () -> f.complete(null));
        return f;
    }

    public static final class WarmProfile {
        public final boolean touchStructureStarts;
        public final boolean touchHeightmap;
        public final boolean sampleBlocks;
        public final boolean touchBlockEntities;
        public final boolean touchLight;
        public final int samplePerChunk;
        public final boolean pulseBlockTicking;
        public final int pulseTicks;
        public static final WarmProfile DEFAULT_WARM_LIKE_PLAYER = new WarmProfile(true, true, true, true, true, 128, true, 1);

        public WarmProfile(boolean touchStructureStarts, boolean touchHeightmap, boolean sampleBlocks, boolean touchBlockEntities, boolean touchLight, int samplePerChunk, boolean pulseBlockTicking, int pulseTicks) {
            this.touchStructureStarts = touchStructureStarts;
            this.touchHeightmap = touchHeightmap;
            this.sampleBlocks = sampleBlocks;
            this.touchBlockEntities = touchBlockEntities;
            this.touchLight = touchLight;
            this.samplePerChunk = samplePerChunk;
            this.pulseBlockTicking = pulseBlockTicking;
            this.pulseTicks = pulseTicks;
        }

        public String toString() {
            return "WarmProfile{struct=" + this.touchStructureStarts + ", hmap=" + this.touchHeightmap + ", blocks=" + this.sampleBlocks + ", be=" + this.touchBlockEntities + ", light=" + this.touchLight + ", samples=" + this.samplePerChunk + ", pulse32=" + this.pulseBlockTicking + ", pulseTicks=" + this.pulseTicks + "}";
        }
    }

    private final class PreheatJob {
        final ChunkPos pos;
        final WarmProfile profile;
        final long createdTick;
        PreheatState state = PreheatState.WAIT_FULL;
        int heightSamplesDone = 0;
        int blockSamplesDone = 0;
        int lightSamplesDone = 0;
        long pulseEndTick = -1L;
        boolean pulseAdded = false;
        long instantPulseStageStartNs = 0L;
        private final BlockPos.MutableBlockPos scratchPos = new BlockPos.MutableBlockPos();
        final CompletableFuture<Void> future = new CompletableFuture();
        final List<Runnable> listeners = new ArrayList<Runnable>();
        final EnumMap<InstantStage, Long> instantStageDurations = new EnumMap(InstantStage.class);
        long throttledDelayTicksAccum = 0L;

        PreheatJob(ChunkPos pos, WarmProfile profile, long createdTick) {
            this.pos = pos;
            this.profile = profile;
            this.createdTick = createdTick;
        }

        void cancel(String reason) {
            if (this.state == PreheatState.DONE || this.state == PreheatState.CANCELLED) {
                return;
            }
            HywChunkManager.debugPreheat("\u9884\u70ed | \u4efb\u52a1\u53d6\u6d88 ({},{}) | \u539f\u56e0:{}", this.pos.f_45578_, this.pos.f_45579_, reason);
            if (this.pulseAdded) {
                this.removeTempTicket(this.pos, 32);
                this.pulseAdded = false;
            }
            this.state = PreheatState.CANCELLED;
            CancellationException exception = new CancellationException(reason == null ? "cancelled" : reason);
            if (!this.future.isDone()) {
                this.future.completeExceptionally(exception);
            }
            for (Runnable listener : this.listeners) {
                try {
                    listener.run();
                }
                catch (Throwable t) {
                    LOGGER.error("\u9884\u70ed\u76d1\u542c\u56de\u8c03\u5f02\u5e38", t);
                }
            }
            this.listeners.clear();
        }

        StepResult step(long gameTime) {
            block15: while (true) {
                switch (this.state) {
                    case WAIT_FULL: {
                        LevelChunk lc = this.getFullChunkNow(this.pos);
                        if (lc != null) {
                            this.state = this.profile.touchStructureStarts ? PreheatState.STRUCT_STARTS : PreheatState.HEIGHTMAP;
                            this.info("\u9884\u70ed | FULL\u5c31\u7eea -> {}", new Object[]{this.state});
                            continue block15;
                        }
                        return StepResult.yielded(false);
                    }
                    case STRUCT_STARTS: {
                        if (skipStructureStage || !this.profile.touchStructureStarts) {
                            if (skipStructureStage) {
                                this.info("\u9884\u70ed | Debug\u8df3\u8fc7\u7ed3\u6784\u7d22\u5f15\u89e6\u6478", new Object[0]);
                            }
                            this.state = PreheatState.HEIGHTMAP;
                            continue block15;
                        }
                        if (!this.consumeBudget(1)) {
                            return StepResult.yielded(false);
                        }
                        LevelChunk lc = this.getFullChunkNow(this.pos);
                        if (lc == null) {
                            return StepResult.yielded(false);
                        }
                        long stageStart = this.startStageTimer(InstantStage.STRUCT);
                        int count = 0;
                        for (StructureStart start : lc.m_6633_().values()) {
                            if (start == null || !start.m_73603_()) continue;
                            start.m_73601_();
                            ++count;
                            if (this.consumeBudget(1)) continue;
                            break;
                        }
                        this.info("\u9884\u70ed | \u7ed3\u6784\u7d22\u5f15\u89e6\u6478 | starts={}", count);
                        this.state = PreheatState.HEIGHTMAP;
                        this.endStageTimer(InstantStage.STRUCT, stageStart, true);
                        return StepResult.yielded(true);
                    }
                    case HEIGHTMAP: {
                        boolean progressed;
                        int done;
                        if (skipHeightmapStage || !this.profile.touchHeightmap) {
                            if (skipHeightmapStage) {
                                this.info("\u9884\u70ed | Debug\u8df3\u8fc7Heightmap\u9636\u6bb5", new Object[0]);
                            }
                            this.state = PreheatState.BLOCK_SAMPLES;
                            continue block15;
                        }
                        LevelChunk lc = this.getFullChunkNow(this.pos);
                        if (lc == null) {
                            return StepResult.yielded(false);
                        }
                        long stageStart = this.startStageTimer(InstantStage.HEIGHTMAP);
                        int need = Math.max(16, this.profile.samplePerChunk / 4);
                        int minX = this.pos.m_45604_();
                        int minZ = this.pos.m_45605_();
                        for (done = 0; done < need - this.heightSamplesDone && this.consumeBudget(1); ++done) {
                            int dx = this.heightSamplesDone + done & 0xF;
                            int dz = this.heightSamplesDone + done >> 4 & 0xF;
                            int x = minX + dx;
                            int z = minZ + dz;
                            HywChunkManager.this.level.m_6924_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, x, z);
                        }
                        this.heightSamplesDone += done;
                        boolean bl = progressed = done > 0;
                        if (this.heightSamplesDone >= need) {
                            this.info("\u9884\u70ed | Heightmap\u5b8c\u6210 | {}", this.heightSamplesDone);
                            this.state = PreheatState.BLOCK_SAMPLES;
                            progressed = true;
                        }
                        this.endStageTimer(InstantStage.HEIGHTMAP, stageStart, progressed);
                        return StepResult.yielded(progressed);
                    }
                    case BLOCK_SAMPLES: {
                        boolean progressed;
                        int done;
                        if (skipBlockSampleStage || !this.profile.sampleBlocks) {
                            if (skipBlockSampleStage) {
                                this.info("\u9884\u70ed | Debug\u8df3\u8fc7\u65b9\u5757\u91c7\u6837\u9636\u6bb5", new Object[0]);
                            }
                            this.state = PreheatState.BLOCK_ENTITY_TOUCH;
                            continue block15;
                        }
                        LevelChunk lc = this.getFullChunkNow(this.pos);
                        if (lc == null) {
                            return StepResult.yielded(false);
                        }
                        long stageStart = this.startStageTimer(InstantStage.BLOCK_SAMPLE);
                        int minX = this.pos.m_45604_();
                        int minZ = this.pos.m_45605_();
                        int maxY = HywChunkManager.this.level.m_151558_() - 1;
                        int minY = Math.max(HywChunkManager.this.level.m_141937_(), maxY - 64);
                        ThreadLocalRandom rnd = ThreadLocalRandom.current();
                        int toDo = Math.min(this.profile.samplePerChunk - this.blockSamplesDone, HywChunkManager.this.preheatOpsBudgetThisTick);
                        for (done = 0; done < toDo && this.consumeBudget(1); ++done) {
                            int x = minX + rnd.nextInt(16);
                            int z = minZ + rnd.nextInt(16);
                            int y = rnd.nextInt(minY, maxY + 1);
                            this.scratchPos.m_122178_(x, y, z);
                            HywChunkManager.this.level.m_8055_((BlockPos)this.scratchPos);
                        }
                        this.blockSamplesDone += done;
                        boolean bl = progressed = done > 0;
                        if (this.blockSamplesDone >= this.profile.samplePerChunk) {
                            this.info("\u9884\u70ed | \u65b9\u5757\u91c7\u6837\u5b8c\u6210 | {}", this.blockSamplesDone);
                            this.state = PreheatState.BLOCK_ENTITY_TOUCH;
                            progressed = true;
                        }
                        this.endStageTimer(InstantStage.BLOCK_SAMPLE, stageStart, progressed);
                        return StepResult.yielded(progressed);
                    }
                    case BLOCK_ENTITY_TOUCH: {
                        if (skipBlockEntityStage || !this.profile.touchBlockEntities) {
                            if (skipBlockEntityStage) {
                                this.info("\u9884\u70ed | Debug\u8df3\u8fc7\u65b9\u5757\u5b9e\u4f53\u9636\u6bb5", new Object[0]);
                            }
                            this.state = PreheatState.LIGHT_TOUCH;
                            continue block15;
                        }
                        if (!this.consumeBudget(4)) {
                            return StepResult.yielded(false);
                        }
                        LevelChunk lc = this.getFullChunkNow(this.pos);
                        if (lc == null) {
                            return StepResult.yielded(false);
                        }
                        long stageStart = this.startStageTimer(InstantStage.BLOCK_ENTITY);
                        int count = 0;
                        for (BlockPos p : lc.m_5928_()) {
                            HywChunkManager.this.level.m_7702_(p);
                            ++count;
                            if (this.consumeBudget(1)) continue;
                            break;
                        }
                        this.info("\u9884\u70ed | \u65b9\u5757\u5b9e\u4f53\u89e6\u6478 | TE={}", count);
                        this.state = PreheatState.LIGHT_TOUCH;
                        this.endStageTimer(InstantStage.BLOCK_ENTITY, stageStart, true);
                        return StepResult.yielded(true);
                    }
                    case LIGHT_TOUCH: {
                        boolean progressed;
                        int done;
                        if (skipLightStage || !this.profile.touchLight) {
                            if (skipLightStage) {
                                this.info("\u9884\u70ed | Debug\u8df3\u8fc7\u5149\u7167\u9636\u6bb5", new Object[0]);
                            }
                            this.state = this.profile.pulseBlockTicking ? PreheatState.PULSE_32_UP : PreheatState.DONE;
                            continue block15;
                        }
                        LevelChunk lc = this.getFullChunkNow(this.pos);
                        if (lc == null) {
                            return StepResult.yielded(false);
                        }
                        long stageStart = this.startStageTimer(InstantStage.LIGHT);
                        int need = Math.max(16, this.profile.samplePerChunk / 4);
                        int minX = this.pos.m_45604_();
                        int minZ = this.pos.m_45605_();
                        int maxY = HywChunkManager.this.level.m_151558_() - 1;
                        int minY = Math.max(HywChunkManager.this.level.m_141937_(), maxY - 32);
                        ThreadLocalRandom rnd = ThreadLocalRandom.current();
                        int toDo = Math.min(need - this.lightSamplesDone, HywChunkManager.this.preheatOpsBudgetThisTick);
                        for (done = 0; done < toDo && this.consumeBudget(1); ++done) {
                            int x = minX + rnd.nextInt(16);
                            int z = minZ + rnd.nextInt(16);
                            int y = rnd.nextInt(minY, maxY + 1);
                            this.scratchPos.m_122178_(x, y, z);
                            HywChunkManager.this.level.m_45517_(LightLayer.SKY, (BlockPos)this.scratchPos);
                            HywChunkManager.this.level.m_45517_(LightLayer.BLOCK, (BlockPos)this.scratchPos);
                        }
                        this.lightSamplesDone += done;
                        boolean bl = progressed = done > 0;
                        if (this.lightSamplesDone >= need) {
                            this.info("\u9884\u70ed | \u5149\u7167\u5b8c\u6210 | {}", this.lightSamplesDone);
                            this.state = this.profile.pulseBlockTicking ? PreheatState.PULSE_32_UP : PreheatState.DONE;
                            progressed = true;
                        }
                        this.endStageTimer(InstantStage.LIGHT, stageStart, progressed);
                        return StepResult.yielded(progressed);
                    }
                    case PULSE_32_UP: {
                        if (!this.profile.pulseBlockTicking || this.profile.pulseTicks <= 0 || skipPulseStage) {
                            if (skipPulseStage) {
                                this.info("\u9884\u70ed | Debug\u8df3\u8fc732\u7ea7\u8109\u51b2\u9636\u6bb5", new Object[0]);
                            }
                            if (this.pulseAdded) {
                                this.removeTempTicket(this.pos, 32);
                                this.pulseAdded = false;
                            }
                            this.instantPulseStageStartNs = 0L;
                            this.state = PreheatState.DONE;
                            continue block15;
                        }
                        if (!this.pulseAdded) {
                            this.addTempTicket(this.pos, 32);
                            this.pulseEndTick = gameTime + (long)this.profile.pulseTicks;
                            if (HywChunkManager.isInstantModeEnabled()) {
                                this.pulseEndTick = gameTime;
                            }
                            this.pulseAdded = true;
                            this.info("\u9884\u70ed | \u5347\u523032(BLOCK_TICKING) {} tick", this.profile.pulseTicks);
                            if (this.instantPulseStageStartNs == 0L) {
                                this.instantPulseStageStartNs = this.startStageTimer(InstantStage.PULSE);
                            }
                        }
                        this.state = PreheatState.PULSE_32_HOLD;
                        return StepResult.yielded(true);
                    }
                    case PULSE_32_HOLD: {
                        if (skipPulseStage) {
                            if (this.pulseAdded) {
                                this.removeTempTicket(this.pos, 32);
                                this.pulseAdded = false;
                            }
                            this.finishPulseStageTiming(this.instantPulseStageStartNs != 0L);
                            this.state = PreheatState.DONE;
                            continue block15;
                        }
                        if (gameTime >= this.pulseEndTick) {
                            this.state = PreheatState.PULSE_32_DOWN;
                            return StepResult.yielded(true);
                        }
                        return StepResult.yielded(false);
                    }
                    case PULSE_32_DOWN: {
                        if (skipPulseStage) {
                            if (this.pulseAdded) {
                                this.removeTempTicket(this.pos, 32);
                                this.pulseAdded = false;
                            }
                            this.finishPulseStageTiming(this.instantPulseStageStartNs != 0L);
                            this.state = PreheatState.DONE;
                            continue block15;
                        }
                        if (this.pulseAdded) {
                            this.removeTempTicket(this.pos, 32);
                            this.pulseAdded = false;
                            this.info("\u9884\u70ed | \u964d\u56de33(FULL)", new Object[0]);
                        }
                        this.finishPulseStageTiming(true);
                        this.state = PreheatState.DONE;
                        continue block15;
                    }
                    case DONE: {
                        this.complete();
                        return StepResult.finished();
                    }
                    case CANCELLED: {
                        this.future.completeExceptionally(new IllegalStateException("cancelled"));
                        for (Runnable r : this.listeners) {
                            try {
                                r.run();
                            }
                            catch (Throwable t) {
                                LOGGER.error("\u9884\u70ed\u76d1\u542c\u56de\u8c03\u5f02\u5e38", t);
                            }
                        }
                        this.listeners.clear();
                        return StepResult.finished();
                    }
                }
            }
        }

        private long startStageTimer(InstantStage stage) {
            return HywChunkManager.isInstantModeEnabled() ? System.nanoTime() : 0L;
        }

        private void endStageTimer(InstantStage stage, long startNs, boolean shouldRecord) {
            if (!shouldRecord) {
                return;
            }
            if (!HywChunkManager.isInstantModeEnabled() || startNs == 0L) {
                return;
            }
            this.instantStageDurations.merge(stage, System.nanoTime() - startNs, Long::sum);
        }

        private void logInstantDurations() {
            if (this.instantStageDurations.isEmpty()) {
                return;
            }
            StringBuilder builder = new StringBuilder();
            for (InstantStage stage : InstantStage.values()) {
                long nanos = this.instantStageDurations.getOrDefault((Object)stage, 0L);
                double ms = (double)nanos / 1000000.0;
                if (builder.length() > 0) {
                    builder.append(" | ");
                }
                builder.append(stage.displayName).append('=').append(String.format(Locale.ROOT, "%.3fms", ms));
            }
            LOGGER.info("\u9884\u70edInstant | \u533a\u5757({},{}) | {}", new Object[]{this.pos.f_45578_, this.pos.f_45579_, builder});
        }

        private void finishPulseStageTiming(boolean progressed) {
            if (!progressed) {
                this.instantPulseStageStartNs = 0L;
                return;
            }
            this.endStageTimer(InstantStage.PULSE, this.instantPulseStageStartNs, true);
            this.instantPulseStageStartNs = 0L;
        }

        private void complete() {
            long key = this.pos.m_45588_();
            HywChunkManager.this.warmCompleted.add(key);
            if (HywChunkManager.isInstantModeEnabled()) {
                this.logInstantDurations();
            }
            this.future.complete(null);
            HywChunkManager.this.completePendingWarmFutures(key, null);
            for (Runnable r : this.listeners) {
                try {
                    r.run();
                }
                catch (Throwable t) {
                    LOGGER.error("\u9884\u70ed\u76d1\u542c\u56de\u8c03\u5f02\u5e38", t);
                }
            }
            this.listeners.clear();
            long acc = this.throttledDelayTicksAccum;
            this.info("\u9884\u70ed | \u5b8c\u6210 | \u603b\u8282\u6d41\u5ef6\u8fdf {} tick ({} \u79d2)", acc, String.format(Locale.ROOT, "%.2f", (double)acc / 20.0));
            HywChunkManager.debugPreheat("\u9884\u70ed | \u533a\u5757({},{})\u5df2\u5b8c\u6210\u5e76\u8bb0\u5f55", this.pos.f_45578_, this.pos.f_45579_);
        }

        int progressPercent() {
            int wPulse;
            int wLight;
            int wBE;
            int wBlock;
            int wHmap;
            int wStruct = this.profile.touchStructureStarts ? 10 : 0;
            int total = wStruct + (wHmap = this.profile.touchHeightmap ? 15 : 0) + (wBlock = this.profile.sampleBlocks ? 40 : 0) + (wBE = this.profile.touchBlockEntities ? 15 : 0) + (wLight = this.profile.touchLight ? 10 : 0) + (wPulse = this.profile.pulseBlockTicking ? 10 : 0);
            if (total == 0) {
                return HywChunkManager.this.chunkSource.m_5563_(this.pos.f_45578_, this.pos.f_45579_) ? 100 : 0;
            }
            int acc = switch (this.state) {
                case PreheatState.WAIT_FULL, PreheatState.STRUCT_STARTS -> 0;
                case PreheatState.HEIGHTMAP -> wStruct;
                case PreheatState.BLOCK_SAMPLES -> wStruct + wHmap;
                case PreheatState.BLOCK_ENTITY_TOUCH -> wStruct + wHmap + (int)((double)wBlock * (double)this.blockSamplesDone / (double)Math.max(1, this.profile.samplePerChunk));
                case PreheatState.LIGHT_TOUCH -> wStruct + wHmap + wBlock + wBE;
                case PreheatState.PULSE_32_UP, PreheatState.PULSE_32_HOLD, PreheatState.PULSE_32_DOWN -> total - wPulse / 2;
                case PreheatState.DONE -> total;
                default -> 0;
            };
            return Math.max(0, Math.min(100, (int)((double)acc * 100.0 / (double)total)));
        }

        private LevelChunk getFullChunkNow(ChunkPos pos) {
            try {
                return HywChunkManager.this.chunkSource.m_7131_(pos.f_45578_, pos.f_45579_);
            }
            catch (Throwable ignored) {
                return null;
            }
        }

        private boolean consumeBudget(int ops) {
            if (HywChunkManager.this.preheatOpsBudgetThisTick < ops) {
                return false;
            }
            HywChunkManager.this.preheatOpsBudgetThisTick -= ops;
            return true;
        }

        private void addTempTicket(ChunkPos pos, int lvl) {
            DistanceManager dm = HywChunkManager.this.chunkSource.f_8325_.m_143145_();
            long key = pos.m_45588_();
            dm.m_140792_(HYW_PERSISTENT_TICKET, pos, lvl, (Object)key);
        }

        private void removeTempTicket(ChunkPos pos, int lvl) {
            DistanceManager dm = HywChunkManager.this.chunkSource.f_8325_.m_143145_();
            long key = pos.m_45588_();
            dm.m_140823_(HYW_PERSISTENT_TICKET, pos, lvl, (Object)key);
        }

        private void info(String fmt, Object ... args) {
            if (!PregenManager.isDebugLoggingEnabled()) {
                return;
            }
            Object[] merged = new Object[args.length + 1];
            merged[0] = this.pos;
            System.arraycopy(args, 0, merged, 1, args.length);
            LOGGER.info("[\u9884\u70ed\u8c03\u8bd5:{}] " + fmt, merged);
        }
    }

    private static enum PreheatState {
        WAIT_FULL,
        STRUCT_STARTS,
        HEIGHTMAP,
        BLOCK_SAMPLES,
        BLOCK_ENTITY_TOUCH,
        LIGHT_TOUCH,
        PULSE_32_UP,
        PULSE_32_HOLD,
        PULSE_32_DOWN,
        DONE,
        CANCELLED;

    }

    private static final class TrackedChunk {
        final ChunkPos chunkPos;
        final long startTick;
        long lastLogTick = -1L;
        long completedTick = -1L;
        boolean completed = false;
        boolean ticketAdded = false;
        boolean ticketReleased = false;
        int ticketLevel = 33;

        TrackedChunk(ChunkPos pos, long start) {
            this.chunkPos = pos;
            this.startTick = start;
        }

        void markCompleted(long tick) {
            this.completed = true;
            this.completedTick = tick;
        }

        boolean shouldLog(long now) {
            return this.lastLogTick < 0L || now - this.lastLogTick >= 20L;
        }
    }

    private final class WarmBarrier {
        final Set<Long> remaining = new HashSet<Long>();
        final int timeoutTick;
        final long created;
        final long deadline;
        final Runnable onReady;
        final Runnable onTimeout;

        WarmBarrier(Collection<ChunkPos> chunks, long now, int timeoutTick, Runnable onReady, Runnable onTimeout) {
            for (ChunkPos cp : chunks) {
                this.remaining.add(cp.m_45588_());
            }
            this.timeoutTick = Math.max(0, timeoutTick);
            this.created = now;
            this.deadline = timeoutTick > 0 ? now + (long)timeoutTick : Long.MAX_VALUE;
            this.onReady = onReady;
            this.onTimeout = onTimeout;
        }

        boolean checkAndMaybeFire() {
            Iterator<Long> it = this.remaining.iterator();
            while (it.hasNext()) {
                int z;
                long key = it.next();
                int x = ChunkPos.m_45592_((long)key);
                if (!HywChunkManager.this.isWarmReady(x, z = ChunkPos.m_45602_((long)key))) continue;
                it.remove();
            }
            if (this.remaining.isEmpty()) {
                try {
                    if (this.onReady != null) {
                        this.onReady.run();
                    }
                }
                catch (Throwable t) {
                    LOGGER.error("WarmBarrier \u51c6\u5907\u5b8c\u6210\u56de\u8c03\u5f02\u5e38", t);
                }
                return true;
            }
            return false;
        }
    }

    private static final class StepRequest {
        final long chunkKey;
        final long enqueuedTick;

        StepRequest(long chunkKey, long enqueuedTick) {
            this.chunkKey = chunkKey;
            this.enqueuedTick = enqueuedTick;
        }
    }

    private record StepResult(StepOutcome outcome, boolean progressed) {
        static StepResult yielded(boolean progressed) {
            return new StepResult(StepOutcome.YIELDED, progressed);
        }

        static StepResult finished() {
            return new StepResult(StepOutcome.FINISHED, true);
        }
    }

    private static enum StepOutcome {
        YIELDED,
        FINISHED;

    }

    private static enum InstantStage {
        STRUCT("\u7ed3\u6784\u7d22\u5f15\u9636\u6bb5"),
        HEIGHTMAP("\u9ad8\u5ea6\u91c7\u6837\u9636\u6bb5"),
        BLOCK_SAMPLE("\u65b9\u5757\u91c7\u6837\u9636\u6bb5"),
        BLOCK_ENTITY("\u65b9\u5757\u5b9e\u4f53\u9636\u6bb5"),
        LIGHT("\u5149\u7167\u9636\u6bb5"),
        PULSE("32\u7ea7\u8109\u51b2\u9636\u6bb5");

        final String displayName;

        private InstantStage(String displayName) {
            this.displayName = displayName;
        }
    }
}

