/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.main.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import ydmsama.hundred_years_war.main.commands.ChunkLoadTestCommands;
import ydmsama.hundred_years_war.main.commands.ChunkPreheatCommands;
import ydmsama.hundred_years_war.main.commands.InstGenCommands;
import ydmsama.hundred_years_war.main.commands.PlayerRelationCommands;
import ydmsama.hundred_years_war.main.commands.PregenCommands;
import ydmsama.hundred_years_war.main.commands.StructureCommands;
import ydmsama.hundred_years_war.main.entity.entities.BaseCombatEntity;
import ydmsama.hundred_years_war.main.entity.goals.TargetAttackGoal;
import ydmsama.hundred_years_war.main.entity.utils.FormationManager;
import ydmsama.hundred_years_war.main.mixins.EntityAccessor;
import ydmsama.hundred_years_war.main.selection.SelectionSystem;
import ydmsama.hundred_years_war.main.utils.ServerRelationHelper;

public class Commands {
    private static final SuggestionProvider<CommandSourceStack> SUGGEST_HYW_ENTITIES = (context, builder) -> SharedSuggestionProvider.m_82970_((Iterable)StreamSupport.stream(BuiltInRegistries.f_256780_.spliterator(), false).filter(entityType -> {
        ResourceLocation registryName = BuiltInRegistries.f_256780_.m_7981_(entityType);
        return registryName != null && registryName.m_135827_().equals("hundred_years_war") && entityType.m_20615_((Level)((CommandSourceStack)context.getSource()).m_81372_()) instanceof BaseCombatEntity;
    }).map(entityType -> BuiltInRegistries.f_256780_.m_7981_(entityType).m_135815_()).collect(Collectors.toList()), (SuggestionsBuilder)builder);

    public static void registerCommands(CommandDispatcher<CommandSourceStack> dispatcher) {
        PlayerRelationCommands.register(dispatcher);
        ChunkLoadTestCommands.register(dispatcher);
        ChunkPreheatCommands.register(dispatcher);
        InstGenCommands.register(dispatcher);
        PregenCommands.register(dispatcher);
        StructureCommands.register(dispatcher);
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)net.minecraft.commands.Commands.m_82127_((String)"hundred_years_war").then(net.minecraft.commands.Commands.m_82127_((String)"summon").then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)net.minecraft.commands.Commands.m_82129_((String)"entity", (ArgumentType)StringArgumentType.word()).suggests(SUGGEST_HYW_ENTITIES).requires(source -> source.m_6761_(2))).executes(context -> {
            String entityName = StringArgumentType.getString((CommandContext)context, (String)"entity");
            CommandSourceStack source = (CommandSourceStack)context.getSource();
            Commands.summonEntity(source, entityName, 1, 1, null);
            return 1;
        })).then(((RequiredArgumentBuilder)net.minecraft.commands.Commands.m_82129_((String)"entity_level", (ArgumentType)IntegerArgumentType.integer()).executes(context -> {
            String entityName = StringArgumentType.getString((CommandContext)context, (String)"entity");
            int entityLevel = IntegerArgumentType.getInteger((CommandContext)context, (String)"entity_level");
            CommandSourceStack source = (CommandSourceStack)context.getSource();
            Commands.summonEntity(source, entityName, entityLevel, entityLevel, null);
            return 1;
        })).then(((RequiredArgumentBuilder)net.minecraft.commands.Commands.m_82129_((String)"equipment_level", (ArgumentType)IntegerArgumentType.integer()).executes(context -> {
            String entityName = StringArgumentType.getString((CommandContext)context, (String)"entity");
            int entityLevel = IntegerArgumentType.getInteger((CommandContext)context, (String)"entity_level");
            int equipmentLevel = IntegerArgumentType.getInteger((CommandContext)context, (String)"equipment_level");
            CommandSourceStack source = (CommandSourceStack)context.getSource();
            Commands.summonEntity(source, entityName, entityLevel, equipmentLevel, null);
            return 1;
        })).then(net.minecraft.commands.Commands.m_82129_((String)"owner", (ArgumentType)EntityArgument.m_91466_()).executes(context -> {
            String entityName = StringArgumentType.getString((CommandContext)context, (String)"entity");
            int entityLevel = IntegerArgumentType.getInteger((CommandContext)context, (String)"entity_level");
            int equipmentLevel = IntegerArgumentType.getInteger((CommandContext)context, (String)"equipment_level");
            CommandSourceStack source = (CommandSourceStack)context.getSource();
            Commands.summonEntity(source, entityName, entityLevel, equipmentLevel, (Entity)EntityArgument.m_91474_((CommandContext)context, (String)"owner"));
            return 1;
        }))))))).then(((LiteralArgumentBuilder)net.minecraft.commands.Commands.m_82127_((String)"follow").requires(source -> source.m_6761_(2))).then(net.minecraft.commands.Commands.m_82129_((String)"soldier", (ArgumentType)EntityArgument.m_91460_()).then(net.minecraft.commands.Commands.m_82129_((String)"target", (ArgumentType)EntityArgument.m_91449_()).executes(context -> {
            CommandSourceStack source = (CommandSourceStack)context.getSource();
            ServerPlayer player = null;
            try {
                player = source.m_81375_();
            }
            catch (CommandSyntaxException commandSyntaxException) {
                // empty catch block
            }
            int successCount = 0;
            for (Entity soldier : EntityArgument.m_91461_((CommandContext)context, (String)"soldier")) {
                if (!(soldier instanceof BaseCombatEntity)) {
                    source.m_81352_((Component)Component.m_237113_((String)("Entity " + soldier.m_7755_().getString() + " is not a controllable combat unit")));
                    continue;
                }
                BaseCombatEntity combatEntity = (BaseCombatEntity)soldier;
                if (player != null && !ServerRelationHelper.hasControlOver((Player)player, (Entity)combatEntity)) {
                    source.m_81352_((Component)Component.m_237113_((String)("You don't have permission to control " + soldier.m_7755_().getString())));
                    continue;
                }
                Entity targetEntity = EntityArgument.m_91452_((CommandContext)context, (String)"target");
                if (!(targetEntity instanceof LivingEntity)) {
                    source.m_81352_((Component)Component.m_237113_((String)("Target " + targetEntity.m_7755_().getString() + " is not a valid follow target")));
                    continue;
                }
                LivingEntity livingTarget = (LivingEntity)targetEntity;
                combatEntity.clearCommandedGoals();
                combatEntity.setFollowTarget(livingTarget);
                ++successCount;
            }
            if (successCount > 0) {
                int finalSuccessCount = successCount;
                source.m_288197_(() -> Component.m_237113_((String)("Successfully commanded " + finalSuccessCount + " units to follow target")), true);
            } else {
                source.m_81352_((Component)Component.m_237113_((String)"No units were successfully set to follow"));
            }
            return successCount;
        }))))).then(((LiteralArgumentBuilder)net.minecraft.commands.Commands.m_82127_((String)"stop_follow").requires(source -> source.m_6761_(2))).then(net.minecraft.commands.Commands.m_82129_((String)"soldier", (ArgumentType)EntityArgument.m_91460_()).executes(context -> {
            CommandSourceStack source = (CommandSourceStack)context.getSource();
            ServerPlayer player = null;
            try {
                player = source.m_81375_();
            }
            catch (CommandSyntaxException commandSyntaxException) {
                // empty catch block
            }
            int successCount = 0;
            for (Entity soldier : EntityArgument.m_91461_((CommandContext)context, (String)"soldier")) {
                if (!(soldier instanceof BaseCombatEntity)) {
                    source.m_81352_((Component)Component.m_237113_((String)("Entity " + soldier.m_7755_().getString() + " is not a controllable combat unit")));
                    continue;
                }
                BaseCombatEntity combatEntity = (BaseCombatEntity)soldier;
                if (player != null && !ServerRelationHelper.hasControlOver((Player)player, (Entity)combatEntity)) {
                    source.m_81352_((Component)Component.m_237113_((String)("You don't have permission to control " + soldier.m_7755_().getString())));
                    continue;
                }
                if (combatEntity.getFollowTarget() == null) continue;
                combatEntity.setFollowTarget(null);
                combatEntity.setHomePosition(combatEntity.m_20183_());
                ++successCount;
            }
            if (successCount > 0) {
                int finalSuccessCount = successCount;
                source.m_288197_(() -> Component.m_237113_((String)("Successfully commanded " + finalSuccessCount + " units to stop following")), true);
            } else {
                source.m_81352_((Component)Component.m_237113_((String)"No units were following a target"));
            }
            return successCount;
        })))).then(((LiteralArgumentBuilder)net.minecraft.commands.Commands.m_82127_((String)"squad_follow").requires(source -> source.m_6761_(2))).then(net.minecraft.commands.Commands.m_82129_((String)"squad_number", (ArgumentType)IntegerArgumentType.integer((int)0)).then(net.minecraft.commands.Commands.m_82129_((String)"target", (ArgumentType)EntityArgument.m_91449_()).executes(context -> {
            CommandSourceStack source = (CommandSourceStack)context.getSource();
            ServerPlayer player = null;
            try {
                player = source.m_81375_();
            }
            catch (CommandSyntaxException e) {
                source.m_81352_((Component)Component.m_237113_((String)"This command must be executed by a player"));
                return 0;
            }
            int squadNumber = IntegerArgumentType.getInteger((CommandContext)context, (String)"squad_number");
            Entity targetEntity = EntityArgument.m_91452_((CommandContext)context, (String)"target");
            if (!(targetEntity instanceof LivingEntity)) {
                source.m_81352_((Component)Component.m_237113_((String)("Target " + targetEntity.m_7755_().getString() + " is not a valid follow target")));
                return 0;
            }
            LivingEntity livingTarget = (LivingEntity)targetEntity;
            List<SelectionSystem.Squad> playerSquads = SelectionSystem.getSquads().get(player.m_20148_());
            if (playerSquads == null || squadNumber >= playerSquads.size() || playerSquads.get(squadNumber) == null) {
                source.m_81352_((Component)Component.m_237113_((String)("Squad #" + squadNumber + " does not exist")));
                return 0;
            }
            SelectionSystem.Squad squad = playerSquads.get(squadNumber);
            ServerLevel world = (ServerLevel)((EntityAccessor)player).getLevel();
            int successCount = 0;
            for (UUID entityUUID : squad.getEntityUUIDs()) {
                Entity entity = world.m_8791_(entityUUID);
                if (!(entity instanceof BaseCombatEntity)) continue;
                BaseCombatEntity combatEntity = (BaseCombatEntity)entity;
                if (!ServerRelationHelper.hasControlOver((Player)player, (Entity)combatEntity)) {
                    source.m_81352_((Component)Component.m_237113_((String)"You don't have permission to control some units in this squad"));
                    continue;
                }
                combatEntity.clearCommandedGoals();
                combatEntity.setFollowTarget(livingTarget);
                ++successCount;
            }
            if (successCount > 0) {
                int finalSuccessCount = successCount;
                source.m_288197_(() -> Component.m_237113_((String)("Successfully commanded " + finalSuccessCount + " units in squad #" + squadNumber + " to follow target")), true);
            } else {
                source.m_81352_((Component)Component.m_237113_((String)("No units in squad #" + squadNumber + " could be set to follow")));
            }
            return successCount;
        }))))).then(((LiteralArgumentBuilder)net.minecraft.commands.Commands.m_82127_((String)"squad_stop_follow").requires(source -> source.m_6761_(2))).then(net.minecraft.commands.Commands.m_82129_((String)"squad_number", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(context -> {
            CommandSourceStack source = (CommandSourceStack)context.getSource();
            ServerPlayer player = null;
            try {
                player = source.m_81375_();
            }
            catch (CommandSyntaxException e) {
                source.m_81352_((Component)Component.m_237113_((String)"This command must be executed by a player"));
                return 0;
            }
            int squadNumber = IntegerArgumentType.getInteger((CommandContext)context, (String)"squad_number");
            List<SelectionSystem.Squad> playerSquads = SelectionSystem.getSquads().get(player.m_20148_());
            if (playerSquads == null || squadNumber >= playerSquads.size() || playerSquads.get(squadNumber) == null) {
                source.m_81352_((Component)Component.m_237113_((String)("Squad #" + squadNumber + " does not exist")));
                return 0;
            }
            SelectionSystem.Squad squad = playerSquads.get(squadNumber);
            ServerLevel world = (ServerLevel)((EntityAccessor)player).getLevel();
            int successCount = 0;
            for (UUID entityUUID : squad.getEntityUUIDs()) {
                Entity entity = world.m_8791_(entityUUID);
                if (!(entity instanceof BaseCombatEntity)) continue;
                BaseCombatEntity combatEntity = (BaseCombatEntity)entity;
                if (!ServerRelationHelper.hasControlOver((Player)player, (Entity)combatEntity)) {
                    source.m_81352_((Component)Component.m_237113_((String)"You don't have permission to control some units in this squad"));
                    continue;
                }
                if (combatEntity.getFollowTarget() == null) continue;
                combatEntity.setFollowTarget(null);
                combatEntity.setHomePosition(combatEntity.m_20183_());
                ++successCount;
            }
            if (successCount > 0) {
                int finalSuccessCount = successCount;
                source.m_288197_(() -> Component.m_237113_((String)("Successfully commanded " + finalSuccessCount + " units in squad #" + squadNumber + " to stop following")), true);
            } else {
                source.m_81352_((Component)Component.m_237113_((String)("No units in squad #" + squadNumber + " were following a target")));
            }
            return successCount;
        })))).then(((LiteralArgumentBuilder)net.minecraft.commands.Commands.m_82127_((String)"squad_move").requires(source -> source.m_6761_(2))).then(net.minecraft.commands.Commands.m_82129_((String)"squad_number", (ArgumentType)IntegerArgumentType.integer((int)0)).then(net.minecraft.commands.Commands.m_82129_((String)"attack_move", (ArgumentType)BoolArgumentType.bool()).executes(context -> {
            CommandSourceStack source = (CommandSourceStack)context.getSource();
            ServerPlayer player = null;
            try {
                player = source.m_81375_();
            }
            catch (CommandSyntaxException e) {
                source.m_81352_((Component)Component.m_237113_((String)"This command must be executed by a player"));
                return 0;
            }
            int squadNumber = IntegerArgumentType.getInteger((CommandContext)context, (String)"squad_number");
            boolean attackMove = BoolArgumentType.getBool((CommandContext)context, (String)"attack_move");
            List<SelectionSystem.Squad> playerSquads = SelectionSystem.getSquads().get(player.m_20148_());
            if (playerSquads == null || squadNumber >= playerSquads.size() || playerSquads.get(squadNumber) == null) {
                source.m_81352_((Component)Component.m_237113_((String)("Squad #" + squadNumber + " does not exist")));
                return 0;
            }
            BlockPos targetPos = Commands.getPlayerLookTargetPos((Player)player, 200);
            if (targetPos == null) {
                source.m_81352_((Component)Component.m_237113_((String)"Failed to get target position"));
                return 0;
            }
            SelectionSystem.Squad squad = playerSquads.get(squadNumber);
            ServerLevel world = (ServerLevel)((EntityAccessor)player).getLevel();
            ArrayList<BaseCombatEntity> entities = new ArrayList<BaseCombatEntity>();
            for (UUID entityUUID : squad.getEntityUUIDs()) {
                Entity entity = world.m_8791_(entityUUID);
                if (!(entity instanceof BaseCombatEntity)) continue;
                BaseCombatEntity combatEntity = (BaseCombatEntity)entity;
                if (!ServerRelationHelper.hasControlOver((Player)player, (Entity)combatEntity)) {
                    source.m_81352_((Component)Component.m_237113_((String)"You don't have permission to control some units in this squad"));
                    continue;
                }
                entities.add(combatEntity);
            }
            if (entities.isEmpty()) {
                source.m_81352_((Component)Component.m_237113_((String)("No units in squad #" + squadNumber + " could be commanded")));
                return 0;
            }
            int priority = attackMove ? 3 : 1;
            FormationManager.move(entities, targetPos, priority, false);
            int finalEntityCount = entities.size();
            if (attackMove) {
                source.m_288197_(() -> Component.m_237113_((String)("Successfully commanded " + finalEntityCount + " units in squad #" + squadNumber + " to attack-move to position (" + targetPos.m_123341_() + ", " + targetPos.m_123342_() + ", " + targetPos.m_123343_() + ")")), true);
            } else {
                source.m_288197_(() -> Component.m_237113_((String)("Successfully commanded " + finalEntityCount + " units in squad #" + squadNumber + " to move to position (" + targetPos.m_123341_() + ", " + targetPos.m_123342_() + ", " + targetPos.m_123343_() + ")")), true);
            }
            return entities.size();
        }))))).then(((LiteralArgumentBuilder)net.minecraft.commands.Commands.m_82127_((String)"squad_form_move").requires(source -> source.m_6761_(2))).then(net.minecraft.commands.Commands.m_82129_((String)"squad_number", (ArgumentType)IntegerArgumentType.integer((int)0)).then(net.minecraft.commands.Commands.m_82129_((String)"attack_move", (ArgumentType)BoolArgumentType.bool()).then(net.minecraft.commands.Commands.m_82129_((String)"formation_type", (ArgumentType)StringArgumentType.word()).suggests((context, builder) -> SharedSuggestionProvider.m_82967_((String[])new String[]{"loose", "tight", "line", "circle", "wedge"}, (SuggestionsBuilder)builder)).executes(context -> {
            CommandSourceStack source = (CommandSourceStack)context.getSource();
            ServerPlayer player = null;
            try {
                player = source.m_81375_();
            }
            catch (CommandSyntaxException e) {
                source.m_81352_((Component)Component.m_237113_((String)"This command must be executed by a player"));
                return 0;
            }
            int squadNumber = IntegerArgumentType.getInteger((CommandContext)context, (String)"squad_number");
            boolean attackMove = BoolArgumentType.getBool((CommandContext)context, (String)"attack_move");
            String formationType = StringArgumentType.getString((CommandContext)context, (String)"formation_type");
            List<SelectionSystem.Squad> playerSquads = SelectionSystem.getSquads().get(player.m_20148_());
            if (playerSquads == null || squadNumber >= playerSquads.size() || playerSquads.get(squadNumber) == null) {
                source.m_81352_((Component)Component.m_237113_((String)("Squad #" + squadNumber + " does not exist")));
                return 0;
            }
            BlockPos targetPos = Commands.getPlayerLookTargetPos((Player)player, 200);
            if (targetPos == null) {
                source.m_81352_((Component)Component.m_237113_((String)"Failed to get target position"));
                return 0;
            }
            SelectionSystem.Squad squad = playerSquads.get(squadNumber);
            ServerLevel world = (ServerLevel)((EntityAccessor)player).getLevel();
            ArrayList<BaseCombatEntity> entities = new ArrayList<BaseCombatEntity>();
            for (UUID entityUUID : squad.getEntityUUIDs()) {
                Entity entity = world.m_8791_(entityUUID);
                if (!(entity instanceof BaseCombatEntity)) continue;
                BaseCombatEntity combatEntity = (BaseCombatEntity)entity;
                if (!ServerRelationHelper.hasControlOver((Player)player, (Entity)combatEntity)) {
                    source.m_81352_((Component)Component.m_237113_((String)"You don't have permission to control some units in this squad"));
                    continue;
                }
                entities.add(combatEntity);
            }
            if (entities.isEmpty()) {
                source.m_81352_((Component)Component.m_237113_((String)("No units in squad #" + squadNumber + " could be commanded")));
                return 0;
            }
            int priority = attackMove ? 3 : 1;
            FormationManager.formMove(entities, targetPos, priority, false, formationType);
            int finalEntityCount = entities.size();
            if (attackMove) {
                source.m_288197_(() -> Component.m_237113_((String)("Successfully commanded " + finalEntityCount + " units in squad #" + squadNumber + " to formation attack-move (" + formationType + ") to position (" + targetPos.m_123341_() + ", " + targetPos.m_123342_() + ", " + targetPos.m_123343_() + ")")), true);
            } else {
                source.m_288197_(() -> Component.m_237113_((String)("Successfully commanded " + finalEntityCount + " units in squad #" + squadNumber + " to formation move (" + formationType + ") to position (" + targetPos.m_123341_() + ", " + targetPos.m_123342_() + ", " + targetPos.m_123343_() + ")")), true);
            }
            return entities.size();
        })))))).then(((LiteralArgumentBuilder)net.minecraft.commands.Commands.m_82127_((String)"move").requires(source -> source.m_6761_(2))).then(net.minecraft.commands.Commands.m_82129_((String)"entities", (ArgumentType)EntityArgument.m_91460_()).then(net.minecraft.commands.Commands.m_82129_((String)"attack_move", (ArgumentType)BoolArgumentType.bool()).executes(context -> {
            CommandSourceStack source = (CommandSourceStack)context.getSource();
            ServerPlayer player = null;
            try {
                player = source.m_81375_();
            }
            catch (CommandSyntaxException e) {
                source.m_81352_((Component)Component.m_237113_((String)"This command must be executed by a player"));
                return 0;
            }
            boolean attackMove = BoolArgumentType.getBool((CommandContext)context, (String)"attack_move");
            BlockPos targetPos = Commands.getPlayerLookTargetPos((Player)player, 200);
            if (targetPos == null) {
                source.m_81352_((Component)Component.m_237113_((String)"Failed to get target position"));
                return 0;
            }
            ArrayList<BaseCombatEntity> entities = new ArrayList<BaseCombatEntity>();
            for (Entity entity : EntityArgument.m_91461_((CommandContext)context, (String)"entities")) {
                if (!(entity instanceof BaseCombatEntity)) continue;
                BaseCombatEntity combatEntity = (BaseCombatEntity)entity;
                if (!ServerRelationHelper.hasControlOver((Player)player, (Entity)combatEntity)) {
                    source.m_81352_((Component)Component.m_237113_((String)("You don't have permission to control " + entity.m_7755_().getString())));
                    continue;
                }
                entities.add(combatEntity);
            }
            if (entities.isEmpty()) {
                source.m_81352_((Component)Component.m_237113_((String)"No valid units could be commanded"));
                return 0;
            }
            int priority = attackMove ? 3 : 1;
            FormationManager.move(entities, targetPos, priority, false);
            int finalEntityCount = entities.size();
            if (attackMove) {
                source.m_288197_(() -> Component.m_237113_((String)("Successfully commanded " + finalEntityCount + " units to attack-move to position (" + targetPos.m_123341_() + ", " + targetPos.m_123342_() + ", " + targetPos.m_123343_() + ")")), true);
            } else {
                source.m_288197_(() -> Component.m_237113_((String)("Successfully commanded " + finalEntityCount + " units to move to position (" + targetPos.m_123341_() + ", " + targetPos.m_123342_() + ", " + targetPos.m_123343_() + ")")), true);
            }
            return entities.size();
        }))))).then(((LiteralArgumentBuilder)net.minecraft.commands.Commands.m_82127_((String)"form_move").requires(source -> source.m_6761_(2))).then(net.minecraft.commands.Commands.m_82129_((String)"entities", (ArgumentType)EntityArgument.m_91460_()).then(net.minecraft.commands.Commands.m_82129_((String)"attack_move", (ArgumentType)BoolArgumentType.bool()).then(net.minecraft.commands.Commands.m_82129_((String)"formation_type", (ArgumentType)StringArgumentType.word()).suggests((context, builder) -> SharedSuggestionProvider.m_82967_((String[])new String[]{"loose", "tight", "line", "circle", "wedge"}, (SuggestionsBuilder)builder)).executes(context -> {
            CommandSourceStack source = (CommandSourceStack)context.getSource();
            ServerPlayer player = null;
            try {
                player = source.m_81375_();
            }
            catch (CommandSyntaxException e) {
                source.m_81352_((Component)Component.m_237113_((String)"This command must be executed by a player"));
                return 0;
            }
            boolean attackMove = BoolArgumentType.getBool((CommandContext)context, (String)"attack_move");
            String formationType = StringArgumentType.getString((CommandContext)context, (String)"formation_type");
            BlockPos targetPos = Commands.getPlayerLookTargetPos((Player)player, 200);
            if (targetPos == null) {
                source.m_81352_((Component)Component.m_237113_((String)"Failed to get target position"));
                return 0;
            }
            ArrayList<BaseCombatEntity> entities = new ArrayList<BaseCombatEntity>();
            for (Entity entity : EntityArgument.m_91461_((CommandContext)context, (String)"entities")) {
                if (!(entity instanceof BaseCombatEntity)) continue;
                BaseCombatEntity combatEntity = (BaseCombatEntity)entity;
                if (!ServerRelationHelper.hasControlOver((Player)player, (Entity)combatEntity)) {
                    source.m_81352_((Component)Component.m_237113_((String)("You don't have permission to control " + entity.m_7755_().getString())));
                    continue;
                }
                entities.add(combatEntity);
            }
            if (entities.isEmpty()) {
                source.m_81352_((Component)Component.m_237113_((String)"No valid units could be commanded"));
                return 0;
            }
            int priority = attackMove ? 3 : 1;
            FormationManager.formMove(entities, targetPos, priority, false, formationType);
            int finalEntityCount = entities.size();
            if (attackMove) {
                source.m_288197_(() -> Component.m_237113_((String)("Successfully commanded " + finalEntityCount + " units to formation attack-move (" + formationType + ") to position (" + targetPos.m_123341_() + ", " + targetPos.m_123342_() + ", " + targetPos.m_123343_() + ")")), true);
            } else {
                source.m_288197_(() -> Component.m_237113_((String)("Successfully commanded " + finalEntityCount + " units to formation move (" + formationType + ") to position (" + targetPos.m_123341_() + ", " + targetPos.m_123342_() + ", " + targetPos.m_123343_() + ")")), true);
            }
            return entities.size();
        })))))).then(((LiteralArgumentBuilder)net.minecraft.commands.Commands.m_82127_((String)"attack_target").requires(source -> source.m_6761_(2))).then(net.minecraft.commands.Commands.m_82129_((String)"entities", (ArgumentType)EntityArgument.m_91460_()).executes(context -> {
            CommandSourceStack source = (CommandSourceStack)context.getSource();
            ServerPlayer player = null;
            try {
                player = source.m_81375_();
            }
            catch (CommandSyntaxException e) {
                source.m_81352_((Component)Component.m_237113_((String)"This command must be executed by a player"));
                return 0;
            }
            LivingEntity targetEntity = Commands.getPlayerLookTargetEntity((Player)player, 200);
            if (targetEntity == null) {
                source.m_81352_((Component)Component.m_237113_((String)"No target entity found in your line of sight"));
                return 0;
            }
            ArrayList<BaseCombatEntity> entities = new ArrayList<BaseCombatEntity>();
            for (Object entity : EntityArgument.m_91461_((CommandContext)context, (String)"entities")) {
                if (!(entity instanceof BaseCombatEntity)) continue;
                BaseCombatEntity combatEntity = (BaseCombatEntity)entity;
                if (!ServerRelationHelper.hasControlOver((Player)player, (Entity)combatEntity)) {
                    source.m_81352_((Component)Component.m_237113_((String)("You don't have permission to control " + entity.m_7755_().getString())));
                    continue;
                }
                entities.add(combatEntity);
            }
            if (entities.isEmpty()) {
                source.m_81352_((Component)Component.m_237113_((String)"No valid units could be commanded"));
                return 0;
            }
            int successCount = 0;
            for (BaseCombatEntity combatEntity : entities) {
                TargetAttackGoal targetAttackGoal = new TargetAttackGoal(combatEntity, 1.0, combatEntity.getAttackReach(), targetEntity);
                combatEntity.clearCommandedGoals();
                combatEntity.addCustomGoal(1, targetAttackGoal);
                ++successCount;
            }
            int finalSuccessCount = successCount;
            String targetName = targetEntity.m_7755_().getString();
            source.m_288197_(() -> Component.m_237113_((String)("Successfully commanded " + finalSuccessCount + " units to attack target: " + targetName)), true);
            return successCount;
        })))).then(((LiteralArgumentBuilder)net.minecraft.commands.Commands.m_82127_((String)"squad_attack_target").requires(source -> source.m_6761_(2))).then(net.minecraft.commands.Commands.m_82129_((String)"squad_number", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(context -> {
            CommandSourceStack source = (CommandSourceStack)context.getSource();
            ServerPlayer player = null;
            try {
                player = source.m_81375_();
            }
            catch (CommandSyntaxException e) {
                source.m_81352_((Component)Component.m_237113_((String)"This command must be executed by a player"));
                return 0;
            }
            int squadNumber = IntegerArgumentType.getInteger((CommandContext)context, (String)"squad_number");
            LivingEntity targetEntity = Commands.getPlayerLookTargetEntity((Player)player, 200);
            if (targetEntity == null) {
                source.m_81352_((Component)Component.m_237113_((String)"No target entity found in your line of sight"));
                return 0;
            }
            List<SelectionSystem.Squad> playerSquads = SelectionSystem.getSquads().get(player.m_20148_());
            if (playerSquads == null || squadNumber >= playerSquads.size() || playerSquads.get(squadNumber) == null) {
                source.m_81352_((Component)Component.m_237113_((String)("Squad #" + squadNumber + " does not exist")));
                return 0;
            }
            SelectionSystem.Squad squad = playerSquads.get(squadNumber);
            ServerLevel world = (ServerLevel)((EntityAccessor)player).getLevel();
            int successCount = 0;
            for (UUID entityUUID : squad.getEntityUUIDs()) {
                Entity entity = world.m_8791_(entityUUID);
                if (!(entity instanceof BaseCombatEntity)) continue;
                BaseCombatEntity combatEntity = (BaseCombatEntity)entity;
                if (!ServerRelationHelper.hasControlOver((Player)player, (Entity)combatEntity)) {
                    source.m_81352_((Component)Component.m_237113_((String)"You don't have permission to control some units in this squad"));
                    continue;
                }
                TargetAttackGoal targetAttackGoal = new TargetAttackGoal(combatEntity, 1.0, combatEntity.getAttackReach(), targetEntity);
                combatEntity.clearCommandedGoals();
                combatEntity.addCustomGoal(1, targetAttackGoal);
                ++successCount;
            }
            int finalSuccessCount = successCount;
            String targetName = targetEntity.m_7755_().getString();
            source.m_288197_(() -> Component.m_237113_((String)("Successfully commanded " + finalSuccessCount + " units in squad #" + squadNumber + " to attack target: " + targetName)), true);
            return successCount;
        })))).then(((LiteralArgumentBuilder)net.minecraft.commands.Commands.m_82127_((String)"add_to_squad").requires(source -> source.m_6761_(2))).then(((RequiredArgumentBuilder)net.minecraft.commands.Commands.m_82129_((String)"squad_number", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(context -> {
            CommandSourceStack source = (CommandSourceStack)context.getSource();
            ServerPlayer player = null;
            try {
                player = source.m_81375_();
            }
            catch (CommandSyntaxException e) {
                source.m_81352_((Component)Component.m_237113_((String)"This command must be executed by a player"));
                return 0;
            }
            int squadNumber = IntegerArgumentType.getInteger((CommandContext)context, (String)"squad_number");
            LivingEntity targetEntity = Commands.getPlayerLookTargetEntity((Player)player, 200);
            if (targetEntity == null) {
                source.m_81352_((Component)Component.m_237113_((String)"No target entity found in your line of sight"));
                return 0;
            }
            if (!(targetEntity instanceof BaseCombatEntity)) {
                source.m_81352_((Component)Component.m_237113_((String)"Target entity is not a valid combat unit"));
                return 0;
            }
            if (!ServerRelationHelper.hasControlOver((Player)player, (Entity)targetEntity)) {
                source.m_81352_((Component)Component.m_237113_((String)("You don't have permission to control " + targetEntity.m_7755_().getString())));
                return 0;
            }
            List playerSquads = SelectionSystem.getSquads().computeIfAbsent(player.m_20148_(), k -> new ArrayList());
            while (playerSquads.size() <= squadNumber) {
                playerSquads.add(new SelectionSystem.Squad(new ArrayList<UUID>()));
            }
            SelectionSystem.Squad squad = (SelectionSystem.Squad)playerSquads.get(squadNumber);
            List<UUID> squadEntityUUIDs = squad.getEntityUUIDs();
            if (squadEntityUUIDs.contains(targetEntity.m_20148_())) {
                source.m_81352_((Component)Component.m_237113_((String)("Target entity is already in squad #" + squadNumber)));
                return 0;
            }
            squadEntityUUIDs.add(targetEntity.m_20148_());
            squad.setEntityUUIDs(squadEntityUUIDs);
            playerSquads.set(squadNumber, squad);
            SelectionSystem.getSquads().put(player.m_20148_(), playerSquads);
            String targetName = targetEntity.m_7755_().getString();
            source.m_288197_(() -> Component.m_237113_((String)("Successfully added " + targetName + " to squad #" + squadNumber)), true);
            return 1;
        })).then(net.minecraft.commands.Commands.m_82129_((String)"entities", (ArgumentType)EntityArgument.m_91460_()).executes(context -> {
            CommandSourceStack source = (CommandSourceStack)context.getSource();
            ServerPlayer player = null;
            try {
                player = source.m_81375_();
            }
            catch (CommandSyntaxException e) {
                source.m_81352_((Component)Component.m_237113_((String)"This command must be executed by a player"));
                return 0;
            }
            int squadNumber = IntegerArgumentType.getInteger((CommandContext)context, (String)"squad_number");
            ArrayList<BaseCombatEntity> entitiesToAdd = new ArrayList<BaseCombatEntity>();
            for (Entity entity : EntityArgument.m_91461_((CommandContext)context, (String)"entities")) {
                if (!(entity instanceof BaseCombatEntity)) continue;
                BaseCombatEntity combatEntity = (BaseCombatEntity)entity;
                if (!ServerRelationHelper.hasControlOver((Player)player, (Entity)combatEntity)) {
                    source.m_81352_((Component)Component.m_237113_((String)("You don't have permission to control " + entity.m_7755_().getString())));
                    continue;
                }
                entitiesToAdd.add(combatEntity);
            }
            if (entitiesToAdd.isEmpty()) {
                source.m_81352_((Component)Component.m_237113_((String)"No valid units could be added to squad"));
                return 0;
            }
            List playerSquads = SelectionSystem.getSquads().computeIfAbsent(player.m_20148_(), k -> new ArrayList());
            while (playerSquads.size() <= squadNumber) {
                playerSquads.add(new SelectionSystem.Squad(new ArrayList<UUID>()));
            }
            SelectionSystem.Squad squad = (SelectionSystem.Squad)playerSquads.get(squadNumber);
            List<UUID> squadEntityUUIDs = squad.getEntityUUIDs();
            int successCount = 0;
            for (BaseCombatEntity entity : entitiesToAdd) {
                if (squadEntityUUIDs.contains(entity.m_20148_())) continue;
                squadEntityUUIDs.add(entity.m_20148_());
                ++successCount;
            }
            if (successCount > 0) {
                squad.setEntityUUIDs(squadEntityUUIDs);
                playerSquads.set(squadNumber, squad);
                SelectionSystem.getSquads().put(player.m_20148_(), playerSquads);
                int finalSuccessCount = successCount;
                source.m_288197_(() -> Component.m_237113_((String)("Successfully added " + finalSuccessCount + " units to squad #" + squadNumber)), true);
            } else {
                source.m_81352_((Component)Component.m_237113_((String)("No new units were added to squad #" + squadNumber)));
            }
            return successCount;
        }))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)net.minecraft.commands.Commands.m_82127_((String)"idle_facing").requires(source -> source.m_6761_(2))).executes(context -> {
            ServerPlayer player;
            CommandSourceStack source = (CommandSourceStack)context.getSource();
            try {
                player = source.m_81375_();
            }
            catch (CommandSyntaxException e) {
                source.m_81352_((Component)Component.m_237113_((String)"This command must be executed by a player"));
                return 0;
            }
            LivingEntity targetEntity = Commands.getPlayerLookTargetEntity((Player)player, 200);
            if (!(targetEntity instanceof BaseCombatEntity)) {
                source.m_81352_((Component)Component.m_237113_((String)"No combat unit found in your line of sight"));
                return 0;
            }
            BaseCombatEntity combatEntity = (BaseCombatEntity)targetEntity;
            if (!ServerRelationHelper.hasControlOver((Player)player, (Entity)combatEntity)) {
                source.m_81352_((Component)Component.m_237113_((String)("You don't have permission to control " + combatEntity.m_7755_().getString())));
                return 0;
            }
            float yaw = player.m_146908_();
            combatEntity.setIdleFacingDirection(yaw);
            source.m_288197_(() -> Component.m_237113_((String)("Set idle facing for " + combatEntity.m_7755_().getString() + " to yaw " + String.format(Locale.ROOT, "%.1f", Float.valueOf(yaw)))), true);
            return 1;
        })).then(net.minecraft.commands.Commands.m_82129_((String)"yaw", (ArgumentType)FloatArgumentType.floatArg()).executes(context -> {
            ServerPlayer player;
            CommandSourceStack source = (CommandSourceStack)context.getSource();
            try {
                player = source.m_81375_();
            }
            catch (CommandSyntaxException e) {
                source.m_81352_((Component)Component.m_237113_((String)"This command must be executed by a player"));
                return 0;
            }
            LivingEntity targetEntity = Commands.getPlayerLookTargetEntity((Player)player, 200);
            if (!(targetEntity instanceof BaseCombatEntity)) {
                source.m_81352_((Component)Component.m_237113_((String)"No combat unit found in your line of sight"));
                return 0;
            }
            BaseCombatEntity combatEntity = (BaseCombatEntity)targetEntity;
            if (!ServerRelationHelper.hasControlOver((Player)player, (Entity)combatEntity)) {
                source.m_81352_((Component)Component.m_237113_((String)("You don't have permission to control " + combatEntity.m_7755_().getString())));
                return 0;
            }
            float yaw = FloatArgumentType.getFloat((CommandContext)context, (String)"yaw");
            combatEntity.setIdleFacingDirection(yaw);
            source.m_288197_(() -> Component.m_237113_((String)("Set idle facing for " + combatEntity.m_7755_().getString() + " to yaw " + String.format(Locale.ROOT, "%.1f", Float.valueOf(yaw)))), true);
            return 1;
        }))).then(net.minecraft.commands.Commands.m_82127_((String)"clear").executes(context -> {
            ServerPlayer player;
            CommandSourceStack source = (CommandSourceStack)context.getSource();
            try {
                player = source.m_81375_();
            }
            catch (CommandSyntaxException e) {
                source.m_81352_((Component)Component.m_237113_((String)"This command must be executed by a player"));
                return 0;
            }
            LivingEntity targetEntity = Commands.getPlayerLookTargetEntity((Player)player, 200);
            if (!(targetEntity instanceof BaseCombatEntity)) {
                source.m_81352_((Component)Component.m_237113_((String)"No combat unit found in your line of sight"));
                return 0;
            }
            BaseCombatEntity combatEntity = (BaseCombatEntity)targetEntity;
            if (!ServerRelationHelper.hasControlOver((Player)player, (Entity)combatEntity)) {
                source.m_81352_((Component)Component.m_237113_((String)("You don't have permission to control " + combatEntity.m_7755_().getString())));
                return 0;
            }
            combatEntity.clearIdleFacingDirection();
            source.m_288197_(() -> Component.m_237113_((String)("Cleared idle facing for " + combatEntity.m_7755_().getString())), true);
            return 1;
        })))).then(net.minecraft.commands.Commands.m_82127_((String)"owner").executes(context -> {
            CommandSourceStack source = (CommandSourceStack)context.getSource();
            ServerPlayer player = null;
            try {
                player = source.m_81375_();
            }
            catch (CommandSyntaxException e) {
                source.m_81352_((Component)Component.m_237113_((String)"This command must be executed by a player"));
                return 0;
            }
            LivingEntity targetEntity = Commands.getPlayerLookTargetEntity((Player)player, 200);
            if (targetEntity == null) {
                source.m_81352_((Component)Component.m_237113_((String)"No entity found in your line of sight"));
                return 0;
            }
            if (!(targetEntity instanceof BaseCombatEntity)) {
                source.m_81352_((Component)Component.m_237113_((String)"Target entity is not a combat unit"));
                return 0;
            }
            BaseCombatEntity combatEntity = (BaseCombatEntity)targetEntity;
            UUID ownerUUID = combatEntity.m_21805_();
            if (ownerUUID == null) {
                source.m_288197_(() -> Commands.lambda$registerCommands$58((Entity)targetEntity), false);
                return 1;
            }
            ServerLevel serverLevel = source.m_81372_();
            ServerPlayer ownerPlayer = serverLevel.m_7654_().m_6846_().m_11259_(ownerUUID);
            if (ownerPlayer != null) {
                String entityName = targetEntity.m_7755_().getString();
                String ownerName = ownerPlayer.m_7755_().getString();
                source.m_288197_(() -> Component.m_237113_((String)("Entity: " + entityName + "\nOwner: " + ownerName + "\nUUID: " + ownerUUID)), false);
            } else {
                String entityName = targetEntity.m_7755_().getString();
                source.m_288197_(() -> Component.m_237113_((String)("Entity: " + entityName + "\nOwner UUID: " + ownerUUID + "\n(Owner is offline)")), false);
            }
            return 1;
        })));
    }

    private static BlockPos getPlayerLookTargetPos(Player player, int maxDistance) {
        Vec3 startPos = player.m_146892_();
        Vec3 lookVec = player.m_20252_(1.0f);
        Vec3 endPos = startPos.m_82520_(lookVec.f_82479_ * (double)maxDistance, lookVec.f_82480_ * (double)maxDistance, lookVec.f_82481_ * (double)maxDistance);
        BlockHitResult blockResult = player.m_9236_().m_45547_(new ClipContext(startPos, endPos, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)player));
        if (blockResult.m_6662_() != HitResult.Type.MISS) {
            return blockResult.m_82425_();
        }
        return new BlockPos((int)endPos.f_82479_, (int)endPos.f_82480_, (int)endPos.f_82481_);
    }

    private static LivingEntity getPlayerLookTargetEntity(Player player, int maxDistance) {
        Vec3 startPos = player.m_146892_();
        Vec3 lookVec = player.m_20252_(1.0f);
        Vec3 endPos = startPos.m_82520_(lookVec.f_82479_ * (double)maxDistance, lookVec.f_82480_ * (double)maxDistance, lookVec.f_82481_ * (double)maxDistance);
        BlockHitResult blockResult = player.m_9236_().m_45547_(new ClipContext(startPos, endPos, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)player));
        double blockDistance = Double.MAX_VALUE;
        if (blockResult.m_6662_() != HitResult.Type.MISS) {
            blockDistance = startPos.m_82557_(blockResult.m_82450_());
        }
        LivingEntity closestEntity = null;
        double closestDistance = Double.MAX_VALUE;
        AABB searchBox = new AABB(startPos.f_82479_ - (double)maxDistance, startPos.f_82480_ - (double)maxDistance, startPos.f_82481_ - (double)maxDistance, startPos.f_82479_ + (double)maxDistance, startPos.f_82480_ + (double)maxDistance, startPos.f_82481_ + (double)maxDistance);
        List entities = player.m_9236_().m_45933_((Entity)player, searchBox);
        for (Entity entity : entities) {
            double distance;
            Vec3 rayEndPos;
            AABB entityBox;
            Optional hitPos;
            if (entity == player || !entity.m_6084_() || !(entity instanceof LivingEntity) || !(hitPos = (entityBox = entity.m_20191_().m_82400_(0.3)).m_82371_(startPos, rayEndPos = startPos.m_82549_(lookVec.m_82490_((double)maxDistance)))).isPresent() || !((distance = startPos.m_82557_((Vec3)hitPos.get())) < closestDistance) || !(distance < blockDistance)) continue;
            closestEntity = (LivingEntity)entity;
            closestDistance = distance;
        }
        return closestEntity;
    }

    public static void summonEntity(CommandSourceStack source, String entityName, int entityLevel, int equipmentLevel, Entity owner) throws CommandSyntaxException {
        ServerLevel world = source.m_81372_();
        String fullEntityName = "hundred_years_war:" + entityName;
        EntityType entityType = EntityType.m_20632_((String)fullEntityName).orElse(null);
        if (entityType != null && entityType.m_20615_((Level)world) instanceof BaseCombatEntity) {
            BaseCombatEntity entity = (BaseCombatEntity)entityType.m_20615_((Level)world);
            assert (entity != null);
            if (owner instanceof Player) {
                Player player = (Player)owner;
                entity.m_30586_(player.m_20148_());
            }
            entity.m_7678_(source.m_81371_().f_82479_, source.m_81371_().f_82480_, source.m_81371_().f_82481_, 0.0f, 0.0f);
            if (entityLevel > 0) {
                entity.applyLevelWithStats(entityLevel);
            }
            entity.setEquipment(equipmentLevel);
            world.m_7967_((Entity)entity);
            entity.setHomePosition(entity.m_20183_());
            source.m_288197_(() -> Component.m_237113_((String)("Successfully summoned " + entityName + (String)(entityLevel > 0 ? " (Entity Level: " + entityLevel + ")" : "") + (String)(equipmentLevel > 0 ? " (Equipment Level: " + equipmentLevel + ")" : ""))), true);
        } else {
            source.m_81352_((Component)Component.m_237113_((String)"Failed to summon entity"));
        }
    }

    private static /* synthetic */ Component lambda$registerCommands$58(Entity targetEntity) {
        return Component.m_237113_((String)("Entity: " + targetEntity.m_7755_().getString() + "\nOwner: No owner (\u91ce\u751f\u5355\u4f4d)"));
    }
}

