/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.main.entity.entities;

import java.util.Random;
import java.util.function.Predicate;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import ydmsama.hundred_years_war.main.entity.entities.BaseCombatEntity;
import ydmsama.hundred_years_war.main.entity.entities.tags.CounterLight;
import ydmsama.hundred_years_war.main.entity.entities.tags.LightUnit;
import ydmsama.hundred_years_war.main.entity.entities.tags.RangedUnit;
import ydmsama.hundred_years_war.main.entity.goals.HywWaterAvoidingRandomStrollGoal;
import ydmsama.hundred_years_war.main.entity.goals.SkyExposedTargetGoal;
import ydmsama.hundred_years_war.main.entity.utils.HorseRider;
import ydmsama.hundred_years_war.main.entity.utils.Mountable;
import ydmsama.hundred_years_war.main.registry.HywAttributes;
import ydmsama.hundred_years_war.main.registry.HywItemRegistry;

public class ArcherEntity
extends BaseCombatEntity
implements RangedAttackMob,
HorseRider,
LightUnit,
RangedUnit,
CounterLight,
Mountable {
    private static final float ATTACK_REACH = 100.0f;
    private static final float MOVEMENT_SPEED = 0.3f;
    private static final float BASE_RANGED_ATTACK_DAMAGE = 2.5f;
    private static final EntityDataAccessor<Integer> USE_ANGLE = SynchedEntityData.m_135353_(ArcherEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);

    public ArcherEntity(EntityType<? extends PathfinderMob> entityType, Level world) {
        super(entityType, world);
        this.m_274367_(1.0f);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(USE_ANGLE, (Object)1);
    }

    public static AttributeSupplier.Builder createArcherAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22277_, 100.0).m_22268_(Attributes.f_22279_, (double)0.3f).m_22268_(Attributes.f_22281_, 8.0).m_22268_(Attributes.f_22284_, 2.0).m_22268_(Attributes.f_22276_, 20.0).m_22268_(Attributes.f_22278_, 0.4).m_22268_((Attribute)HywAttributes.ATTACK_REACH.get(), 100.0).m_22268_((Attribute)HywAttributes.RANGED_ATTACK_DAMAGE.get(), 2.5);
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
    }

    @Override
    protected void setDefaultEquipment() {
        this.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.f_42411_));
        this.m_8061_(EquipmentSlot.OFFHAND, ItemStack.f_41583_);
        this.m_8061_(EquipmentSlot.HEAD, new ItemStack((ItemLike)Items.f_42464_));
        this.m_8061_(EquipmentSlot.CHEST, new ItemStack((ItemLike)Items.f_42465_));
        this.m_8061_(EquipmentSlot.LEGS, new ItemStack((ItemLike)Items.f_42466_));
        this.m_8061_(EquipmentSlot.FEET, new ItemStack((ItemLike)Items.f_42467_));
    }

    @Override
    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
    }

    @Override
    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
    }

    @Override
    public int getBaseAttackAnimationTime() {
        return 15;
    }

    @Override
    public int getAttackDamageTickDelay() {
        Random random = new Random();
        return Math.max(this.getBaseAttackAnimationTime() - random.nextInt(5), 5);
    }

    @Override
    public int getAttackCoolDownDuration() {
        Random random = new Random();
        return 3 + random.nextInt(8);
    }

    public void m_6504_(LivingEntity target, float pullProgress) {
        double dy;
        double dz;
        double dx;
        double distance;
        AbstractArrow arrow = ProjectileUtil.m_37300_((LivingEntity)this, (ItemStack)new ItemStack((ItemLike)Items.f_42412_), (float)pullProgress);
        arrow.m_36781_(this.m_21133_((Attribute)HywAttributes.RANGED_ATTACK_DAMAGE.get()));
        ItemStack bowStack = this.m_21120_(InteractionHand.MAIN_HAND);
        int powerLevel = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44988_, (ItemStack)bowStack);
        int punchLevel = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44989_, (ItemStack)bowStack);
        int flameLevel = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44990_, (ItemStack)bowStack);
        if (powerLevel > 0) {
            arrow.m_36781_(arrow.m_36789_() + (double)powerLevel * 0.5 + 0.5);
        }
        if (punchLevel > 0) {
            arrow.m_36735_(punchLevel);
        }
        if (flameLevel > 0) {
            arrow.m_20254_(100);
        }
        if ((distance = Math.sqrt((dx = target.m_20185_() - this.m_20185_()) * dx + (dz = target.m_20189_() - this.m_20189_()) * dz + (dy = target.m_20227_(0.5) - arrow.m_20186_()) * dy)) == 0.0) {
            return;
        }
        float speed = 2.0f;
        double gravity = 0.05;
        double angle = Double.NaN;
        float maxArrowSpeed = 3.0f;
        float miss = 2.5f;
        this.setUseAngle(-1);
        while (speed <= maxArrowSpeed) {
            double[] angles = this.calculateLaunchAngles(speed, gravity, distance, dy);
            if (!(this.isObstructed(target) && !this.m_20159_() && target.m_9236_().m_45527_(target.m_20183_()) || Double.isNaN(angles[1]) && !(distance < 5.0))) {
                angle = angles[1];
                this.setUseAngle(1);
                break;
            }
            if (!Double.isNaN(angles[0]) && this.isPathClear(arrow, angles[0], speed, dx, dy, dz, distance, target)) {
                angle = angles[0];
                this.setUseAngle(0);
                break;
            }
            if (!((speed += 0.25f) > maxArrowSpeed)) continue;
            break;
        }
        if (this.getUseAngle() == -1) {
            return;
        }
        double randomSpeedOffset = ArcherEntity.getRandomInRange(-0.25, 0.75);
        double timeToTarget = distance / (((double)speed - randomSpeedOffset) * Math.cos(angle));
        double targetVelocityX = target.m_20184_().m_7096_();
        double targetVelocityZ = target.m_20184_().m_7094_();
        double predictedX = target.m_20185_() + targetVelocityX * timeToTarget;
        double predictedZ = target.m_20189_() + targetVelocityZ * timeToTarget;
        double predictedDistance = Math.sqrt((predictedX - this.m_20185_()) * (predictedX - this.m_20185_()) + (predictedZ - this.m_20189_()) * (predictedZ - this.m_20189_()));
        double[] angles = this.calculateLaunchAngles(speed, gravity, predictedDistance, dy);
        if (Double.isNaN(angles[0]) && Double.isNaN(angles[1])) {
            return;
        }
        angle = angles[this.getUseAngle()];
        dx = predictedX - this.m_20185_();
        double horizontalDistance = Math.sqrt(dx * dx + (dz = predictedZ - this.m_20189_()) * dz);
        if (horizontalDistance == 0.0) {
            return;
        }
        double horizontalSpeed = (double)speed * Math.cos(angle);
        double verticalSpeed = (double)speed * Math.sin(angle);
        float velocityX = (float)(dx / horizontalDistance * horizontalSpeed);
        float velocityY = (float)verticalSpeed;
        float velocityZ = (float)(dz / horizontalDistance * horizontalSpeed);
        if (this.getUseAngle() == 0) {
            miss = 3.5f;
            arrow.m_36781_(this.m_21133_((Attribute)HywAttributes.RANGED_ATTACK_DAMAGE.get()) * 1.5);
            arrow.m_36781_(arrow.m_36789_() + (double)powerLevel * 0.5 + 0.5);
        }
        arrow.m_6686_((double)velocityX, (double)velocityY, (double)velocityZ, speed, miss);
        this.m_5496_(SoundEvents.f_12382_, 1.0f, 1.0f / (this.m_217043_().m_188501_() * 0.4f + 0.8f));
        this.m_9236_().m_7967_((Entity)arrow);
        this.m_5810_();
    }

    private boolean isPathClear(AbstractArrow arrow, double angle, float speed, double dx, double dy, double dz, double distance, LivingEntity target) {
        Vec3 startPos = this.m_146892_();
        Vec3 direction = new Vec3(dx / distance, Math.tan(angle), dz / distance).m_82541_();
        Vec3 endPos = startPos.m_82549_(direction.m_82490_(5.0));
        BlockHitResult hitResult = this.m_9236_().m_45547_(new ClipContext(startPos, endPos, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)arrow));
        return hitResult.m_6662_() == HitResult.Type.MISS;
    }

    private double[] calculateLaunchAngles(double speed, double gravity, double distance, double heightDifference) {
        double discriminant = speed * speed * speed * speed - gravity * (gravity * distance * distance + 2.0 * heightDifference * speed * speed);
        if (discriminant < 0.0) {
            return new double[]{Double.NaN, Double.NaN};
        }
        double angle1 = Math.atan2(speed * speed + Math.sqrt(discriminant), gravity * distance);
        double angle2 = Math.atan2(speed * speed - Math.sqrt(discriminant), gravity * distance);
        return new double[]{angle1, angle2};
    }

    @Override
    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(5, (Goal)new HywWaterAvoidingRandomStrollGoal(this, 0.75));
        this.f_21345_.m_25352_(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 4.0f));
        this.f_21345_.m_25352_(7, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    @Override
    public void addTargetSelector() {
        Predicate<LivingEntity> unifiedPredicate = this::isValidTarget;
        this.f_21346_.m_25352_(1, (Goal)new SkyExposedTargetGoal(this, LivingEntity.class, 10, true, false, unifiedPredicate));
    }

    public int getUseAngle() {
        return (Integer)this.f_19804_.m_135370_(USE_ANGLE);
    }

    public void setUseAngle(int useAngle) {
        this.f_19804_.m_135381_(USE_ANGLE, (Object)useAngle);
    }

    public static double getRandomInRange(double min, double max) {
        return min + Math.random() * (max - min);
    }

    @Override
    public Item getScrollType() {
        return switch (this.getEquipmentLevel()) {
            case 1 -> (Item)HywItemRegistry.SCROLL_ARCHER.get();
            case 2 -> (Item)HywItemRegistry.SCROLL_ARCHER_1.get();
            case 3 -> (Item)HywItemRegistry.SCROLL_ARCHER_2.get();
            case 4 -> (Item)HywItemRegistry.SCROLL_ARCHER_3.get();
            default -> null;
        };
    }

    @Override
    protected void increaseStatsOnLevelUp() {
        super.increaseStatsOnLevelUp();
        AttributeInstance rangedAttackDamage = this.m_21051_((Attribute)HywAttributes.RANGED_ATTACK_DAMAGE.get());
        if (rangedAttackDamage != null) {
            rangedAttackDamage.m_22100_(rangedAttackDamage.m_22115_() + 0.1);
        }
    }

    @Override
    public double getLightDamageModifier() {
        return 1.5;
    }

    @Override
    public double getHeavyDamageModifier() {
        return 0.5;
    }

    @Override
    public LivingEntity asLivingEntity() {
        return this;
    }

    @Override
    public boolean hasValidTarget() {
        return this.getHywTarget() != null;
    }

    @Override
    public double getHorseSpeed() {
        return 0.38;
    }
}

