/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.main.entity.entities;

import com.google.gson.Gson;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Queue;
import java.util.Random;
import java.util.UUID;
import java.util.function.Predicate;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.OpenDoorGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WrappedGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.EnderMan;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ProjectileWeaponItem;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import ydmsama.hundred_years_war.main.config.RecruitBalanceConfig;
import ydmsama.hundred_years_war.main.config.ServerModConfig;
import ydmsama.hundred_years_war.main.entity.action.Action;
import ydmsama.hundred_years_war.main.entity.action.AttackAction;
import ydmsama.hundred_years_war.main.entity.action.CancelAction;
import ydmsama.hundred_years_war.main.entity.action.HoldAction;
import ydmsama.hundred_years_war.main.entity.action.PatrolAction;
import ydmsama.hundred_years_war.main.entity.action.PositionAttackAction;
import ydmsama.hundred_years_war.main.entity.action.UnloadAction;
import ydmsama.hundred_years_war.main.entity.entities.ArcherEntity;
import ydmsama.hundred_years_war.main.entity.entities.BaseWorkerEntity;
import ydmsama.hundred_years_war.main.entity.entities.HywHorseEntity;
import ydmsama.hundred_years_war.main.entity.entities.HywSkeletonArcherEntity;
import ydmsama.hundred_years_war.main.entity.entities.SpearManEntity;
import ydmsama.hundred_years_war.main.entity.entities.UseCrossbow;
import ydmsama.hundred_years_war.main.entity.entities.UseShield;
import ydmsama.hundred_years_war.main.entity.entities.mounted.MountedLancerRiderEntity;
import ydmsama.hundred_years_war.main.entity.entities.puppets.IPuppet;
import ydmsama.hundred_years_war.main.entity.entities.siege.PositionAttackable;
import ydmsama.hundred_years_war.main.entity.entities.siege.UnloadPassengerable;
import ydmsama.hundred_years_war.main.entity.entities.tags.CavalryUnit;
import ydmsama.hundred_years_war.main.entity.entities.tags.CounterCavalry;
import ydmsama.hundred_years_war.main.entity.entities.tags.CounterHeavy;
import ydmsama.hundred_years_war.main.entity.entities.tags.CounterLight;
import ydmsama.hundred_years_war.main.entity.entities.tags.CounterRanged;
import ydmsama.hundred_years_war.main.entity.entities.tags.CounterSiege;
import ydmsama.hundred_years_war.main.entity.entities.tags.HeavyUnit;
import ydmsama.hundred_years_war.main.entity.entities.tags.LightUnit;
import ydmsama.hundred_years_war.main.entity.entities.tags.RangedUnit;
import ydmsama.hundred_years_war.main.entity.entities.tags.RotationLimited;
import ydmsama.hundred_years_war.main.entity.entities.tags.SiegeUnit;
import ydmsama.hundred_years_war.main.entity.goals.BaseCombatEntityAttackGoal;
import ydmsama.hundred_years_war.main.entity.goals.CommandedGoal;
import ydmsama.hundred_years_war.main.entity.goals.FollowEntityGoal;
import ydmsama.hundred_years_war.main.entity.goals.FormMoveGoal;
import ydmsama.hundred_years_war.main.entity.goals.MoveGoal;
import ydmsama.hundred_years_war.main.entity.goals.PatrolGoal;
import ydmsama.hundred_years_war.main.entity.goals.PrioritizedGoal;
import ydmsama.hundred_years_war.main.entity.goals.ReturnToHomeGoal;
import ydmsama.hundred_years_war.main.entity.navigation.BaseCombatNavigation;
import ydmsama.hundred_years_war.main.entity.navigation.LadderAwareMoveControl;
import ydmsama.hundred_years_war.main.entity.utils.AttackStrategy;
import ydmsama.hundred_years_war.main.entity.utils.BaseCombatSupport;
import ydmsama.hundred_years_war.main.entity.utils.Chargeable;
import ydmsama.hundred_years_war.main.entity.utils.FormationManager;
import ydmsama.hundred_years_war.main.entity.utils.HorseRider;
import ydmsama.hundred_years_war.main.entity.utils.MeleeCapableRangedAttacker;
import ydmsama.hundred_years_war.main.entity.utils.MultiSeatVehicle;
import ydmsama.hundred_years_war.main.entity.utils.json.EnchantmentData;
import ydmsama.hundred_years_war.main.entity.utils.json.EquipmentData;
import ydmsama.hundred_years_war.main.entity.utils.json.EquipmentLevelData;
import ydmsama.hundred_years_war.main.entity.utils.json.EquipmentOption;
import ydmsama.hundred_years_war.main.item.BaseScrollItem;
import ydmsama.hundred_years_war.main.mixins.EntityAccessor;
import ydmsama.hundred_years_war.main.registry.HywAttributes;
import ydmsama.hundred_years_war.main.supply.SupplyManager;
import ydmsama.hundred_years_war.main.utils.BetterMobCombatIntegration;
import ydmsama.hundred_years_war.main.utils.CreativeModeSettings;
import ydmsama.hundred_years_war.main.utils.ExpBlacklistManager;
import ydmsama.hundred_years_war.main.utils.RelationSystem;
import ydmsama.hundred_years_war.main.utils.ServerRelationHelper;
import ydmsama.hundred_years_war.main.utils.TargetListManager;
import ydmsama.hundred_years_war.main.utils.TreeFellingHandler;
import ydmsama.hundred_years_war.main.utils.WeaponTypeHelper;
import ydmsama.hundred_years_war.main.utils.WorldTickCounter;

public abstract class BaseCombatEntity
extends PathfinderMob
implements BaseCombatSupport {
    protected float currentRot;
    protected float targetRot;
    protected float rotationLimit = 90.0f;
    private boolean hasIdleFacing;
    private float idleFacingYaw;
    private final List<RandomLookGoalEntry> removedRandomLookGoals = new ArrayList<RandomLookGoalEntry>();
    protected LivingEntity startTarget;
    private int equipmentLevel;
    private double desiredDistance = 1.5;
    private int targetNullTicks = 0;
    protected boolean isAttacking = false;
    private AttackStrategy attackStrategy = AttackStrategy.DEFAULT;
    protected int attackAnimationTime = -1;
    protected int attackDamageTick = -1;
    private int attackCoolDown = 0;
    private UUID followTargetUUID;
    private LivingEntity followTarget;
    private final List<BlockPos> patrolPoints;
    private int healCooldown = 1200;
    private int shieldCoolDown;
    private final double defaultHomeReturnRadius = 1.5;
    private double homeReturnRadius = 1.5;
    protected double unitOccupiedArea = 5.0;
    private long unloadTime = -1L;
    private double[] screenPos;
    private UUID formationUUID;
    private BlockPos homePosition;
    private int treeFellingCooldown = 0;
    private Vec3 lastTreeFellingPosition = null;
    private static final EntityDataAccessor<Boolean> START_ATTACKING = SynchedEntityData.m_135353_(BaseCombatEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> CURRENT_SKIN_INDEX = SynchedEntityData.m_135353_(BaseCombatEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> EXPERIENCE_POINTS = SynchedEntityData.m_135353_(BaseCombatEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> LEVEL = SynchedEntityData.m_135353_(BaseCombatEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> HAS_TARGET = SynchedEntityData.m_135353_(BaseCombatEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Optional<UUID>> OWNER_UUID = SynchedEntityData.m_135353_(BaseCombatEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    private static final EntityDataAccessor<Integer> KILL_COUNT = SynchedEntityData.m_135353_(BaseCombatEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Float> Y_BODY_ROT = SynchedEntityData.m_135353_(BaseCombatEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Boolean> SHOULD_RENDER = SynchedEntityData.m_135353_(BaseCombatEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> REQUIRES_SUPPLY = SynchedEntityData.m_135353_(BaseCombatEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private int renderRestoreTimer = 0;
    private static final int RENDER_RESTORE_DELAY = 10;
    private int aiRestoreTimer = 0;
    private static final int AI_RESTORE_DELAY = 5;
    private boolean aiDisabledByVehicle = false;
    private boolean queueMode = false;
    private boolean holding = false;
    private boolean commandHold = false;
    private boolean forceMoveOnly = false;
    private Queue<PrioritizedGoal> goalQueue = new LinkedList<PrioritizedGoal>();
    private PrioritizedGoal currentCommandedGoal;
    private boolean shouldExecuteNext;
    public final AnimationState attackAnimationState = new AnimationState();
    public final AnimationState idleAnimationState = new AnimationState();
    public final AnimationState moveAnimationState = new AnimationState();
    private long lastInteractionTime = 0L;
    private static final long INTERACTION_COOLDOWN = 500L;
    protected long lastWeaponReplaceTime = 0L;
    protected static final long WEAPON_REPLACE_COOLDOWN = 1000L;
    protected LivingEntity hywTarget;
    protected int targetResetTick = 10;
    private static final int TARGET_RESET_TIME = 10;
    private boolean forceAttackTarget = false;
    private final List<Action> actions = new ArrayList<Action>();
    private static final UUID WATER_SPEED_MODIFIER_UUID = UUID.fromString("550e8400-e29b-41d4-a716-446655440000");
    private static final UUID WEAKNESS_RANGED_DAMAGE_MODIFIER_UUID = UUID.fromString("550e8400-e29b-41d4-a716-446655440001");
    private static final UUID RANGED_USING_ITEM_SPEED_MODIFIER_UUID = UUID.fromString("550e8400-e29b-41d4-a716-446655440002");
    private final Random shieldBlockRandom = new Random();
    private int summonWeaknessTimer = 0;
    private int comboCount = 0;
    private EquipmentData equipmentData;
    private final Random random = new Random();

    public int getComboCount() {
        return this.comboCount;
    }

    public void setComboCount(int comboCount) {
        this.comboCount = comboCount;
    }

    public int getSummonWeaknessTimer() {
        return this.summonWeaknessTimer;
    }

    public void setSummonWeaknessTimer(int timer) {
        this.summonWeaknessTimer = timer;
    }

    public boolean getShouldRender() {
        return (Boolean)this.f_19804_.m_135370_(SHOULD_RENDER);
    }

    public void setShouldRender(boolean shouldRender) {
        this.f_19804_.m_135381_(SHOULD_RENDER, (Object)shouldRender);
    }

    private boolean isInInternalSeat() {
        Entity vehicle = this.m_20202_();
        if (vehicle instanceof MultiSeatVehicle) {
            MultiSeatVehicle multiSeatVehicle = (MultiSeatVehicle)vehicle;
            return multiSeatVehicle.getSeatForEntity((Entity)this).map(seat -> seat.getType() == MultiSeatVehicle.SeatType.INTERNAL).orElse(false);
        }
        return false;
    }

    private void manageAIState() {
        boolean currentlyInInternalSeat = this.isInInternalSeat();
        boolean currentAIDisabled = this.m_21525_();
        if (!currentAIDisabled && currentlyInInternalSeat) {
            this.m_21557_(true);
            this.aiDisabledByVehicle = true;
            this.aiRestoreTimer = 0;
        } else if (currentAIDisabled && this.aiDisabledByVehicle && !currentlyInInternalSeat) {
            ++this.aiRestoreTimer;
            if (this.aiRestoreTimer >= 5) {
                this.m_21557_(false);
                this.aiDisabledByVehicle = false;
                this.aiRestoreTimer = 0;
            }
        } else if (currentAIDisabled && this.aiDisabledByVehicle && currentlyInInternalSeat) {
            this.aiRestoreTimer = 0;
        }
    }

    public BaseCombatEntity(EntityType<? extends PathfinderMob> entityType, Level world) {
        super(entityType, world);
        this.patrolPoints = new ArrayList<BlockPos>();
        this.m_20088_().m_135372_(START_ATTACKING, (Object)false);
        this.m_20088_().m_135372_(HAS_TARGET, (Object)false);
        this.m_20088_().m_135372_(OWNER_UUID, Optional.empty());
        this.m_20088_().m_135372_(SHOULD_RENDER, (Object)true);
        this.m_20088_().m_135372_(REQUIRES_SUPPLY, (Object)true);
        this.m_21530_();
        this.f_19804_.m_135372_(EXPERIENCE_POINTS, (Object)0);
        this.f_19804_.m_135372_(LEVEL, (Object)1);
        this.f_19804_.m_135372_(CURRENT_SKIN_INDEX, (Object)0);
        this.setCurrentSkinIndex(this.random.nextInt(this.getSkinCounts()) + 1);
        ((GroundPathNavigation)this.m_21573_()).m_26477_(true);
        ((GroundPathNavigation)this.m_21573_()).m_148214_(true);
        this.m_21441_(BlockPathTypes.RAIL, 0.0f);
        this.m_21441_(BlockPathTypes.UNPASSABLE_RAIL, 0.0f);
        this.m_21441_(BlockPathTypes.TRAPDOOR, 7.0f);
        this.m_21441_(BlockPathTypes.POWDER_SNOW, -1.0f);
        this.f_21342_ = new LadderAwareMoveControl((Mob)this);
        this.initActions();
    }

    public int getSkinCounts() {
        return 20;
    }

    public boolean isHolding() {
        return this.holding;
    }

    public void setHolding(boolean holding) {
        this.holding = holding;
    }

    public boolean isForceMoveOnly() {
        return this.forceMoveOnly;
    }

    public void setForceMoveOnly(boolean forceMoveOnly) {
        this.forceMoveOnly = forceMoveOnly;
    }

    public boolean commandHold() {
        return this.commandHold;
    }

    public void setCommandHold(boolean commandHold) {
        if (commandHold) {
            this.m_21573_().m_26573_();
            this.setHywTarget(null);
            if (this.homePosition == null) {
                this.setHomePosition(this.m_20183_());
            }
        }
        this.commandHold = commandHold;
    }

    public boolean getWithinAttackRange() {
        if (this.getHywTarget() != null) {
            float attackReach;
            double distanceSq = this.m_20275_(this.getHywTarget().m_20185_(), this.getHywTarget().m_20186_(), this.getHywTarget().m_20189_());
            return distanceSq <= (double)((attackReach = this.getAttackReach()) * attackReach);
        }
        return false;
    }

    public boolean getWithinPushRange() {
        if (this.getHywTarget() != null && this.m_5448_() != null) {
            double followRange;
            double distanceSq = this.m_20275_(this.getHywTarget().m_20185_(), this.getHywTarget().m_20186_(), this.getHywTarget().m_20189_());
            return distanceSq <= (followRange = Objects.requireNonNull(this.m_21051_(Attributes.f_22277_)).m_22135_()) * followRange;
        }
        return false;
    }

    public double[] getScreenPos() {
        return this.screenPos;
    }

    public double getDefaultHomeReturnRadius() {
        return 1.5;
    }

    public double getHomeReturnRadius() {
        return this.homeReturnRadius;
    }

    public void setHomeReturnRadius(double homeReturnRadius) {
        this.homeReturnRadius = homeReturnRadius;
    }

    public double getUnitOccupiedArea() {
        return this.unitOccupiedArea;
    }

    public void setUnitOccupiedArea(double area) {
        this.unitOccupiedArea = Math.max(0.25, area);
    }

    public void setScreenPos(double[] screenPos) {
        this.screenPos = screenPos;
    }

    public int getCurrentSkinIndex() {
        return (Integer)this.m_20088_().m_135370_(CURRENT_SKIN_INDEX);
    }

    public void setCurrentSkinIndex(int index) {
        this.m_20088_().m_135381_(CURRENT_SKIN_INDEX, (Object)index);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(KILL_COUNT, (Object)0);
        this.f_19804_.m_135372_(Y_BODY_ROT, (Object)Float.valueOf(0.0f));
    }

    protected PathNavigation m_6037_(Level level) {
        return new BaseCombatNavigation((Mob)this, level);
    }

    public boolean isOnLadder() {
        BlockPos currentPos = this.m_20183_();
        return this.m_9236_().m_8055_(currentPos).m_204336_(BlockTags.f_13082_);
    }

    @Override
    public void m_30586_(UUID uuid) {
        if (uuid == null) {
            this.f_19804_.m_135381_(OWNER_UUID, Optional.empty());
        } else {
            this.f_19804_.m_135381_(OWNER_UUID, Optional.of(uuid));
        }
    }

    public ServerPlayer getOwner() {
        MinecraftServer server;
        Optional optionalUUID = (Optional)this.f_19804_.m_135370_(OWNER_UUID);
        if (optionalUUID.isPresent() && (server = ((EntityAccessor)((Object)this)).getLevel().m_7654_()) != null) {
            return server.m_6846_().m_11259_((UUID)optionalUUID.get());
        }
        return null;
    }

    public int getExperiencePoints() {
        return (Integer)this.f_19804_.m_135370_(EXPERIENCE_POINTS);
    }

    public void setExperiencePoints(int experiencePoints) {
        this.f_19804_.m_135381_(EXPERIENCE_POINTS, (Object)experiencePoints);
    }

    public int getLevel() {
        return (Integer)this.f_19804_.m_135370_(LEVEL);
    }

    public void setLevel(int level) {
        this.f_19804_.m_135381_(LEVEL, (Object)level);
    }

    @Override
    public UUID m_21805_() {
        return ((Optional)this.f_19804_.m_135370_(OWNER_UUID)).orElse(null);
    }

    @Override
    public void setHomePosition(BlockPos homePosition) {
        this.homePosition = homePosition;
    }

    @Override
    public BlockPos getHomePosition() {
        return this.homePosition;
    }

    @Override
    public boolean requiresSupply() {
        return (Boolean)this.f_19804_.m_135370_(REQUIRES_SUPPLY);
    }

    @Override
    public void setRequiresSupply(boolean requires) {
        this.f_19804_.m_135381_(REQUIRES_SUPPLY, (Object)requires);
    }

    @Override
    public double getDailySupplyConsumption() {
        return 2.0;
    }

    public void removeCustomGoal(Goal goal) {
        this.f_21345_.m_25363_(goal);
    }

    public void clearAllGoals() {
        this.f_21345_.m_148105_().clear();
    }

    public void addCustomGoal(int priority, Goal goal) {
        this.goalQueue.add(new PrioritizedGoal(priority, goal));
        if (this.goalQueue.size() == 1) {
            this.executeNextGoal();
        }
    }

    public void executeNextGoal() {
        if (!this.goalQueue.isEmpty()) {
            PrioritizedGoal prioritizedGoal;
            this.currentCommandedGoal = prioritizedGoal = this.goalQueue.peek();
            this.f_21345_.m_25352_(prioritizedGoal.priority, this.currentCommandedGoal.goal);
        }
    }

    public void goalFinished() {
        this.goalQueue.poll();
        this.currentCommandedGoal = null;
    }

    public void clearCommandedGoals() {
        this.clearNonPatrolCommandedGoals();
        this.clearPatrolPoints();
    }

    public void clearNonPatrolCommandedGoals() {
        for (Object passenger : this.m_20197_()) {
            if (!(passenger instanceof BaseCombatEntity)) continue;
            ((BaseCombatEntity)passenger).clearCommandedGoals();
        }
        ArrayList toRemove = new ArrayList();
        this.f_21345_.m_148105_().stream().filter(pair -> pair.m_26015_() instanceof CommandedGoal).forEach(pair -> {
            toRemove.add(pair.m_26015_());
            pair.m_26015_().m_8041_();
        });
        for (Goal goal : toRemove) {
            this.f_21345_.m_25363_(goal);
            goal.m_8041_();
        }
        BaseCombatEntity baseCombatEntity = this;
        if (baseCombatEntity instanceof PositionAttackable) {
            PositionAttackable positionAttackable = (PositionAttackable)((Object)baseCombatEntity);
            positionAttackable.setPositionTarget(null);
        }
        if ((baseCombatEntity = this) instanceof UnloadPassengerable) {
            UnloadPassengerable unloadPassengerable = (UnloadPassengerable)((Object)baseCombatEntity);
            unloadPassengerable.setUnloadTarget(null);
        }
        this.m_21573_().m_26573_();
        this.clearGoalQueue();
        this.setFollowTarget(null);
        this.setHywTarget(null);
        this.setCommandHold(false);
    }

    public void clearGoalQueue() {
        for (PrioritizedGoal goal : this.goalQueue) {
            if (!(goal.goal instanceof FormMoveGoal)) continue;
            UUID formationUUID = ((FormMoveGoal)goal.goal).getFormationUUID();
            FormationManager.getFormationStatus(formationUUID).removeEntityFromFormation(this);
        }
        this.goalQueue.clear();
        this.currentCommandedGoal = null;
    }

    public boolean isShouldExecuteNext() {
        return this.shouldExecuteNext;
    }

    public void setShouldExecuteNext(boolean shouldExecuteNext) {
        this.shouldExecuteNext = shouldExecuteNext;
    }

    public UUID getFormationUUID() {
        return this.formationUUID;
    }

    public void setFormationUUID(UUID formationUUID) {
        this.formationUUID = formationUUID;
    }

    public void setQueueMode(boolean queueMode) {
        this.queueMode = queueMode;
    }

    public boolean getQueueMode() {
        return this.queueMode;
    }

    public void setStartAttacking(boolean start) {
        this.m_20088_().m_135381_(START_ATTACKING, (Object)start);
    }

    public boolean getStartAttacking() {
        return (Boolean)this.m_20088_().m_135370_(START_ATTACKING);
    }

    protected boolean allowBetterCombatAttack() {
        return true;
    }

    protected boolean allowEquipmentReplacement() {
        return true;
    }

    public boolean getHasTarget() {
        return (Boolean)this.f_19804_.m_135370_(HAS_TARGET);
    }

    public void setHasTarget(boolean hasTarget) {
        this.f_19804_.m_135381_(HAS_TARGET, (Object)hasTarget);
    }

    public AttackStrategy getAttackStrategy() {
        return this.attackStrategy;
    }

    public void setAttackStrategy(AttackStrategy strategy) {
        AttackStrategy resolved;
        this.attackStrategy = resolved = strategy == null ? AttackStrategy.DEFAULT : strategy;
        if (resolved == AttackStrategy.CEASE_FIRE) {
            this.m_6710_(null);
            this.setHywTarget(null);
        }
    }

    protected void setDefaultEquipment() {
    }

    @Override
    public void m_7380_(CompoundTag compound) {
        MinecraftServer server;
        AttributeInstance attackAttribute;
        Optional ownerUUID;
        super.m_7380_(compound);
        if (this.homePosition != null) {
            compound.m_128405_("HomePosX", this.homePosition.m_123341_());
            compound.m_128405_("HomePosY", this.homePosition.m_123342_());
            compound.m_128405_("HomePosZ", this.homePosition.m_123343_());
        }
        if ((ownerUUID = (Optional)this.f_19804_.m_135370_(OWNER_UUID)).isPresent()) {
            compound.m_128362_("OwnerUUID", (UUID)ownerUUID.get());
        }
        compound.m_128347_("HomeReturnRadius", this.getHomeReturnRadius());
        ArrayList<Integer> patrolList = new ArrayList<Integer>();
        for (BlockPos pos : this.patrolPoints) {
            patrolList.add(pos.m_123341_());
            patrolList.add(pos.m_123342_());
            patrolList.add(pos.m_123343_());
        }
        compound.m_128408_("PatrolPoints", patrolList);
        if (this.followTarget != null) {
            compound.m_128362_("FollowTargetUUID", this.followTarget.m_20148_());
        }
        compound.m_128405_("ExperiencePoints", this.getExperiencePoints());
        compound.m_128405_("Level", this.getLevel());
        compound.m_128347_("Health", (double)this.m_21223_());
        AttributeInstance maxHealthAttribute = this.m_21051_(Attributes.f_22276_);
        if (maxHealthAttribute != null) {
            compound.m_128347_("MaxHealth", maxHealthAttribute.m_22115_());
        }
        if ((attackAttribute = this.m_21051_(Attributes.f_22281_)) != null) {
            compound.m_128347_("AttackDamage", attackAttribute.m_22115_());
        }
        compound.m_128405_("Skin", this.getCurrentSkinIndex());
        compound.m_128405_("EquipmentLevel", this.getEquipmentLevel());
        compound.m_128379_("CommandHold", this.commandHold);
        compound.m_128405_("KillCount", this.getKillCount());
        compound.m_128405_("SummonWeaknessTimer", this.summonWeaknessTimer);
        compound.m_128379_("AIDisabledByVehicle", this.aiDisabledByVehicle);
        compound.m_128379_("RequiresSupply", this.requiresSupply());
        compound.m_128359_("AttackStrategy", this.attackStrategy.getId());
        if (this.hasIdleFacingDirection()) {
            compound.m_128379_("HasIdleFacing", true);
            compound.m_128350_("IdleFacingYaw", this.getIdleFacingYaw());
        }
        if (!this.m_9236_().f_46443_ && (server = this.m_9236_().m_7654_()) != null) {
            WorldTickCounter counter = WorldTickCounter.get(server);
            compound.m_128356_("UnloadWorldTicks", counter.getTotalWorldTicks());
        }
    }

    @Override
    public void m_7378_(CompoundTag compound) {
        AttributeInstance attackAttribute;
        AttributeInstance maxHealthAttribute;
        super.m_7378_(compound);
        if (compound.m_128441_("HomePosX") && compound.m_128441_("HomePosY") && compound.m_128441_("HomePosZ")) {
            int homeX = compound.m_128451_("HomePosX");
            int homeY = compound.m_128451_("HomePosY");
            int homeZ = compound.m_128451_("HomePosZ");
            this.setHomePosition(new BlockPos(homeX, homeY, homeZ));
        }
        if (compound.m_128403_("OwnerUUID")) {
            UUID ownerUUID = compound.m_128342_("OwnerUUID");
            this.f_19804_.m_135381_(OWNER_UUID, Optional.of(ownerUUID));
        } else {
            this.f_19804_.m_135381_(OWNER_UUID, Optional.empty());
        }
        if (compound.m_128441_("HomeReturnRadius")) {
            this.setHomeReturnRadius(compound.m_128459_("HomeReturnRadius"));
        }
        int[] patrolList = compound.m_128465_("PatrolPoints");
        this.patrolPoints.clear();
        for (int i = 0; i < patrolList.length; i += 3) {
            BlockPos pos = new BlockPos(patrolList[i], patrolList[i + 1], patrolList[i + 2]);
            this.patrolPoints.add(pos);
        }
        if (compound.m_128403_("FollowTargetUUID")) {
            this.followTargetUUID = compound.m_128342_("FollowTargetUUID");
        }
        if (compound.m_128441_("ExperiencePoints")) {
            this.setExperiencePoints(compound.m_128451_("ExperiencePoints"));
        }
        if (compound.m_128441_("Level")) {
            this.setLevel(compound.m_128451_("Level"));
        }
        if (compound.m_128441_("MaxHealth") && (maxHealthAttribute = this.m_21051_(Attributes.f_22276_)) != null) {
            maxHealthAttribute.m_22100_(compound.m_128459_("MaxHealth"));
        }
        if (compound.m_128441_("Health")) {
            this.m_21153_((float)compound.m_128459_("Health"));
        }
        if (compound.m_128441_("AttackDamage") && (attackAttribute = this.m_21051_(Attributes.f_22281_)) != null) {
            attackAttribute.m_22100_(compound.m_128459_("AttackDamage"));
        }
        if (compound.m_128441_("Skin")) {
            this.setCurrentSkinIndex(compound.m_128451_("Skin"));
        }
        if (compound.m_128441_("EquipmentLevel")) {
            this.setEquipmentLevel(compound.m_128451_("EquipmentLevel"));
        }
        if (compound.m_128441_("CommandHold")) {
            this.commandHold = compound.m_128471_("CommandHold");
        }
        if (compound.m_128441_("KillCount")) {
            this.setKillCount(compound.m_128451_("KillCount"));
        }
        if (compound.m_128441_("SummonWeaknessTimer")) {
            this.summonWeaknessTimer = compound.m_128451_("SummonWeaknessTimer");
        }
        if (compound.m_128441_("AIDisabledByVehicle")) {
            this.aiDisabledByVehicle = compound.m_128471_("AIDisabledByVehicle");
        }
        if (compound.m_128441_("AttackStrategy")) {
            this.setAttackStrategy(AttackStrategy.fromId(compound.m_128461_("AttackStrategy")));
        }
        if (compound.m_128441_("RequiresSupply")) {
            this.setRequiresSupply(compound.m_128471_("RequiresSupply"));
        }
        if (compound.m_128441_("HasIdleFacing")) {
            boolean hasFacing = compound.m_128471_("HasIdleFacing");
            if (hasFacing) {
                float yaw = compound.m_128441_("IdleFacingYaw") ? compound.m_128457_("IdleFacingYaw") : this.m_146908_();
                this.setIdleFacingDirection(yaw);
            } else {
                this.clearIdleFacingDirection();
            }
        }
        if (!this.m_9236_().f_46443_ && compound.m_128441_("UnloadWorldTicks")) {
            this.unloadTime = compound.m_128454_("UnloadWorldTicks");
            this.handleTimeBasedRecovery(compound);
        }
    }

    public void m_8119_() {
        Entity entity2;
        MinecraftServer server;
        UnloadPassengerable unloadPassengerable;
        BaseCombatEntity targetPos2;
        double horizontalDistanceSq;
        double dz;
        PositionAttackable positionAttackable;
        BaseCombatEntity currentShouldRender2;
        super.m_8119_();
        if (!this.m_9236_().f_46443_) {
            AttributeInstance speedAttr;
            Level level;
            if (this.requiresSupply() && (level = this.m_9236_()) instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                SupplyManager.tryEstablishSupply(this, (Level)serverLevel);
            }
            if (this instanceof HorseRider) {
                this.syncHealthToHorse();
            }
            if (!(this instanceof IPuppet)) {
                if (this.summonWeaknessTimer > 0) {
                    --this.summonWeaknessTimer;
                }
                this.manageWeaknessRangedDamageModifier();
            }
            if ((speedAttr = this.m_21051_(Attributes.f_22279_)) == null) {
                return;
            }
            boolean inWater = this.m_20069_();
            AttributeModifier waterBoost = speedAttr.m_22111_(WATER_SPEED_MODIFIER_UUID);
            if (inWater) {
                if (waterBoost == null) {
                    speedAttr.m_22118_(new AttributeModifier(WATER_SPEED_MODIFIER_UUID, "In water speed boost", 1.0, AttributeModifier.Operation.MULTIPLY_TOTAL));
                }
            } else if (waterBoost != null) {
                speedAttr.m_22120_(WATER_SPEED_MODIFIER_UUID);
            }
            this.manageRangedUsingItemSpeedModifier();
            if (this instanceof SiegeUnit) {
                this.handleSiegeTreeFelling();
            }
        }
        if (!this.m_9236_().f_46443_) {
            this.setHasTarget(this.getHywTarget() != null);
            this.checkAndUpdateTarget();
        }
        if (this.m_9236_().f_46443_) {
            this.updateAnimationState();
            if (this.m_20184_().m_165925_() < 1.0E-6) {
                this.moveAnimationState.m_216973_();
            }
        }
        if (!this.m_9236_().f_46443_) {
            this.setHolding(this.commandHold());
        }
        if (!this.m_9236_().f_46443_ && this.shouldExecuteNext) {
            this.executeNextGoal();
            this.shouldExecuteNext = false;
        }
        if (!this.m_9236_().f_46443_) {
            boolean currentlyInInternalSeat = this.isInInternalSeat();
            boolean currentShouldRender2 = this.getShouldRender();
            if (currentShouldRender2 && currentlyInInternalSeat) {
                this.setShouldRender(false);
                this.renderRestoreTimer = 0;
            } else if (!currentShouldRender2 && !currentlyInInternalSeat) {
                ++this.renderRestoreTimer;
                if (this.renderRestoreTimer >= 10) {
                    this.setShouldRender(true);
                    this.renderRestoreTimer = 0;
                }
            } else if (!currentShouldRender2 && currentlyInInternalSeat) {
                this.renderRestoreTimer = 0;
            }
            this.manageAIState();
        }
        if (!this.m_9236_().f_46443_ && !(this instanceof IPuppet)) {
            if (this.healCooldown > 0) {
                --this.healCooldown;
            } else {
                if (this.m_21223_() < this.m_21233_()) {
                    this.m_5634_(1.0f);
                }
                this.healCooldown = 1200;
            }
        }
        if (!this.m_9236_().f_46443_ && (currentShouldRender2 = this) instanceof PositionAttackable && (positionAttackable = (PositionAttackable)((Object)currentShouldRender2)).hasPositionTarget()) {
            Vec3 targetPos2 = positionAttackable.getPositionTarget();
            double dx = targetPos2.f_82479_ - this.m_20185_();
            dz = targetPos2.f_82481_ - this.m_20189_();
            horizontalDistanceSq = dx * dx + dz * dz;
            double attackReachSq = this.getAttackReach() * this.getAttackReach();
            if (this.goalQueue.isEmpty() && !this.commandHold) {
                if (horizontalDistanceSq >= attackReachSq) {
                    if (this.getHomePosition() != null) {
                        this.setHomePosition(null);
                    }
                    this.m_21573_().m_26519_(targetPos2.f_82479_, targetPos2.f_82480_, targetPos2.f_82481_, 1.0);
                } else if (this.m_21573_().m_26572_()) {
                    this.m_21573_().m_26573_();
                }
            } else if (!this.goalQueue.isEmpty() && this.m_21573_().m_26572_() && this.m_21573_().m_26567_() != null && this.m_21573_().m_26567_().equals((Object)new BlockPos((int)targetPos2.f_82479_, (int)targetPos2.f_82480_, (int)targetPos2.f_82481_))) {
                this.m_21573_().m_26573_();
            }
        }
        if (!this.m_9236_().f_46443_ && (targetPos2 = this) instanceof UnloadPassengerable && (unloadPassengerable = (UnloadPassengerable)((Object)targetPos2)).hasUnloadTarget()) {
            targetPos2 = unloadPassengerable.getUnloadTarget();
            double dx = ((Vec3)targetPos2).f_82479_ - this.m_20185_();
            dz = ((Vec3)targetPos2).f_82481_ - this.m_20189_();
            horizontalDistanceSq = dx * dx + dz * dz;
            double unloadRangeSq = unloadPassengerable.getMaxUnloadDistance() * unloadPassengerable.getMaxUnloadDistance();
            if (this.goalQueue.isEmpty() && !this.commandHold) {
                if (horizontalDistanceSq >= unloadRangeSq) {
                    if (this.getHomePosition() != null) {
                        this.setHomePosition(null);
                    }
                    this.m_21573_().m_26519_(((Vec3)targetPos2).f_82479_, ((Vec3)targetPos2).f_82480_, ((Vec3)targetPos2).f_82481_, 1.0);
                } else if (this.m_21573_().m_26572_()) {
                    this.m_21573_().m_26573_();
                }
            } else if (!this.goalQueue.isEmpty() && this.m_21573_().m_26572_() && this.m_21573_().m_26567_() != null && this.m_21573_().m_26567_().equals((Object)new BlockPos((int)((Vec3)targetPos2).f_82479_, (int)((Vec3)targetPos2).f_82480_, (int)((Vec3)targetPos2).f_82481_))) {
                this.m_21573_().m_26573_();
            }
        }
        if (!this.m_9236_().f_46443_ && this.followTargetUUID != null && this.followTarget == null && (server = this.m_9236_().m_7654_()) != null && (entity2 = server.m_129880_(this.m_9236_().m_46472_()).m_8791_(this.followTargetUUID)) instanceof LivingEntity) {
            this.followTarget = (LivingEntity)entity2;
        }
        if (!this.m_9236_().f_46443_ && this.attackCoolDown > 0) {
            --this.attackCoolDown;
        }
        if (!this.m_9236_().f_46443_) {
            if (this.getHywTarget() == null) {
                ++this.targetNullTicks;
                if (this.targetNullTicks >= 20 && this.getAttackAnimationTime() <= 0) {
                    this.setStartAttacking(false);
                    this.setAttacking(false);
                    this.m_5810_();
                    this.targetNullTicks = 0;
                }
            } else {
                this.targetNullTicks = 0;
            }
        }
        if (!(this.m_9236_().f_46443_ || this.getHywTarget() != null || this.m_5448_() == null || this.m_5448_() instanceof BaseCombatEntity && !ServerRelationHelper.isEnemyRelation((Entity)this, (Entity)this.m_5448_()))) {
            this.setHywTarget(this.m_5448_());
        }
        if (!this.m_9236_().f_46443_) {
            double desiredDistance = this.getDesiredDistance();
            List nearbyEntities = this.m_9236_().m_6443_(BaseCombatEntity.class, this.m_20191_().m_82400_(desiredDistance), entity -> entity != this);
            Vec3 repulsion = Vec3.f_82478_;
            for (BaseCombatEntity otherEntity : nearbyEntities) {
                List overlappingEntities;
                BaseCombatEntity otherTarget;
                BaseCombatEntity selfCombat = this;
                BaseCombatEntity otherCombat = otherEntity;
                BaseCombatEntity selfTarget = this.m_20159_() ? this.m_20202_() : this;
                BaseCombatEntity baseCombatEntity = otherTarget = otherCombat.m_20159_() ? otherCombat.m_20202_() : otherCombat;
                if (selfCombat instanceof BaseWorkerEntity && otherCombat instanceof BaseWorkerEntity || selfCombat.m_20202_() instanceof MultiSeatVehicle || otherCombat.m_20202_() instanceof MultiSeatVehicle || selfCombat.m_6147_() || otherCombat.m_6147_() || selfTarget == null || otherTarget == null || selfTarget == otherTarget || otherTarget == this.m_20202_() || selfTarget == otherEntity.m_20202_() || this.m_20197_().contains(otherEntity) || otherEntity.m_20197_().contains(this) || selfTarget instanceof SiegeUnit && !(otherTarget instanceof SiegeUnit) && !ServerRelationHelper.isEnemyRelation((Entity)selfTarget, (Entity)otherTarget)) continue;
                if (otherTarget instanceof SiegeUnit && !ServerRelationHelper.isEnemyRelation((Entity)selfTarget, (Entity)otherTarget)) {
                    desiredDistance *= 2.0;
                }
                if (!this.getWithinPushRange() && !ServerRelationHelper.isEnemyRelation((Entity)selfCombat, (Entity)otherCombat) && (selfCombat.m_21573_().m_26572_() || otherCombat.m_21573_().m_26572_()) && (overlappingEntities = ((EntityAccessor)((Object)selfCombat)).getLevel().m_45976_(BaseCombatEntity.class, selfCombat.m_20191_().m_82400_(0.5))).size() <= 10) continue;
                Vec3 difference = selfTarget.m_20182_().m_82546_(otherTarget.m_20182_());
                difference = new Vec3(difference.f_82479_, 0.0, difference.f_82481_);
                double distance = difference.m_82553_();
                if (!(distance < desiredDistance) || !(distance > 0.0)) continue;
                double strength = (desiredDistance - distance) / desiredDistance;
                strength = !selfCombat.m_21573_().m_26572_() && this.getHywTarget() != null ? (strength *= 0.2) : (!ServerRelationHelper.isEnemyRelation((Entity)selfCombat, (Entity)otherCombat) ? (this.getWithinPushRange() ? (strength *= 3.0) : (strength *= 1.0)) : (this.m_20202_() instanceof AbstractHorse ? (strength *= 2.0) : (strength *= 5.0)));
                if (selfCombat instanceof SiegeUnit && !(otherCombat instanceof SiegeUnit)) {
                    strength *= 0.01;
                }
                Vec3 repulsionVector = difference.m_82541_().m_82490_(strength * 0.1);
                repulsion = repulsion.m_82549_(repulsionVector);
            }
            if (!repulsion.equals((Object)Vec3.f_82478_)) {
                BaseCombatEntity targetToMove;
                BaseCombatEntity baseCombatEntity = targetToMove = this.m_20159_() ? this.m_20202_() : this;
                if (targetToMove != null) {
                    targetToMove.m_20256_(targetToMove.m_20184_().m_82549_(repulsion));
                }
            }
        }
        if (!(!this.m_9236_().f_46443_ || this.m_20202_() == null || this instanceof RangedAttackMob && this.getHasTarget())) {
            this.f_20885_ = this.m_20202_().m_146908_();
        }
        if (!this.m_9236_().f_46443_ && this.f_19797_ % 2 == 0) {
            this.handleAttackLogic();
        }
        this.manageRotation();
    }

    private void handleAttackLogic() {
        PositionAttackable positionAttackable;
        BaseCombatEntity baseCombatEntity = this;
        if (baseCombatEntity instanceof PositionAttackable && (positionAttackable = (PositionAttackable)((Object)baseCombatEntity)).hasPositionTarget()) {
            Vec3 targetPos = positionAttackable.getPositionTarget();
            double attackReachSq = this.getAttackReach() * this.getAttackReach();
            double positionDistanceSq = this.m_20275_(targetPos.f_82479_, this.m_20186_(), targetPos.f_82481_);
            boolean withinPositionRange = positionDistanceSq <= attackReachSq;
            LivingEntity target = this.getHywTarget();
            if (!(target == null || target.m_6084_() && this.isValidTarget(target))) {
                target = null;
                this.setHywTarget(null);
            }
            boolean withinEntityRange = false;
            if (target != null) {
                double entityDistanceSq = this.m_20275_(target.m_20185_(), target.m_20186_(), target.m_20189_());
                boolean bl = this.usingBetterCombat() ? BetterMobCombatIntegration.isWithinBetterCombatRange(this, target) : (withinEntityRange = entityDistanceSq <= attackReachSq);
            }
            if (this.isAttacking() && this.getAttackAnimationTime() > 0) {
                if (withinEntityRange) {
                    this.handleAttackAnimation();
                } else {
                    this.handlePositionAttackAnimation(targetPos);
                }
            } else if (this.getAttackCoolDown() == 0) {
                if (withinEntityRange) {
                    this.startNewAttackCycle();
                } else if (withinPositionRange) {
                    this.startNewAttackCycleForPosition(targetPos);
                }
            }
            return;
        }
        LivingEntity target = this.getHywTarget();
        if (target == null || !target.m_6084_() || !this.m_6084_()) {
            if (this.getAttackAnimationTime() > 0) {
                this.setAttackAnimationTime(this.getAttackAnimationTime() - 1);
            }
        } else {
            boolean withinAttackRange;
            double distanceSq = this.m_20275_(target.m_20185_(), target.m_20186_(), target.m_20189_());
            boolean bl = this.usingBetterCombat() ? BetterMobCombatIntegration.isWithinBetterCombatRange(this, target) : (withinAttackRange = distanceSq <= (double)(this.getAttackReach() * this.getAttackReach()));
            if (this.isAttacking() && this.getAttackAnimationTime() > 0) {
                this.handleAttackAnimation();
            } else if (withinAttackRange && this.getAttackCoolDown() == 0) {
                this.startNewAttackCycle();
            }
            if (this instanceof UseShield) {
                if (this.getShieldCoolDown() > 0) {
                    this.coolDown();
                } else {
                    ItemStack offhandItem = this.m_6844_(EquipmentSlot.OFFHAND);
                    if (WeaponTypeHelper.isShieldLikeItem(offhandItem) && (!BetterMobCombatIntegration.isActivated() || this.m_21223_() < this.m_21233_() * 0.5f)) {
                        this.m_6672_(InteractionHand.OFF_HAND);
                    }
                }
            }
        }
    }

    private void handlePositionAttackAnimation(Vec3 targetPos) {
        this.m_21573_().m_26573_();
        this.m_21563_().m_24950_(targetPos.f_82479_, targetPos.f_82480_, targetPos.f_82481_, 30.0f, 30.0f);
        this.setAttackAnimationTime(this.getAttackAnimationTime() - 1);
        this.setAttackDamageTick(this.getAttackDamageTick() - 1);
        if (this.getAttackDamageTick() == 0) {
            BaseCombatEntity baseCombatEntity = this;
            if (baseCombatEntity instanceof PositionAttackable) {
                PositionAttackable positionAttackable = (PositionAttackable)((Object)baseCombatEntity);
                positionAttackable.performPositionAttack(targetPos, 1.0f);
            }
            this.setAttackDamageTick(-1);
        }
        if (this.getAttackAnimationTime() == 0) {
            this.resetAttackCycle();
            this.startTarget = null;
        }
    }

    private void startNewAttackCycleForPosition(Vec3 targetPos) {
        PositionAttackable positionAttackable;
        BaseCombatEntity baseCombatEntity = this;
        if (baseCombatEntity instanceof PositionAttackable && !(positionAttackable = (PositionAttackable)((Object)baseCombatEntity)).canFireAtPosition(targetPos)) {
            return;
        }
        this.setAttacking(true);
        this.setStartAttacking(true);
        this.setAttackAnimationTime(this.getBaseAttackAnimationTime());
        this.setAttackDamageTick(this.getAttackDamageTickDelay());
        this.setAttackCoolDown(this.getAttackCoolDownDuration() + this.getBaseAttackAnimationTime());
        if (this instanceof RangedAttackMob) {
            InteractionHand hand;
            ItemStack itemStack;
            MeleeCapableRangedAttacker meleeCapable;
            baseCombatEntity = this;
            if (baseCombatEntity instanceof MeleeCapableRangedAttacker && !(meleeCapable = (MeleeCapableRangedAttacker)((Object)baseCombatEntity)).isUsingRanged()) {
                return;
            }
            if ((this instanceof ArcherEntity || this instanceof HywSkeletonArcherEntity) && ((itemStack = this.m_21120_(hand = InteractionHand.MAIN_HAND)).m_150930_(Items.f_42411_) || WeaponTypeHelper.isBowLikeWeapon(itemStack))) {
                this.m_6672_(hand);
            }
            if (this instanceof UseCrossbow && ((itemStack = this.m_21120_(hand = InteractionHand.MAIN_HAND)).m_150930_(Items.f_42717_) || WeaponTypeHelper.isCrossbowLikeWeapon(itemStack))) {
                this.m_6672_(hand);
            }
        }
    }

    private void handleAttackAnimation() {
        LivingEntity target = this.getHywTarget();
        this.m_21563_().m_24960_((Entity)target, 30.0f, 30.0f);
        if (this instanceof RangedAttackMob && !this.shouldMoveOnly()) {
            this.m_21573_().m_26573_();
        }
        this.setAttackAnimationTime(this.getAttackAnimationTime() - 1);
        this.setAttackDamageTick(this.getAttackDamageTick() - 1);
        if (this.getAttackDamageTick() == 0) {
            BaseCombatEntity baseCombatEntity;
            if (this instanceof RangedAttackMob && (baseCombatEntity = this) instanceof MeleeCapableRangedAttacker) {
                MeleeCapableRangedAttacker meleeCapable = (MeleeCapableRangedAttacker)((Object)baseCombatEntity);
                if (meleeCapable.isUsingRanged()) {
                    ((RangedAttackMob)this).m_6504_(target, 1.0f);
                } else {
                    float meleeReach;
                    boolean withinAttackRange;
                    double distanceSq = this.m_20275_(target.m_20185_(), target.m_20186_(), target.m_20189_());
                    boolean bl = withinAttackRange = distanceSq <= (double)((meleeReach = meleeCapable.getMeleeAttackReach()) * meleeReach);
                    if ((target == this.startTarget || withinAttackRange) && !this.usingBetterCombat()) {
                        this.m_21011_(InteractionHand.MAIN_HAND, true);
                        this.m_7327_((Entity)target);
                        ++this.comboCount;
                    }
                }
            } else {
                BaseCombatEntity distanceSq = this;
                if (distanceSq instanceof RangedAttackMob) {
                    RangedAttackMob rangedAttackMob = (RangedAttackMob)distanceSq;
                    rangedAttackMob.m_6504_(target, 1.0f);
                } else {
                    float attackReach;
                    boolean withinAttackRange;
                    double distanceSq2 = this.m_20275_(target.m_20185_(), target.m_20186_(), target.m_20189_());
                    boolean bl = withinAttackRange = distanceSq2 <= (double)((attackReach = (float)this.m_21133_((Attribute)HywAttributes.ATTACK_REACH.get())) * attackReach);
                    if ((target == this.startTarget || withinAttackRange) && !this.usingBetterCombat()) {
                        this.m_21011_(InteractionHand.MAIN_HAND, true);
                        this.m_7327_((Entity)target);
                        ++this.comboCount;
                    }
                }
            }
            this.setAttackDamageTick(-1);
        }
        if (this.getAttackAnimationTime() == 0) {
            this.resetAttackCycle();
            this.startTarget = null;
        }
    }

    public boolean usingBetterCombat() {
        MeleeCapableRangedAttacker meleeCapable;
        BaseCombatEntity baseCombatEntity;
        if (!BetterMobCombatIntegration.isActivated() || !this.allowBetterCombatAttack()) {
            return false;
        }
        boolean isMeleeUnit = !(this instanceof RangedAttackMob) || (baseCombatEntity = this) instanceof MeleeCapableRangedAttacker && !(meleeCapable = (MeleeCapableRangedAttacker)((Object)baseCombatEntity)).isUsingRanged();
        boolean canUse = !this.m_6117_() && BetterMobCombatIntegration.isBetterCombatWeapon(this.m_21205_());
        return isMeleeUnit && canUse;
    }

    private void startNewAttackCycle() {
        LivingEntity target = this.getHywTarget();
        if (!this.canFireAtTarget(target)) {
            return;
        }
        this.startTarget = target;
        this.setAttacking(true);
        this.setStartAttacking(true);
        this.setAttackAnimationTime(this.getBaseAttackAnimationTime());
        this.setAttackDamageTick(this.getAttackDamageTickDelay());
        this.setAttackCoolDown(this.getAttackCoolDownDuration() + this.getBaseAttackAnimationTime());
        if (this.usingBetterCombat()) {
            try {
                if (BetterMobCombatIntegration.performBetterMobCombatAttack(this, target)) {
                    return;
                }
            }
            catch (Exception e) {
                System.out.println("[HundredYearsWar] Better Mob Combat attack failed for " + this + ", falling back to vanilla attack: " + e.getMessage());
            }
        }
        if (this instanceof RangedAttackMob) {
            InteractionHand hand;
            ItemStack itemStack;
            MeleeCapableRangedAttacker meleeCapable;
            BaseCombatEntity baseCombatEntity = this;
            if (baseCombatEntity instanceof MeleeCapableRangedAttacker && !(meleeCapable = (MeleeCapableRangedAttacker)((Object)baseCombatEntity)).isUsingRanged()) {
                return;
            }
            if ((this instanceof ArcherEntity || this instanceof HywSkeletonArcherEntity) && ((itemStack = this.m_21120_(hand = InteractionHand.MAIN_HAND)).m_150930_(Items.f_42411_) || itemStack.m_41720_() instanceof BowItem)) {
                this.m_6672_(hand);
            }
            if (this instanceof UseCrossbow) {
                hand = InteractionHand.MAIN_HAND;
                this.m_6672_(hand);
            }
        }
    }

    private void resetAttackCycle() {
        this.setAttacking(false);
        this.setStartAttacking(false);
        this.setAttackCoolDown(this.getAttackCoolDownDuration());
        if (!BetterMobCombatIntegration.isActivated() || !BetterMobCombatIntegration.isBetterCombatWeapon(this.m_21205_())) {
            this.comboCount = 0;
        }
    }

    protected void updateAnimationState() {
        if (this.getStartAttacking()) {
            if (!this.attackAnimationState.m_216984_()) {
                this.moveAnimationState.m_216973_();
                this.idleAnimationState.m_216973_();
                this.attackAnimationState.m_216977_(this.f_19797_);
            }
        } else if (this.m_20184_().m_165925_() < 1.0E-6) {
            this.moveAnimationState.m_216973_();
            this.attackAnimationState.m_216973_();
            if (!this.idleAnimationState.m_216984_()) {
                this.idleAnimationState.m_216977_(this.f_19797_);
            }
        } else {
            this.attackAnimationState.m_216973_();
            this.idleAnimationState.m_216973_();
            if (!this.moveAnimationState.m_216984_()) {
                this.moveAnimationState.m_216977_(this.f_19797_);
            }
        }
    }

    public int getBaseAttackAnimationTime() {
        return 0;
    }

    public int getAttackDamageTickDelay() {
        return 0;
    }

    public int getAttackCoolDownDuration() {
        return 0;
    }

    public float getAttackReach() {
        AttributeInstance attackReachAttr = this.m_21051_((Attribute)HywAttributes.ATTACK_REACH.get());
        return attackReachAttr != null ? (float)attackReachAttr.m_22135_() : 3.0f;
    }

    private void manageWeaknessRangedDamageModifier() {
        boolean hasModifier;
        if (!ServerModConfig.INSTANCE.isEnableRecruitBalance()) {
            return;
        }
        AttributeInstance rangedDamageAttr = this.m_21051_((Attribute)HywAttributes.RANGED_ATTACK_DAMAGE.get());
        if (rangedDamageAttr == null) {
            return;
        }
        boolean hasWeakness = this.m_21023_(MobEffects.f_19613_);
        boolean bl = hasModifier = rangedDamageAttr.m_22111_(WEAKNESS_RANGED_DAMAGE_MODIFIER_UUID) != null;
        if (hasWeakness && !hasModifier) {
            int weaknessLevel = this.m_21124_(MobEffects.f_19613_).m_19564_() + 1;
            double damageMultiplier = this.summonWeaknessTimer > 0 ? RecruitBalanceConfig.getWeaknessRangedDamageMultiplier(weaknessLevel) : Math.pow(0.8, weaknessLevel);
            double reductionPercentage = 1.0 - damageMultiplier;
            AttributeModifier weaknessModifier = new AttributeModifier(WEAKNESS_RANGED_DAMAGE_MODIFIER_UUID, "Weakness ranged damage reduction", -reductionPercentage, AttributeModifier.Operation.MULTIPLY_TOTAL);
            rangedDamageAttr.m_22125_(weaknessModifier);
        } else if (!hasWeakness && hasModifier) {
            rangedDamageAttr.m_22120_(WEAKNESS_RANGED_DAMAGE_MODIFIER_UUID);
        } else if (hasWeakness && hasModifier) {
            int currentWeaknessLevel = this.m_21124_(MobEffects.f_19613_).m_19564_() + 1;
            AttributeModifier currentModifier = rangedDamageAttr.m_22111_(WEAKNESS_RANGED_DAMAGE_MODIFIER_UUID);
            double expectedMultiplier = this.summonWeaknessTimer > 0 ? RecruitBalanceConfig.getWeaknessRangedDamageMultiplier(currentWeaknessLevel) : Math.pow(0.5, currentWeaknessLevel);
            double expectedReduction = 1.0 - expectedMultiplier;
            if (currentModifier != null && Math.abs(currentModifier.m_22218_() + expectedReduction) > 0.001) {
                rangedDamageAttr.m_22120_(WEAKNESS_RANGED_DAMAGE_MODIFIER_UUID);
                AttributeModifier newWeaknessModifier = new AttributeModifier(WEAKNESS_RANGED_DAMAGE_MODIFIER_UUID, "Weakness ranged damage reduction", -expectedReduction, AttributeModifier.Operation.MULTIPLY_TOTAL);
                rangedDamageAttr.m_22125_(newWeaknessModifier);
            }
        }
    }

    private void manageRangedUsingItemSpeedModifier() {
        boolean hasModifier;
        AttributeInstance speedAttr = this.m_21051_(Attributes.f_22279_);
        if (speedAttr == null) {
            return;
        }
        boolean shouldApplySlowdown = this instanceof RangedAttackMob && !this.m_20159_() && this.m_6117_();
        AttributeModifier currentModifier = speedAttr.m_22111_(RANGED_USING_ITEM_SPEED_MODIFIER_UUID);
        boolean bl = hasModifier = currentModifier != null;
        if (shouldApplySlowdown && !hasModifier) {
            AttributeModifier slowdownModifier = new AttributeModifier(RANGED_USING_ITEM_SPEED_MODIFIER_UUID, "Ranged using item speed reduction", -0.1, AttributeModifier.Operation.MULTIPLY_TOTAL);
            speedAttr.m_22118_(slowdownModifier);
        } else if (!shouldApplySlowdown && hasModifier) {
            speedAttr.m_22120_(RANGED_USING_ITEM_SPEED_MODIFIER_UUID);
        }
    }

    private void handleSiegeTreeFelling() {
        double distanceMoved;
        if (!ServerModConfig.INSTANCE.enableSiegeTreeFelling) {
            return;
        }
        if (this.treeFellingCooldown > 0) {
            --this.treeFellingCooldown;
            return;
        }
        Vec3 currentPosition = this.m_20182_();
        if (this.lastTreeFellingPosition != null && (distanceMoved = currentPosition.m_82554_(this.lastTreeFellingPosition)) < ServerModConfig.INSTANCE.siegeTreeFellingMoveThreshold) {
            return;
        }
        int felledTreeCount = TreeFellingHandler.getInstance().fellTreesAroundSiegeEntity(this.m_9236_(), (Entity)this);
        if (felledTreeCount > 0) {
            this.treeFellingCooldown = ServerModConfig.INSTANCE.siegeTreeFellingInterval;
            this.lastTreeFellingPosition = currentPosition;
        } else {
            this.treeFellingCooldown = ServerModConfig.INSTANCE.siegeTreeFellingInterval / 2;
        }
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new OpenDoorGoal((Mob)this, true));
        this.f_21345_.m_25352_(1, (Goal)new FollowEntityGoal(this, 1.0, ServerModConfig.INSTANCE.getFollowDistanceInner(), ServerModConfig.INSTANCE.getFollowDistanceOuter(), 25.0, 50.0));
        this.f_21345_.m_25352_(2, (Goal)new BaseCombatEntityAttackGoal(this, 1.0));
        this.f_21345_.m_25352_(3, (Goal)new PatrolGoal(this, 1.0, 40));
        this.f_21345_.m_25352_(3, (Goal)new FollowEntityGoal(this, 1.0, ServerModConfig.INSTANCE.getFollowDistanceInner(), ServerModConfig.INSTANCE.getFollowDistanceInner(), Double.MAX_VALUE, 0.0));
        this.f_21345_.m_25352_(4, (Goal)new ReturnToHomeGoal(this, 1.0));
        this.addTargetSelector();
    }

    public void addTargetSelector() {
        Predicate<LivingEntity> unifiedPredicate = this::isValidTarget;
        this.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal((Mob)this, LivingEntity.class, 10, true, false, unifiedPredicate));
    }

    public boolean isValidTarget(LivingEntity potentialTarget) {
        LivingEntity owner;
        TamableAnimal tamable;
        MultiSeatVehicle multiSeatVehicle;
        if (potentialTarget == null) {
            return false;
        }
        if (TargetListManager.isInTargetBlacklist(potentialTarget)) {
            return false;
        }
        UUID ownerUUID = this.m_21805_();
        if (this.attackStrategy == AttackStrategy.CEASE_FIRE) {
            return false;
        }
        if (this.attackStrategy == AttackStrategy.INDISCRIMINATE) {
            if (!potentialTarget.m_6084_()) {
                return false;
            }
            if (this.hasSameOwner(ownerUUID, potentialTarget)) {
                return false;
            }
            LivingEntity controllingPassenger = this.getLivingControllingPassenger(potentialTarget);
            if (controllingPassenger != null && (this.hasSameOwner(ownerUUID, controllingPassenger) || this.isFriendlyOrControlled(controllingPassenger))) {
                return false;
            }
            return !this.isFriendlyOrControlled(potentialTarget);
        }
        if (ownerUUID != null && potentialTarget.m_20148_().equals(ownerUUID)) {
            return false;
        }
        Entity entity = potentialTarget.m_20202_();
        if (entity instanceof MultiSeatVehicle && (multiSeatVehicle = (MultiSeatVehicle)entity).getSeatForEntity((Entity)potentialTarget).map(seat -> seat.getType() == MultiSeatVehicle.SeatType.INTERNAL).orElse(false).booleanValue()) {
            return false;
        }
        if (potentialTarget instanceof TamableAnimal && (tamable = (TamableAnimal)potentialTarget).m_21824_() && (owner = tamable.m_269323_()) != null) {
            return ServerRelationHelper.isEnemyRelation((Entity)this, (Entity)owner);
        }
        if (potentialTarget instanceof Enemy) {
            if (this instanceof RangedAttackMob) {
                return !(potentialTarget instanceof EnderMan);
            }
            if (potentialTarget instanceof Creeper) {
                return ServerModConfig.INSTANCE.isAllowMeleeAttackCreeper();
            }
            return true;
        }
        if (TargetListManager.isInTargetList(potentialTarget)) {
            return true;
        }
        if (potentialTarget instanceof BaseCombatEntity || potentialTarget instanceof Player) {
            return ServerRelationHelper.isEnemyRelation((Entity)this, (Entity)potentialTarget);
        }
        return false;
    }

    protected void m_6728_(LivingEntity livingEntity) {
        if (livingEntity.m_213824_()) {
            this.disableShield(true);
        }
    }

    public void disableShield(boolean bl) {
        float f = 0.25f + (float)EnchantmentHelper.m_44926_((LivingEntity)this) * 0.05f;
        if (bl) {
            f += 0.75f;
        }
        if (this.random.nextFloat() < f) {
            this.shieldCoolDown += 100;
            this.m_5810_();
            this.m_9236_().m_7605_((Entity)this, (byte)30);
        }
    }

    private LivingEntity getLivingControllingPassenger(LivingEntity potentialTarget) {
        LivingEntity controllingPassenger = potentialTarget.m_6688_();
        if (controllingPassenger instanceof LivingEntity) {
            LivingEntity livingPassenger = controllingPassenger;
            return livingPassenger;
        }
        return null;
    }

    private boolean hasSameOwner(UUID ownerUUID, LivingEntity entity) {
        TamableAnimal tamable;
        BaseCombatSupport baseCombatSupport;
        UUID targetOwnerUUID;
        if (ownerUUID == null) {
            return false;
        }
        if (ownerUUID.equals(entity.m_20148_())) {
            return true;
        }
        if (entity instanceof BaseCombatSupport && ownerUUID.equals(targetOwnerUUID = (baseCombatSupport = (BaseCombatSupport)entity).m_21805_())) {
            return true;
        }
        return entity instanceof TamableAnimal && (tamable = (TamableAnimal)entity).m_21824_() && ownerUUID.equals(targetOwnerUUID = tamable.m_21805_());
    }

    private boolean isFriendlyOrControlled(LivingEntity potentialTarget) {
        return ServerRelationHelper.isFriendlyRelation((Entity)this, (Entity)potentialTarget) || ServerRelationHelper.isControlRelation((Entity)this, (Entity)potentialTarget);
    }

    public int getShieldCoolDown() {
        return this.shieldCoolDown;
    }

    public void coolDown() {
        --this.shieldCoolDown;
    }

    public Queue<PrioritizedGoal> getGoalQueue() {
        return this.goalQueue;
    }

    public void setGoalQueue(Queue<PrioritizedGoal> goalQueue) {
        this.goalQueue = goalQueue != null ? goalQueue : new LinkedList();
    }

    public List<BlockPos> getPatrolPoints() {
        return this.patrolPoints;
    }

    public void clearPatrolPoints() {
        this.patrolPoints.clear();
    }

    public LivingEntity getFollowTarget() {
        return this.followTarget;
    }

    public void setFollowTarget(LivingEntity followTarget) {
        this.followTarget = followTarget;
        if (followTarget == null) {
            this.followTargetUUID = null;
        }
    }

    public int getAttackCoolDown() {
        return this.attackCoolDown;
    }

    public void setAttackCoolDown(int attackCoolDown) {
        this.attackCoolDown = attackCoolDown;
    }

    protected String getEquipmentJsonPath() {
        ResourceLocation entityId = BuiltInRegistries.f_256780_.m_7981_((Object)this.m_6095_());
        if (entityId == null) {
            return null;
        }
        String entityName = entityId.m_135815_();
        String equipmentFile = ServerModConfig.getCurrentEquipmentFileName();
        return "hundred_years_war:hyw/npc/" + entityName + "/" + equipmentFile;
    }

    protected void loadEquipmentData() {
        this.equipmentData = null;
        String configResourcePath = this.getEquipmentJsonPath();
        if (configResourcePath == null) {
            return;
        }
        EquipmentData loaded = this.loadEquipmentData(configResourcePath);
        if (loaded == null && !ServerModConfig.getCurrentEquipmentFileName().equals("equipment.json")) {
            String fallbackPath = configResourcePath.replace(ServerModConfig.getCurrentEquipmentFileName(), "equipment.json");
            loaded = this.loadEquipmentData(fallbackPath);
        }
        this.equipmentData = loaded;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private EquipmentData loadEquipmentData(String namespacedPath) {
        String[] parts = namespacedPath.split(":");
        if (parts.length != 2) {
            return null;
        }
        String namespace = parts[0];
        String path = parts[1];
        String fullPath = "/assets/" + namespace + "/" + path;
        InputStream is = this.getClass().getResourceAsStream(fullPath);
        if (is == null) {
            return null;
        }
        try (InputStream inputStream = is;){
            EquipmentData equipmentData;
            try (InputStreamReader reader = new InputStreamReader(inputStream);){
                Gson gson = new Gson();
                equipmentData = (EquipmentData)gson.fromJson((Reader)reader, EquipmentData.class);
            }
            return equipmentData;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    protected EquipmentOption selectRandomItem(List<EquipmentOption> options) {
        if (options == null || options.isEmpty()) {
            return null;
        }
        double totalProbability = 0.0;
        for (EquipmentOption option : options) {
            totalProbability += option.getProbability();
        }
        double randomValue = this.random.nextDouble() * totalProbability;
        double cumulativeProbability = 0.0;
        for (EquipmentOption option : options) {
            if (!(randomValue <= (cumulativeProbability += option.getProbability()))) continue;
            return option;
        }
        return null;
    }

    protected ItemStack createItemStack(EquipmentOption option) {
        if (option == null || option.getItem() == null) {
            return ItemStack.f_41583_;
        }
        ResourceLocation itemId = new ResourceLocation(option.getItem());
        Item item = (Item)BuiltInRegistries.f_257033_.m_7745_(itemId);
        if (item == Items.f_41852_) {
            System.err.println("missing\uff1a" + option.getItem());
            return ItemStack.f_41583_;
        }
        ItemStack itemStack = new ItemStack((ItemLike)item);
        if (option.getEnchantments() != null) {
            for (EnchantmentData enchantmentData : option.getEnchantments()) {
                ResourceLocation enchantmentId = new ResourceLocation(enchantmentData.getEnchantment());
                Enchantment enchantment = (Enchantment)BuiltInRegistries.f_256876_.m_7745_(enchantmentId);
                if (enchantment != null) {
                    itemStack.m_41663_(enchantment, enchantmentData.getLevel());
                    continue;
                }
                System.err.println("missing\uff1a" + enchantmentData.getEnchantment());
            }
        }
        return itemStack;
    }

    @Override
    public void setEquipment(int level) {
        this.loadEquipmentData();
        if (this.equipmentData != null) {
            EquipmentLevelData levelData = this.equipmentData.getLevels().get(String.valueOf(level));
            if (levelData == null) {
                this.setDefaultEquipment();
                return;
            }
            this.setEquipmentFromLevelData(levelData);
            this.setEquipmentLevel(level);
        } else {
            this.setDefaultEquipment();
        }
    }

    protected void setEquipmentFromLevelData(EquipmentLevelData levelData) {
        EquipmentSlot[] equipmentSlots = new EquipmentSlot[]{EquipmentSlot.MAINHAND, EquipmentSlot.OFFHAND, EquipmentSlot.HEAD, EquipmentSlot.CHEST, EquipmentSlot.LEGS, EquipmentSlot.FEET};
        List<List> optionsList = Arrays.asList(levelData.getMainHand(), levelData.getOffHand(), levelData.getHead(), levelData.getChest(), levelData.getLegs(), levelData.getFeet());
        for (int i = 0; i < equipmentSlots.length; ++i) {
            EquipmentSlot slot = equipmentSlots[i];
            List options = optionsList.get(i);
            EquipmentOption option = this.selectRandomItem(options);
            ItemStack itemStack = this.createItemStack(option);
            this.m_8061_(slot, itemStack);
        }
    }

    @Override
    public Item getScrollType() {
        return null;
    }

    @NotNull
    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        if (!this.m_9236_().f_46443_) {
            long currentTime = System.currentTimeMillis();
            if (currentTime - this.lastInteractionTime < 500L) {
                return InteractionResult.SUCCESS;
            }
            this.lastInteractionTime = currentTime;
            if (player.m_6144_() && ServerRelationHelper.hasControlOver(player, (Entity)this)) {
                if (this.getScrollType() != null) {
                    boolean canRecall = false;
                    canRecall = player.m_7500_() ? CreativeModeSettings.canControlAllUnits(player) : (this instanceof SiegeUnit ? ServerModConfig.INSTANCE.isAllowSiegeRecall() : ServerModConfig.INSTANCE.isAllowSoldierRecall());
                    if (canRecall) {
                        ItemStack stack = new ItemStack((ItemLike)this.getScrollType());
                        CompoundTag entityData = new CompoundTag();
                        this.m_20240_(entityData);
                        ((BaseScrollItem)stack.m_41720_()).saveEntityDataToItem(stack, entityData);
                        if (!player.m_150109_().m_36054_(stack)) {
                            player.m_36176_(stack, false);
                        }
                        this.spawnParticles(this.m_9236_(), this.m_20185_(), this.m_20186_(), this.m_20189_());
                        this.m_146870_();
                    }
                }
                return InteractionResult.SUCCESS;
            }
            if (ServerRelationHelper.hasControlOver(player, (Entity)this) && !(player.m_21120_(hand).m_41720_() instanceof BaseScrollItem) && !(this instanceof MultiSeatVehicle)) {
                BaseCombatEntity vehicle;
                Entity entity;
                BaseCombatEntity target = this.m_20202_() != null && (entity = this.m_20202_()) instanceof BaseCombatEntity ? (vehicle = (BaseCombatEntity)entity) : this;
                if (target.getFollowTarget() == null) {
                    target.setFollowTarget((LivingEntity)player);
                    if (player instanceof ServerPlayer) {
                        serverPlayer = (ServerPlayer)player;
                        serverPlayer.m_5661_((Component)Component.m_237115_((String)"message.hundred_years_war.following").m_130940_(ChatFormatting.GREEN), true);
                    }
                } else {
                    target.setFollowTarget(null);
                    target.setHomePosition(target.m_20183_());
                    if (player instanceof ServerPlayer) {
                        serverPlayer = (ServerPlayer)player;
                        serverPlayer.m_5661_((Component)Component.m_237115_((String)"message.hundred_years_war.stop_following").m_130940_(ChatFormatting.RED), true);
                    }
                }
                return InteractionResult.SUCCESS;
            }
        }
        return super.m_6071_(player, hand);
    }

    public boolean m_6469_(DamageSource source, float amount) {
        Projectile projectile;
        Object attackerMeleeCapable;
        MeleeCapableRangedAttacker meleeCapable;
        BaseCombatEntity canEquip2;
        Projectile projectile2;
        Projectile projectile3;
        Player player;
        EquipmentSlot[] livingEntity;
        MultiSeatVehicle multiSeatVehicle;
        Entity vehicle = this.m_20202_();
        if (vehicle instanceof MultiSeatVehicle && (multiSeatVehicle = (MultiSeatVehicle)vehicle).getSeatForEntity((Entity)this).map(seat -> seat.getType() == MultiSeatVehicle.SeatType.INTERNAL).orElse(false).booleanValue()) {
            return false;
        }
        if (this.m_9236_().f_46443_) {
            return super.m_6469_(source, amount);
        }
        if (this instanceof UseShield) {
            boolean usingShield;
            ItemStack offhandItem = this.m_6844_(EquipmentSlot.OFFHAND);
            boolean bl = usingShield = WeaponTypeHelper.isShieldLikeItem(offhandItem) && this.m_6117_();
            if (usingShield) {
                Entity direct;
                if (this.shieldBlockRandom.nextInt(100) < 50) {
                    amount *= 0.2f;
                    this.m_5496_(SoundEvents.f_12346_, this.m_6121_(), this.m_6100_());
                }
                if ((direct = source.m_7640_()) instanceof LivingEntity) {
                    livingEntity = (EquipmentSlot[])direct;
                    this.m_6728_((LivingEntity)livingEntity);
                }
            }
        }
        if (this instanceof IPuppet || source.m_7639_() instanceof IPuppet) {
            return super.m_6469_(source, amount);
        }
        Entity usingShield = source.m_7639_();
        if (usingShield instanceof Player && (player = (Player)usingShield).m_6144_() && ServerRelationHelper.hasControlOver(player, (Entity)this) && ServerModConfig.INSTANCE.isAllowEquipmentChange() && this.allowEquipmentReplacement()) {
            boolean canEquip2;
            ArmorItem armorItem;
            EquipmentSlot slotForArmor;
            ItemStack entityArmorItem;
            ItemStack playerItem = player.m_21120_(InteractionHand.MAIN_HAND);
            if (playerItem.m_41619_()) {
                EquipmentSlot[] armorSlots;
                livingEntity = armorSlots = new EquipmentSlot[]{EquipmentSlot.HEAD, EquipmentSlot.CHEST, EquipmentSlot.LEGS, EquipmentSlot.FEET};
                int n = livingEntity.length;
                for (int i = 0; i < n; ++i) {
                    EquipmentSlot slot = livingEntity[i];
                    ItemStack armorItem2 = this.m_6844_(slot);
                    if (armorItem2.m_41619_()) continue;
                    this.m_19983_(armorItem2);
                    this.m_8061_(slot, ItemStack.f_41583_);
                    return false;
                }
            }
            if ((livingEntity = playerItem.m_41720_()) instanceof ArmorItem && (entityArmorItem = this.m_6844_(slotForArmor = (armorItem = (ArmorItem)livingEntity).m_40402_())).m_41619_()) {
                this.m_8061_(slotForArmor, playerItem.m_41777_());
                player.m_21008_(InteractionHand.MAIN_HAND, ItemStack.f_41583_);
                return false;
            }
            EquipmentSlot slotToCheck = this.determineEquipmentSlot(playerItem);
            ItemStack entityItem = this.m_6844_(slotToCheck);
            boolean itemReplaced = false;
            boolean bl = canEquip2 = !(this instanceof SpearManEntity) || playerItem.m_41720_() instanceof ArmorItem || playerItem.m_41720_() instanceof ShieldItem || WeaponTypeHelper.isPikeLikeWeapon(playerItem);
            if (canEquip2 && this.isSameItemType(playerItem, entityItem)) {
                long currentTime;
                boolean isWeaponItem;
                boolean bl2 = isWeaponItem = WeaponTypeHelper.isSwordLikeWeapon(playerItem) || WeaponTypeHelper.isAxeLikeWeapon(playerItem) || WeaponTypeHelper.isBowLikeWeapon(playerItem) || WeaponTypeHelper.isLanceLikeWeapon(playerItem) || WeaponTypeHelper.isPikeLikeWeapon(playerItem);
                if (isWeaponItem && (currentTime = System.currentTimeMillis()) - this.lastWeaponReplaceTime < 1000L) {
                    return false;
                }
                this.m_8061_(slotToCheck, playerItem.m_41777_());
                player.m_21008_(InteractionHand.MAIN_HAND, ItemStack.f_41583_);
                if (!entityItem.m_41619_()) {
                    player.m_21008_(InteractionHand.MAIN_HAND, entityItem);
                }
                itemReplaced = true;
                if (isWeaponItem) {
                    long currentTime2;
                    this.lastWeaponReplaceTime = currentTime2 = System.currentTimeMillis();
                }
            }
            return false;
        }
        Player attackingPlayer = null;
        Entity directEntity = source.m_7640_();
        if (directEntity instanceof Player) {
            attackingPlayer = (Player)directEntity;
        } else if (directEntity instanceof Projectile && (projectile3 = (Projectile)directEntity).m_19749_() instanceof Player) {
            attackingPlayer = (Player)projectile3.m_19749_();
        }
        if (attackingPlayer != null && !attackingPlayer.m_7500_() && (ServerRelationHelper.hasControlOver(attackingPlayer, (Entity)this) || ServerRelationHelper.isFriendlyRelation((Entity)attackingPlayer, (Entity)this))) {
            amount *= (float)ServerModConfig.INSTANCE.getPlayerFriendlyFireDamageMultiplier();
        }
        BaseCombatEntity attacker = null;
        if (directEntity instanceof BaseCombatEntity) {
            attacker = (BaseCombatEntity)directEntity;
        } else if (directEntity instanceof Projectile && (projectile2 = (Projectile)directEntity).m_19749_() instanceof BaseCombatEntity) {
            attacker = (BaseCombatEntity)projectile2.m_19749_();
        }
        if (attacker != null) {
            double damageModifier = this.calculateDamageModifier(attacker, this);
            amount *= (float)damageModifier;
        }
        boolean isDefenderMelee = !(this instanceof RangedAttackMob) || (canEquip2 = this) instanceof MeleeCapableRangedAttacker && !(meleeCapable = (MeleeCapableRangedAttacker)((Object)canEquip2)).isUsingRanged();
        boolean isAttackerMelee = false;
        Entity isWeaponItem = source.m_7640_();
        if (isWeaponItem instanceof BaseCombatEntity) {
            BaseCombatEntity baseCombatEntity = (BaseCombatEntity)isWeaponItem;
            boolean bl = isAttackerMelee = !(baseCombatEntity instanceof RangedAttackMob) || baseCombatEntity instanceof MeleeCapableRangedAttacker && !(attackerMeleeCapable = (MeleeCapableRangedAttacker)((Object)baseCombatEntity)).isUsingRanged();
        }
        if (isDefenderMelee && isAttackerMelee) {
            amount *= 0.5f;
        }
        if (this instanceof RangedAttackMob && (attackerMeleeCapable = source.m_7640_()) instanceof Projectile && (projectile = (Projectile)attackerMeleeCapable).m_19749_() instanceof BaseCombatEntity) {
            amount *= 1.0f;
        }
        if (source.m_7640_() instanceof BaseCombatEntity || (attackerMeleeCapable = source.m_7640_()) instanceof Projectile && (projectile = (Projectile)attackerMeleeCapable).m_19749_() instanceof BaseCombatEntity) {
            amount *= 0.5f;
        }
        if (this.m_20202_() != null && this.m_20202_() instanceof BaseCombatEntity) {
            amount *= 0.8f;
        }
        if (this instanceof SiegeUnit && source.m_7640_() instanceof Projectile) {
            amount *= 0.5f;
        } else if (this instanceof SiegeUnit) {
            amount *= 3.0f;
        }
        if (ServerModConfig.INSTANCE.isEnableRecruitBalance() && this.m_21023_(MobEffects.f_19613_) && this.summonWeaknessTimer > 0) {
            int weaknessLevel = this.m_21124_(MobEffects.f_19613_).m_19564_() + 1;
            float damageMultiplier = RecruitBalanceConfig.getWeaknessDamageMultiplier(weaknessLevel);
            amount *= damageMultiplier;
        }
        return super.m_6469_(source, amount);
    }

    private double calculateDamageModifier(BaseCombatEntity attacker, BaseCombatEntity defender) {
        double modifier = 1.0;
        boolean defenderIsLight = defender instanceof LightUnit;
        boolean defenderIsHeavy = defender instanceof HeavyUnit;
        boolean defenderIsCavalry = defender instanceof CavalryUnit;
        boolean defenderIsRanged = defender instanceof RangedUnit;
        boolean defenderIsSiege = defender instanceof SiegeUnit;
        if (defenderIsLight && attacker instanceof CounterLight) {
            CounterLight counterLight = (CounterLight)((Object)attacker);
            modifier *= counterLight.getLightDamageModifier();
        } else if (defenderIsLight && attacker instanceof CounterHeavy) {
            CounterHeavy counterHeavy = (CounterHeavy)((Object)attacker);
            modifier *= counterHeavy.getLightDamageModifier();
        }
        if (defenderIsHeavy && attacker instanceof CounterHeavy) {
            CounterHeavy counterHeavy = (CounterHeavy)((Object)attacker);
            modifier *= counterHeavy.getHeavyDamageModifier();
        } else if (defenderIsHeavy && attacker instanceof CounterLight) {
            CounterLight counterLight = (CounterLight)((Object)attacker);
            modifier *= counterLight.getHeavyDamageModifier();
        }
        if (defenderIsCavalry && attacker instanceof CounterCavalry) {
            CounterCavalry counterCavalry = (CounterCavalry)((Object)attacker);
            modifier *= counterCavalry.getCavalryDamageModifier();
        }
        if (defenderIsRanged && attacker instanceof CounterRanged) {
            CounterRanged counterRanged = (CounterRanged)((Object)attacker);
            modifier *= counterRanged.getRangedDamageModifier();
        }
        if (defenderIsSiege && attacker instanceof CounterSiege) {
            CounterSiege counterSiege = (CounterSiege)((Object)attacker);
            modifier *= counterSiege.getSiegeDamageModifier();
        }
        return modifier;
    }

    protected EquipmentSlot determineEquipmentSlot(ItemStack item) {
        if (item.m_41720_() instanceof ShieldItem) {
            return EquipmentSlot.OFFHAND;
        }
        if (item.m_41720_() instanceof ArmorItem) {
            return ((ArmorItem)item.m_41720_()).m_40402_();
        }
        if (item.m_41720_() instanceof ProjectileWeaponItem || item.m_41720_() instanceof SwordItem || item.m_41720_() instanceof AxeItem) {
            return EquipmentSlot.MAINHAND;
        }
        return EquipmentSlot.MAINHAND;
    }

    private boolean isSameItemType(ItemStack item1, ItemStack item2) {
        if (item1.m_41619_() || item2.m_41619_()) {
            return false;
        }
        if (WeaponTypeHelper.isSameWeaponType(item1, item2)) {
            return true;
        }
        if (item1.m_41720_() instanceof ArmorItem && item2.m_41720_() instanceof ArmorItem) {
            return ((ArmorItem)item1.m_41720_()).m_266204_().m_266308_() == ((ArmorItem)item2.m_41720_()).m_266204_().m_266308_();
        }
        return false;
    }

    private void spawnParticles(Level world, double x, double y, double z) {
        int particleCount = 40;
        if (world instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)world;
            for (int i = 0; i < particleCount; ++i) {
                double offsetX = (world.f_46441_.m_188500_() - 0.5) * 1.0;
                double offsetY = world.f_46441_.m_188500_() * 0.5 + 0.5;
                double offsetZ = (world.f_46441_.m_188500_() - 0.5) * 1.0;
                serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123796_, x, y + 0.5, z, 1, offsetX, offsetY, offsetZ, 0.0);
            }
        }
    }

    public void m_5993_(Entity killedEntity, int score, DamageSource damageSource) {
        LivingEntity target;
        super.m_5993_(killedEntity, score, damageSource);
        if (killedEntity instanceof LivingEntity && this.isValidTarget(target = (LivingEntity)killedEntity)) {
            if (ExpBlacklistManager.isInExpBlacklist(target)) {
                return;
            }
            int xpGained = (int)((LivingEntity)killedEntity).m_21233_();
            ServerPlayer owner = this.getOwner();
            if (owner != null && ServerModConfig.INSTANCE.isShareExperienceWithPlayer()) {
                owner.m_6756_(xpGained / 6);
            }
            this.incrementKillCount();
            this.addExperience(xpGained);
        }
    }

    public int m_213860_() {
        return (int)(this.m_21233_() / 3.0f);
    }

    public int m_6056_() {
        return 6;
    }

    protected int m_5639_(float fallDistance, float damageMultiplier) {
        if (this.m_6095_().m_204039_(EntityTypeTags.f_273841_)) {
            return 0;
        }
        MobEffectInstance jumpBoostEffect = this.m_21124_(MobEffects.f_19603_);
        float jumpBoostReduction = jumpBoostEffect == null ? 0.0f : (float)(jumpBoostEffect.m_19564_() + 1);
        return Mth.m_14167_((float)((fallDistance - 6.0f - jumpBoostReduction) * damageMultiplier));
    }

    public void addExperience(int amount) {
        if (this instanceof IPuppet) {
            return;
        }
        int newXP = this.getExperiencePoints() + amount;
        this.setExperiencePoints(newXP);
        this.checkLevelUp();
    }

    private void checkLevelUp() {
        while (this.getExperiencePoints() >= this.getXpThresholdForNextLevel() && this.getLevel() < ServerModConfig.INSTANCE.getSoldierLevelCap()) {
            this.levelUp();
        }
    }

    private int getXpThresholdForNextLevel() {
        return this.getLevel() * 20;
    }

    public void levelUp() {
        this.setExperiencePoints(this.getExperiencePoints() - this.getXpThresholdForNextLevel());
        this.setLevel(this.getLevel() + 1);
        this.increaseStatsOnLevelUp();
    }

    protected void increaseStatsOnLevelUp() {
        AttributeInstance attackDamage;
        AttributeInstance maxHealth = this.m_21051_(Attributes.f_22276_);
        if (maxHealth != null) {
            maxHealth.m_22100_(maxHealth.m_22115_() + 1.0);
            this.m_5634_(1.0f);
        }
        if ((attackDamage = this.m_21051_(Attributes.f_22281_)) != null) {
            attackDamage.m_22100_(attackDamage.m_22115_() + 0.25);
        }
    }

    public void applyLevelWithStats(int targetLevel) {
        int currentLevel;
        int clampedLevel = Math.max(1, targetLevel);
        if (clampedLevel > (currentLevel = Math.max(1, this.getLevel()))) {
            for (int i = currentLevel; i < clampedLevel; ++i) {
                this.increaseStatsOnLevelUp();
            }
        }
        this.setLevel(clampedLevel);
        this.setExperiencePoints(0);
        this.m_21153_(this.m_21233_());
    }

    public int getAttackAnimationTime() {
        return this.attackAnimationTime;
    }

    public void setAttackAnimationTime(int attackAnimationTime) {
        this.attackAnimationTime = attackAnimationTime;
    }

    public int getAttackDamageTick() {
        return this.attackDamageTick;
    }

    public void setAttackDamageTick(int attackDamageTick) {
        this.attackDamageTick = attackDamageTick;
    }

    public boolean isAttacking() {
        return this.isAttacking;
    }

    public void setAttacking(boolean attacking) {
        this.isAttacking = attacking;
    }

    public double getDesiredDistance() {
        return this.desiredDistance;
    }

    public double getRidingOffsetFactor() {
        return 0.5;
    }

    public void setDesiredDistance(double desiredDistance) {
        this.desiredDistance = desiredDistance;
    }

    public double getArrivalThreshold() {
        if (this.m_20202_() instanceof AbstractHorse) {
            return 2.0;
        }
        return 0.2;
    }

    @Override
    public int getEquipmentLevel() {
        return this.equipmentLevel;
    }

    @Override
    public void setEquipmentLevel(int equipmentLevel) {
        this.equipmentLevel = equipmentLevel;
    }

    public void m_7334_(Entity entity) {
        double e;
        double d;
        double f;
        if (this.m_20159_() || entity.m_20159_()) {
            return;
        }
        if (entity instanceof BaseCombatSupport && !(entity instanceof BaseWorkerEntity)) {
            return;
        }
        if (!this.m_20365_(entity) && !entity.f_19794_ && !this.f_19794_ && (f = Mth.m_14005_((double)(d = entity.m_20185_() - this.m_20185_()), (double)(e = entity.m_20189_() - this.m_20189_()))) >= (double)0.01f) {
            f = Math.sqrt(f);
            d /= f;
            e /= f;
            double g = 1.0 / f;
            if (g > 1.0) {
                g = 1.0;
            }
            d *= g;
            e *= g;
            d *= (double)0.05f;
            e *= (double)0.05f;
            if (this.m_6094_()) {
                this.m_5997_(-d, 0.0, -e);
            }
            if (entity.m_6094_()) {
                entity.m_5997_(d, 0.0, e);
            }
        }
    }

    public boolean m_6094_() {
        return true;
    }

    public void m_6667_(DamageSource damageSource) {
        Entity entity;
        if (damageSource.m_7639_() != null) {
            Projectile projectile;
            Entity sourceEntity = damageSource.m_7639_();
            UUID attackerOwnerUUID = null;
            if (sourceEntity instanceof Player) {
                Player player = (Player)sourceEntity;
                attackerOwnerUUID = player.m_20148_();
            } else if (sourceEntity instanceof BaseCombatEntity) {
                BaseCombatEntity baseCombatEntity = (BaseCombatEntity)sourceEntity;
                attackerOwnerUUID = baseCombatEntity.m_21805_();
            } else if (sourceEntity instanceof Projectile && (projectile = (Projectile)sourceEntity).m_19749_() instanceof LivingEntity) {
                Entity owner = projectile.m_19749_();
                if (owner instanceof Player) {
                    Player player = (Player)owner;
                    attackerOwnerUUID = player.m_20148_();
                } else if (owner instanceof BaseCombatEntity) {
                    BaseCombatEntity baseCombatEntity = (BaseCombatEntity)owner;
                    attackerOwnerUUID = baseCombatEntity.m_21805_();
                }
            }
            UUID victimOwnerUUID = this.m_21805_();
            if (attackerOwnerUUID != null && victimOwnerUUID != null && !attackerOwnerUUID.equals(victimOwnerUUID) && ServerRelationHelper.isNeutralRelation((Entity)this, sourceEntity)) {
                RelationSystem.setRelation(victimOwnerUUID, attackerOwnerUUID, RelationSystem.RelationType.HOSTILE);
                System.out.println("\u56e0\u88ab\u6740\u6b7b\uff0c" + victimOwnerUUID + " \u73b0\u5728\u5bf9 " + attackerOwnerUUID + " \u662f\u654c\u5bf9\u5173\u7cfb");
            }
        }
        if (this.m_20202_() != null && (entity = this.m_20202_()) instanceof HywHorseEntity) {
            HywHorseEntity vehicle = (HywHorseEntity)entity;
            this.m_8127_();
            vehicle.m_6074_();
        }
        super.m_6667_(damageSource);
    }

    public boolean isObstructed(LivingEntity target) {
        Vec3 startPos = this.m_146892_();
        Vec3 endPos = target.m_146892_();
        BlockHitResult blockHitResult = this.m_9236_().m_45547_(new ClipContext(startPos, endPos, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this));
        if (blockHitResult.m_6662_() != HitResult.Type.MISS) {
            return true;
        }
        AABB boundingBox = new AABB(startPos, endPos);
        List entities = this.m_9236_().m_6249_((Entity)this, boundingBox, entity -> !entity.m_5833_() && entity.m_6087_() && entity != this && entity != target);
        for (Entity entity2 : entities) {
            Optional optionalHit = entity2.m_20191_().m_82371_(startPos, endPos);
            if (!optionalHit.isPresent() || !(entity2 instanceof BaseCombatEntity) || ServerRelationHelper.isEnemyRelation((Entity)this, (Entity)((BaseCombatEntity)entity2))) continue;
            return true;
        }
        return false;
    }

    public LivingEntity getHywTarget() {
        return this.hywTarget;
    }

    public void setHywTarget(LivingEntity hywTarget) {
        if (this.hywTarget != hywTarget) {
            if (BetterMobCombatIntegration.isActivated() && BetterMobCombatIntegration.isBetterCombatWeapon(this.m_21205_())) {
                BetterMobCombatIntegration.resetComboCount(this);
            } else {
                this.comboCount = 0;
            }
        }
        this.hywTarget = hywTarget;
    }

    public void resetTargetTick() {
        this.targetResetTick = 10;
    }

    public int getTargetResetTick() {
        return this.targetResetTick;
    }

    public boolean isForceAttackTarget() {
        return this.forceAttackTarget;
    }

    public void setForceAttackTarget(boolean forceAttackTarget) {
        this.forceAttackTarget = forceAttackTarget;
    }

    public void checkAndUpdateTarget() {
        if (this.forceAttackTarget) {
            return;
        }
        if (this.m_5448_() != null && this.hywTarget != null && this.targetResetTick > 0) {
            --this.targetResetTick;
        } else if (this.hywTarget != null) {
            LivingEntity nearestTarget = this.findNearestTarget();
            if (nearestTarget != null && !nearestTarget.equals((Object)this.hywTarget)) {
                this.setHywTarget(nearestTarget);
            }
            if (!this.isValidTarget(this.hywTarget)) {
                this.setHywTarget(null);
            }
            this.targetResetTick = 10;
        }
    }

    private LivingEntity findNearestTarget() {
        TargetingConditions conditions = this.createTargetingConditions();
        List list = ((EntityAccessor)((Object)this)).getLevel().m_45971_(LivingEntity.class, conditions, (LivingEntity)this, this.m_20191_().m_82400_(this.m_21133_(Attributes.f_22277_)));
        LivingEntity nearestTarget = null;
        double nearestDistanceSq = Double.MAX_VALUE;
        for (LivingEntity entity : list) {
            double distanceSq = this.m_20280_((Entity)entity);
            if (!(distanceSq < nearestDistanceSq)) continue;
            nearestDistanceSq = distanceSq;
            nearestTarget = entity;
        }
        return nearestTarget;
    }

    private TargetingConditions createTargetingConditions() {
        return TargetingConditions.m_148352_().m_26883_(this.m_21133_(Attributes.f_22277_)).m_26888_(target -> target.m_6084_() && this.isValidTarget((LivingEntity)target));
    }

    public boolean canFireAtTarget(LivingEntity target) {
        return true;
    }

    public void m_8107_() {
        super.m_8107_();
        this.m_21203_();
    }

    public void m_7472_(DamageSource damageSource, int looting, boolean hitByPlayer) {
    }

    protected void m_5907_() {
        EquipmentSlot[] equipmentSlots;
        if (!ServerModConfig.INSTANCE.isAllowEquipmentDrop()) {
            return;
        }
        for (EquipmentSlot slot : equipmentSlots = new EquipmentSlot[]{EquipmentSlot.MAINHAND, EquipmentSlot.OFFHAND, EquipmentSlot.HEAD, EquipmentSlot.CHEST, EquipmentSlot.LEGS, EquipmentSlot.FEET}) {
            ItemStack itemStack = this.m_6844_(slot);
            if (itemStack.m_41619_()) continue;
            this.m_19983_(itemStack);
            this.m_8061_(slot, ItemStack.f_41583_);
        }
    }

    public List<Action> getActions() {
        return this.actions;
    }

    protected void initActions() {
        this.initDefaultActions();
        this.initCustomActions();
    }

    protected void initDefaultActions() {
        this.actions.add(new AttackAction());
        this.actions.add(new HoldAction());
        this.actions.add(new CancelAction());
        this.actions.add(new PatrolAction());
        if (this instanceof PositionAttackable) {
            this.actions.add(new PositionAttackAction());
        }
        if (this instanceof UnloadPassengerable) {
            this.actions.add(new UnloadAction());
        }
    }

    protected void initCustomActions() {
    }

    public PrioritizedGoal getCurrentCommandedGoal() {
        return this.currentCommandedGoal;
    }

    public int getKillCount() {
        return (Integer)this.f_19804_.m_135370_(KILL_COUNT);
    }

    public void setKillCount(int killCount) {
        this.f_19804_.m_135381_(KILL_COUNT, (Object)killCount);
    }

    public void incrementKillCount() {
        this.setKillCount(this.getKillCount() + 1);
    }

    protected void setAttributeBaseValue(Attribute attribute, double value) {
        AttributeInstance attr = this.m_21051_(attribute);
        if (attr != null) {
            attr.m_22100_(value);
        }
    }

    private void handleTimeBasedRecovery(CompoundTag compound) {
        if (this.unloadTime <= 0L) {
            return;
        }
        MinecraftServer server = this.m_9236_().m_7654_();
        if (server == null) {
            return;
        }
        WorldTickCounter counter = WorldTickCounter.get(server);
        long currentWorldTicks = counter.getTotalWorldTicks();
        long tickDiff = currentWorldTicks - this.unloadTime;
        if (tickDiff <= 0L) {
            return;
        }
        long healTicks = tickDiff / 1200L;
        if (healTicks > 0L) {
            float currentHealth = this.m_21223_();
            float maxHealth = this.m_21233_();
            float healAmount = Math.min((float)healTicks, maxHealth - currentHealth);
            if (healAmount > 0.0f) {
                this.m_5634_(healAmount);
            }
        }
        if (this.summonWeaknessTimer > 0) {
            long newTimer = (long)this.summonWeaknessTimer - tickDiff;
            this.summonWeaknessTimer = (int)Math.max(0L, newTimer);
        }
        this.handleOfflinePotionEffects(tickDiff);
        this.unloadTime = -1L;
    }

    private void handleOfflinePotionEffects(long tickDiff) {
        ArrayList activeEffects = new ArrayList(this.m_21220_());
        for (MobEffectInstance effect : activeEffects) {
            int remainingDuration = effect.m_19557_();
            if (tickDiff >= (long)remainingDuration) {
                this.m_21195_(effect.m_19544_());
                continue;
            }
            this.m_21195_(effect.m_19544_());
            int newDuration = (int)((long)remainingDuration - tickDiff);
            MobEffectInstance newEffect = new MobEffectInstance(effect.m_19544_(), newDuration, effect.m_19564_(), effect.m_19571_(), effect.m_19572_(), effect.m_19575_());
            this.m_7292_(newEffect);
        }
    }

    private void manageRotation() {
        if (this.shouldSkipBaseRotation()) {
            return;
        }
        if (this instanceof SiegeUnit) {
            this.manageSiegeRotation();
            return;
        }
        if (!this.m_9236_().f_46443_) {
            boolean idleFacingActive;
            LivingEntity target = this.getHywTarget();
            if (target != null && !target.m_213877_() && target.m_6084_() && !(this instanceof RotationLimited)) {
                BaseCombatEntity baseCombatEntity;
                boolean allowTargetRotation;
                boolean bl = allowTargetRotation = !this.shouldMoveOnly();
                if (!allowTargetRotation && (baseCombatEntity = this) instanceof MountedLancerRiderEntity) {
                    MountedLancerRiderEntity lancer = (MountedLancerRiderEntity)baseCombatEntity;
                    boolean bl2 = allowTargetRotation = !lancer.isUsingChargeWeapon();
                }
                if (allowTargetRotation) {
                    boolean isCharging;
                    double distanceSq = this.m_20280_((Entity)target);
                    double attackRangeSq = this.getAttackReach() * this.getAttackReach();
                    boolean bl3 = isCharging = this instanceof Chargeable && ((Chargeable)((Object)this)).isCharging();
                    if (distanceSq <= attackRangeSq * 1.5 || isCharging) {
                        float effectiveRotationLimit;
                        double dx = target.m_20185_() - this.m_20185_();
                        double dz = target.m_20189_() - this.m_20189_();
                        this.targetRot = (float)(Mth.m_14136_((double)dz, (double)dx) * 57.29577951308232) - 90.0f;
                        float rotationDifference = Mth.m_14177_((float)(this.targetRot - this.currentRot));
                        float f = effectiveRotationLimit = distanceSq <= attackRangeSq ? this.getRotationLimit() * 1.5f : this.getRotationLimit();
                        if (rotationDifference > effectiveRotationLimit) {
                            rotationDifference = effectiveRotationLimit;
                        } else if (rotationDifference < -effectiveRotationLimit) {
                            rotationDifference = -effectiveRotationLimit;
                        }
                        this.currentRot += rotationDifference;
                        this.m_146922_(this.currentRot);
                        this.m_5618_(this.currentRot);
                        Entity entity = this.m_20202_();
                        if (entity instanceof AbstractHorse) {
                            AbstractHorse horse = (AbstractHorse)entity;
                            horse.m_146922_(this.currentRot);
                            horse.m_5618_(this.currentRot);
                        }
                        return;
                    }
                }
            }
            if (this instanceof RotationLimited) {
                float desiredRot;
                if (this.f_19797_ == 0) {
                    this.currentRot = this.m_146908_();
                }
                Vec3 movement = this.m_20184_();
                double speedSq = movement.f_82479_ * movement.f_82479_ + movement.f_82481_ * movement.f_82481_;
                double speedThreshold = 1.0E-4;
                if (speedSq > speedThreshold && this.shouldMoveOnly()) {
                    desiredRot = (float)(Mth.m_14136_((double)movement.f_82481_, (double)movement.f_82479_) * 57.29577951308232) - 90.0f;
                } else {
                    Vec3 targetPos = this.getSiegeTargetPosition();
                    if (targetPos != null) {
                        double dx = targetPos.f_82479_ - this.m_20185_();
                        double dz = targetPos.f_82481_ - this.m_20189_();
                        desiredRot = (float)(Mth.m_14136_((double)dz, (double)dx) * 57.29577951308232) - 90.0f;
                    } else {
                        desiredRot = this.hasIdleFacingDirection() ? this.idleFacingYaw : this.f_20885_;
                    }
                }
                float rotationDifference = Mth.m_14177_((float)(desiredRot - this.currentRot));
                float rotationCap = this.getRotationLimit();
                if (rotationDifference > rotationCap) {
                    rotationDifference = rotationCap;
                } else if (rotationDifference < -rotationCap) {
                    rotationDifference = -rotationCap;
                }
                this.currentRot += rotationDifference;
                this.f_19804_.m_135381_(Y_BODY_ROT, (Object)Float.valueOf(this.currentRot));
                return;
            }
            Entity speedSq = this.m_20202_();
            if (speedSq instanceof AbstractHorse) {
                AbstractHorse horse = (AbstractHorse)speedSq;
                double velocityX = horse.m_20184_().f_82479_;
                double velocityZ = horse.m_20184_().f_82481_;
                double speedSq2 = velocityX * velocityX + velocityZ * velocityZ;
                double speedThreshold = 1.0E-4;
                if (speedSq2 > speedThreshold) {
                    boolean isPureRanged;
                    float currentRotationLimit;
                    this.targetRot = (float)(Mth.m_14136_((double)velocityZ, (double)velocityX) * 57.29577951308232) - 90.0f;
                    float rotationDifference = Mth.m_14177_((float)(this.targetRot - this.currentRot));
                    if (rotationDifference > (currentRotationLimit = this.getRotationLimit())) {
                        rotationDifference = currentRotationLimit;
                    } else if (rotationDifference < -currentRotationLimit) {
                        rotationDifference = -currentRotationLimit;
                    }
                    this.currentRot += rotationDifference;
                    horse.m_146922_(this.currentRot);
                    horse.m_5618_(this.currentRot);
                    boolean bl = isPureRanged = this instanceof RangedAttackMob && !(this instanceof MeleeCapableRangedAttacker);
                    if (!isPureRanged) {
                        this.m_146922_(this.currentRot);
                        this.m_5618_(this.currentRot);
                    }
                }
            }
            if ((idleFacingActive = this.hasIdleFacingDirection()) && target == null) {
                boolean vehicleMoving;
                boolean isNavigating = this.m_21573_().m_26572_();
                boolean isMoving = this.m_20184_().m_165925_() > 1.0E-4;
                boolean bl = vehicleMoving = this.m_20202_() != null && this.m_20202_().m_20184_().m_165925_() > 1.0E-4;
                if (!(isNavigating || isMoving || vehicleMoving)) {
                    if (this.f_19797_ == 0 && this.currentRot == 0.0f) {
                        this.currentRot = this.m_146908_();
                    }
                    float rotationDifference = Mth.m_14177_((float)(this.idleFacingYaw - this.currentRot));
                    float rotationCap = this.getRotationLimit();
                    rotationDifference = Mth.m_14036_((float)rotationDifference, (float)(-rotationCap), (float)rotationCap);
                    this.currentRot += rotationDifference;
                    this.m_146922_(this.currentRot);
                    this.m_5618_(this.currentRot);
                    this.f_20885_ = this.currentRot;
                    Entity entity = this.m_20202_();
                    if (entity instanceof AbstractHorse) {
                        AbstractHorse horse = (AbstractHorse)entity;
                        horse.m_146922_(this.currentRot);
                        horse.m_5618_(this.currentRot);
                    }
                    this.f_19804_.m_135381_(Y_BODY_ROT, (Object)Float.valueOf(this.currentRot));
                }
            }
        } else if (this instanceof RotationLimited) {
            this.f_20885_ = ((Float)this.f_19804_.m_135370_(Y_BODY_ROT)).floatValue();
            this.f_20883_ = ((Float)this.f_19804_.m_135370_(Y_BODY_ROT)).floatValue();
        }
    }

    public float getCurrentRot() {
        return this.currentRot;
    }

    public float getTargetRot() {
        return this.targetRot;
    }

    public float getRotationLimit() {
        return this.rotationLimit;
    }

    public boolean hasIdleFacingDirection() {
        return this.hasIdleFacing;
    }

    public float getIdleFacingYaw() {
        return this.idleFacingYaw;
    }

    public void setIdleFacingDirection(float yaw) {
        this.hasIdleFacing = true;
        this.idleFacingYaw = Mth.m_14177_((float)yaw);
        this.disableRandomLookGoals();
    }

    public void clearIdleFacingDirection() {
        this.hasIdleFacing = false;
        this.idleFacingYaw = 0.0f;
        this.restoreRandomLookGoals();
    }

    private void disableRandomLookGoals() {
        if (!this.removedRandomLookGoals.isEmpty()) {
            return;
        }
        List<WrappedGoal> toRemove = this.f_21345_.m_148105_().stream().filter(wrappedGoal -> wrappedGoal.m_26015_() instanceof RandomLookAroundGoal).toList();
        for (WrappedGoal wrappedGoal2 : toRemove) {
            this.removedRandomLookGoals.add(new RandomLookGoalEntry(wrappedGoal2.m_26012_(), wrappedGoal2.m_26015_()));
            this.f_21345_.m_25363_(wrappedGoal2.m_26015_());
        }
    }

    private void restoreRandomLookGoals() {
        if (this.removedRandomLookGoals.isEmpty()) {
            return;
        }
        for (RandomLookGoalEntry entry : this.removedRandomLookGoals) {
            this.f_21345_.m_25352_(entry.priority(), entry.goal());
        }
        this.removedRandomLookGoals.clear();
    }

    public boolean shouldMoveOnly() {
        if (this.forceMoveOnly) {
            return true;
        }
        if (this.getCurrentCommandedGoal() != null && this.getCurrentCommandedGoal().goal instanceof MoveGoal && this.getCurrentCommandedGoal().priority == 1) {
            return true;
        }
        return this.f_21345_.m_148105_().stream().anyMatch(pair -> pair.m_26015_() instanceof FollowEntityGoal && pair.m_7620_());
    }

    protected void manageSiegeRotation() {
        if (!this.m_9236_().f_46443_) {
            double velocityX = this.m_20184_().f_82479_;
            double velocityZ = this.m_20184_().f_82481_;
            double speedSq = velocityX * velocityX + velocityZ * velocityZ;
            double speedThreshold = 1.0E-4;
            if (speedSq > speedThreshold) {
                float rotLimit;
                this.targetRot = (float)(Mth.m_14136_((double)velocityZ, (double)velocityX) * 57.29577951308232) - 90.0f;
                float rotationDifference = Mth.m_14177_((float)(this.targetRot - this.currentRot));
                if (rotationDifference > (rotLimit = this.getRotationLimit())) {
                    rotationDifference = rotLimit;
                } else if (rotationDifference < -rotLimit) {
                    rotationDifference = -rotLimit;
                }
                this.currentRot += rotationDifference;
            } else {
                Vec3 targetPosition = this.getSiegeTargetPosition();
                if (targetPosition != null) {
                    float rotLimit;
                    double targetX = targetPosition.f_82479_ - this.m_20185_();
                    double targetZ = targetPosition.f_82481_ - this.m_20189_();
                    this.targetRot = (float)(Mth.m_14136_((double)targetZ, (double)targetX) * 57.29577951308232) - 90.0f;
                    float rotationDifference = Mth.m_14177_((float)(this.targetRot - this.currentRot));
                    if (rotationDifference > (rotLimit = this.getRotationLimit())) {
                        rotationDifference = rotLimit;
                    } else if (rotationDifference < -rotLimit) {
                        rotationDifference = -rotLimit;
                    }
                    this.currentRot += rotationDifference;
                } else {
                    this.targetRot = this.currentRot;
                }
            }
            this.f_19804_.m_135381_(Y_BODY_ROT, (Object)Float.valueOf(this.currentRot));
        } else {
            this.f_20883_ = ((Float)this.f_19804_.m_135370_(Y_BODY_ROT)).floatValue();
        }
    }

    public float getTrueYBodyRot() {
        return ((Float)this.f_19804_.m_135370_(Y_BODY_ROT)).floatValue();
    }

    public boolean shouldSkipBaseRotation() {
        return false;
    }

    protected Vec3 getSiegeTargetPosition() {
        PositionAttackable positionAttackable;
        UnloadPassengerable unloadPassengerable;
        BaseCombatEntity baseCombatEntity = this;
        if (baseCombatEntity instanceof UnloadPassengerable && (unloadPassengerable = (UnloadPassengerable)((Object)baseCombatEntity)).hasUnloadTarget()) {
            return unloadPassengerable.getUnloadTarget();
        }
        baseCombatEntity = this;
        if (baseCombatEntity instanceof PositionAttackable && (positionAttackable = (PositionAttackable)((Object)baseCombatEntity)).hasPositionTarget()) {
            return positionAttackable.getPositionTarget();
        }
        if (this.getHywTarget() != null) {
            return new Vec3(this.getHywTarget().m_20185_(), this.getHywTarget().m_20186_(), this.getHywTarget().m_20189_());
        }
        return null;
    }

    @Override
    public LivingEntity asLivingEntity() {
        return this;
    }

    @NotNull
    public Vec3 m_20184_() {
        Entity entity = this.m_20202_();
        if (entity instanceof AbstractHorse) {
            AbstractHorse horseEntity = (AbstractHorse)entity;
            return horseEntity.m_20184_();
        }
        return super.m_20184_();
    }

    public void syncHealthToHorse() {
        Entity entity;
        if (!this.m_9236_().f_46443_ && (entity = this.m_20202_()) instanceof AbstractHorse) {
            AttributeInstance maxHealthAttr;
            AbstractHorse horse = (AbstractHorse)entity;
            float riderMaxHealth = this.m_21233_();
            if (horse.m_21233_() != riderMaxHealth && (maxHealthAttr = horse.m_21051_(Attributes.f_22276_)) != null) {
                maxHealthAttr.m_22100_((double)riderMaxHealth);
            }
            float riderHealth = this.m_21223_();
            if (horse.m_21223_() != riderHealth) {
                horse.m_21153_(riderHealth);
            }
        }
    }

    private record RandomLookGoalEntry(int priority, Goal goal) {
    }
}

