/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.main.entity.entities;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import ydmsama.hundred_years_war.main.blocks.workstation.FishingWorkstationBlockEntity;
import ydmsama.hundred_years_war.main.entity.entities.BaseWorkerEntity;
import ydmsama.hundred_years_war.main.entity.goals.FisherActivateWorkstationGoal;
import ydmsama.hundred_years_war.main.registry.HywItemRegistry;

public class FisherEntity
extends BaseWorkerEntity {
    private static final int WORKSTATION_SEARCH_RANGE = 16;

    public FisherEntity(EntityType<? extends PathfinderMob> entityType, Level world) {
        super(entityType, world);
        this.m_274367_(1.0f);
    }

    @Override
    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(3, (Goal)new FisherActivateWorkstationGoal(this, 16));
    }

    public static AttributeSupplier.Builder createFisherAttributes() {
        return PathfinderMob.m_21552_().m_22268_(Attributes.f_22276_, 20.0).m_22268_(Attributes.f_22279_, 0.25).m_22268_(Attributes.f_22277_, 16.0);
    }

    public BlockPos findNearestWorkstation() {
        BlockPos entityPos = this.m_20183_();
        BlockPos nearestPos = null;
        double nearestDistance = Double.MAX_VALUE;
        for (int x = -16; x <= 16; ++x) {
            for (int y = -16; y <= 16; ++y) {
                for (int z = -16; z <= 16; ++z) {
                    double distance;
                    BlockPos checkPos = entityPos.m_7918_(x, y, z);
                    BlockEntity blockEntity = this.m_9236_().m_7702_(checkPos);
                    if (!(blockEntity instanceof FishingWorkstationBlockEntity) || !((distance = entityPos.m_123331_((Vec3i)checkPos)) < nearestDistance)) continue;
                    nearestDistance = distance;
                    nearestPos = checkPos;
                }
            }
        }
        return nearestPos;
    }

    public BlockPos findNearestInactiveWorkstation() {
        BlockPos entityPos = this.m_20183_();
        BlockPos nearestPos = null;
        double nearestDistance = Double.MAX_VALUE;
        for (int x = -16; x <= 16; ++x) {
            for (int y = -16; y <= 16; ++y) {
                for (int z = -16; z <= 16; ++z) {
                    double distance;
                    FishingWorkstationBlockEntity workstation;
                    BlockPos checkPos = entityPos.m_7918_(x, y, z);
                    BlockEntity blockEntity = this.m_9236_().m_7702_(checkPos);
                    if (!(blockEntity instanceof FishingWorkstationBlockEntity) || (workstation = (FishingWorkstationBlockEntity)blockEntity).isActivated() || !((distance = entityPos.m_123331_((Vec3i)checkPos)) < nearestDistance)) continue;
                    nearestDistance = distance;
                    nearestPos = checkPos;
                }
            }
        }
        return nearestPos;
    }

    @Override
    public Item getScrollType() {
        return (Item)HywItemRegistry.FISHER_SCROLL.get();
    }

    public boolean m_6573_(Player player) {
        return false;
    }

    public boolean m_5912_() {
        return false;
    }

    @Override
    public int getSkinCounts() {
        return 2;
    }
}

