/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.main.entity.entities;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import ydmsama.hundred_years_war.main.entity.entities.BaseCombatEntity;
import ydmsama.hundred_years_war.main.entity.entities.siege.PositionAttackable;
import ydmsama.hundred_years_war.main.entity.entities.tags.HeavyUnit;
import ydmsama.hundred_years_war.main.entity.entities.tags.RotationLimited;
import ydmsama.hundred_years_war.main.entity.goals.HywWaterAvoidingRandomStrollGoal;
import ydmsama.hundred_years_war.main.registry.HywAttributes;
import ydmsama.hundred_years_war.main.registry.HywItemRegistry;

public class HywGiantEntity
extends BaseCombatEntity
implements HeavyUnit,
PositionAttackable,
RotationLimited {
    private static final float ATTACK_REACH = 10.0f;
    private static final float MOVEMENT_SPEED = 0.23f;
    private static final double SLAM_RADIUS = 10.0;
    private static final double SLAM_HORIZONTAL_SPEED = 0.35;
    private static final double SLAM_VERTICAL_BOOST = 0.65;
    private static final int SLAM_COOLDOWN_TICKS = 120;
    private static final float MAX_DESTROYABLE_HARDNESS = 50.0f;
    private static final double DESTRUCTION_VALUE_PER_ATTACK = 30.0;
    private static final int MANDATORY_MARGIN = 1;
    private static final int INFLUENCE_MARGIN = 3;
    private static final int EXTRA_HEIGHT_TOP = 2;
    private static final EntityDataAccessor<BlockPos> TARGET_POS = SynchedEntityData.m_135353_(HywGiantEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135038_);
    private static final EntityDataAccessor<Boolean> HAS_POSITION_TARGET = SynchedEntityData.m_135353_(HywGiantEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private boolean slamming = false;
    private boolean leftGround = false;
    private int slamCooldown = 0;
    private Vec3 positionTarget;

    public HywGiantEntity(EntityType<? extends PathfinderMob> entityType, Level world) {
        super(entityType, world);
        this.m_274367_(5.0f);
    }

    public static AttributeSupplier.Builder createHywGiantAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22277_, 28.0).m_22268_(Attributes.f_22279_, (double)0.23f).m_22268_(Attributes.f_22281_, 50.0).m_22268_(Attributes.f_22284_, 8.0).m_22268_(Attributes.f_22276_, 500.0).m_22268_(Attributes.f_22278_, 0.9).m_22268_((Attribute)HywAttributes.ATTACK_REACH.get(), 10.0);
    }

    @Override
    public float getRotationLimit() {
        return 5.0f;
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(TARGET_POS, (Object)BlockPos.f_121853_);
        this.f_19804_.m_135372_(HAS_POSITION_TARGET, (Object)false);
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (!this.m_9236_().f_46443_) {
            if (this.hasPositionTarget() && this.positionTarget != null) {
                this.f_19804_.m_135381_(TARGET_POS, (Object)BlockPos.m_274446_((Position)this.positionTarget));
            } else {
                this.f_19804_.m_135381_(TARGET_POS, (Object)BlockPos.f_121853_);
            }
            if (this.slamCooldown > 0) {
                --this.slamCooldown;
            }
            if (this.slamming) {
                if (!this.m_20096_()) {
                    this.leftGround = true;
                } else if (this.leftGround) {
                    this.performSlamImpact();
                    this.finishSlam();
                }
            } else if (this.canStartSlam()) {
                this.startSlam();
            }
        }
    }

    private boolean canStartSlam() {
        LivingEntity target = this.getActiveTarget();
        if (this.slamCooldown > 0 || target == null || !target.m_6084_() || !this.m_20096_()) {
            return false;
        }
        double distance = this.m_20270_((Entity)target);
        return distance <= 10.0;
    }

    private void startSlam() {
        LivingEntity target = this.getActiveTarget();
        if (target == null) {
            return;
        }
        Vec3 direction = target.m_20182_().m_82546_(this.m_20182_());
        Vec3 horizontal = new Vec3(direction.f_82479_, 0.0, direction.f_82481_);
        if (horizontal.m_82556_() > 1.0E-4) {
            horizontal = horizontal.m_82541_().m_82490_(0.35);
        }
        this.m_20334_(horizontal.f_82479_, 0.65, horizontal.f_82481_);
        this.f_19812_ = true;
        this.slamming = true;
        this.leftGround = false;
    }

    private void finishSlam() {
        this.slamming = false;
        this.leftGround = false;
        this.slamCooldown = 120;
        this.m_183634_();
    }

    private void performSlamImpact() {
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123796_, this.m_20185_(), this.m_20186_(), this.m_20189_(), 12, 1.0, 0.2, 1.0, 0.05);
        }
        this.m_5496_(SoundEvents.f_11913_, 0.7f, 0.9f + this.m_217043_().m_188501_() * 0.2f);
        AABB area = this.m_20191_().m_82377_(10.0, 0.8, 10.0);
        for (LivingEntity living : this.m_9236_().m_6443_(LivingEntity.class, area, target -> target != this && this.isValidTarget((LivingEntity)target))) {
            living.f_19802_ = 0;
            living.m_6469_(this.m_269291_().m_269333_((LivingEntity)this), (float)(this.m_21133_(Attributes.f_22281_) * (double)0.9f));
            double dx = living.m_20185_() - this.m_20185_();
            double dz = living.m_20189_() - this.m_20189_();
            living.m_147240_(0.7, dx, dz);
        }
    }

    private void performBlockDestructionAttack(Vec3 targetPosition) {
        if (this.m_9236_().f_46443_ || targetPosition == null) {
            return;
        }
        double centerX = targetPosition.f_82479_;
        double centerZ = targetPosition.f_82481_;
        double entityBottomY = this.m_20191_().f_82289_;
        double halfWidth = (double)this.m_20205_() / 2.0 + 1.0;
        int minX = Mth.m_14107_((double)(centerX - halfWidth));
        int maxX = Mth.m_14107_((double)(centerX + halfWidth));
        int minZ = Mth.m_14107_((double)(centerZ - halfWidth));
        int maxZ = Mth.m_14107_((double)(centerZ + halfWidth));
        int minY = Mth.m_14107_((double)entityBottomY);
        int maxY = Mth.m_14107_((double)(entityBottomY + (double)this.m_20206_() + 2.0));
        double influenceHalfWidth = halfWidth + 3.0;
        int influenceMinX = Mth.m_14107_((double)(centerX - influenceHalfWidth));
        int influenceMaxX = Mth.m_14107_((double)(centerX + influenceHalfWidth));
        int influenceMinZ = Mth.m_14107_((double)(centerZ - influenceHalfWidth));
        int influenceMaxZ = Mth.m_14107_((double)(centerZ + influenceHalfWidth));
        int influenceMaxY = maxY + 3;
        List<BlockPos> mandatoryBlocks = this.collectDestructibleBlocks(minX, maxX, minY, maxY, minZ, maxZ);
        if (mandatoryBlocks.isEmpty()) {
            this.setPositionTarget(null);
            return;
        }
        HashSet<BlockPos> mandatorySet = new HashSet<BlockPos>(mandatoryBlocks);
        HashSet<BlockPos> influenceBlocks = new HashSet<BlockPos>(this.collectDestructibleBlocks(influenceMinX, influenceMaxX, minY, influenceMaxY, influenceMinZ, influenceMaxZ));
        influenceBlocks.removeIf(pos -> this.isWithinBounds((BlockPos)pos, minX, maxX, minY, maxY, minZ, maxZ));
        Set<BlockPos> connectedInfluence = this.getConnectedInfluenceBlocks(mandatorySet, influenceBlocks, influenceMinX, influenceMaxX, minY, influenceMaxY, influenceMinZ, influenceMaxZ);
        RandomSource random = this.m_217043_();
        List<BlockPos> toBreakMandatory = this.selectBlocksByBudget(mandatoryBlocks, 30.0, random);
        this.destroyBlocks(toBreakMandatory);
        if (!connectedInfluence.isEmpty()) {
            List<BlockPos> toBreakInfluence = this.selectBlocksByBudget(new ArrayList<BlockPos>(connectedInfluence), 15.0, random);
            this.destroyBlocks(toBreakInfluence);
        }
        if (!this.hasDestructibleInBounds(minX, maxX, minY, maxY, minZ, maxZ)) {
            this.setPositionTarget(null);
        }
    }

    private List<BlockPos> collectDestructibleBlocks(int minX, int maxX, int minY, int maxY, int minZ, int maxZ) {
        ArrayList<BlockPos> result = new ArrayList<BlockPos>();
        for (int x = minX; x <= maxX; ++x) {
            for (int y = minY; y <= maxY; ++y) {
                for (int z = minZ; z <= maxZ; ++z) {
                    BlockPos pos = new BlockPos(x, y, z);
                    if (!this.isDestructible(pos)) continue;
                    result.add(pos);
                }
            }
        }
        return result;
    }

    private boolean isDestructible(BlockPos pos) {
        BlockState state = this.m_9236_().m_8055_(pos);
        if (state.m_60795_()) {
            return false;
        }
        float hardness = state.m_60800_((BlockGetter)this.m_9236_(), pos);
        return hardness >= 0.0f && hardness <= 50.0f;
    }

    private boolean isWithinBounds(BlockPos pos, int minX, int maxX, int minY, int maxY, int minZ, int maxZ) {
        return pos.m_123341_() >= minX && pos.m_123341_() <= maxX && pos.m_123342_() >= minY && pos.m_123342_() <= maxY && pos.m_123343_() >= minZ && pos.m_123343_() <= maxZ;
    }

    private Set<BlockPos> getConnectedInfluenceBlocks(Set<BlockPos> mandatoryBlocks, Set<BlockPos> influenceBlocks, int minX, int maxX, int minY, int maxY, int minZ, int maxZ) {
        HashSet<BlockPos> connected = new HashSet<BlockPos>(mandatoryBlocks);
        ArrayDeque<BlockPos> queue = new ArrayDeque<BlockPos>(mandatoryBlocks);
        while (!queue.isEmpty()) {
            BlockPos current = queue.poll();
            for (Direction direction : Direction.values()) {
                BlockPos next = current.m_121945_(direction);
                if (!this.isWithinBounds(next, minX, maxX, minY, maxY, minZ, maxZ) || !influenceBlocks.contains(next) || connected.contains(next)) continue;
                connected.add(next);
                queue.add(next);
            }
        }
        connected.removeAll(mandatoryBlocks);
        return connected;
    }

    private double getBlockDestructionCost(BlockPos pos) {
        BlockState state = this.m_9236_().m_8055_(pos);
        float hardness = state.m_60800_((BlockGetter)this.m_9236_(), pos);
        if (hardness < 0.0f || hardness > 50.0f) {
            return Double.MAX_VALUE;
        }
        double coefficient = 1.0;
        if (state.m_204336_(BlockTags.f_144282_)) {
            coefficient = 3.0;
        } else if (state.m_204336_(BlockTags.f_144283_)) {
            coefficient = 0.5;
        } else if (state.m_204336_(BlockTags.f_144280_)) {
            coefficient = 1.5;
        }
        return (double)hardness * coefficient;
    }

    private List<BlockPos> selectBlocksByBudget(List<BlockPos> candidates, double budget, RandomSource random) {
        BlockPos pos;
        double cost;
        ArrayList<BlockPos> shuffled = new ArrayList<BlockPos>(candidates);
        Collections.shuffle(shuffled, new Random(random.m_188505_()));
        ArrayList<BlockPos> selected = new ArrayList<BlockPos>();
        double remaining = budget;
        Iterator iterator = shuffled.iterator();
        while (iterator.hasNext() && !((cost = this.getBlockDestructionCost(pos = (BlockPos)iterator.next())) > remaining)) {
            selected.add(pos);
            if (!((remaining -= cost) <= 0.0)) continue;
            break;
        }
        return selected;
    }

    private void destroyBlocks(Collection<BlockPos> positions) {
        for (BlockPos pos : positions) {
            this.m_9236_().m_46961_(pos, true);
        }
    }

    private boolean hasDestructibleInBounds(int minX, int maxX, int minY, int maxY, int minZ, int maxZ) {
        for (int x = minX; x <= maxX; ++x) {
            for (int y = minY; y <= maxY; ++y) {
                for (int z = minZ; z <= maxZ; ++z) {
                    if (!this.isDestructible(new BlockPos(x, y, z))) continue;
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public void performPositionAttack(Vec3 targetPosition, float pullProgress) {
        this.m_21011_(InteractionHand.MAIN_HAND, true);
        this.performBlockDestructionAttack(targetPosition);
    }

    @Override
    public double getArrivalThreshold() {
        return 5.0;
    }

    @Override
    public boolean canFireAtPosition(Vec3 targetPosition) {
        return targetPosition != null;
    }

    @Override
    public boolean hasPositionTarget() {
        return (Boolean)this.f_19804_.m_135370_(HAS_POSITION_TARGET);
    }

    @Override
    public Vec3 getPositionTarget() {
        return this.positionTarget;
    }

    @Override
    public void setPositionTarget(Vec3 targetPosition) {
        this.positionTarget = targetPosition;
        this.f_19804_.m_135381_(HAS_POSITION_TARGET, (Object)(targetPosition != null ? 1 : 0));
        this.f_19804_.m_135381_(TARGET_POS, (Object)(targetPosition != null ? BlockPos.m_274446_((Position)targetPosition) : BlockPos.f_121853_));
    }

    @Override
    public void PerformRangedAttackBoth(Vec3 targetPosition, LivingEntity target) {
        if (targetPosition == null && target != null) {
            targetPosition = target.m_20182_();
        }
        this.performBlockDestructionAttack(targetPosition);
    }

    public boolean m_7327_(Entity entity) {
        boolean success = super.m_7327_(entity);
        if (success && entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            AABB splashArea = living.m_20191_().m_82400_(1.8);
            for (LivingEntity other : this.m_9236_().m_6443_(LivingEntity.class, splashArea, target -> target != this && target != living && this.isValidTarget((LivingEntity)target))) {
                other.f_19802_ = 0;
                other.m_6469_(this.m_269291_().m_269333_((LivingEntity)this), (float)(this.m_21133_(Attributes.f_22281_) * (double)0.65f));
            }
        }
        return success;
    }

    private LivingEntity getActiveTarget() {
        LivingEntity target = this.getHywTarget();
        if (target == null) {
            target = this.m_5448_();
        }
        return target;
    }

    @Override
    protected void setDefaultEquipment() {
        this.m_8061_(EquipmentSlot.MAINHAND, ItemStack.f_41583_);
        this.m_8061_(EquipmentSlot.OFFHAND, ItemStack.f_41583_);
        this.m_8061_(EquipmentSlot.HEAD, ItemStack.f_41583_);
        this.m_8061_(EquipmentSlot.CHEST, ItemStack.f_41583_);
        this.m_8061_(EquipmentSlot.LEGS, ItemStack.f_41583_);
        this.m_8061_(EquipmentSlot.FEET, ItemStack.f_41583_);
    }

    @Override
    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128379_("Slamming", this.slamming);
        compound.m_128379_("LeftGround", this.leftGround);
        compound.m_128405_("SlamCooldown", this.slamCooldown);
        compound.m_128379_("HasPositionTarget", this.hasPositionTarget());
        if (this.hasPositionTarget() && this.positionTarget != null) {
            compound.m_128347_("PositionTargetX", this.positionTarget.f_82479_);
            compound.m_128347_("PositionTargetY", this.positionTarget.f_82480_);
            compound.m_128347_("PositionTargetZ", this.positionTarget.f_82481_);
        }
    }

    @Override
    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.slamming = compound.m_128471_("Slamming");
        this.leftGround = compound.m_128471_("LeftGround");
        this.slamCooldown = compound.m_128451_("SlamCooldown");
        if (compound.m_128471_("HasPositionTarget")) {
            double x = compound.m_128459_("PositionTargetX");
            double y = compound.m_128459_("PositionTargetY");
            double z = compound.m_128459_("PositionTargetZ");
            this.setPositionTarget(new Vec3(x, y, z));
        } else {
            this.setPositionTarget(null);
        }
    }

    @Override
    public int getBaseAttackAnimationTime() {
        return 18;
    }

    @Override
    public int getAttackDamageTickDelay() {
        return 8;
    }

    @Override
    public int getAttackCoolDownDuration() {
        Random random = new Random();
        return 12 + random.nextInt(10);
    }

    @Override
    protected void increaseStatsOnLevelUp() {
        AttributeInstance attackDamage;
        AttributeInstance maxHealth = this.m_21051_(Attributes.f_22276_);
        if (maxHealth != null) {
            maxHealth.m_22100_(maxHealth.m_22115_() + 6.0);
            this.m_5634_(6.0f);
        }
        if ((attackDamage = this.m_21051_(Attributes.f_22281_)) != null) {
            attackDamage.m_22100_(attackDamage.m_22115_() + 0.6);
        }
    }

    @Override
    protected void m_8099_() {
        this.f_21345_.m_25352_(5, (Goal)new HywWaterAvoidingRandomStrollGoal(this, 0.6));
        this.f_21345_.m_25352_(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        super.m_8099_();
    }

    @Override
    public Item getScrollType() {
        return (Item)HywItemRegistry.SCROLL_GIANT.get();
    }

    protected SoundEvent m_7975_(DamageSource damageSource) {
        return SoundEvents.f_12608_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_12603_;
    }

    protected SoundEvent m_7515_() {
        return SoundEvents.f_12598_;
    }

    public MobType m_6336_() {
        return MobType.f_21641_;
    }
}

