/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.main.entity.entities;

import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import ydmsama.hundred_years_war.main.entity.entities.mounted.MountedLightLancerRiderEntity;
import ydmsama.hundred_years_war.main.entity.utils.BackItemHolder;
import ydmsama.hundred_years_war.main.registry.HywAttributes;
import ydmsama.hundred_years_war.main.registry.HywEntityRegistry;
import ydmsama.hundred_years_war.main.registry.HywItemRegistry;
import ydmsama.hundred_years_war.main.utils.WeaponTypeHelper;

public class HywSkeletonLightCavalryEntity
extends MountedLightLancerRiderEntity
implements BackItemHolder {
    private static final float ATTACK_REACH = 3.0f;
    private static final float MOVEMENT_SPEED = 0.34f;
    private static final double RIDING_OFFSET_FACTOR = 0.4;

    public HywSkeletonLightCavalryEntity(EntityType<? extends PathfinderMob> entityType, Level world) {
        super(entityType, world);
    }

    public static AttributeSupplier.Builder createSkeletonLightCavalryAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22277_, 28.0).m_22268_(Attributes.f_22279_, (double)0.34f).m_22268_(Attributes.f_22281_, 3.0).m_22268_(Attributes.f_22284_, 6.0).m_22268_(Attributes.f_22276_, 28.0).m_22268_(Attributes.f_22278_, 0.5).m_22268_((Attribute)HywAttributes.ATTACK_REACH.get(), 3.0);
    }

    @Override
    protected void setDefaultEquipment() {
        this.setMainWeapon(this.getDefaultMainWeapon());
        this.setChargeWeapon(this.getDefaultChargeWeapon());
        this.setUsingChargeWeapon(false);
        this.m_8061_(EquipmentSlot.OFFHAND, ItemStack.f_41583_);
        this.m_8061_(EquipmentSlot.HEAD, new ItemStack((ItemLike)Items.f_42468_));
        this.m_8061_(EquipmentSlot.CHEST, new ItemStack((ItemLike)Items.f_42469_));
        this.m_8061_(EquipmentSlot.LEGS, ItemStack.f_41583_);
        this.m_8061_(EquipmentSlot.FEET, ItemStack.f_41583_);
    }

    @Override
    protected ItemStack getDefaultChargeWeapon() {
        return new ItemStack((ItemLike)HywItemRegistry.IRON_PIKE.get());
    }

    @Override
    public ItemStack getBackItem() {
        ItemStack mainWeapon = this.getMainWeapon();
        if (mainWeapon.m_41619_() || !WeaponTypeHelper.isSwordLikeWeapon(mainWeapon)) {
            return ItemStack.f_41583_;
        }
        ItemStack heldItem = this.m_21205_();
        boolean holdingSword = WeaponTypeHelper.isSwordLikeWeapon(heldItem) && ItemStack.m_150942_((ItemStack)heldItem, (ItemStack)mainWeapon);
        return holdingSword ? ItemStack.f_41583_ : mainWeapon;
    }

    @Override
    public void setBackItem(ItemStack itemStack) {
        this.setMainWeapon(itemStack);
    }

    @Override
    public boolean shouldRenderBackItem() {
        return !this.getBackItem().m_41619_();
    }

    @Override
    protected AbstractHorse createHorseEntity() {
        return (AbstractHorse)((EntityType)HywEntityRegistry.HYW_SKELETON_HORSE.get()).m_20615_(this.m_9236_());
    }

    @Override
    public Item getScrollType() {
        return switch (this.getEquipmentLevel()) {
            case 1 -> (Item)HywItemRegistry.SCROLL_SKELETON_LIGHT_CAVALRY.get();
            case 2 -> (Item)HywItemRegistry.SCROLL_SKELETON_LIGHT_CAVALRY_1.get();
            case 3 -> (Item)HywItemRegistry.SCROLL_SKELETON_LIGHT_CAVALRY_2.get();
            case 4 -> (Item)HywItemRegistry.SCROLL_SKELETON_LIGHT_CAVALRY_3.get();
            default -> null;
        };
    }

    @Override
    public double getRidingOffsetFactor() {
        return 0.4;
    }

    protected SoundEvent m_7975_(DamageSource damageSource) {
        return SoundEvents.f_12381_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_12424_;
    }

    protected SoundEvent m_7515_() {
        return SoundEvents.f_12423_;
    }

    @NotNull
    public MobType m_6336_() {
        return MobType.f_21641_;
    }
}

