/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.main.entity.entities;

import java.util.Random;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundLevelParticlesPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import ydmsama.hundred_years_war.main.entity.entities.BaseCombatEntity;
import ydmsama.hundred_years_war.main.entity.entities.UseCrossbow;
import ydmsama.hundred_years_war.main.entity.entities.projectile.BulletEntity;
import ydmsama.hundred_years_war.main.entity.entities.tags.CounterCavalry;
import ydmsama.hundred_years_war.main.entity.entities.tags.CounterHeavy;
import ydmsama.hundred_years_war.main.entity.entities.tags.LightUnit;
import ydmsama.hundred_years_war.main.entity.entities.tags.RangedUnit;
import ydmsama.hundred_years_war.main.entity.utils.Mountable;
import ydmsama.hundred_years_war.main.registry.HywAttributes;
import ydmsama.hundred_years_war.main.registry.HywEntityRegistry;
import ydmsama.hundred_years_war.main.registry.HywItemRegistry;

public class MatchlockManEntity
extends BaseCombatEntity
implements RangedAttackMob,
UseCrossbow,
LightUnit,
RangedUnit,
CounterHeavy,
CounterCavalry,
Mountable {
    private static final float ATTACK_REACH = 100.0f;
    private static final float MOVEMENT_SPEED = 0.3f;
    private static final float BASE_RANGED_ATTACK_DAMAGE = 2.0f;
    private static final EntityDataAccessor<Integer> USE_ANGLE = SynchedEntityData.m_135353_(MatchlockManEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);

    public MatchlockManEntity(EntityType<? extends PathfinderMob> entityType, Level world) {
        super(entityType, world);
        this.m_274367_(1.0f);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(USE_ANGLE, (Object)1);
    }

    public static AttributeSupplier.Builder createMatchlockManAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22277_, 100.0).m_22268_(Attributes.f_22279_, (double)0.3f).m_22268_(Attributes.f_22281_, 8.0).m_22268_(Attributes.f_22284_, 2.0).m_22268_(Attributes.f_22276_, 20.0).m_22268_(Attributes.f_22278_, 0.4).m_22268_((Attribute)HywAttributes.ATTACK_REACH.get(), 100.0).m_22268_((Attribute)HywAttributes.RANGED_ATTACK_DAMAGE.get(), 2.0);
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
    }

    @Override
    protected void setDefaultEquipment() {
        this.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)HywItemRegistry.MATCHLOCK.get()));
        this.m_8061_(EquipmentSlot.OFFHAND, ItemStack.f_41583_);
        this.m_8061_(EquipmentSlot.HEAD, new ItemStack((ItemLike)Items.f_42464_));
        this.m_8061_(EquipmentSlot.CHEST, new ItemStack((ItemLike)Items.f_42465_));
        this.m_8061_(EquipmentSlot.LEGS, new ItemStack((ItemLike)Items.f_42466_));
        this.m_8061_(EquipmentSlot.FEET, new ItemStack((ItemLike)Items.f_42467_));
    }

    @Override
    public int getBaseAttackAnimationTime() {
        int baseCooldown = 20;
        return baseCooldown;
    }

    @Override
    public int getAttackDamageTickDelay() {
        Random random = new Random();
        return Math.max(this.getBaseAttackAnimationTime() - random.nextInt(15), 5);
    }

    @Override
    public int getAttackCoolDownDuration() {
        Random random = new Random();
        return 80 + random.nextInt(40);
    }

    public void m_6504_(LivingEntity target, float pullProgress) {
        float speed = 12.0f;
        float inaccuracy = 1.0f;
        BulletEntity bulletEntity = new BulletEntity((EntityType<? extends BulletEntity>)((EntityType)HywEntityRegistry.BULLET.get()), (LivingEntity)this, this.m_9236_());
        double baseDamage = 2.0;
        AttributeInstance rangedDamageAttr = this.m_21051_((Attribute)HywAttributes.RANGED_ATTACK_DAMAGE.get());
        if (rangedDamageAttr != null) {
            baseDamage = rangedDamageAttr.m_22135_();
        }
        bulletEntity.m_36781_(baseDamage);
        double dx = target.m_20185_() - this.m_20185_();
        double dz = target.m_20189_() - this.m_20189_();
        double dy = target.m_20227_(0.5) - bulletEntity.m_20186_();
        double distance = Math.sqrt(dx * dx + dz * dz + dy * dy);
        if (distance == 0.0) {
            return;
        }
        double gravity = 0.05;
        double[] angles = this.calculateLaunchAngles(speed, gravity, distance, dy);
        if (!(!Double.isNaN(angles[1]) && this.isPathClear((Entity)bulletEntity, angles[1], speed, dx, dy, dz, distance, target) || distance < 5.0)) {
            return;
        }
        double angle = angles[1];
        double randomSpeedOffset = MatchlockManEntity.getRandomInRange(-0.25, 0.75);
        double timeToTarget = distance / (((double)speed - randomSpeedOffset) * Math.cos(angle));
        double targetVelocityX = target.m_20184_().m_7096_();
        double targetVelocityZ = target.m_20184_().m_7094_();
        double predictedX = target.m_20185_() + targetVelocityX * timeToTarget;
        double predictedZ = target.m_20189_() + targetVelocityZ * timeToTarget;
        double predictedDistance = Math.sqrt((predictedX - this.m_20185_()) * (predictedX - this.m_20185_()) + (predictedZ - this.m_20189_()) * (predictedZ - this.m_20189_()));
        angles = this.calculateLaunchAngles(speed, gravity, predictedDistance, dy);
        angle = angles[1];
        double yaw = Math.atan2(predictedZ - this.m_20189_(), predictedX - this.m_20185_());
        double horizontalSpeed = Math.cos(angle) * (double)speed;
        float velocityX = (float)(horizontalSpeed * Math.cos(yaw));
        float velocityY = (float)(Math.sin(angle) * (double)speed);
        float velocityZ = (float)(horizontalSpeed * Math.sin(yaw));
        bulletEntity.m_6686_(velocityX, velocityY, velocityZ, speed, inaccuracy);
        this.m_9236_().m_7967_((Entity)bulletEntity);
        float randomPitch = 1.4f + (float)MatchlockManEntity.getRandomInRange(0.0, 0.4);
        this.m_5496_(SoundEvents.f_11913_, 5.0f, randomPitch);
        this.m_5810_();
        if (this.m_9236_() instanceof ServerLevel) {
            double dirX = Math.cos(yaw);
            double dirZ = Math.sin(yaw);
            double eyeX = this.m_20185_();
            double eyeY = this.m_20186_() + (double)this.m_20192_() - 0.15;
            double eyeZ = this.m_20189_();
            this.spawnParticles(this.m_9236_(), eyeX + dirX * 1.5, eyeY + Math.sin(angle) * 1.5, eyeZ + dirZ * 1.5);
        }
    }

    private void spawnParticles(Level world, double x, double y, double z) {
        if (world instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)world;
            this.sendParticlesToAllNearby(serverLevel, ParticleTypes.f_123762_, x, y, z, 20, 0.1, 0.1, 0.1, 0.02);
            this.sendParticlesToAllNearby(serverLevel, ParticleTypes.f_123744_, x, y, z, 5, 0.1, 0.1, 0.1, 0.2);
        }
    }

    public <T extends ParticleOptions> int sendParticlesToAllNearby(ServerLevel serverLevel, T particleOptions, double x, double y, double z, int count, double xOffset, double yOffset, double zOffset, double speed) {
        ClientboundLevelParticlesPacket packet = new ClientboundLevelParticlesPacket(particleOptions, true, x, y, z, (float)xOffset, (float)yOffset, (float)zOffset, (float)speed, count);
        int sentCount = 0;
        for (ServerPlayer serverPlayer : serverLevel.m_6907_()) {
            if (!this.sendParticlesToPlayer(serverLevel, serverPlayer, x, y, z, (Packet<?>)packet)) continue;
            ++sentCount;
        }
        return sentCount;
    }

    private boolean sendParticlesToPlayer(ServerLevel serverLevel, ServerPlayer serverPlayer, double x, double y, double z, Packet<?> packet) {
        if (serverPlayer.m_9236_() != serverLevel) {
            return false;
        }
        double distanceSquared = serverPlayer.m_20182_().m_82557_(new Vec3(x, y, z));
        if (distanceSquared < 262144.0) {
            serverPlayer.f_8906_.m_9829_(packet);
            return true;
        }
        return false;
    }

    private boolean isPathClear(Entity entity, double angle, float speed, double dx, double dy, double dz, double distance, LivingEntity target) {
        return true;
    }

    private double[] calculateLaunchAngles(double speed, double gravity, double distance, double heightDifference) {
        double speedSquared = speed * speed;
        double horizontalDistanceSquared = distance * distance;
        double heightDifferenceSquared = heightDifference * heightDifference;
        double discriminant = speedSquared * speedSquared - gravity * (gravity * horizontalDistanceSquared + 2.0 * heightDifference * speedSquared);
        if (discriminant < 0.0) {
            return new double[]{Double.NaN, Double.NaN};
        }
        double discriminantSqrt = Math.sqrt(discriminant);
        double term1 = Math.atan((speedSquared + discriminantSqrt) / (gravity * distance));
        double term2 = Math.atan((speedSquared - discriminantSqrt) / (gravity * distance));
        return new double[]{term1, term2};
    }

    public static double getRandomInRange(double min, double max) {
        return min + Math.random() * (max - min);
    }

    @Override
    public Item getScrollType() {
        return switch (this.getEquipmentLevel()) {
            case 3 -> (Item)HywItemRegistry.SCROLL_MATCHLOCK_MAN_2.get();
            case 4 -> (Item)HywItemRegistry.SCROLL_MATCHLOCK_MAN_3.get();
            default -> null;
        };
    }

    @Override
    protected void increaseStatsOnLevelUp() {
        super.increaseStatsOnLevelUp();
        AttributeInstance rangedAttackDamage = this.m_21051_((Attribute)HywAttributes.RANGED_ATTACK_DAMAGE.get());
        if (rangedAttackDamage != null) {
            rangedAttackDamage.m_22100_(rangedAttackDamage.m_22115_() + 0.1);
        }
    }

    @Override
    public boolean isValidTarget(LivingEntity potentialTarget) {
        if (this.isObstructed(potentialTarget)) {
            return false;
        }
        return super.isValidTarget(potentialTarget);
    }

    @Override
    public boolean canFireAtTarget(LivingEntity target) {
        if (this.isObstructed(target)) {
            return false;
        }
        return super.canFireAtTarget(target);
    }

    @Override
    public double getLightDamageModifier() {
        return 1.0;
    }

    @Override
    public double getHeavyDamageModifier() {
        return 1.2;
    }

    @Override
    public double getCavalryDamageModifier() {
        return 1.2;
    }
}

