/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.main.entity.entities;

import java.util.Random;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrownPotion;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import ydmsama.hundred_years_war.main.entity.entities.BaseCombatEntity;
import ydmsama.hundred_years_war.main.entity.entities.tags.LightUnit;
import ydmsama.hundred_years_war.main.entity.goals.HywWaterAvoidingRandomStrollGoal;
import ydmsama.hundred_years_war.main.entity.utils.HorseRider;
import ydmsama.hundred_years_war.main.entity.utils.Mountable;
import ydmsama.hundred_years_war.main.registry.HywAttributes;
import ydmsama.hundred_years_war.main.registry.HywItemRegistry;
import ydmsama.hundred_years_war.main.utils.ServerRelationHelper;

public class PriestEntity
extends BaseCombatEntity
implements RangedAttackMob,
HorseRider,
LightUnit,
Mountable {
    private static final float ATTACK_REACH = 5.0f;
    private static final float MOVEMENT_SPEED = 0.25f;
    private static final float HEALING_AMOUNT = 1.0f;
    private int selfHealCheckTimer = 0;

    public PriestEntity(EntityType<? extends PathfinderMob> entityType, Level world) {
        super(entityType, world);
        this.m_274367_(1.0f);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
    }

    @Override
    public int getSkinCounts() {
        return 6;
    }

    public static AttributeSupplier.Builder createPriestAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22277_, 20.0).m_22268_(Attributes.f_22279_, 0.25).m_22268_(Attributes.f_22281_, 2.0).m_22268_(Attributes.f_22284_, 5.0).m_22268_(Attributes.f_22276_, 24.0).m_22268_(Attributes.f_22278_, 0.4).m_22268_((Attribute)HywAttributes.ATTACK_REACH.get(), 5.0).m_22268_((Attribute)HywAttributes.RANGED_ATTACK_DAMAGE.get(), 1.0);
    }

    @Override
    protected void setDefaultEquipment() {
        Random random = new Random();
        ItemStack healingPotion = new ItemStack((ItemLike)Items.f_42736_);
        PotionUtils.m_43549_((ItemStack)healingPotion, (Potion)Potions.f_43623_);
        this.m_8061_(EquipmentSlot.MAINHAND, healingPotion);
        Item cane = random.nextBoolean() ? (Item)HywItemRegistry.PRIEST_CANE_1.get() : (Item)HywItemRegistry.PRIEST_CANE_2.get();
        this.m_8061_(EquipmentSlot.OFFHAND, new ItemStack((ItemLike)cane));
        this.m_8061_(EquipmentSlot.HEAD, ItemStack.f_41583_);
        this.m_8061_(EquipmentSlot.CHEST, ItemStack.f_41583_);
        this.m_8061_(EquipmentSlot.LEGS, ItemStack.f_41583_);
        this.m_8061_(EquipmentSlot.FEET, ItemStack.f_41583_);
    }

    @Override
    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128405_("selfHealCheckTimer", this.selfHealCheckTimer);
    }

    @Override
    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.selfHealCheckTimer = compound.m_128451_("selfHealCheckTimer");
    }

    @Override
    public int getBaseAttackAnimationTime() {
        return 10;
    }

    @Override
    public int getAttackDamageTickDelay() {
        Random random = new Random();
        return Math.max(this.getBaseAttackAnimationTime() - random.nextInt(3), 8);
    }

    @Override
    public int getAttackCoolDownDuration() {
        Random random = new Random();
        return 50 + random.nextInt(50);
    }

    public void m_6504_(LivingEntity target, float pullProgress) {
        ItemStack healingPotionStack = new ItemStack((ItemLike)Items.f_42736_);
        PotionUtils.m_43549_((ItemStack)healingPotionStack, (Potion)Potions.f_43623_);
        ThrownPotion thrownPotion = new ThrownPotion(this.m_9236_(), (LivingEntity)this);
        thrownPotion.m_37446_(healingPotionStack);
        double dx = target.m_20185_() - this.m_20185_();
        double dz = target.m_20189_() - this.m_20189_();
        double dy = target.m_20227_(0.3) - thrownPotion.m_20186_();
        double distance = Math.sqrt(dx * dx + dz * dz);
        float velocity = 0.75f;
        thrownPotion.m_6686_(dx, dy + distance * 0.2, dz, velocity, 8.0f);
        this.m_6674_(InteractionHand.MAIN_HAND);
        this.m_5496_(SoundEvents.f_12437_, 1.0f, 0.8f + this.m_217043_().m_188501_() * 0.4f);
        this.m_9236_().m_7967_((Entity)thrownPotion);
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (!this.m_9236_().f_46443_) {
            ++this.selfHealCheckTimer;
            if (this.selfHealCheckTimer >= 20) {
                LivingEntity currentTarget;
                this.selfHealCheckTimer = 0;
                if (this.m_21223_() < this.m_21233_() && (currentTarget = this.getHywTarget()) == null) {
                    this.setHywTarget((LivingEntity)this);
                    this.m_6710_((LivingEntity)this);
                }
            }
        }
    }

    @Override
    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(5, (Goal)new HywWaterAvoidingRandomStrollGoal(this, 0.6));
        this.f_21345_.m_25352_(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 4.0f));
        this.f_21345_.m_25352_(7, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    @Override
    public boolean isValidTarget(LivingEntity entity) {
        if (!entity.m_6084_()) {
            return false;
        }
        if (entity.m_6336_().equals(MobType.f_21641_)) {
            return false;
        }
        if (entity == this) {
            return entity.m_21223_() < entity.m_21233_();
        }
        if (entity instanceof BaseCombatEntity || entity instanceof Player || entity.m_20148_().equals(this.m_21805_())) {
            boolean isSameTeam = !ServerRelationHelper.isEnemyRelation((Entity)this, (Entity)entity) || entity.m_20148_().equals(this.m_21805_());
            boolean needsHealing = entity.m_21223_() < entity.m_21233_();
            return isSameTeam && needsHealing;
        }
        return false;
    }

    @Override
    public Item getScrollType() {
        return (Item)HywItemRegistry.SCROLL_PRIEST.get();
    }

    @Override
    public LivingEntity asLivingEntity() {
        return this;
    }

    @Override
    public boolean hasValidTarget() {
        return this.getHywTarget() != null;
    }

    @Override
    public double getHorseSpeed() {
        return 0.32;
    }
}

