/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.main.entity.entities.bandits;

import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import ydmsama.hundred_years_war.main.entity.entities.BaseCombatEntity;
import ydmsama.hundred_years_war.main.entity.entities.tags.CounterHeavy;
import ydmsama.hundred_years_war.main.entity.entities.tags.LightUnit;
import ydmsama.hundred_years_war.main.entity.goals.HywWaterAvoidingRandomStrollGoal;
import ydmsama.hundred_years_war.main.registry.HywAttributes;
import ydmsama.hundred_years_war.main.registry.HywItemRegistry;
import ydmsama.hundred_years_war.main.utils.ServerRelationHelper;

public class BanditExecutionerEntity
extends BaseCombatEntity
implements LightUnit,
CounterHeavy {
    private static final int WHIRLWIND_DURATION = 80;
    private static final int WHIRLWIND_COOLDOWN = 200;
    private static final EntityDataAccessor<Boolean> SPINNING = SynchedEntityData.m_135353_(BanditExecutionerEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private int spinningTicks = 0;
    private int spinCooldown = 0;
    private int damageTicker = 0;
    private static final int DAMAGE_INTERVAL_TICKS = 12;
    private static final double SPIN_DAMAGE_RADIUS = 1.25;
    private float clientSpinYaw = 0.0f;

    public BanditExecutionerEntity(EntityType<? extends PathfinderMob> type, Level level) {
        super(type, level);
        this.m_274367_(1.0f);
    }

    public static AttributeSupplier.Builder createBanditExecutionerAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22277_, 24.0).m_22268_(Attributes.f_22279_, 0.3).m_22268_(Attributes.f_22281_, 7.0).m_22268_(Attributes.f_22284_, 4.0).m_22268_(Attributes.f_22276_, 32.0).m_22268_(Attributes.f_22278_, 0.8).m_22268_((Attribute)HywAttributes.ATTACK_REACH.get(), 2.5);
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (!this.m_9236_().f_46443_) {
            this.handleSpinLogic();
        } else if (!this.isSpinning()) {
            this.clientSpinYaw = 0.0f;
        }
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(SPINNING, (Object)false);
    }

    private void handleSpinLogic() {
        if (this.spinCooldown > 0) {
            --this.spinCooldown;
        }
        if (this.spinningTicks > 0) {
            Level level;
            --this.spinningTicks;
            ++this.damageTicker;
            this.applySpinRotation();
            if (this.damageTicker % 12 == 0) {
                this.applySpinDamage();
            }
            if ((level = this.m_9236_()) instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                this.spawnSpinParticles(serverLevel);
            }
            if (this.spinningTicks == 0) {
                this.damageTicker = 0;
                this.setSpinning(false);
                this.clientSpinYaw = 0.0f;
            }
        } else if (this.spinCooldown == 0 && this.hasSpinOpportunity()) {
            this.startWhirlwind();
        }
    }

    private void applySpinRotation() {
        if (!this.m_9236_().f_46443_) {
            float yawAdd = 18.0f;
            this.m_146922_(this.m_146908_() + yawAdd);
            this.f_20883_ = this.m_146908_();
            this.f_20885_ = this.m_146908_();
            this.clientSpinYaw += yawAdd;
        }
    }

    @Override
    public boolean shouldSkipBaseRotation() {
        return this.isSpinning();
    }

    protected float m_5632_(float bodyRot, float headRot) {
        if (this.isSpinning()) {
            float yaw;
            this.f_20885_ = yaw = this.m_146908_();
            this.f_20883_ = yaw;
            return yaw;
        }
        return super.m_5632_(bodyRot, headRot);
    }

    private boolean hasSpinOpportunity() {
        if (this.getHywTarget() == null) {
            return false;
        }
        AABB area = this.m_20191_().m_82400_(3.0);
        long enemyCount = this.m_9236_().m_6443_(LivingEntity.class, area, target -> target != this && ServerRelationHelper.isEnemyRelation((Entity)this, (Entity)target)).size();
        return enemyCount >= 1L;
    }

    private void startWhirlwind() {
        this.spinningTicks = 80;
        this.spinCooldown = 200;
        this.setSpinning(true);
    }

    private void applySpinDamage() {
        AABB area = this.m_20191_().m_82400_(1.25);
        for (LivingEntity living : this.m_9236_().m_6443_(LivingEntity.class, area, target -> target != this && ServerRelationHelper.isEnemyRelation((Entity)this, (Entity)target))) {
            living.f_19802_ = 0;
            living.m_6469_(this.m_269291_().m_269333_((LivingEntity)this), (float)(this.m_21133_(Attributes.f_22281_) * (double)0.6f));
        }
    }

    private void spawnSpinParticles(ServerLevel serverLevel) {
        RandomSource random = serverLevel.f_46441_;
        for (int i = 0; i < 1; ++i) {
            double angle = random.m_188500_() * Math.PI * 2.0;
            double radius = random.m_188500_() * 1.25;
            double offsetX = Math.cos(angle) * radius;
            double offsetZ = Math.sin(angle) * radius;
            serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123766_, this.m_20185_() + offsetX, this.m_20186_() + 1.0, this.m_20189_() + offsetZ, 1, 0.05, 0.02, 0.05, 0.0);
        }
    }

    public float getClientSpinYaw() {
        return this.clientSpinYaw;
    }

    public boolean isSpinning() {
        return (Boolean)this.f_19804_.m_135370_(SPINNING);
    }

    private void setSpinning(boolean spinning) {
        this.f_19804_.m_135381_(SPINNING, (Object)spinning);
    }

    @Override
    protected void setDefaultEquipment() {
        this.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.f_42386_));
    }

    @Override
    protected void m_8099_() {
        this.f_21345_.m_25352_(5, (Goal)new HywWaterAvoidingRandomStrollGoal(this, 0.75));
        this.f_21345_.m_25352_(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 5.0f));
        this.f_21345_.m_25352_(7, (Goal)new RandomLookAroundGoal((Mob)this));
        super.m_8099_();
    }

    @Override
    public int getBaseAttackAnimationTime() {
        return 12;
    }

    @Override
    public int getAttackDamageTickDelay() {
        return 6;
    }

    @Override
    public int getAttackCoolDownDuration() {
        return 20;
    }

    @Override
    protected boolean allowBetterCombatAttack() {
        return false;
    }

    @Override
    protected boolean allowEquipmentReplacement() {
        return false;
    }

    @Override
    public Item getScrollType() {
        return (Item)HywItemRegistry.SCROLL_BANDIT_EXECUTIONER.get();
    }

    @Override
    public void m_7380_(CompoundTag compoundTag) {
        super.m_7380_(compoundTag);
        compoundTag.m_128405_("SpinCooldown", this.spinCooldown);
        compoundTag.m_128405_("SpinTicks", this.spinningTicks);
        compoundTag.m_128379_("Spinning", this.isSpinning());
    }

    @Override
    public void m_7378_(CompoundTag compoundTag) {
        super.m_7378_(compoundTag);
        this.spinCooldown = compoundTag.m_128451_("SpinCooldown");
        this.spinningTicks = compoundTag.m_128451_("SpinTicks");
        this.setSpinning(compoundTag.m_128471_("Spinning") && this.spinningTicks > 0);
    }

    @Override
    public double getLightDamageModifier() {
        return 1.5;
    }

    @Override
    public double getHeavyDamageModifier() {
        return 0.8;
    }

    @Override
    public int getSkinCounts() {
        return 3;
    }
}

