/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.main.entity.entities.bandits;

import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import ydmsama.hundred_years_war.main.entity.entities.BaseCombatEntity;
import ydmsama.hundred_years_war.main.entity.entities.projectile.ThrowingKnifeEntity;
import ydmsama.hundred_years_war.main.entity.entities.tags.CounterLight;
import ydmsama.hundred_years_war.main.entity.entities.tags.LightUnit;
import ydmsama.hundred_years_war.main.entity.entities.tags.RangedUnit;
import ydmsama.hundred_years_war.main.entity.goals.HywWaterAvoidingRandomStrollGoal;
import ydmsama.hundred_years_war.main.registry.HywAttributes;
import ydmsama.hundred_years_war.main.registry.HywItemRegistry;

public class BanditKnifeThrowerEntity
extends BaseCombatEntity
implements RangedAttackMob,
LightUnit,
RangedUnit,
CounterLight {
    private static final float ATTACK_REACH = 32.0f;
    private static final float MOVEMENT_SPEED = 0.32f;
    private static final float BASE_RANGED_DAMAGE = 5.0f;
    private static final int OFFHAND_THROW_DELAY = 12;
    private int offhandThrowTicker = -1;
    private LivingEntity queuedOffhandTarget = null;

    public BanditKnifeThrowerEntity(EntityType<? extends PathfinderMob> type, Level level) {
        super(type, level);
        this.m_274367_(1.0f);
    }

    public static AttributeSupplier.Builder createKnifeThrowerAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22277_, 32.0).m_22268_(Attributes.f_22279_, (double)0.32f).m_22268_(Attributes.f_22281_, 4.0).m_22268_(Attributes.f_22284_, 2.0).m_22268_(Attributes.f_22276_, 20.0).m_22268_(Attributes.f_22278_, 0.3).m_22268_((Attribute)HywAttributes.ATTACK_REACH.get(), 32.0).m_22268_((Attribute)HywAttributes.RANGED_ATTACK_DAMAGE.get(), 5.0);
    }

    @Override
    protected void setDefaultEquipment() {
        this.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)HywItemRegistry.THROWING_KNIFE.get()));
    }

    @Override
    protected void m_8099_() {
        this.f_21345_.m_25352_(5, (Goal)new HywWaterAvoidingRandomStrollGoal(this, 0.8));
        this.f_21345_.m_25352_(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21345_.m_25352_(7, (Goal)new RandomLookAroundGoal((Mob)this));
        super.m_8099_();
    }

    public void m_6504_(LivingEntity target, float pullProgress) {
        this.throwFan(InteractionHand.MAIN_HAND, target);
        this.queuedOffhandTarget = target;
        this.offhandThrowTicker = 12;
    }

    @Override
    public int getBaseAttackAnimationTime() {
        return 16;
    }

    @Override
    public int getAttackDamageTickDelay() {
        return 10;
    }

    @Override
    public int getAttackCoolDownDuration() {
        return 20 + this.m_217043_().m_188503_(10);
    }

    @Override
    protected boolean allowEquipmentReplacement() {
        return false;
    }

    @Override
    public Item getScrollType() {
        return (Item)HywItemRegistry.SCROLL_BANDIT_KNIFE_THROWER.get();
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (!this.m_9236_().f_46443_) {
            this.handleQueuedOffhandThrow();
        }
    }

    private void handleQueuedOffhandThrow() {
        if (this.offhandThrowTicker >= 0) {
            --this.offhandThrowTicker;
            if (this.offhandThrowTicker == 0 && this.queuedOffhandTarget != null && this.queuedOffhandTarget.m_6084_()) {
                this.throwFan(InteractionHand.OFF_HAND, this.queuedOffhandTarget);
            }
            if (this.offhandThrowTicker == 0 || this.queuedOffhandTarget == null || this.queuedOffhandTarget != null && !this.queuedOffhandTarget.m_6084_()) {
                this.offhandThrowTicker = -1;
                this.queuedOffhandTarget = null;
            }
        }
    }

    private void throwFan(InteractionHand hand, LivingEntity target) {
        this.m_21011_(hand, true);
        for (int i = 0; i < 4; ++i) {
            ThrowingKnifeEntity knife = new ThrowingKnifeEntity(this.m_9236_(), (LivingEntity)this);
            knife.m_36781_((float)this.m_21133_((Attribute)HywAttributes.RANGED_ATTACK_DAMAGE.get()));
            this.shootFlatPredicted(target, knife);
        }
        this.m_5496_(SoundEvents.f_12520_, 1.0f, 1.0f + (this.m_217043_().m_188501_() - 0.5f) * 0.2f);
    }

    private void shootFlatPredicted(LivingEntity target, ThrowingKnifeEntity knife) {
        double predicteddz;
        double dy;
        double dz;
        double dx = target.m_20185_() - this.m_20185_();
        double distance = Math.sqrt(dx * dx + (dz = target.m_20189_() - this.m_20189_()) * dz + (dy = target.m_20227_(0.5) - knife.m_20186_()) * dy);
        if (distance == 0.0) {
            return;
        }
        float speed = 1.4f;
        double gravity = 0.05;
        float miss = 18.0f;
        double[] angles = this.calculateLaunchAngles(speed, gravity, distance, dy);
        double angle = angles[1];
        if (Double.isNaN(angle)) {
            return;
        }
        Vec3 targetVel = target.m_20184_();
        double timeToTarget = distance / ((double)speed * Math.cos(angle));
        double predictedX = target.m_20185_() + targetVel.f_82479_ * timeToTarget;
        double predictedZ = target.m_20189_() + targetVel.f_82481_ * timeToTarget;
        double predicteddx = predictedX - this.m_20185_();
        double horizontalDistance = Math.sqrt(predicteddx * predicteddx + (predicteddz = predictedZ - this.m_20189_()) * predicteddz);
        if (horizontalDistance == 0.0) {
            return;
        }
        double horizontalSpeed = (double)speed * Math.cos(angle);
        double verticalSpeed = (double)speed * Math.sin(angle);
        float velocityX = (float)(predicteddx / horizontalDistance * horizontalSpeed);
        float velocityY = (float)verticalSpeed;
        float velocityZ = (float)(predicteddz / horizontalDistance * horizontalSpeed);
        float horizontalMiss = miss;
        float verticalMiss = miss * 0.5f;
        this.shootWithAnisotropicInaccuracy(knife, velocityX, velocityY, velocityZ, speed, horizontalMiss, verticalMiss);
        knife.m_36762_(false);
        this.m_9236_().m_7967_((Entity)knife);
    }

    private double[] calculateLaunchAngles(double speed, double gravity, double distance, double heightDifference) {
        double discriminant = speed * speed * speed * speed - gravity * (gravity * distance * distance + 2.0 * heightDifference * speed * speed);
        if (discriminant < 0.0) {
            return new double[]{Double.NaN, Double.NaN};
        }
        double angle1 = Math.atan2(speed * speed + Math.sqrt(discriminant), gravity * distance);
        double angle2 = Math.atan2(speed * speed - Math.sqrt(discriminant), gravity * distance);
        return new double[]{angle1, angle2};
    }

    private void shootWithAnisotropicInaccuracy(ThrowingKnifeEntity knife, float velocityX, float velocityY, float velocityZ, float speed, float horizontalMiss, float verticalMiss) {
        Vec3 direction = new Vec3((double)velocityX, (double)velocityY, (double)velocityZ).m_82541_().m_82520_(this.m_217043_().m_216328_(0.0, 0.0172275 * (double)horizontalMiss), this.m_217043_().m_216328_(0.0, 0.0172275 * (double)verticalMiss), this.m_217043_().m_216328_(0.0, 0.0172275 * (double)horizontalMiss)).m_82541_().m_82490_((double)speed);
        knife.m_20256_(direction);
        double horizontalLength = direction.m_165924_();
        knife.m_146922_((float)(Mth.m_14136_((double)direction.f_82479_, (double)direction.f_82481_) * 57.29577951308232));
        knife.m_146926_((float)(Mth.m_14136_((double)direction.f_82480_, (double)horizontalLength) * 57.29577951308232));
        knife.f_19859_ = knife.m_146908_();
        knife.f_19860_ = knife.m_146909_();
    }

    @Override
    public int getSkinCounts() {
        return 1;
    }

    @Override
    public double getLightDamageModifier() {
        return 1.5;
    }

    @Override
    public double getHeavyDamageModifier() {
        return 0.5;
    }
}

